# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFoundationHypervisorIsosResult',
    'AwaitableGetFoundationHypervisorIsosResult',
    'get_foundation_hypervisor_isos',
    'get_foundation_hypervisor_isos_output',
]

@pulumi.output_type
class GetFoundationHypervisorIsosResult:
    """
    A collection of values returned by getFoundationHypervisorIsos.
    """
    def __init__(__self__, esxes=None, hypervs=None, id=None, kvms=None, linuxes=None, xens=None):
        if esxes and not isinstance(esxes, list):
            raise TypeError("Expected argument 'esxes' to be a list")
        pulumi.set(__self__, "esxes", esxes)
        if hypervs and not isinstance(hypervs, list):
            raise TypeError("Expected argument 'hypervs' to be a list")
        pulumi.set(__self__, "hypervs", hypervs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kvms and not isinstance(kvms, list):
            raise TypeError("Expected argument 'kvms' to be a list")
        pulumi.set(__self__, "kvms", kvms)
        if linuxes and not isinstance(linuxes, list):
            raise TypeError("Expected argument 'linuxes' to be a list")
        pulumi.set(__self__, "linuxes", linuxes)
        if xens and not isinstance(xens, list):
            raise TypeError("Expected argument 'xens' to be a list")
        pulumi.set(__self__, "xens", xens)

    @_builtins.property
    @pulumi.getter
    def esxes(self) -> Sequence['outputs.GetFoundationHypervisorIsosEsxResult']:
        """
        List of esx isos and theirdetails present in foundation vm
        """
        return pulumi.get(self, "esxes")

    @_builtins.property
    @pulumi.getter
    def hypervs(self) -> Sequence['outputs.GetFoundationHypervisorIsosHypervResult']:
        """
        List of hyperv isos and their details present in foundation vm
        """
        return pulumi.get(self, "hypervs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def kvms(self) -> Sequence['outputs.GetFoundationHypervisorIsosKvmResult']:
        """
        List of kvm isos and their details present in foundation vm
        """
        return pulumi.get(self, "kvms")

    @_builtins.property
    @pulumi.getter
    def linuxes(self) -> Sequence['outputs.GetFoundationHypervisorIsosLinuxResult']:
        """
        List of linux isos and their details present in foundation vm
        """
        return pulumi.get(self, "linuxes")

    @_builtins.property
    @pulumi.getter
    def xens(self) -> Sequence['outputs.GetFoundationHypervisorIsosXenResult']:
        """
        List of esx isos and theirdetails present in foundation vm
        """
        return pulumi.get(self, "xens")


class AwaitableGetFoundationHypervisorIsosResult(GetFoundationHypervisorIsosResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFoundationHypervisorIsosResult(
            esxes=self.esxes,
            hypervs=self.hypervs,
            id=self.id,
            kvms=self.kvms,
            linuxes=self.linuxes,
            xens=self.xens)


def get_foundation_hypervisor_isos(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFoundationHypervisorIsosResult:
    """
    Describes a list of hypervisor isos image file details present in foundation vm

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    hypervisor_isos = nutanix.get_foundation_hypervisor_isos()
    ```

    ## Note

    * This data source only lists .iso files details.

    See detailed information in [Nutanix Foundation Hypervisor Isos](https://www.nutanix.dev/api_references/foundation/#/b3A6MjIyMjM0MDE-list-hypervisor-images-available-in-foundation).
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getFoundationHypervisorIsos:getFoundationHypervisorIsos', __args__, opts=opts, typ=GetFoundationHypervisorIsosResult).value

    return AwaitableGetFoundationHypervisorIsosResult(
        esxes=pulumi.get(__ret__, 'esxes'),
        hypervs=pulumi.get(__ret__, 'hypervs'),
        id=pulumi.get(__ret__, 'id'),
        kvms=pulumi.get(__ret__, 'kvms'),
        linuxes=pulumi.get(__ret__, 'linuxes'),
        xens=pulumi.get(__ret__, 'xens'))
def get_foundation_hypervisor_isos_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFoundationHypervisorIsosResult]:
    """
    Describes a list of hypervisor isos image file details present in foundation vm

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    hypervisor_isos = nutanix.get_foundation_hypervisor_isos()
    ```

    ## Note

    * This data source only lists .iso files details.

    See detailed information in [Nutanix Foundation Hypervisor Isos](https://www.nutanix.dev/api_references/foundation/#/b3A6MjIyMjM0MDE-list-hypervisor-images-available-in-foundation).
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getFoundationHypervisorIsos:getFoundationHypervisorIsos', __args__, opts=opts, typ=GetFoundationHypervisorIsosResult)
    return __ret__.apply(lambda __response__: GetFoundationHypervisorIsosResult(
        esxes=pulumi.get(__response__, 'esxes'),
        hypervs=pulumi.get(__response__, 'hypervs'),
        id=pulumi.get(__response__, 'id'),
        kvms=pulumi.get(__response__, 'kvms'),
        linuxes=pulumi.get(__response__, 'linuxes'),
        xens=pulumi.get(__response__, 'xens')))
