# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFoundationNodeNetworkDetailsResult',
    'AwaitableGetFoundationNodeNetworkDetailsResult',
    'get_foundation_node_network_details',
    'get_foundation_node_network_details_output',
]

@pulumi.output_type
class GetFoundationNodeNetworkDetailsResult:
    """
    A collection of values returned by getFoundationNodeNetworkDetails.
    """
    def __init__(__self__, id=None, ipv6_addresses=None, nodes=None, timeout=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipv6_addresses and not isinstance(ipv6_addresses, list):
            raise TypeError("Expected argument 'ipv6_addresses' to be a list")
        pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if timeout and not isinstance(timeout, str):
            raise TypeError("Expected argument 'timeout' to be a str")
        pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ipv6_addresses")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetFoundationNodeNetworkDetailsNodeResult']:
        """
        nodes array.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "timeout")


class AwaitableGetFoundationNodeNetworkDetailsResult(GetFoundationNodeNetworkDetailsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFoundationNodeNetworkDetailsResult(
            id=self.id,
            ipv6_addresses=self.ipv6_addresses,
            nodes=self.nodes,
            timeout=self.timeout)


def get_foundation_node_network_details(ipv6_addresses: Optional[Sequence[_builtins.str]] = None,
                                        timeout: Optional[_builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFoundationNodeNetworkDetailsResult:
    """
    Gets hypervisor, CVM & IPMI info of the discovered nodes using their ipv6 address.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    network_details = nutanix.get_foundation_node_network_details(ipv6_addresses=[
            "<ipv6-address-1>",
            "<ipv6-address-2>",
        ],
        timeout="30")
    ```


    :param Sequence[_builtins.str] ipv6_addresses: list of ipv6 addresses
    :param _builtins.str timeout: timeout in seconds
    """
    __args__ = dict()
    __args__['ipv6Addresses'] = ipv6_addresses
    __args__['timeout'] = timeout
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getFoundationNodeNetworkDetails:getFoundationNodeNetworkDetails', __args__, opts=opts, typ=GetFoundationNodeNetworkDetailsResult).value

    return AwaitableGetFoundationNodeNetworkDetailsResult(
        id=pulumi.get(__ret__, 'id'),
        ipv6_addresses=pulumi.get(__ret__, 'ipv6_addresses'),
        nodes=pulumi.get(__ret__, 'nodes'),
        timeout=pulumi.get(__ret__, 'timeout'))
def get_foundation_node_network_details_output(ipv6_addresses: Optional[pulumi.Input[Sequence[_builtins.str]]] = None,
                                               timeout: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFoundationNodeNetworkDetailsResult]:
    """
    Gets hypervisor, CVM & IPMI info of the discovered nodes using their ipv6 address.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    network_details = nutanix.get_foundation_node_network_details(ipv6_addresses=[
            "<ipv6-address-1>",
            "<ipv6-address-2>",
        ],
        timeout="30")
    ```


    :param Sequence[_builtins.str] ipv6_addresses: list of ipv6 addresses
    :param _builtins.str timeout: timeout in seconds
    """
    __args__ = dict()
    __args__['ipv6Addresses'] = ipv6_addresses
    __args__['timeout'] = timeout
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getFoundationNodeNetworkDetails:getFoundationNodeNetworkDetails', __args__, opts=opts, typ=GetFoundationNodeNetworkDetailsResult)
    return __ret__.apply(lambda __response__: GetFoundationNodeNetworkDetailsResult(
        id=pulumi.get(__response__, 'id'),
        ipv6_addresses=pulumi.get(__response__, 'ipv6_addresses'),
        nodes=pulumi.get(__response__, 'nodes'),
        timeout=pulumi.get(__response__, 'timeout')))
