# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetHostV2Result',
    'AwaitableGetHostV2Result',
    'get_host_v2',
    'get_host_v2_output',
]

@pulumi.output_type
class GetHostV2Result:
    """
    A collection of values returned by getHostV2.
    """
    def __init__(__self__, block_model=None, block_serial=None, boot_time_usecs=None, cluster_ext_id=None, clusters=None, controller_vms=None, cpu_capacity_hz=None, cpu_frequency_hz=None, cpu_model=None, default_vhd_container_uuid=None, default_vhd_location=None, default_vm_container_uuid=None, default_vm_location=None, disks=None, ext_id=None, failover_cluster_fqdn=None, failover_cluster_node_status=None, gpu_driver_version=None, gpu_lists=None, has_csr=None, host_name=None, host_type=None, hypervisors=None, id=None, ipmis=None, is_degraded=None, is_hardware_virtualized=None, is_reboot_pending=None, is_secure_booted=None, key_management_device_to_cert_statuses=None, links=None, maintenance_state=None, memory_size_bytes=None, node_status=None, number_of_cpu_cores=None, number_of_cpu_sockets=None, number_of_cpu_threads=None, rackable_unit_uuid=None, tenant_id=None):
        if block_model and not isinstance(block_model, str):
            raise TypeError("Expected argument 'block_model' to be a str")
        pulumi.set(__self__, "block_model", block_model)
        if block_serial and not isinstance(block_serial, str):
            raise TypeError("Expected argument 'block_serial' to be a str")
        pulumi.set(__self__, "block_serial", block_serial)
        if boot_time_usecs and not isinstance(boot_time_usecs, int):
            raise TypeError("Expected argument 'boot_time_usecs' to be a int")
        pulumi.set(__self__, "boot_time_usecs", boot_time_usecs)
        if cluster_ext_id and not isinstance(cluster_ext_id, str):
            raise TypeError("Expected argument 'cluster_ext_id' to be a str")
        pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if controller_vms and not isinstance(controller_vms, list):
            raise TypeError("Expected argument 'controller_vms' to be a list")
        pulumi.set(__self__, "controller_vms", controller_vms)
        if cpu_capacity_hz and not isinstance(cpu_capacity_hz, int):
            raise TypeError("Expected argument 'cpu_capacity_hz' to be a int")
        pulumi.set(__self__, "cpu_capacity_hz", cpu_capacity_hz)
        if cpu_frequency_hz and not isinstance(cpu_frequency_hz, int):
            raise TypeError("Expected argument 'cpu_frequency_hz' to be a int")
        pulumi.set(__self__, "cpu_frequency_hz", cpu_frequency_hz)
        if cpu_model and not isinstance(cpu_model, str):
            raise TypeError("Expected argument 'cpu_model' to be a str")
        pulumi.set(__self__, "cpu_model", cpu_model)
        if default_vhd_container_uuid and not isinstance(default_vhd_container_uuid, str):
            raise TypeError("Expected argument 'default_vhd_container_uuid' to be a str")
        pulumi.set(__self__, "default_vhd_container_uuid", default_vhd_container_uuid)
        if default_vhd_location and not isinstance(default_vhd_location, str):
            raise TypeError("Expected argument 'default_vhd_location' to be a str")
        pulumi.set(__self__, "default_vhd_location", default_vhd_location)
        if default_vm_container_uuid and not isinstance(default_vm_container_uuid, str):
            raise TypeError("Expected argument 'default_vm_container_uuid' to be a str")
        pulumi.set(__self__, "default_vm_container_uuid", default_vm_container_uuid)
        if default_vm_location and not isinstance(default_vm_location, str):
            raise TypeError("Expected argument 'default_vm_location' to be a str")
        pulumi.set(__self__, "default_vm_location", default_vm_location)
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if failover_cluster_fqdn and not isinstance(failover_cluster_fqdn, str):
            raise TypeError("Expected argument 'failover_cluster_fqdn' to be a str")
        pulumi.set(__self__, "failover_cluster_fqdn", failover_cluster_fqdn)
        if failover_cluster_node_status and not isinstance(failover_cluster_node_status, str):
            raise TypeError("Expected argument 'failover_cluster_node_status' to be a str")
        pulumi.set(__self__, "failover_cluster_node_status", failover_cluster_node_status)
        if gpu_driver_version and not isinstance(gpu_driver_version, str):
            raise TypeError("Expected argument 'gpu_driver_version' to be a str")
        pulumi.set(__self__, "gpu_driver_version", gpu_driver_version)
        if gpu_lists and not isinstance(gpu_lists, list):
            raise TypeError("Expected argument 'gpu_lists' to be a list")
        pulumi.set(__self__, "gpu_lists", gpu_lists)
        if has_csr and not isinstance(has_csr, bool):
            raise TypeError("Expected argument 'has_csr' to be a bool")
        pulumi.set(__self__, "has_csr", has_csr)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if host_type and not isinstance(host_type, str):
            raise TypeError("Expected argument 'host_type' to be a str")
        pulumi.set(__self__, "host_type", host_type)
        if hypervisors and not isinstance(hypervisors, list):
            raise TypeError("Expected argument 'hypervisors' to be a list")
        pulumi.set(__self__, "hypervisors", hypervisors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipmis and not isinstance(ipmis, list):
            raise TypeError("Expected argument 'ipmis' to be a list")
        pulumi.set(__self__, "ipmis", ipmis)
        if is_degraded and not isinstance(is_degraded, bool):
            raise TypeError("Expected argument 'is_degraded' to be a bool")
        pulumi.set(__self__, "is_degraded", is_degraded)
        if is_hardware_virtualized and not isinstance(is_hardware_virtualized, bool):
            raise TypeError("Expected argument 'is_hardware_virtualized' to be a bool")
        pulumi.set(__self__, "is_hardware_virtualized", is_hardware_virtualized)
        if is_reboot_pending and not isinstance(is_reboot_pending, bool):
            raise TypeError("Expected argument 'is_reboot_pending' to be a bool")
        pulumi.set(__self__, "is_reboot_pending", is_reboot_pending)
        if is_secure_booted and not isinstance(is_secure_booted, bool):
            raise TypeError("Expected argument 'is_secure_booted' to be a bool")
        pulumi.set(__self__, "is_secure_booted", is_secure_booted)
        if key_management_device_to_cert_statuses and not isinstance(key_management_device_to_cert_statuses, list):
            raise TypeError("Expected argument 'key_management_device_to_cert_statuses' to be a list")
        pulumi.set(__self__, "key_management_device_to_cert_statuses", key_management_device_to_cert_statuses)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if maintenance_state and not isinstance(maintenance_state, str):
            raise TypeError("Expected argument 'maintenance_state' to be a str")
        pulumi.set(__self__, "maintenance_state", maintenance_state)
        if memory_size_bytes and not isinstance(memory_size_bytes, int):
            raise TypeError("Expected argument 'memory_size_bytes' to be a int")
        pulumi.set(__self__, "memory_size_bytes", memory_size_bytes)
        if node_status and not isinstance(node_status, str):
            raise TypeError("Expected argument 'node_status' to be a str")
        pulumi.set(__self__, "node_status", node_status)
        if number_of_cpu_cores and not isinstance(number_of_cpu_cores, int):
            raise TypeError("Expected argument 'number_of_cpu_cores' to be a int")
        pulumi.set(__self__, "number_of_cpu_cores", number_of_cpu_cores)
        if number_of_cpu_sockets and not isinstance(number_of_cpu_sockets, int):
            raise TypeError("Expected argument 'number_of_cpu_sockets' to be a int")
        pulumi.set(__self__, "number_of_cpu_sockets", number_of_cpu_sockets)
        if number_of_cpu_threads and not isinstance(number_of_cpu_threads, int):
            raise TypeError("Expected argument 'number_of_cpu_threads' to be a int")
        pulumi.set(__self__, "number_of_cpu_threads", number_of_cpu_threads)
        if rackable_unit_uuid and not isinstance(rackable_unit_uuid, str):
            raise TypeError("Expected argument 'rackable_unit_uuid' to be a str")
        pulumi.set(__self__, "rackable_unit_uuid", rackable_unit_uuid)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="blockModel")
    def block_model(self) -> _builtins.str:
        """
        - Rackable unit model name.
        """
        return pulumi.get(self, "block_model")

    @_builtins.property
    @pulumi.getter(name="blockSerial")
    def block_serial(self) -> _builtins.str:
        """
        - Rackable unit serial name.
        """
        return pulumi.get(self, "block_serial")

    @_builtins.property
    @pulumi.getter(name="bootTimeUsecs")
    def boot_time_usecs(self) -> _builtins.int:
        """
        - Boot time in secs.
        """
        return pulumi.get(self, "boot_time_usecs")

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetHostV2ClusterResult']:
        """
        - Cluster reference for an entity.
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter(name="controllerVms")
    def controller_vms(self) -> Sequence['outputs.GetHostV2ControllerVmResult']:
        """
        - Host entity with its attributes.
        """
        return pulumi.get(self, "controller_vms")

    @_builtins.property
    @pulumi.getter(name="cpuCapacityHz")
    def cpu_capacity_hz(self) -> _builtins.int:
        """
        - CPU capacity in Hz.
        """
        return pulumi.get(self, "cpu_capacity_hz")

    @_builtins.property
    @pulumi.getter(name="cpuFrequencyHz")
    def cpu_frequency_hz(self) -> _builtins.int:
        """
        - CPU frequency in Hz.
        """
        return pulumi.get(self, "cpu_frequency_hz")

    @_builtins.property
    @pulumi.getter(name="cpuModel")
    def cpu_model(self) -> _builtins.str:
        """
        - CPU model name.
        """
        return pulumi.get(self, "cpu_model")

    @_builtins.property
    @pulumi.getter(name="defaultVhdContainerUuid")
    def default_vhd_container_uuid(self) -> _builtins.str:
        """
        - Default VHD container UUID.
        """
        return pulumi.get(self, "default_vhd_container_uuid")

    @_builtins.property
    @pulumi.getter(name="defaultVhdLocation")
    def default_vhd_location(self) -> _builtins.str:
        """
        - Default VHD location.
        """
        return pulumi.get(self, "default_vhd_location")

    @_builtins.property
    @pulumi.getter(name="defaultVmContainerUuid")
    def default_vm_container_uuid(self) -> _builtins.str:
        """
        - Default VM container UUID.
        """
        return pulumi.get(self, "default_vm_container_uuid")

    @_builtins.property
    @pulumi.getter(name="defaultVmLocation")
    def default_vm_location(self) -> _builtins.str:
        """
        - Default VM location.
        """
        return pulumi.get(self, "default_vm_location")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetHostV2DiskResult']:
        """
        - Disks attached to host.
        """
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="failoverClusterFqdn")
    def failover_cluster_fqdn(self) -> _builtins.str:
        """
        - Failover cluster FQDN.
        """
        return pulumi.get(self, "failover_cluster_fqdn")

    @_builtins.property
    @pulumi.getter(name="failoverClusterNodeStatus")
    def failover_cluster_node_status(self) -> _builtins.str:
        """
        - Failover cluster node status.
        """
        return pulumi.get(self, "failover_cluster_node_status")

    @_builtins.property
    @pulumi.getter(name="gpuDriverVersion")
    def gpu_driver_version(self) -> _builtins.str:
        """
        - GPU driver version.
        """
        return pulumi.get(self, "gpu_driver_version")

    @_builtins.property
    @pulumi.getter(name="gpuLists")
    def gpu_lists(self) -> Sequence[_builtins.str]:
        """
        - GPU attached list.
        """
        return pulumi.get(self, "gpu_lists")

    @_builtins.property
    @pulumi.getter(name="hasCsr")
    def has_csr(self) -> _builtins.bool:
        """
        - Certificate signing request status.
        """
        return pulumi.get(self, "has_csr")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        - Name of the host.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="hostType")
    def host_type(self) -> _builtins.str:
        """
        - Type of the host.
        * `HYPER_CONVERGED`: Hyper-converged node.
        * `COMPUTE_ONLY`: Compute only node.
        * `STORAGE_ONLY`: Storage only node.
        """
        return pulumi.get(self, "host_type")

    @_builtins.property
    @pulumi.getter
    def hypervisors(self) -> Sequence['outputs.GetHostV2HypervisorResult']:
        """
        - Hypervisor details.
        """
        return pulumi.get(self, "hypervisors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ipmis(self) -> Sequence['outputs.GetHostV2IpmiResult']:
        """
        - IPMI reference.
        """
        return pulumi.get(self, "ipmis")

    @_builtins.property
    @pulumi.getter(name="isDegraded")
    def is_degraded(self) -> _builtins.bool:
        """
        - Node degraded status.
        """
        return pulumi.get(self, "is_degraded")

    @_builtins.property
    @pulumi.getter(name="isHardwareVirtualized")
    def is_hardware_virtualized(self) -> _builtins.bool:
        """
        - Indicates whether the hardware is virtualized or not.
        """
        return pulumi.get(self, "is_hardware_virtualized")

    @_builtins.property
    @pulumi.getter(name="isRebootPending")
    def is_reboot_pending(self) -> _builtins.bool:
        return pulumi.get(self, "is_reboot_pending")

    @_builtins.property
    @pulumi.getter(name="isSecureBooted")
    def is_secure_booted(self) -> _builtins.bool:
        """
        - Secure boot status.
        """
        return pulumi.get(self, "is_secure_booted")

    @_builtins.property
    @pulumi.getter(name="keyManagementDeviceToCertStatuses")
    def key_management_device_to_cert_statuses(self) -> Sequence['outputs.GetHostV2KeyManagementDeviceToCertStatusResult']:
        """
        - Mapping of key management device to certificate status list.
        """
        return pulumi.get(self, "key_management_device_to_cert_statuses")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetHostV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="maintenanceState")
    def maintenance_state(self) -> _builtins.str:
        """
        - Host Maintenance State.
        """
        return pulumi.get(self, "maintenance_state")

    @_builtins.property
    @pulumi.getter(name="memorySizeBytes")
    def memory_size_bytes(self) -> _builtins.int:
        """
        - Memory size in bytes.
        """
        return pulumi.get(self, "memory_size_bytes")

    @_builtins.property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> _builtins.str:
        """
        - Node status.
        * `TO_BE_PREPROTECTED`: Node to be preprotected.
        * `TO_BE_REMOVED`: Node to be removed.
        * `PREPROTECTED`: Node is preprotected.
        * `OK_TO_BE_REMOVED`: Indicates whether removing the node from the cluster is adequate.
        * `NORMAL`: Normal node.
        * `NEW_NODE`: New node.
        """
        return pulumi.get(self, "node_status")

    @_builtins.property
    @pulumi.getter(name="numberOfCpuCores")
    def number_of_cpu_cores(self) -> _builtins.int:
        """
        - Number of CPU cores.
        """
        return pulumi.get(self, "number_of_cpu_cores")

    @_builtins.property
    @pulumi.getter(name="numberOfCpuSockets")
    def number_of_cpu_sockets(self) -> _builtins.int:
        """
        - Number of CPU sockets.
        """
        return pulumi.get(self, "number_of_cpu_sockets")

    @_builtins.property
    @pulumi.getter(name="numberOfCpuThreads")
    def number_of_cpu_threads(self) -> _builtins.int:
        """
        - Number of CPU threads.
        """
        return pulumi.get(self, "number_of_cpu_threads")

    @_builtins.property
    @pulumi.getter(name="rackableUnitUuid")
    def rackable_unit_uuid(self) -> _builtins.str:
        """
        - Rackable unit UUID.
        """
        return pulumi.get(self, "rackable_unit_uuid")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - image uuid.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetHostV2Result(GetHostV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostV2Result(
            block_model=self.block_model,
            block_serial=self.block_serial,
            boot_time_usecs=self.boot_time_usecs,
            cluster_ext_id=self.cluster_ext_id,
            clusters=self.clusters,
            controller_vms=self.controller_vms,
            cpu_capacity_hz=self.cpu_capacity_hz,
            cpu_frequency_hz=self.cpu_frequency_hz,
            cpu_model=self.cpu_model,
            default_vhd_container_uuid=self.default_vhd_container_uuid,
            default_vhd_location=self.default_vhd_location,
            default_vm_container_uuid=self.default_vm_container_uuid,
            default_vm_location=self.default_vm_location,
            disks=self.disks,
            ext_id=self.ext_id,
            failover_cluster_fqdn=self.failover_cluster_fqdn,
            failover_cluster_node_status=self.failover_cluster_node_status,
            gpu_driver_version=self.gpu_driver_version,
            gpu_lists=self.gpu_lists,
            has_csr=self.has_csr,
            host_name=self.host_name,
            host_type=self.host_type,
            hypervisors=self.hypervisors,
            id=self.id,
            ipmis=self.ipmis,
            is_degraded=self.is_degraded,
            is_hardware_virtualized=self.is_hardware_virtualized,
            is_reboot_pending=self.is_reboot_pending,
            is_secure_booted=self.is_secure_booted,
            key_management_device_to_cert_statuses=self.key_management_device_to_cert_statuses,
            links=self.links,
            maintenance_state=self.maintenance_state,
            memory_size_bytes=self.memory_size_bytes,
            node_status=self.node_status,
            number_of_cpu_cores=self.number_of_cpu_cores,
            number_of_cpu_sockets=self.number_of_cpu_sockets,
            number_of_cpu_threads=self.number_of_cpu_threads,
            rackable_unit_uuid=self.rackable_unit_uuid,
            tenant_id=self.tenant_id)


def get_host_v2(cluster_ext_id: Optional[_builtins.str] = None,
                ext_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostV2Result:
    """
    Describes the statistics data of the host identified by {hostExtId} belonging to the cluster identified by {clusterExtId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    host = nutanix.get_host_v2(cluster_ext_id="021151dc-3ed1-4fec-a81d-39606451750c",
        ext_id="919c9488-0b50-4fc8-9159-923e56a3abca")
    ```


    :param _builtins.str cluster_ext_id: - (Required) cluster uuid
    :param _builtins.str ext_id: - (Required) host uuid
    """
    __args__ = dict()
    __args__['clusterExtId'] = cluster_ext_id
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getHostV2:getHostV2', __args__, opts=opts, typ=GetHostV2Result).value

    return AwaitableGetHostV2Result(
        block_model=pulumi.get(__ret__, 'block_model'),
        block_serial=pulumi.get(__ret__, 'block_serial'),
        boot_time_usecs=pulumi.get(__ret__, 'boot_time_usecs'),
        cluster_ext_id=pulumi.get(__ret__, 'cluster_ext_id'),
        clusters=pulumi.get(__ret__, 'clusters'),
        controller_vms=pulumi.get(__ret__, 'controller_vms'),
        cpu_capacity_hz=pulumi.get(__ret__, 'cpu_capacity_hz'),
        cpu_frequency_hz=pulumi.get(__ret__, 'cpu_frequency_hz'),
        cpu_model=pulumi.get(__ret__, 'cpu_model'),
        default_vhd_container_uuid=pulumi.get(__ret__, 'default_vhd_container_uuid'),
        default_vhd_location=pulumi.get(__ret__, 'default_vhd_location'),
        default_vm_container_uuid=pulumi.get(__ret__, 'default_vm_container_uuid'),
        default_vm_location=pulumi.get(__ret__, 'default_vm_location'),
        disks=pulumi.get(__ret__, 'disks'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        failover_cluster_fqdn=pulumi.get(__ret__, 'failover_cluster_fqdn'),
        failover_cluster_node_status=pulumi.get(__ret__, 'failover_cluster_node_status'),
        gpu_driver_version=pulumi.get(__ret__, 'gpu_driver_version'),
        gpu_lists=pulumi.get(__ret__, 'gpu_lists'),
        has_csr=pulumi.get(__ret__, 'has_csr'),
        host_name=pulumi.get(__ret__, 'host_name'),
        host_type=pulumi.get(__ret__, 'host_type'),
        hypervisors=pulumi.get(__ret__, 'hypervisors'),
        id=pulumi.get(__ret__, 'id'),
        ipmis=pulumi.get(__ret__, 'ipmis'),
        is_degraded=pulumi.get(__ret__, 'is_degraded'),
        is_hardware_virtualized=pulumi.get(__ret__, 'is_hardware_virtualized'),
        is_reboot_pending=pulumi.get(__ret__, 'is_reboot_pending'),
        is_secure_booted=pulumi.get(__ret__, 'is_secure_booted'),
        key_management_device_to_cert_statuses=pulumi.get(__ret__, 'key_management_device_to_cert_statuses'),
        links=pulumi.get(__ret__, 'links'),
        maintenance_state=pulumi.get(__ret__, 'maintenance_state'),
        memory_size_bytes=pulumi.get(__ret__, 'memory_size_bytes'),
        node_status=pulumi.get(__ret__, 'node_status'),
        number_of_cpu_cores=pulumi.get(__ret__, 'number_of_cpu_cores'),
        number_of_cpu_sockets=pulumi.get(__ret__, 'number_of_cpu_sockets'),
        number_of_cpu_threads=pulumi.get(__ret__, 'number_of_cpu_threads'),
        rackable_unit_uuid=pulumi.get(__ret__, 'rackable_unit_uuid'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_host_v2_output(cluster_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                       ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostV2Result]:
    """
    Describes the statistics data of the host identified by {hostExtId} belonging to the cluster identified by {clusterExtId}.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    host = nutanix.get_host_v2(cluster_ext_id="021151dc-3ed1-4fec-a81d-39606451750c",
        ext_id="919c9488-0b50-4fc8-9159-923e56a3abca")
    ```


    :param _builtins.str cluster_ext_id: - (Required) cluster uuid
    :param _builtins.str ext_id: - (Required) host uuid
    """
    __args__ = dict()
    __args__['clusterExtId'] = cluster_ext_id
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getHostV2:getHostV2', __args__, opts=opts, typ=GetHostV2Result)
    return __ret__.apply(lambda __response__: GetHostV2Result(
        block_model=pulumi.get(__response__, 'block_model'),
        block_serial=pulumi.get(__response__, 'block_serial'),
        boot_time_usecs=pulumi.get(__response__, 'boot_time_usecs'),
        cluster_ext_id=pulumi.get(__response__, 'cluster_ext_id'),
        clusters=pulumi.get(__response__, 'clusters'),
        controller_vms=pulumi.get(__response__, 'controller_vms'),
        cpu_capacity_hz=pulumi.get(__response__, 'cpu_capacity_hz'),
        cpu_frequency_hz=pulumi.get(__response__, 'cpu_frequency_hz'),
        cpu_model=pulumi.get(__response__, 'cpu_model'),
        default_vhd_container_uuid=pulumi.get(__response__, 'default_vhd_container_uuid'),
        default_vhd_location=pulumi.get(__response__, 'default_vhd_location'),
        default_vm_container_uuid=pulumi.get(__response__, 'default_vm_container_uuid'),
        default_vm_location=pulumi.get(__response__, 'default_vm_location'),
        disks=pulumi.get(__response__, 'disks'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        failover_cluster_fqdn=pulumi.get(__response__, 'failover_cluster_fqdn'),
        failover_cluster_node_status=pulumi.get(__response__, 'failover_cluster_node_status'),
        gpu_driver_version=pulumi.get(__response__, 'gpu_driver_version'),
        gpu_lists=pulumi.get(__response__, 'gpu_lists'),
        has_csr=pulumi.get(__response__, 'has_csr'),
        host_name=pulumi.get(__response__, 'host_name'),
        host_type=pulumi.get(__response__, 'host_type'),
        hypervisors=pulumi.get(__response__, 'hypervisors'),
        id=pulumi.get(__response__, 'id'),
        ipmis=pulumi.get(__response__, 'ipmis'),
        is_degraded=pulumi.get(__response__, 'is_degraded'),
        is_hardware_virtualized=pulumi.get(__response__, 'is_hardware_virtualized'),
        is_reboot_pending=pulumi.get(__response__, 'is_reboot_pending'),
        is_secure_booted=pulumi.get(__response__, 'is_secure_booted'),
        key_management_device_to_cert_statuses=pulumi.get(__response__, 'key_management_device_to_cert_statuses'),
        links=pulumi.get(__response__, 'links'),
        maintenance_state=pulumi.get(__response__, 'maintenance_state'),
        memory_size_bytes=pulumi.get(__response__, 'memory_size_bytes'),
        node_status=pulumi.get(__response__, 'node_status'),
        number_of_cpu_cores=pulumi.get(__response__, 'number_of_cpu_cores'),
        number_of_cpu_sockets=pulumi.get(__response__, 'number_of_cpu_sockets'),
        number_of_cpu_threads=pulumi.get(__response__, 'number_of_cpu_threads'),
        rackable_unit_uuid=pulumi.get(__response__, 'rackable_unit_uuid'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
