# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetHostsV2Result',
    'AwaitableGetHostsV2Result',
    'get_hosts_v2',
    'get_hosts_v2_output',
]

@pulumi.output_type
class GetHostsV2Result:
    """
    A collection of values returned by getHostsV2.
    """
    def __init__(__self__, apply=None, filter=None, host_entities=None, id=None, limit=None, order_by=None, page=None, select=None):
        if apply and not isinstance(apply, str):
            raise TypeError("Expected argument 'apply' to be a str")
        pulumi.set(__self__, "apply", apply)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if host_entities and not isinstance(host_entities, list):
            raise TypeError("Expected argument 'host_entities' to be a list")
        pulumi.set(__self__, "host_entities", host_entities)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)

    @_builtins.property
    @pulumi.getter
    def apply(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "apply")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="hostEntities")
    def host_entities(self) -> Sequence['outputs.GetHostsV2HostEntityResult']:
        """
        - Lists all host entities across clusters registered to Prism Central.
        """
        return pulumi.get(self, "host_entities")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")


class AwaitableGetHostsV2Result(GetHostsV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostsV2Result(
            apply=self.apply,
            filter=self.filter,
            host_entities=self.host_entities,
            id=self.id,
            limit=self.limit,
            order_by=self.order_by,
            page=self.page,
            select=self.select)


def get_hosts_v2(apply: Optional[_builtins.str] = None,
                 filter: Optional[_builtins.str] = None,
                 limit: Optional[_builtins.int] = None,
                 order_by: Optional[_builtins.str] = None,
                 page: Optional[_builtins.int] = None,
                 select: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostsV2Result:
    """
    Describes the Lists of all host entities across clusters registered to Prism Central.

    ## Example Usage

    ## Host Entities

    The host_entities attribute supports the following:

    * `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    * `tenant_id`: - image uuid.
    * `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    * `host_name`: - Name of the host.
    * `host_type`: - Type of the host.
       * `HYPER_CONVERGED`: Hyper-converged node.
       * `COMPUTE_ONLY`: Compute only node.
       * `STORAGE_ONLY`: Storage only node.
    * `hypervisor`: - Hypervisor details.
    * `cluster`: - Cluster reference for an entity.
    * `controller_vm`: - Host entity with its attributes.
    * `disk`: - Disks attached to host.
    * `is_degraded`: - Node degraded status.
    * `is_secure_booted`: - Secure boot status.
    * `is_hardware_virtualized`: - Indicates whether the hardware is virtualized or not.
    * `has_csr`: - Certificate signing request status.
    * `key_management_device_to_cert_status`: - Mapping of key management device to certificate status list.
    * `number_of_cpu_cores`: - Number of CPU cores.
    * `number_of_cpu_threads`: - Number of CPU threads.
    * `number_of_cpu_sockets`: - Number of CPU sockets.
    * `cpu_capacity_hz`: - CPU capacity in Hz.
    * `cpu_frequency_hz`: - CPU frequency in Hz.
    * `cpu_model`: - CPU model name.
    * `gpu_driver_version`: - GPU driver version.
    * `gpu_list`: - GPU attached list.
    * `default_vhd_location`: - Default VHD location.
    * `default_vhd_container_uuid`: - Default VHD container UUID.
    * `default_vm_location`: - Default VM location.
    * `default_vm_container_uuid`: - Default VM container UUID.
    * `reboot_pending`: - Reboot pending status.
    * `failover_cluster_fqdn`: - Failover cluster FQDN.
    * `failover_cluster_node_status`: - Failover cluster node status.
    * `boot_time_usecs`: - Boot time in secs.
    * `memory_size_bytes`: - Memory size in bytes.
    * `block_serial`: - Rackable unit serial name.
    * `block_model`: - Rackable unit model name.
    * `maintenance_state`: - Host Maintenance State.
    * `node_status`: - Node status.
       * `TO_BE_PREPROTECTED`: Node to be preprotected.
       * `TO_BE_REMOVED`: Node to be removed.
       * `PREPROTECTED`: Node is preprotected.
       * `OK_TO_BE_REMOVED`: Indicates whether removing the node from the cluster is adequate.
       * `NORMAL`: Normal node.
       * `NEW_NODE`: New node.

    ### Links

    The links attribute supports the following:

    * `href`: - The URL at which the entity described by the link can be accessed.
    * `rel`: - A name that identifies the relationship of the link to the object that is returned by the URL. The unique value of "self" identifies the URL for the object.

    ### Hypervisor
    The hypervisor attribute supports the following:

    * `external_address`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `user_name`: - Hypervisor user name.
    * `full_name`: - Hypervisor full name.
    * `type`: - Hypervisor type.
       * `XEN`: Xen hypervisor.
       * `HYPERV`: HyperV hypervisor.
       * `ESX`: ESX hypervisor.
       * `AHV`: AHV hypervisor.
    * `number_of_vms`: - Number of VMs.
    * `state`: - Hypervisor state.
       * `HA_HEALING_TARGET`: Hypervisor in HA healing target state.
       * `ENTERING_MAINTENANCE_MODE`: Hypervisor entering maintenance mode.
       * `RESERVED_FOR_HA_FAILOVER`: Hypervisor reserved for HA failover.
       * `HA_HEALING_SOURCE`: Hypervisor in HA healing source state.
       * `RESERVING_FOR_HA_FAILOVER`: Hypervisor that is planned to be reserved for HA failover.
       * `HA_FAILOVER_SOURCE`: Hypervisor in HA failover source state.
       * `ACROPOLIS_NORMAL`: Hypervisor in Acropolis normal state.
       * `ENTERED_MAINTENANCE_MODE`: Hypervisor entered maintenance mode.
       * `ENTERING_MAINTENANCE_MODE_FROM_HA_FAILOVER`: Hypervisor entering maintenance mode from HA failover.
       * `HA_FAILOVER_TARGET`: Hypervisor in HA failover target state.
    * `acropolis_connection_state`: - Status of Acropolis connection to hypervisor.
       * `DISCONNECTED`: Acropolis disconnected.
       * `CONNECTED`: Acropolis connected.

    ### Cluster
    The cluster attribute supports the following:

    * `uuid`: - Cluster UUID.
    * `name`: - Cluster name. This is part of payload for both cluster create & update operations.

    ### Controller VM
    The controller_vm attribute supports the following:

    * `id`: - Controller VM Id.
    * `external_address`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `backplane_address`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `rdma_backplane_address`: - RDMA backplane address.
    * `ipmi`: - IPMI reference.
    * `nat_ip`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `nat_port`: - NAT port.
    * `maintenance_mode`: - Maintenance mode status.
    * `rackable_unit_uuid`: - Rackable unit UUID.

    ### Disk
    The disk attribute supports the following:

    * `uuid`: - Disk UUID.
    * `mount_path`: - Disk mount path.
    * `size_in_bytes`: - Disk size.
    * `serial_id`: - Disk serial Id.
    * `storage_tier`: - Disk storage Tier type.
       * `HDD`: HDD storage tier.
       * `PCIE_SSD`: PCIE SSD storage tier.
       * `SATA_SSD`: SATA SSD storage tier.

    ### key Management Device To Cert Status
    The key_management_device_to_cert_status attribute supports the following:

    * `key_management_server_name`: - Key management server name.
    * `status`: - Certificate status.

    #### external Address
    The external_address attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### Backplane Address
    The backplane_address attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### Rdma Backplane Address
    The rdma_backplane_address attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### ipmi
    The ipmi attribute supports the following:

    * `ip`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `username`: - IPMI username.

    #### Nat Ip
    The nat_ip attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    ##### ip

    The ip attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    ###### IPV4

    The ipv4 attribute supports the following:

    * `value`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `prefix_length`: - The prefix length of the network to which this host IPv4 address belongs.

    ###### IPV6

    The ipv6 attribute supports the following:

    * `value`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    * `prefix_length`: - The prefix length of the network to which this host IPv6 address belongs.

    See detailed information in [Nutanix List Hosts V4](https://developers.nutanix.com/api-reference?namespace=clustermgmt&version=v4.0#tag/Clusters/operation/listHostsByClusterId).


    :param _builtins.str apply: -(Optional) A URL query parameter that allows clients to specify a sequence of transformations to the entity set, such as groupby, filter, aggregate etc. As of now only support for groupby exists.For example '\\$apply=groupby((templateName))' would get all templates grouped by templateName. The groupby can be applied on the following fields:
           * `cluster/name`
           * `hypervisor/type`
    :param _builtins.str filter: -(Optional) A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
           * `bootTimeUsecs`
           * `cluster/name`
           * `cluster/uuid`
           * `cpuCapacityHz`
           * `cpuFrequencyHz`
           * `cpuModel`
           * `defaultVhdContainerUuid`
           * `defaultVhdLocation`
           * `defaultVmContainerUuid`
           * `defaultVmLocation`
           * `extId`
           * `gpuDriverVersion`
           * `gpuList`
           * `hostName`
           * `hypervisor/type`
           * `memorySizeBytes`
           * `numberOfCpuCores`
           * `numberOfCpuSockets`
           * `numberOfCpuThreads`
    :param _builtins.int limit: -(Optional) A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.int page: -(Optional) A query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource.
    :param _builtins.str select: -(Optional) A query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., \\*), then all properties on the matching resource will be returned. The select can be applied to the following fields:
           * `blockModel`
           * `blockSerial`
           * `bootTimeUsecs`
    """
    __args__ = dict()
    __args__['apply'] = apply
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getHostsV2:getHostsV2', __args__, opts=opts, typ=GetHostsV2Result).value

    return AwaitableGetHostsV2Result(
        apply=pulumi.get(__ret__, 'apply'),
        filter=pulumi.get(__ret__, 'filter'),
        host_entities=pulumi.get(__ret__, 'host_entities'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        select=pulumi.get(__ret__, 'select'))
def get_hosts_v2_output(apply: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostsV2Result]:
    """
    Describes the Lists of all host entities across clusters registered to Prism Central.

    ## Example Usage

    ## Host Entities

    The host_entities attribute supports the following:

    * `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    * `tenant_id`: - image uuid.
    * `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    * `host_name`: - Name of the host.
    * `host_type`: - Type of the host.
       * `HYPER_CONVERGED`: Hyper-converged node.
       * `COMPUTE_ONLY`: Compute only node.
       * `STORAGE_ONLY`: Storage only node.
    * `hypervisor`: - Hypervisor details.
    * `cluster`: - Cluster reference for an entity.
    * `controller_vm`: - Host entity with its attributes.
    * `disk`: - Disks attached to host.
    * `is_degraded`: - Node degraded status.
    * `is_secure_booted`: - Secure boot status.
    * `is_hardware_virtualized`: - Indicates whether the hardware is virtualized or not.
    * `has_csr`: - Certificate signing request status.
    * `key_management_device_to_cert_status`: - Mapping of key management device to certificate status list.
    * `number_of_cpu_cores`: - Number of CPU cores.
    * `number_of_cpu_threads`: - Number of CPU threads.
    * `number_of_cpu_sockets`: - Number of CPU sockets.
    * `cpu_capacity_hz`: - CPU capacity in Hz.
    * `cpu_frequency_hz`: - CPU frequency in Hz.
    * `cpu_model`: - CPU model name.
    * `gpu_driver_version`: - GPU driver version.
    * `gpu_list`: - GPU attached list.
    * `default_vhd_location`: - Default VHD location.
    * `default_vhd_container_uuid`: - Default VHD container UUID.
    * `default_vm_location`: - Default VM location.
    * `default_vm_container_uuid`: - Default VM container UUID.
    * `reboot_pending`: - Reboot pending status.
    * `failover_cluster_fqdn`: - Failover cluster FQDN.
    * `failover_cluster_node_status`: - Failover cluster node status.
    * `boot_time_usecs`: - Boot time in secs.
    * `memory_size_bytes`: - Memory size in bytes.
    * `block_serial`: - Rackable unit serial name.
    * `block_model`: - Rackable unit model name.
    * `maintenance_state`: - Host Maintenance State.
    * `node_status`: - Node status.
       * `TO_BE_PREPROTECTED`: Node to be preprotected.
       * `TO_BE_REMOVED`: Node to be removed.
       * `PREPROTECTED`: Node is preprotected.
       * `OK_TO_BE_REMOVED`: Indicates whether removing the node from the cluster is adequate.
       * `NORMAL`: Normal node.
       * `NEW_NODE`: New node.

    ### Links

    The links attribute supports the following:

    * `href`: - The URL at which the entity described by the link can be accessed.
    * `rel`: - A name that identifies the relationship of the link to the object that is returned by the URL. The unique value of "self" identifies the URL for the object.

    ### Hypervisor
    The hypervisor attribute supports the following:

    * `external_address`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `user_name`: - Hypervisor user name.
    * `full_name`: - Hypervisor full name.
    * `type`: - Hypervisor type.
       * `XEN`: Xen hypervisor.
       * `HYPERV`: HyperV hypervisor.
       * `ESX`: ESX hypervisor.
       * `AHV`: AHV hypervisor.
    * `number_of_vms`: - Number of VMs.
    * `state`: - Hypervisor state.
       * `HA_HEALING_TARGET`: Hypervisor in HA healing target state.
       * `ENTERING_MAINTENANCE_MODE`: Hypervisor entering maintenance mode.
       * `RESERVED_FOR_HA_FAILOVER`: Hypervisor reserved for HA failover.
       * `HA_HEALING_SOURCE`: Hypervisor in HA healing source state.
       * `RESERVING_FOR_HA_FAILOVER`: Hypervisor that is planned to be reserved for HA failover.
       * `HA_FAILOVER_SOURCE`: Hypervisor in HA failover source state.
       * `ACROPOLIS_NORMAL`: Hypervisor in Acropolis normal state.
       * `ENTERED_MAINTENANCE_MODE`: Hypervisor entered maintenance mode.
       * `ENTERING_MAINTENANCE_MODE_FROM_HA_FAILOVER`: Hypervisor entering maintenance mode from HA failover.
       * `HA_FAILOVER_TARGET`: Hypervisor in HA failover target state.
    * `acropolis_connection_state`: - Status of Acropolis connection to hypervisor.
       * `DISCONNECTED`: Acropolis disconnected.
       * `CONNECTED`: Acropolis connected.

    ### Cluster
    The cluster attribute supports the following:

    * `uuid`: - Cluster UUID.
    * `name`: - Cluster name. This is part of payload for both cluster create & update operations.

    ### Controller VM
    The controller_vm attribute supports the following:

    * `id`: - Controller VM Id.
    * `external_address`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `backplane_address`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `rdma_backplane_address`: - RDMA backplane address.
    * `ipmi`: - IPMI reference.
    * `nat_ip`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `nat_port`: - NAT port.
    * `maintenance_mode`: - Maintenance mode status.
    * `rackable_unit_uuid`: - Rackable unit UUID.

    ### Disk
    The disk attribute supports the following:

    * `uuid`: - Disk UUID.
    * `mount_path`: - Disk mount path.
    * `size_in_bytes`: - Disk size.
    * `serial_id`: - Disk serial Id.
    * `storage_tier`: - Disk storage Tier type.
       * `HDD`: HDD storage tier.
       * `PCIE_SSD`: PCIE SSD storage tier.
       * `SATA_SSD`: SATA SSD storage tier.

    ### key Management Device To Cert Status
    The key_management_device_to_cert_status attribute supports the following:

    * `key_management_server_name`: - Key management server name.
    * `status`: - Certificate status.

    #### external Address
    The external_address attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### Backplane Address
    The backplane_address attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### Rdma Backplane Address
    The rdma_backplane_address attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### ipmi
    The ipmi attribute supports the following:

    * `ip`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    * `username`: - IPMI username.

    #### Nat Ip
    The nat_ip attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    ##### ip

    The ip attribute supports the following:

    * `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    ###### IPV4

    The ipv4 attribute supports the following:

    * `value`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    * `prefix_length`: - The prefix length of the network to which this host IPv4 address belongs.

    ###### IPV6

    The ipv6 attribute supports the following:

    * `value`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    * `prefix_length`: - The prefix length of the network to which this host IPv6 address belongs.

    See detailed information in [Nutanix List Hosts V4](https://developers.nutanix.com/api-reference?namespace=clustermgmt&version=v4.0#tag/Clusters/operation/listHostsByClusterId).


    :param _builtins.str apply: -(Optional) A URL query parameter that allows clients to specify a sequence of transformations to the entity set, such as groupby, filter, aggregate etc. As of now only support for groupby exists.For example '\\$apply=groupby((templateName))' would get all templates grouped by templateName. The groupby can be applied on the following fields:
           * `cluster/name`
           * `hypervisor/type`
    :param _builtins.str filter: -(Optional) A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
           * `bootTimeUsecs`
           * `cluster/name`
           * `cluster/uuid`
           * `cpuCapacityHz`
           * `cpuFrequencyHz`
           * `cpuModel`
           * `defaultVhdContainerUuid`
           * `defaultVhdLocation`
           * `defaultVmContainerUuid`
           * `defaultVmLocation`
           * `extId`
           * `gpuDriverVersion`
           * `gpuList`
           * `hostName`
           * `hypervisor/type`
           * `memorySizeBytes`
           * `numberOfCpuCores`
           * `numberOfCpuSockets`
           * `numberOfCpuThreads`
    :param _builtins.int limit: -(Optional) A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.int page: -(Optional) A query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource.
    :param _builtins.str select: -(Optional) A query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., \\*), then all properties on the matching resource will be returned. The select can be applied to the following fields:
           * `blockModel`
           * `blockSerial`
           * `bootTimeUsecs`
    """
    __args__ = dict()
    __args__['apply'] = apply
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getHostsV2:getHostsV2', __args__, opts=opts, typ=GetHostsV2Result)
    return __ret__.apply(lambda __response__: GetHostsV2Result(
        apply=pulumi.get(__response__, 'apply'),
        filter=pulumi.get(__response__, 'filter'),
        host_entities=pulumi.get(__response__, 'host_entities'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        select=pulumi.get(__response__, 'select')))
