# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetImageResult',
    'AwaitableGetImageResult',
    'get_image',
    'get_image_output',
]

@pulumi.output_type
class GetImageResult:
    """
    A collection of values returned by getImage.
    """
    def __init__(__self__, api_version=None, architecture=None, availability_zone_reference=None, categories=None, checksum=None, cluster_name=None, cluster_references=None, cluster_uuid=None, current_cluster_reference_lists=None, data_source_references=None, description=None, id=None, image_id=None, image_name=None, image_type=None, metadata=None, name=None, owner_reference=None, project_reference=None, retrieval_uri_lists=None, size_bytes=None, source_uri=None, state=None, version=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if availability_zone_reference and not isinstance(availability_zone_reference, dict):
            raise TypeError("Expected argument 'availability_zone_reference' to be a dict")
        pulumi.set(__self__, "availability_zone_reference", availability_zone_reference)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if checksum and not isinstance(checksum, dict):
            raise TypeError("Expected argument 'checksum' to be a dict")
        pulumi.set(__self__, "checksum", checksum)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_references and not isinstance(cluster_references, list):
            raise TypeError("Expected argument 'cluster_references' to be a list")
        pulumi.set(__self__, "cluster_references", cluster_references)
        if cluster_uuid and not isinstance(cluster_uuid, str):
            raise TypeError("Expected argument 'cluster_uuid' to be a str")
        pulumi.set(__self__, "cluster_uuid", cluster_uuid)
        if current_cluster_reference_lists and not isinstance(current_cluster_reference_lists, list):
            raise TypeError("Expected argument 'current_cluster_reference_lists' to be a list")
        pulumi.set(__self__, "current_cluster_reference_lists", current_cluster_reference_lists)
        if data_source_references and not isinstance(data_source_references, list):
            raise TypeError("Expected argument 'data_source_references' to be a list")
        pulumi.set(__self__, "data_source_references", data_source_references)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if image_name and not isinstance(image_name, str):
            raise TypeError("Expected argument 'image_name' to be a str")
        pulumi.set(__self__, "image_name", image_name)
        if image_type and not isinstance(image_type, str):
            raise TypeError("Expected argument 'image_type' to be a str")
        pulumi.set(__self__, "image_type", image_type)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_reference and not isinstance(owner_reference, dict):
            raise TypeError("Expected argument 'owner_reference' to be a dict")
        pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference and not isinstance(project_reference, dict):
            raise TypeError("Expected argument 'project_reference' to be a dict")
        pulumi.set(__self__, "project_reference", project_reference)
        if retrieval_uri_lists and not isinstance(retrieval_uri_lists, list):
            raise TypeError("Expected argument 'retrieval_uri_lists' to be a list")
        pulumi.set(__self__, "retrieval_uri_lists", retrieval_uri_lists)
        if size_bytes and not isinstance(size_bytes, int):
            raise TypeError("Expected argument 'size_bytes' to be a int")
        pulumi.set(__self__, "size_bytes", size_bytes)
        if source_uri and not isinstance(source_uri, str):
            raise TypeError("Expected argument 'source_uri' to be a str")
        pulumi.set(__self__, "source_uri", source_uri)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if version and not isinstance(version, dict):
            raise TypeError("Expected argument 'version' to be a dict")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> _builtins.str:
        """
        - The supported CPU architecture for a disk image.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneReference")
    def availability_zone_reference(self) -> Mapping[str, _builtins.str]:
        """
        - The reference to a availability_zone.
        """
        return pulumi.get(self, "availability_zone_reference")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetImageCategoryResult']:
        """
        - Categories for the image.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> Mapping[str, _builtins.str]:
        """
        - Checksum of the image. The checksum is used for image validation if the image has a source specified. For images that do not have their source specified the checksum is generated by the image service.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> _builtins.str:
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterReferences")
    def cluster_references(self) -> Sequence['outputs.GetImageClusterReferenceResult']:
        return pulumi.get(self, "cluster_references")

    @_builtins.property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> _builtins.str:
        return pulumi.get(self, "cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="currentClusterReferenceLists")
    def current_cluster_reference_lists(self) -> Sequence['outputs.GetImageCurrentClusterReferenceListResult']:
        return pulumi.get(self, "current_cluster_reference_lists")

    @_builtins.property
    @pulumi.getter(name="dataSourceReferences")
    def data_source_references(self) -> Sequence['outputs.GetImageDataSourceReferenceResult']:
        """
        - Reference to a data source.
        """
        return pulumi.get(self, "data_source_references")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - A description for image.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="imageType")
    def image_type(self) -> _builtins.str:
        """
        - The type of image.
        """
        return pulumi.get(self, "image_type")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        - The image kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - the name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Mapping[str, _builtins.str]:
        """
        - The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Mapping[str, _builtins.str]:
        """
        - The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="retrievalUriLists")
    def retrieval_uri_lists(self) -> Sequence[_builtins.str]:
        """
        - List of URIs where the raw image data can be accessed.
        """
        return pulumi.get(self, "retrieval_uri_lists")

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> _builtins.int:
        """
        - The size of the image in bytes.
        """
        return pulumi.get(self, "size_bytes")

    @_builtins.property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> _builtins.str:
        """
        - The source URI points at the location of the source image which is used to create/update image.
        """
        return pulumi.get(self, "source_uri")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        - The state of the image.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Mapping[str, _builtins.str]:
        """
        - The image version.
        """
        return pulumi.get(self, "version")


class AwaitableGetImageResult(GetImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageResult(
            api_version=self.api_version,
            architecture=self.architecture,
            availability_zone_reference=self.availability_zone_reference,
            categories=self.categories,
            checksum=self.checksum,
            cluster_name=self.cluster_name,
            cluster_references=self.cluster_references,
            cluster_uuid=self.cluster_uuid,
            current_cluster_reference_lists=self.current_cluster_reference_lists,
            data_source_references=self.data_source_references,
            description=self.description,
            id=self.id,
            image_id=self.image_id,
            image_name=self.image_name,
            image_type=self.image_type,
            metadata=self.metadata,
            name=self.name,
            owner_reference=self.owner_reference,
            project_reference=self.project_reference,
            retrieval_uri_lists=self.retrieval_uri_lists,
            size_bytes=self.size_bytes,
            source_uri=self.source_uri,
            state=self.state,
            version=self.version)


def get_image(categories: Optional[Sequence[Union['GetImageCategoryArgs', 'GetImageCategoryArgsDict']]] = None,
              image_id: Optional[_builtins.str] = None,
              image_name: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageResult:
    """
    Describes a Image

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test_image = nutanix.Image("test",
        name="Ubuntu",
        description="Ubuntu",
        source_uri="http://archive.ubuntu.com/ubuntu/dists/bionic/main/installer-amd64/current/images/netboot/mini.iso")
    test = nutanix.get_image_output(image_id=test_image.id)
    testname = nutanix.get_image_output(image_name=test_image.name)
    ```


    :param Sequence[Union['GetImageCategoryArgs', 'GetImageCategoryArgsDict']] categories: - Categories for the image.
    :param _builtins.str image_id: Represents image UUID
    :param _builtins.str image_name: Represents image name
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['imageId'] = image_id
    __args__['imageName'] = image_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult).value

    return AwaitableGetImageResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        architecture=pulumi.get(__ret__, 'architecture'),
        availability_zone_reference=pulumi.get(__ret__, 'availability_zone_reference'),
        categories=pulumi.get(__ret__, 'categories'),
        checksum=pulumi.get(__ret__, 'checksum'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        cluster_references=pulumi.get(__ret__, 'cluster_references'),
        cluster_uuid=pulumi.get(__ret__, 'cluster_uuid'),
        current_cluster_reference_lists=pulumi.get(__ret__, 'current_cluster_reference_lists'),
        data_source_references=pulumi.get(__ret__, 'data_source_references'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        image_name=pulumi.get(__ret__, 'image_name'),
        image_type=pulumi.get(__ret__, 'image_type'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        owner_reference=pulumi.get(__ret__, 'owner_reference'),
        project_reference=pulumi.get(__ret__, 'project_reference'),
        retrieval_uri_lists=pulumi.get(__ret__, 'retrieval_uri_lists'),
        size_bytes=pulumi.get(__ret__, 'size_bytes'),
        source_uri=pulumi.get(__ret__, 'source_uri'),
        state=pulumi.get(__ret__, 'state'),
        version=pulumi.get(__ret__, 'version'))
def get_image_output(categories: Optional[pulumi.Input[Optional[Sequence[Union['GetImageCategoryArgs', 'GetImageCategoryArgsDict']]]]] = None,
                     image_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     image_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageResult]:
    """
    Describes a Image

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test_image = nutanix.Image("test",
        name="Ubuntu",
        description="Ubuntu",
        source_uri="http://archive.ubuntu.com/ubuntu/dists/bionic/main/installer-amd64/current/images/netboot/mini.iso")
    test = nutanix.get_image_output(image_id=test_image.id)
    testname = nutanix.get_image_output(image_name=test_image.name)
    ```


    :param Sequence[Union['GetImageCategoryArgs', 'GetImageCategoryArgsDict']] categories: - Categories for the image.
    :param _builtins.str image_id: Represents image UUID
    :param _builtins.str image_name: Represents image name
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['imageId'] = image_id
    __args__['imageName'] = image_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getImage:getImage', __args__, opts=opts, typ=GetImageResult)
    return __ret__.apply(lambda __response__: GetImageResult(
        api_version=pulumi.get(__response__, 'api_version'),
        architecture=pulumi.get(__response__, 'architecture'),
        availability_zone_reference=pulumi.get(__response__, 'availability_zone_reference'),
        categories=pulumi.get(__response__, 'categories'),
        checksum=pulumi.get(__response__, 'checksum'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        cluster_references=pulumi.get(__response__, 'cluster_references'),
        cluster_uuid=pulumi.get(__response__, 'cluster_uuid'),
        current_cluster_reference_lists=pulumi.get(__response__, 'current_cluster_reference_lists'),
        data_source_references=pulumi.get(__response__, 'data_source_references'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        image_name=pulumi.get(__response__, 'image_name'),
        image_type=pulumi.get(__response__, 'image_type'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        owner_reference=pulumi.get(__response__, 'owner_reference'),
        project_reference=pulumi.get(__response__, 'project_reference'),
        retrieval_uri_lists=pulumi.get(__response__, 'retrieval_uri_lists'),
        size_bytes=pulumi.get(__response__, 'size_bytes'),
        source_uri=pulumi.get(__response__, 'source_uri'),
        state=pulumi.get(__response__, 'state'),
        version=pulumi.get(__response__, 'version')))
