# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetImagePlacementPolicyV2Result',
    'AwaitableGetImagePlacementPolicyV2Result',
    'get_image_placement_policy_v2',
    'get_image_placement_policy_v2_output',
]

@pulumi.output_type
class GetImagePlacementPolicyV2Result:
    """
    A collection of values returned by getImagePlacementPolicyV2.
    """
    def __init__(__self__, cluster_entity_filters=None, create_time=None, description=None, enforcement_state=None, ext_id=None, id=None, image_entity_filters=None, last_update_time=None, name=None, owner_ext_id=None, placement_type=None):
        if cluster_entity_filters and not isinstance(cluster_entity_filters, list):
            raise TypeError("Expected argument 'cluster_entity_filters' to be a list")
        pulumi.set(__self__, "cluster_entity_filters", cluster_entity_filters)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enforcement_state and not isinstance(enforcement_state, str):
            raise TypeError("Expected argument 'enforcement_state' to be a str")
        pulumi.set(__self__, "enforcement_state", enforcement_state)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_entity_filters and not isinstance(image_entity_filters, list):
            raise TypeError("Expected argument 'image_entity_filters' to be a list")
        pulumi.set(__self__, "image_entity_filters", image_entity_filters)
        if last_update_time and not isinstance(last_update_time, str):
            raise TypeError("Expected argument 'last_update_time' to be a str")
        pulumi.set(__self__, "last_update_time", last_update_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_ext_id and not isinstance(owner_ext_id, str):
            raise TypeError("Expected argument 'owner_ext_id' to be a str")
        pulumi.set(__self__, "owner_ext_id", owner_ext_id)
        if placement_type and not isinstance(placement_type, str):
            raise TypeError("Expected argument 'placement_type' to be a str")
        pulumi.set(__self__, "placement_type", placement_type)

    @_builtins.property
    @pulumi.getter(name="clusterEntityFilters")
    def cluster_entity_filters(self) -> Sequence['outputs.GetImagePlacementPolicyV2ClusterEntityFilterResult']:
        """
        (Required) Category-based entity filter.
        """
        return pulumi.get(self, "cluster_entity_filters")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (Optional) Description of the image placement policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enforcementState")
    def enforcement_state(self) -> _builtins.str:
        """
        (Optional) Enforcement status of the image placement policy. Valid values:
        - ACTIVE: The image placement policy is being actively enforced.
        - SUSPENDED: The policy enforcement for image placement is suspended.
        """
        return pulumi.get(self, "enforcement_state")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageEntityFilters")
    def image_entity_filters(self) -> Sequence['outputs.GetImagePlacementPolicyV2ImageEntityFilterResult']:
        """
        (Required) Category-based entity filter.
        """
        return pulumi.get(self, "image_entity_filters")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> _builtins.str:
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Required) Name of the image placement policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "owner_ext_id")

    @_builtins.property
    @pulumi.getter(name="placementType")
    def placement_type(self) -> _builtins.str:
        """
        (Required) Type of the image placement policy. Valid values:
        - HARD: Hard placement policy. Images can only be placed on clusters enforced by the image placement policy.
        - SOFT: Soft placement policy. Images can be placed on clusters apart from those enforced by the image placement policy.
        """
        return pulumi.get(self, "placement_type")


class AwaitableGetImagePlacementPolicyV2Result(GetImagePlacementPolicyV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImagePlacementPolicyV2Result(
            cluster_entity_filters=self.cluster_entity_filters,
            create_time=self.create_time,
            description=self.description,
            enforcement_state=self.enforcement_state,
            ext_id=self.ext_id,
            id=self.id,
            image_entity_filters=self.image_entity_filters,
            last_update_time=self.last_update_time,
            name=self.name,
            owner_ext_id=self.owner_ext_id,
            placement_type=self.placement_type)


def get_image_placement_policy_v2(ext_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImagePlacementPolicyV2Result:
    """
    Retrieve the image placement policy details for the provided external identifier.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    ipp = nutanix.get_image_placement_policy_v2(ext_id="cf96e27a-4e52-4cec-b563-d0b25413cc4a")
    ```


    :param _builtins.str ext_id: The external identifier of an image placement policy.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getImagePlacementPolicyV2:getImagePlacementPolicyV2', __args__, opts=opts, typ=GetImagePlacementPolicyV2Result).value

    return AwaitableGetImagePlacementPolicyV2Result(
        cluster_entity_filters=pulumi.get(__ret__, 'cluster_entity_filters'),
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        enforcement_state=pulumi.get(__ret__, 'enforcement_state'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        image_entity_filters=pulumi.get(__ret__, 'image_entity_filters'),
        last_update_time=pulumi.get(__ret__, 'last_update_time'),
        name=pulumi.get(__ret__, 'name'),
        owner_ext_id=pulumi.get(__ret__, 'owner_ext_id'),
        placement_type=pulumi.get(__ret__, 'placement_type'))
def get_image_placement_policy_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImagePlacementPolicyV2Result]:
    """
    Retrieve the image placement policy details for the provided external identifier.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    ipp = nutanix.get_image_placement_policy_v2(ext_id="cf96e27a-4e52-4cec-b563-d0b25413cc4a")
    ```


    :param _builtins.str ext_id: The external identifier of an image placement policy.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getImagePlacementPolicyV2:getImagePlacementPolicyV2', __args__, opts=opts, typ=GetImagePlacementPolicyV2Result)
    return __ret__.apply(lambda __response__: GetImagePlacementPolicyV2Result(
        cluster_entity_filters=pulumi.get(__response__, 'cluster_entity_filters'),
        create_time=pulumi.get(__response__, 'create_time'),
        description=pulumi.get(__response__, 'description'),
        enforcement_state=pulumi.get(__response__, 'enforcement_state'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        image_entity_filters=pulumi.get(__response__, 'image_entity_filters'),
        last_update_time=pulumi.get(__response__, 'last_update_time'),
        name=pulumi.get(__response__, 'name'),
        owner_ext_id=pulumi.get(__response__, 'owner_ext_id'),
        placement_type=pulumi.get(__response__, 'placement_type')))
