# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetImagesV2Result',
    'AwaitableGetImagesV2Result',
    'get_images_v2',
    'get_images_v2_output',
]

@pulumi.output_type
class GetImagesV2Result:
    """
    A collection of values returned by getImagesV2.
    """
    def __init__(__self__, filter=None, id=None, images=None, limit=None, order_by=None, page=None, select=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetImagesV2ImageResult']:
        """
        List of all images
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")


class AwaitableGetImagesV2Result(GetImagesV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImagesV2Result(
            filter=self.filter,
            id=self.id,
            images=self.images,
            limit=self.limit,
            order_by=self.order_by,
            page=self.page,
            select=self.select)


def get_images_v2(filter: Optional[_builtins.str] = None,
                  limit: Optional[_builtins.int] = None,
                  order_by: Optional[_builtins.str] = None,
                  page: Optional[_builtins.int] = None,
                  select: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImagesV2Result:
    """
    List images owned by Prism Central along with the image details like name, description, type, etc. This operation supports filtering, sorting, selection & pagination.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # List all images
    list_images = nutanix.get_images_v2()
    # List images with filter, page and limit
    filtered_images = nutanix.get_images_v2(filter="startswith(name,'image_name')",
        page=0,
        limit=10)
    ```

    ## Images

    The `images` object is a list of all images. Each image has the following attributes:

    * `ext_id`: A globally unique identifier of an instance that is suitable for external consumption.
    * `name`: The user defined name of an image.
    * `description`: The user defined description of an image.
    * `type`: The type of an image.
    * `checksum`: The checksum of an image.
    * `size_bytes`: The size in bytes of an image file.
    * `source`: The source of an image. It can be a VM disk or a URL.
    * `category_ext_ids`: List of category external identifiers for an image.
    * `cluster_location_ext_ids`: List of cluster external identifiers where the image is located.
    * `create_time`: Create time of an image.
    * `last_update_time`: Last update time of an image.
    * `owner_ext_id`: External identifier of the owner of the image
    * `placement_policy_status`: Status of an image placement policy.

    ### source
    * `ext_id`: The external identifier of VM Disk.
    * `url`: The URL for creating an image.
    * `basic_auth`: Basic authentication credentials for image source HTTP/S URL.
    * `basic_auth.username`: Username for basic authentication.
    * `basic_auth.password`: Password for basic authentication.

    ### placement_policy_status
    * `placement_policy_ext_id`: Image placement policy external identifier.
    * `compliance_status`: Compliance status for a placement policy.
    * `enforcement_mode`: Indicates whether the placement policy enforcement is ongoing or has failed.
    * `policy_cluster_ext_ids`: List of cluster external identifiers of the image location for the enforced placement policy.
    * `enforced_cluster_ext_ids`: List of cluster external identifiers for the enforced placement policy.
    * `conflicting_policy_ext_ids`: List of image placement policy external identifier that conflict with the current one.

    See detailed information in [Nutanix List Images V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Images)


    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
           - description
           - name
           - sizeBytes
           - type
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '\\$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:
           - description
           - lastUpdateTime
           - name
           - sizeBytes
           - type
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., *), then all properties on the matching resource will be returned. The select can be applied to the following fields:
           - categoryExtIds
           - clusterLocationExtIds
           - createTime
           - description
           - extId
           - lastUpdateTime
           - links
           - name
           - ownerExtId
           - sizeBytes
           - tenantId
           - type
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getImagesV2:getImagesV2', __args__, opts=opts, typ=GetImagesV2Result).value

    return AwaitableGetImagesV2Result(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        images=pulumi.get(__ret__, 'images'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        select=pulumi.get(__ret__, 'select'))
def get_images_v2_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                         select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImagesV2Result]:
    """
    List images owned by Prism Central along with the image details like name, description, type, etc. This operation supports filtering, sorting, selection & pagination.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # List all images
    list_images = nutanix.get_images_v2()
    # List images with filter, page and limit
    filtered_images = nutanix.get_images_v2(filter="startswith(name,'image_name')",
        page=0,
        limit=10)
    ```

    ## Images

    The `images` object is a list of all images. Each image has the following attributes:

    * `ext_id`: A globally unique identifier of an instance that is suitable for external consumption.
    * `name`: The user defined name of an image.
    * `description`: The user defined description of an image.
    * `type`: The type of an image.
    * `checksum`: The checksum of an image.
    * `size_bytes`: The size in bytes of an image file.
    * `source`: The source of an image. It can be a VM disk or a URL.
    * `category_ext_ids`: List of category external identifiers for an image.
    * `cluster_location_ext_ids`: List of cluster external identifiers where the image is located.
    * `create_time`: Create time of an image.
    * `last_update_time`: Last update time of an image.
    * `owner_ext_id`: External identifier of the owner of the image
    * `placement_policy_status`: Status of an image placement policy.

    ### source
    * `ext_id`: The external identifier of VM Disk.
    * `url`: The URL for creating an image.
    * `basic_auth`: Basic authentication credentials for image source HTTP/S URL.
    * `basic_auth.username`: Username for basic authentication.
    * `basic_auth.password`: Password for basic authentication.

    ### placement_policy_status
    * `placement_policy_ext_id`: Image placement policy external identifier.
    * `compliance_status`: Compliance status for a placement policy.
    * `enforcement_mode`: Indicates whether the placement policy enforcement is ongoing or has failed.
    * `policy_cluster_ext_ids`: List of cluster external identifiers of the image location for the enforced placement policy.
    * `enforced_cluster_ext_ids`: List of cluster external identifiers for the enforced placement policy.
    * `conflicting_policy_ext_ids`: List of image placement policy external identifier that conflict with the current one.

    See detailed information in [Nutanix List Images V4](https://developers.nutanix.com/api-reference?namespace=vmm&version=v4.0#tag/Images)


    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with \\$filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the \\$filter must conform to the OData V4.01 URL conventions. For example, filter '\\$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '\\$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
           - description
           - name
           - sizeBytes
           - type
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '\\$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:
           - description
           - lastUpdateTime
           - name
           - sizeBytes
           - type
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the \\$select must conform to the OData V4.01 URL conventions. If a \\$select expression consists of a single select item that is an asterisk (i.e., *), then all properties on the matching resource will be returned. The select can be applied to the following fields:
           - categoryExtIds
           - clusterLocationExtIds
           - createTime
           - description
           - extId
           - lastUpdateTime
           - links
           - name
           - ownerExtId
           - sizeBytes
           - tenantId
           - type
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getImagesV2:getImagesV2', __args__, opts=opts, typ=GetImagesV2Result)
    return __ret__.apply(lambda __response__: GetImagesV2Result(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        images=pulumi.get(__response__, 'images'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        select=pulumi.get(__response__, 'select')))
