# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetKarbonClusterResult',
    'AwaitableGetKarbonClusterResult',
    'get_karbon_cluster',
    'get_karbon_cluster_output',
]

@pulumi.output_type
class GetKarbonClusterResult:
    """
    A collection of values returned by getKarbonCluster.
    """
    def __init__(__self__, deployment_type=None, etcd_node_pools=None, id=None, karbon_cluster_id=None, karbon_cluster_name=None, kubeapi_server_ipv4_address=None, master_node_pools=None, name=None, status=None, uuid=None, version=None, worker_node_pools=None):
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if etcd_node_pools and not isinstance(etcd_node_pools, list):
            raise TypeError("Expected argument 'etcd_node_pools' to be a list")
        pulumi.set(__self__, "etcd_node_pools", etcd_node_pools)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if karbon_cluster_id and not isinstance(karbon_cluster_id, str):
            raise TypeError("Expected argument 'karbon_cluster_id' to be a str")
        pulumi.set(__self__, "karbon_cluster_id", karbon_cluster_id)
        if karbon_cluster_name and not isinstance(karbon_cluster_name, str):
            raise TypeError("Expected argument 'karbon_cluster_name' to be a str")
        pulumi.set(__self__, "karbon_cluster_name", karbon_cluster_name)
        if kubeapi_server_ipv4_address and not isinstance(kubeapi_server_ipv4_address, str):
            raise TypeError("Expected argument 'kubeapi_server_ipv4_address' to be a str")
        pulumi.set(__self__, "kubeapi_server_ipv4_address", kubeapi_server_ipv4_address)
        if master_node_pools and not isinstance(master_node_pools, list):
            raise TypeError("Expected argument 'master_node_pools' to be a list")
        pulumi.set(__self__, "master_node_pools", master_node_pools)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if worker_node_pools and not isinstance(worker_node_pools, list):
            raise TypeError("Expected argument 'worker_node_pools' to be a list")
        pulumi.set(__self__, "worker_node_pools", worker_node_pools)

    @_builtins.property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> _builtins.str:
        return pulumi.get(self, "deployment_type")

    @_builtins.property
    @pulumi.getter(name="etcdNodePools")
    def etcd_node_pools(self) -> Sequence['outputs.GetKarbonClusterEtcdNodePoolResult']:
        """
        - Configuration of the node pools that the nodes in the etcd cluster belong to. The etcd nodes require a minimum of 8,192 MiB memory and 409,60 MiB disk space.
        """
        return pulumi.get(self, "etcd_node_pools")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="karbonClusterId")
    def karbon_cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "karbon_cluster_id")

    @_builtins.property
    @pulumi.getter(name="karbonClusterName")
    def karbon_cluster_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "karbon_cluster_name")

    @_builtins.property
    @pulumi.getter(name="kubeapiServerIpv4Address")
    def kubeapi_server_ipv4_address(self) -> _builtins.str:
        return pulumi.get(self, "kubeapi_server_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="masterNodePools")
    def master_node_pools(self) -> Sequence['outputs.GetKarbonClusterMasterNodePoolResult']:
        """
        - Configuration of the master node pools.
        """
        return pulumi.get(self, "master_node_pools")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - Unique name of the node pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        return pulumi.get(self, "uuid")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        - K8s version of the cluster.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="workerNodePools")
    def worker_node_pools(self) -> Sequence['outputs.GetKarbonClusterWorkerNodePoolResult']:
        return pulumi.get(self, "worker_node_pools")


class AwaitableGetKarbonClusterResult(GetKarbonClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKarbonClusterResult(
            deployment_type=self.deployment_type,
            etcd_node_pools=self.etcd_node_pools,
            id=self.id,
            karbon_cluster_id=self.karbon_cluster_id,
            karbon_cluster_name=self.karbon_cluster_name,
            kubeapi_server_ipv4_address=self.kubeapi_server_ipv4_address,
            master_node_pools=self.master_node_pools,
            name=self.name,
            status=self.status,
            uuid=self.uuid,
            version=self.version,
            worker_node_pools=self.worker_node_pools)


def get_karbon_cluster(karbon_cluster_id: Optional[_builtins.str] = None,
                       karbon_cluster_name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKarbonClusterResult:
    """
    Describes a Karbon Cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    cluster = nutanix.get_karbon_cluster(karbon_cluster_id="<YOUR-CLUSTER-ID>")
    ```


    :param _builtins.str karbon_cluster_id: Represents karbon cluster uuid
    :param _builtins.str karbon_cluster_name: Represents the name of karbon cluster
    """
    __args__ = dict()
    __args__['karbonClusterId'] = karbon_cluster_id
    __args__['karbonClusterName'] = karbon_cluster_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getKarbonCluster:getKarbonCluster', __args__, opts=opts, typ=GetKarbonClusterResult).value

    return AwaitableGetKarbonClusterResult(
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        etcd_node_pools=pulumi.get(__ret__, 'etcd_node_pools'),
        id=pulumi.get(__ret__, 'id'),
        karbon_cluster_id=pulumi.get(__ret__, 'karbon_cluster_id'),
        karbon_cluster_name=pulumi.get(__ret__, 'karbon_cluster_name'),
        kubeapi_server_ipv4_address=pulumi.get(__ret__, 'kubeapi_server_ipv4_address'),
        master_node_pools=pulumi.get(__ret__, 'master_node_pools'),
        name=pulumi.get(__ret__, 'name'),
        status=pulumi.get(__ret__, 'status'),
        uuid=pulumi.get(__ret__, 'uuid'),
        version=pulumi.get(__ret__, 'version'),
        worker_node_pools=pulumi.get(__ret__, 'worker_node_pools'))
def get_karbon_cluster_output(karbon_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              karbon_cluster_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKarbonClusterResult]:
    """
    Describes a Karbon Cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    cluster = nutanix.get_karbon_cluster(karbon_cluster_id="<YOUR-CLUSTER-ID>")
    ```


    :param _builtins.str karbon_cluster_id: Represents karbon cluster uuid
    :param _builtins.str karbon_cluster_name: Represents the name of karbon cluster
    """
    __args__ = dict()
    __args__['karbonClusterId'] = karbon_cluster_id
    __args__['karbonClusterName'] = karbon_cluster_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getKarbonCluster:getKarbonCluster', __args__, opts=opts, typ=GetKarbonClusterResult)
    return __ret__.apply(lambda __response__: GetKarbonClusterResult(
        deployment_type=pulumi.get(__response__, 'deployment_type'),
        etcd_node_pools=pulumi.get(__response__, 'etcd_node_pools'),
        id=pulumi.get(__response__, 'id'),
        karbon_cluster_id=pulumi.get(__response__, 'karbon_cluster_id'),
        karbon_cluster_name=pulumi.get(__response__, 'karbon_cluster_name'),
        kubeapi_server_ipv4_address=pulumi.get(__response__, 'kubeapi_server_ipv4_address'),
        master_node_pools=pulumi.get(__response__, 'master_node_pools'),
        name=pulumi.get(__response__, 'name'),
        status=pulumi.get(__response__, 'status'),
        uuid=pulumi.get(__response__, 'uuid'),
        version=pulumi.get(__response__, 'version'),
        worker_node_pools=pulumi.get(__response__, 'worker_node_pools')))
