# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetKarbonClusterKubeConfigResult',
    'AwaitableGetKarbonClusterKubeConfigResult',
    'get_karbon_cluster_kube_config',
    'get_karbon_cluster_kube_config_output',
]

@pulumi.output_type
class GetKarbonClusterKubeConfigResult:
    """
    A collection of values returned by getKarbonClusterKubeConfig.
    """
    def __init__(__self__, access_token=None, cluster_ca_certificate=None, cluster_url=None, id=None, karbon_cluster_id=None, karbon_cluster_name=None, name=None):
        if access_token and not isinstance(access_token, str):
            raise TypeError("Expected argument 'access_token' to be a str")
        pulumi.set(__self__, "access_token", access_token)
        if cluster_ca_certificate and not isinstance(cluster_ca_certificate, str):
            raise TypeError("Expected argument 'cluster_ca_certificate' to be a str")
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if cluster_url and not isinstance(cluster_url, str):
            raise TypeError("Expected argument 'cluster_url' to be a str")
        pulumi.set(__self__, "cluster_url", cluster_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if karbon_cluster_id and not isinstance(karbon_cluster_id, str):
            raise TypeError("Expected argument 'karbon_cluster_id' to be a str")
        pulumi.set(__self__, "karbon_cluster_id", karbon_cluster_id)
        if karbon_cluster_name and not isinstance(karbon_cluster_name, str):
            raise TypeError("Expected argument 'karbon_cluster_name' to be a str")
        pulumi.set(__self__, "karbon_cluster_name", karbon_cluster_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> _builtins.str:
        return pulumi.get(self, "access_token")

    @_builtins.property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> _builtins.str:
        return pulumi.get(self, "cluster_ca_certificate")

    @_builtins.property
    @pulumi.getter(name="clusterUrl")
    def cluster_url(self) -> _builtins.str:
        return pulumi.get(self, "cluster_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="karbonClusterId")
    def karbon_cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "karbon_cluster_id")

    @_builtins.property
    @pulumi.getter(name="karbonClusterName")
    def karbon_cluster_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "karbon_cluster_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


class AwaitableGetKarbonClusterKubeConfigResult(GetKarbonClusterKubeConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKarbonClusterKubeConfigResult(
            access_token=self.access_token,
            cluster_ca_certificate=self.cluster_ca_certificate,
            cluster_url=self.cluster_url,
            id=self.id,
            karbon_cluster_id=self.karbon_cluster_id,
            karbon_cluster_name=self.karbon_cluster_name,
            name=self.name)


def get_karbon_cluster_kube_config(karbon_cluster_id: Optional[_builtins.str] = None,
                                   karbon_cluster_name: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKarbonClusterKubeConfigResult:
    """
    Describes the SSH config from a Karbon Cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get kubeconfig by cluster UUID
    configbyid = nutanix.get_karbon_cluster_kube_config(karbon_cluster_id="<YOUR-CLUSTER-ID>")
    # Get Kubeconfig by cluster name
    configbyname = nutanix.get_karbon_cluster_kube_config(karbon_cluster_name="<YOUR-CLUSTER-NAME>")
    ```


    :param _builtins.str karbon_cluster_id: Represents karbon cluster uuid
    :param _builtins.str karbon_cluster_name: Represents the name of karbon cluster
    """
    __args__ = dict()
    __args__['karbonClusterId'] = karbon_cluster_id
    __args__['karbonClusterName'] = karbon_cluster_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getKarbonClusterKubeConfig:getKarbonClusterKubeConfig', __args__, opts=opts, typ=GetKarbonClusterKubeConfigResult).value

    return AwaitableGetKarbonClusterKubeConfigResult(
        access_token=pulumi.get(__ret__, 'access_token'),
        cluster_ca_certificate=pulumi.get(__ret__, 'cluster_ca_certificate'),
        cluster_url=pulumi.get(__ret__, 'cluster_url'),
        id=pulumi.get(__ret__, 'id'),
        karbon_cluster_id=pulumi.get(__ret__, 'karbon_cluster_id'),
        karbon_cluster_name=pulumi.get(__ret__, 'karbon_cluster_name'),
        name=pulumi.get(__ret__, 'name'))
def get_karbon_cluster_kube_config_output(karbon_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          karbon_cluster_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKarbonClusterKubeConfigResult]:
    """
    Describes the SSH config from a Karbon Cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get kubeconfig by cluster UUID
    configbyid = nutanix.get_karbon_cluster_kube_config(karbon_cluster_id="<YOUR-CLUSTER-ID>")
    # Get Kubeconfig by cluster name
    configbyname = nutanix.get_karbon_cluster_kube_config(karbon_cluster_name="<YOUR-CLUSTER-NAME>")
    ```


    :param _builtins.str karbon_cluster_id: Represents karbon cluster uuid
    :param _builtins.str karbon_cluster_name: Represents the name of karbon cluster
    """
    __args__ = dict()
    __args__['karbonClusterId'] = karbon_cluster_id
    __args__['karbonClusterName'] = karbon_cluster_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getKarbonClusterKubeConfig:getKarbonClusterKubeConfig', __args__, opts=opts, typ=GetKarbonClusterKubeConfigResult)
    return __ret__.apply(lambda __response__: GetKarbonClusterKubeConfigResult(
        access_token=pulumi.get(__response__, 'access_token'),
        cluster_ca_certificate=pulumi.get(__response__, 'cluster_ca_certificate'),
        cluster_url=pulumi.get(__response__, 'cluster_url'),
        id=pulumi.get(__response__, 'id'),
        karbon_cluster_id=pulumi.get(__response__, 'karbon_cluster_id'),
        karbon_cluster_name=pulumi.get(__response__, 'karbon_cluster_name'),
        name=pulumi.get(__response__, 'name')))
