# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetKarbonClusterSshResult',
    'AwaitableGetKarbonClusterSshResult',
    'get_karbon_cluster_ssh',
    'get_karbon_cluster_ssh_output',
]

@pulumi.output_type
class GetKarbonClusterSshResult:
    """
    A collection of values returned by getKarbonClusterSsh.
    """
    def __init__(__self__, certificate=None, expiry_time=None, id=None, karbon_cluster_id=None, karbon_cluster_name=None, private_key=None, username=None):
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if expiry_time and not isinstance(expiry_time, str):
            raise TypeError("Expected argument 'expiry_time' to be a str")
        pulumi.set(__self__, "expiry_time", expiry_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if karbon_cluster_id and not isinstance(karbon_cluster_id, str):
            raise TypeError("Expected argument 'karbon_cluster_id' to be a str")
        pulumi.set(__self__, "karbon_cluster_id", karbon_cluster_id)
        if karbon_cluster_name and not isinstance(karbon_cluster_name, str):
            raise TypeError("Expected argument 'karbon_cluster_name' to be a str")
        pulumi.set(__self__, "karbon_cluster_name", karbon_cluster_name)
        if private_key and not isinstance(private_key, str):
            raise TypeError("Expected argument 'private_key' to be a str")
        pulumi.set(__self__, "private_key", private_key)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> _builtins.str:
        """
        Certificate of the user for SSH access.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> _builtins.str:
        """
        Timestamp of certificate expiry in the ISO 8601 format (YYYY-MM-DDThh:mm:ss.sssZ).
        """
        return pulumi.get(self, "expiry_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="karbonClusterId")
    def karbon_cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "karbon_cluster_id")

    @_builtins.property
    @pulumi.getter(name="karbonClusterName")
    def karbon_cluster_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "karbon_cluster_name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> _builtins.str:
        """
        The private key of the user for SSH access.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username for which credentials are returned.
        """
        return pulumi.get(self, "username")


class AwaitableGetKarbonClusterSshResult(GetKarbonClusterSshResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKarbonClusterSshResult(
            certificate=self.certificate,
            expiry_time=self.expiry_time,
            id=self.id,
            karbon_cluster_id=self.karbon_cluster_id,
            karbon_cluster_name=self.karbon_cluster_name,
            private_key=self.private_key,
            username=self.username)


def get_karbon_cluster_ssh(karbon_cluster_id: Optional[_builtins.str] = None,
                           karbon_cluster_name: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKarbonClusterSshResult:
    """
    Describes the SSH config from a Karbon Cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get ssh credentials by cluster UUID
    sshbyid = nutanix.get_karbon_cluster_ssh(karbon_cluster_id="<YOUR-CLUSTER-ID>")
    # Get ssh credentials by cluster name
    sshbyname = nutanix.get_karbon_cluster_ssh(karbon_cluster_name="<YOUR-CLUSTER-NAME>")
    ```


    :param _builtins.str karbon_cluster_id: Represents karbon cluster uuid
    :param _builtins.str karbon_cluster_name: Represents the name of karbon cluster
    """
    __args__ = dict()
    __args__['karbonClusterId'] = karbon_cluster_id
    __args__['karbonClusterName'] = karbon_cluster_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getKarbonClusterSsh:getKarbonClusterSsh', __args__, opts=opts, typ=GetKarbonClusterSshResult).value

    return AwaitableGetKarbonClusterSshResult(
        certificate=pulumi.get(__ret__, 'certificate'),
        expiry_time=pulumi.get(__ret__, 'expiry_time'),
        id=pulumi.get(__ret__, 'id'),
        karbon_cluster_id=pulumi.get(__ret__, 'karbon_cluster_id'),
        karbon_cluster_name=pulumi.get(__ret__, 'karbon_cluster_name'),
        private_key=pulumi.get(__ret__, 'private_key'),
        username=pulumi.get(__ret__, 'username'))
def get_karbon_cluster_ssh_output(karbon_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  karbon_cluster_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKarbonClusterSshResult]:
    """
    Describes the SSH config from a Karbon Cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Get ssh credentials by cluster UUID
    sshbyid = nutanix.get_karbon_cluster_ssh(karbon_cluster_id="<YOUR-CLUSTER-ID>")
    # Get ssh credentials by cluster name
    sshbyname = nutanix.get_karbon_cluster_ssh(karbon_cluster_name="<YOUR-CLUSTER-NAME>")
    ```


    :param _builtins.str karbon_cluster_id: Represents karbon cluster uuid
    :param _builtins.str karbon_cluster_name: Represents the name of karbon cluster
    """
    __args__ = dict()
    __args__['karbonClusterId'] = karbon_cluster_id
    __args__['karbonClusterName'] = karbon_cluster_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getKarbonClusterSsh:getKarbonClusterSsh', __args__, opts=opts, typ=GetKarbonClusterSshResult)
    return __ret__.apply(lambda __response__: GetKarbonClusterSshResult(
        certificate=pulumi.get(__response__, 'certificate'),
        expiry_time=pulumi.get(__response__, 'expiry_time'),
        id=pulumi.get(__response__, 'id'),
        karbon_cluster_id=pulumi.get(__response__, 'karbon_cluster_id'),
        karbon_cluster_name=pulumi.get(__response__, 'karbon_cluster_name'),
        private_key=pulumi.get(__response__, 'private_key'),
        username=pulumi.get(__response__, 'username')))
