# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetKarbonPrivateRegistryResult',
    'AwaitableGetKarbonPrivateRegistryResult',
    'get_karbon_private_registry',
    'get_karbon_private_registry_output',
]

@pulumi.output_type
class GetKarbonPrivateRegistryResult:
    """
    A collection of values returned by getKarbonPrivateRegistry.
    """
    def __init__(__self__, endpoint=None, id=None, name=None, private_registry_id=None, private_registry_name=None, uuid=None):
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_registry_id and not isinstance(private_registry_id, str):
            raise TypeError("Expected argument 'private_registry_id' to be a str")
        pulumi.set(__self__, "private_registry_id", private_registry_id)
        if private_registry_name and not isinstance(private_registry_name, str):
            raise TypeError("Expected argument 'private_registry_name' to be a str")
        pulumi.set(__self__, "private_registry_name", private_registry_name)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        - Endpoint of the private in format `url:port`.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - Name of the private registry.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateRegistryId")
    def private_registry_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_registry_id")

    @_builtins.property
    @pulumi.getter(name="privateRegistryName")
    def private_registry_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_registry_name")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        - UUID of the private registry.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetKarbonPrivateRegistryResult(GetKarbonPrivateRegistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKarbonPrivateRegistryResult(
            endpoint=self.endpoint,
            id=self.id,
            name=self.name,
            private_registry_id=self.private_registry_id,
            private_registry_name=self.private_registry_name,
            uuid=self.uuid)


def get_karbon_private_registry(private_registry_id: Optional[_builtins.str] = None,
                                private_registry_name: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKarbonPrivateRegistryResult:
    """
    Describes Karbon private registry entry

    ## Example Usage


    :param _builtins.str private_registry_id: Represents karbon private registry uuid
    :param _builtins.str private_registry_name: Represents the name of karbon private registry
    """
    __args__ = dict()
    __args__['privateRegistryId'] = private_registry_id
    __args__['privateRegistryName'] = private_registry_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getKarbonPrivateRegistry:getKarbonPrivateRegistry', __args__, opts=opts, typ=GetKarbonPrivateRegistryResult).value

    return AwaitableGetKarbonPrivateRegistryResult(
        endpoint=pulumi.get(__ret__, 'endpoint'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        private_registry_id=pulumi.get(__ret__, 'private_registry_id'),
        private_registry_name=pulumi.get(__ret__, 'private_registry_name'),
        uuid=pulumi.get(__ret__, 'uuid'))
def get_karbon_private_registry_output(private_registry_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       private_registry_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKarbonPrivateRegistryResult]:
    """
    Describes Karbon private registry entry

    ## Example Usage


    :param _builtins.str private_registry_id: Represents karbon private registry uuid
    :param _builtins.str private_registry_name: Represents the name of karbon private registry
    """
    __args__ = dict()
    __args__['privateRegistryId'] = private_registry_id
    __args__['privateRegistryName'] = private_registry_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getKarbonPrivateRegistry:getKarbonPrivateRegistry', __args__, opts=opts, typ=GetKarbonPrivateRegistryResult)
    return __ret__.apply(lambda __response__: GetKarbonPrivateRegistryResult(
        endpoint=pulumi.get(__response__, 'endpoint'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        private_registry_id=pulumi.get(__response__, 'private_registry_id'),
        private_registry_name=pulumi.get(__response__, 'private_registry_name'),
        uuid=pulumi.get(__response__, 'uuid')))
