# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLcmConfigV2Result',
    'AwaitableGetLcmConfigV2Result',
    'get_lcm_config_v2',
    'get_lcm_config_v2_output',
]

@pulumi.output_type
class GetLcmConfigV2Result:
    """
    A collection of values returned by getLcmConfigV2.
    """
    def __init__(__self__, auto_inventory_schedule=None, connectivity_type=None, deprecated_software_entities=None, display_version=None, ext_id=None, has_module_auto_upgrade_enabled=None, id=None, is_auto_inventory_enabled=None, is_framework_bundle_uploaded=None, is_https_enabled=None, links=None, supported_software_entities=None, tenant_id=None, url=None, version=None, x_cluster_id=None):
        if auto_inventory_schedule and not isinstance(auto_inventory_schedule, str):
            raise TypeError("Expected argument 'auto_inventory_schedule' to be a str")
        pulumi.set(__self__, "auto_inventory_schedule", auto_inventory_schedule)
        if connectivity_type and not isinstance(connectivity_type, str):
            raise TypeError("Expected argument 'connectivity_type' to be a str")
        pulumi.set(__self__, "connectivity_type", connectivity_type)
        if deprecated_software_entities and not isinstance(deprecated_software_entities, list):
            raise TypeError("Expected argument 'deprecated_software_entities' to be a list")
        pulumi.set(__self__, "deprecated_software_entities", deprecated_software_entities)
        if display_version and not isinstance(display_version, str):
            raise TypeError("Expected argument 'display_version' to be a str")
        pulumi.set(__self__, "display_version", display_version)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if has_module_auto_upgrade_enabled and not isinstance(has_module_auto_upgrade_enabled, bool):
            raise TypeError("Expected argument 'has_module_auto_upgrade_enabled' to be a bool")
        pulumi.set(__self__, "has_module_auto_upgrade_enabled", has_module_auto_upgrade_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_inventory_enabled and not isinstance(is_auto_inventory_enabled, bool):
            raise TypeError("Expected argument 'is_auto_inventory_enabled' to be a bool")
        pulumi.set(__self__, "is_auto_inventory_enabled", is_auto_inventory_enabled)
        if is_framework_bundle_uploaded and not isinstance(is_framework_bundle_uploaded, bool):
            raise TypeError("Expected argument 'is_framework_bundle_uploaded' to be a bool")
        pulumi.set(__self__, "is_framework_bundle_uploaded", is_framework_bundle_uploaded)
        if is_https_enabled and not isinstance(is_https_enabled, bool):
            raise TypeError("Expected argument 'is_https_enabled' to be a bool")
        pulumi.set(__self__, "is_https_enabled", is_https_enabled)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if supported_software_entities and not isinstance(supported_software_entities, list):
            raise TypeError("Expected argument 'supported_software_entities' to be a list")
        pulumi.set(__self__, "supported_software_entities", supported_software_entities)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if x_cluster_id and not isinstance(x_cluster_id, str):
            raise TypeError("Expected argument 'x_cluster_id' to be a str")
        pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="autoInventorySchedule")
    def auto_inventory_schedule(self) -> _builtins.str:
        """
        The scheduled time in "%H:%M" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM).
        """
        return pulumi.get(self, "auto_inventory_schedule")

    @_builtins.property
    @pulumi.getter(name="connectivityType")
    def connectivity_type(self) -> _builtins.str:
        """
        This field indicates whether LCM framework on the cluster is running in connected-site mode or darksite mode. Values are :
        - `CONNECTED_SITE`: In connected-site, LCM on the cluster has internet connectivity to reach configured portal for downloading LCM modules/bundles etc.
        - `DARKSITE_DIRECT_UPLOAD`: LCM on the cluster does not have external connectivity and will have a facility to upload darksite bundles through LCM.
        - `DARKSITE_WEB_SERVER`: LCM on the cluster does not have external connectivity and will have a connection to darksite webserver maintained by the customer.
        """
        return pulumi.get(self, "connectivity_type")

    @_builtins.property
    @pulumi.getter(name="deprecatedSoftwareEntities")
    def deprecated_software_entities(self) -> Sequence[_builtins.str]:
        """
        List of entities for which One-Click upgrades are not available.
        """
        return pulumi.get(self, "deprecated_software_entities")

    @_builtins.property
    @pulumi.getter(name="displayVersion")
    def display_version(self) -> _builtins.str:
        """
        User friendly display version of LCM installed on the cluster.
        """
        return pulumi.get(self, "display_version")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="hasModuleAutoUpgradeEnabled")
    def has_module_auto_upgrade_enabled(self) -> _builtins.bool:
        """
        Indicates if LCM is enabled to auto-upgrade products. The default value is False.
        """
        return pulumi.get(self, "has_module_auto_upgrade_enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAutoInventoryEnabled")
    def is_auto_inventory_enabled(self) -> _builtins.bool:
        """
        Indicates if the auto inventory operation is enabled. The default value is set to False.
        """
        return pulumi.get(self, "is_auto_inventory_enabled")

    @_builtins.property
    @pulumi.getter(name="isFrameworkBundleUploaded")
    def is_framework_bundle_uploaded(self) -> _builtins.bool:
        """
        Indicates if the bundle is uploaded or not.
        """
        return pulumi.get(self, "is_framework_bundle_uploaded")

    @_builtins.property
    @pulumi.getter(name="isHttpsEnabled")
    def is_https_enabled(self) -> _builtins.bool:
        """
        Indicates if the LCM URL has HTTPS enabled. The default value is True.
        """
        return pulumi.get(self, "is_https_enabled")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetLcmConfigV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="supportedSoftwareEntities")
    def supported_software_entities(self) -> Sequence[_builtins.str]:
        """
        List of entities for which One-Click upgrades are supported.
        """
        return pulumi.get(self, "supported_software_entities")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        URL of the LCM repository.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        LCM version installed on the cluster.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "x_cluster_id")


class AwaitableGetLcmConfigV2Result(GetLcmConfigV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLcmConfigV2Result(
            auto_inventory_schedule=self.auto_inventory_schedule,
            connectivity_type=self.connectivity_type,
            deprecated_software_entities=self.deprecated_software_entities,
            display_version=self.display_version,
            ext_id=self.ext_id,
            has_module_auto_upgrade_enabled=self.has_module_auto_upgrade_enabled,
            id=self.id,
            is_auto_inventory_enabled=self.is_auto_inventory_enabled,
            is_framework_bundle_uploaded=self.is_framework_bundle_uploaded,
            is_https_enabled=self.is_https_enabled,
            links=self.links,
            supported_software_entities=self.supported_software_entities,
            tenant_id=self.tenant_id,
            url=self.url,
            version=self.version,
            x_cluster_id=self.x_cluster_id)


def get_lcm_config_v2(x_cluster_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLcmConfigV2Result:
    """
    Get LCM configuration.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    lcm_configuration = nutanix.get_lcm_config_v2()
    # Get LCM configuration for a specific cluster
    lcm_configuration_cluster = nutanix.get_lcm_config_v2(x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b")
    ```


    :param _builtins.str x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
    """
    __args__ = dict()
    __args__['xClusterId'] = x_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getLcmConfigV2:getLcmConfigV2', __args__, opts=opts, typ=GetLcmConfigV2Result).value

    return AwaitableGetLcmConfigV2Result(
        auto_inventory_schedule=pulumi.get(__ret__, 'auto_inventory_schedule'),
        connectivity_type=pulumi.get(__ret__, 'connectivity_type'),
        deprecated_software_entities=pulumi.get(__ret__, 'deprecated_software_entities'),
        display_version=pulumi.get(__ret__, 'display_version'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        has_module_auto_upgrade_enabled=pulumi.get(__ret__, 'has_module_auto_upgrade_enabled'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_inventory_enabled=pulumi.get(__ret__, 'is_auto_inventory_enabled'),
        is_framework_bundle_uploaded=pulumi.get(__ret__, 'is_framework_bundle_uploaded'),
        is_https_enabled=pulumi.get(__ret__, 'is_https_enabled'),
        links=pulumi.get(__ret__, 'links'),
        supported_software_entities=pulumi.get(__ret__, 'supported_software_entities'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        url=pulumi.get(__ret__, 'url'),
        version=pulumi.get(__ret__, 'version'),
        x_cluster_id=pulumi.get(__ret__, 'x_cluster_id'))
def get_lcm_config_v2_output(x_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLcmConfigV2Result]:
    """
    Get LCM configuration.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    lcm_configuration = nutanix.get_lcm_config_v2()
    # Get LCM configuration for a specific cluster
    lcm_configuration_cluster = nutanix.get_lcm_config_v2(x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b")
    ```


    :param _builtins.str x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
    """
    __args__ = dict()
    __args__['xClusterId'] = x_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getLcmConfigV2:getLcmConfigV2', __args__, opts=opts, typ=GetLcmConfigV2Result)
    return __ret__.apply(lambda __response__: GetLcmConfigV2Result(
        auto_inventory_schedule=pulumi.get(__response__, 'auto_inventory_schedule'),
        connectivity_type=pulumi.get(__response__, 'connectivity_type'),
        deprecated_software_entities=pulumi.get(__response__, 'deprecated_software_entities'),
        display_version=pulumi.get(__response__, 'display_version'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        has_module_auto_upgrade_enabled=pulumi.get(__response__, 'has_module_auto_upgrade_enabled'),
        id=pulumi.get(__response__, 'id'),
        is_auto_inventory_enabled=pulumi.get(__response__, 'is_auto_inventory_enabled'),
        is_framework_bundle_uploaded=pulumi.get(__response__, 'is_framework_bundle_uploaded'),
        is_https_enabled=pulumi.get(__response__, 'is_https_enabled'),
        links=pulumi.get(__response__, 'links'),
        supported_software_entities=pulumi.get(__response__, 'supported_software_entities'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        url=pulumi.get(__response__, 'url'),
        version=pulumi.get(__response__, 'version'),
        x_cluster_id=pulumi.get(__response__, 'x_cluster_id')))
