# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLcmEntityV2Result',
    'AwaitableGetLcmEntityV2Result',
    'get_lcm_entity_v2',
    'get_lcm_entity_v2_output',
]

@pulumi.output_type
class GetLcmEntityV2Result:
    """
    A collection of values returned by getLcmEntityV2.
    """
    def __init__(__self__, available_versions=None, child_entities=None, cluster_ext_id=None, device_id=None, entity_class=None, entity_description=None, entity_details=None, entity_model=None, entity_type=None, entity_version=None, ext_id=None, group_uuid=None, hardware_family=None, hardware_vendor=None, id=None, last_updated_time=None, links=None, location_infos=None, sub_entities=None, target_version=None, tenant_id=None):
        if available_versions and not isinstance(available_versions, list):
            raise TypeError("Expected argument 'available_versions' to be a list")
        pulumi.set(__self__, "available_versions", available_versions)
        if child_entities and not isinstance(child_entities, list):
            raise TypeError("Expected argument 'child_entities' to be a list")
        pulumi.set(__self__, "child_entities", child_entities)
        if cluster_ext_id and not isinstance(cluster_ext_id, str):
            raise TypeError("Expected argument 'cluster_ext_id' to be a str")
        pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if device_id and not isinstance(device_id, str):
            raise TypeError("Expected argument 'device_id' to be a str")
        pulumi.set(__self__, "device_id", device_id)
        if entity_class and not isinstance(entity_class, str):
            raise TypeError("Expected argument 'entity_class' to be a str")
        pulumi.set(__self__, "entity_class", entity_class)
        if entity_description and not isinstance(entity_description, str):
            raise TypeError("Expected argument 'entity_description' to be a str")
        pulumi.set(__self__, "entity_description", entity_description)
        if entity_details and not isinstance(entity_details, list):
            raise TypeError("Expected argument 'entity_details' to be a list")
        pulumi.set(__self__, "entity_details", entity_details)
        if entity_model and not isinstance(entity_model, str):
            raise TypeError("Expected argument 'entity_model' to be a str")
        pulumi.set(__self__, "entity_model", entity_model)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if entity_version and not isinstance(entity_version, str):
            raise TypeError("Expected argument 'entity_version' to be a str")
        pulumi.set(__self__, "entity_version", entity_version)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if group_uuid and not isinstance(group_uuid, str):
            raise TypeError("Expected argument 'group_uuid' to be a str")
        pulumi.set(__self__, "group_uuid", group_uuid)
        if hardware_family and not isinstance(hardware_family, str):
            raise TypeError("Expected argument 'hardware_family' to be a str")
        pulumi.set(__self__, "hardware_family", hardware_family)
        if hardware_vendor and not isinstance(hardware_vendor, str):
            raise TypeError("Expected argument 'hardware_vendor' to be a str")
        pulumi.set(__self__, "hardware_vendor", hardware_vendor)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if location_infos and not isinstance(location_infos, list):
            raise TypeError("Expected argument 'location_infos' to be a list")
        pulumi.set(__self__, "location_infos", location_infos)
        if sub_entities and not isinstance(sub_entities, list):
            raise TypeError("Expected argument 'sub_entities' to be a list")
        pulumi.set(__self__, "sub_entities", sub_entities)
        if target_version and not isinstance(target_version, str):
            raise TypeError("Expected argument 'target_version' to be a str")
        pulumi.set(__self__, "target_version", target_version)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="availableVersions")
    def available_versions(self) -> Sequence['outputs.GetLcmEntityV2AvailableVersionResult']:
        """
        List of available versions for an LCM entity to update.
        """
        return pulumi.get(self, "available_versions")

    @_builtins.property
    @pulumi.getter(name="childEntities")
    def child_entities(self) -> Sequence[_builtins.str]:
        """
        Component information for the payload based entity.
        """
        return pulumi.get(self, "child_entities")

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> _builtins.str:
        """
        Cluster uuid on which the resource is present or operation is being performed.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> _builtins.str:
        """
        Unique identifier of an LCM entity e.g. "HDD serial number".
        """
        return pulumi.get(self, "device_id")

    @_builtins.property
    @pulumi.getter(name="entityClass")
    def entity_class(self) -> _builtins.str:
        """
        LCM entity class.
        """
        return pulumi.get(self, "entity_class")

    @_builtins.property
    @pulumi.getter(name="entityDescription")
    def entity_description(self) -> _builtins.str:
        """
        Description of an LCM entity.
        """
        return pulumi.get(self, "entity_description")

    @_builtins.property
    @pulumi.getter(name="entityDetails")
    def entity_details(self) -> Sequence['outputs.GetLcmEntityV2EntityDetailResult']:
        """
        Detailed information for the LCM entity. For example, firmware entities contain additional information about NIC and so on.
        """
        return pulumi.get(self, "entity_details")

    @_builtins.property
    @pulumi.getter(name="entityModel")
    def entity_model(self) -> _builtins.str:
        """
        LCM entity model.
        """
        return pulumi.get(self, "entity_model")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        Type of an LCM entity.  Enum Values:
        * `FIRMWARE`: LCM entity type firmware.
        * `SOFTWARE`: LCM entity type software.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter(name="entityVersion")
    def entity_version(self) -> _builtins.str:
        """
        Current version of an LCM entity.
        """
        return pulumi.get(self, "entity_version")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="groupUuid")
    def group_uuid(self) -> _builtins.str:
        """
        UUID of the group that this LCM entity is part of.
        """
        return pulumi.get(self, "group_uuid")

    @_builtins.property
    @pulumi.getter(name="hardwareFamily")
    def hardware_family(self) -> _builtins.str:
        """
        A hardware family for a LCM entity.
        """
        return pulumi.get(self, "hardware_family")

    @_builtins.property
    @pulumi.getter(name="hardwareVendor")
    def hardware_vendor(self) -> _builtins.str:
        """
        Hardware vendor information.
        """
        return pulumi.get(self, "hardware_vendor")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> _builtins.str:
        """
        UTC date and time in RFC-3339 format when the task was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetLcmEntityV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="locationInfos")
    def location_infos(self) -> Sequence['outputs.GetLcmEntityV2LocationInfoResult']:
        """
        Location info corresponds to a tuple of location type (either node/cluster) and ExtID
        """
        return pulumi.get(self, "location_infos")

    @_builtins.property
    @pulumi.getter(name="subEntities")
    def sub_entities(self) -> Sequence['outputs.GetLcmEntityV2SubEntityResult']:
        """
        A list of sub-entities applicable to the entity.
        """
        return pulumi.get(self, "sub_entities")

    @_builtins.property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> _builtins.str:
        """
        The requested update version of an LCM entity.
        """
        return pulumi.get(self, "target_version")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetLcmEntityV2Result(GetLcmEntityV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLcmEntityV2Result(
            available_versions=self.available_versions,
            child_entities=self.child_entities,
            cluster_ext_id=self.cluster_ext_id,
            device_id=self.device_id,
            entity_class=self.entity_class,
            entity_description=self.entity_description,
            entity_details=self.entity_details,
            entity_model=self.entity_model,
            entity_type=self.entity_type,
            entity_version=self.entity_version,
            ext_id=self.ext_id,
            group_uuid=self.group_uuid,
            hardware_family=self.hardware_family,
            hardware_vendor=self.hardware_vendor,
            id=self.id,
            last_updated_time=self.last_updated_time,
            links=self.links,
            location_infos=self.location_infos,
            sub_entities=self.sub_entities,
            target_version=self.target_version,
            tenant_id=self.tenant_id)


def get_lcm_entity_v2(ext_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLcmEntityV2Result:
    """
    Get details about an LCM entity.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    entity_before_upgrade = nutanix.get_lcm_entity_v2(ext_id="613no9d0-7caf-49y7-k582-1db5a5df580c")
    ```


    :param _builtins.str ext_id: ExtId of the LCM entity.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getLcmEntityV2:getLcmEntityV2', __args__, opts=opts, typ=GetLcmEntityV2Result).value

    return AwaitableGetLcmEntityV2Result(
        available_versions=pulumi.get(__ret__, 'available_versions'),
        child_entities=pulumi.get(__ret__, 'child_entities'),
        cluster_ext_id=pulumi.get(__ret__, 'cluster_ext_id'),
        device_id=pulumi.get(__ret__, 'device_id'),
        entity_class=pulumi.get(__ret__, 'entity_class'),
        entity_description=pulumi.get(__ret__, 'entity_description'),
        entity_details=pulumi.get(__ret__, 'entity_details'),
        entity_model=pulumi.get(__ret__, 'entity_model'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        entity_version=pulumi.get(__ret__, 'entity_version'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        group_uuid=pulumi.get(__ret__, 'group_uuid'),
        hardware_family=pulumi.get(__ret__, 'hardware_family'),
        hardware_vendor=pulumi.get(__ret__, 'hardware_vendor'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        links=pulumi.get(__ret__, 'links'),
        location_infos=pulumi.get(__ret__, 'location_infos'),
        sub_entities=pulumi.get(__ret__, 'sub_entities'),
        target_version=pulumi.get(__ret__, 'target_version'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_lcm_entity_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLcmEntityV2Result]:
    """
    Get details about an LCM entity.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    entity_before_upgrade = nutanix.get_lcm_entity_v2(ext_id="613no9d0-7caf-49y7-k582-1db5a5df580c")
    ```


    :param _builtins.str ext_id: ExtId of the LCM entity.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getLcmEntityV2:getLcmEntityV2', __args__, opts=opts, typ=GetLcmEntityV2Result)
    return __ret__.apply(lambda __response__: GetLcmEntityV2Result(
        available_versions=pulumi.get(__response__, 'available_versions'),
        child_entities=pulumi.get(__response__, 'child_entities'),
        cluster_ext_id=pulumi.get(__response__, 'cluster_ext_id'),
        device_id=pulumi.get(__response__, 'device_id'),
        entity_class=pulumi.get(__response__, 'entity_class'),
        entity_description=pulumi.get(__response__, 'entity_description'),
        entity_details=pulumi.get(__response__, 'entity_details'),
        entity_model=pulumi.get(__response__, 'entity_model'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        entity_version=pulumi.get(__response__, 'entity_version'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        group_uuid=pulumi.get(__response__, 'group_uuid'),
        hardware_family=pulumi.get(__response__, 'hardware_family'),
        hardware_vendor=pulumi.get(__response__, 'hardware_vendor'),
        id=pulumi.get(__response__, 'id'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        links=pulumi.get(__response__, 'links'),
        location_infos=pulumi.get(__response__, 'location_infos'),
        sub_entities=pulumi.get(__response__, 'sub_entities'),
        target_version=pulumi.get(__response__, 'target_version'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
