# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLcmStatusV2Result',
    'AwaitableGetLcmStatusV2Result',
    'get_lcm_status_v2',
    'get_lcm_status_v2_output',
]

@pulumi.output_type
class GetLcmStatusV2Result:
    """
    A collection of values returned by getLcmStatusV2.
    """
    def __init__(__self__, ext_id=None, framework_versions=None, id=None, in_progress_operations=None, is_cancel_intent_set=None, links=None, tenant_id=None, upload_task_uuid=None, x_cluster_id=None):
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if framework_versions and not isinstance(framework_versions, list):
            raise TypeError("Expected argument 'framework_versions' to be a list")
        pulumi.set(__self__, "framework_versions", framework_versions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if in_progress_operations and not isinstance(in_progress_operations, list):
            raise TypeError("Expected argument 'in_progress_operations' to be a list")
        pulumi.set(__self__, "in_progress_operations", in_progress_operations)
        if is_cancel_intent_set and not isinstance(is_cancel_intent_set, bool):
            raise TypeError("Expected argument 'is_cancel_intent_set' to be a bool")
        pulumi.set(__self__, "is_cancel_intent_set", is_cancel_intent_set)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if upload_task_uuid and not isinstance(upload_task_uuid, str):
            raise TypeError("Expected argument 'upload_task_uuid' to be a str")
        pulumi.set(__self__, "upload_task_uuid", upload_task_uuid)
        if x_cluster_id and not isinstance(x_cluster_id, str):
            raise TypeError("Expected argument 'x_cluster_id' to be a str")
        pulumi.set(__self__, "x_cluster_id", x_cluster_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="frameworkVersions")
    def framework_versions(self) -> Sequence['outputs.GetLcmStatusV2FrameworkVersionResult']:
        """
        LCM framework version information.
        """
        return pulumi.get(self, "framework_versions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inProgressOperations")
    def in_progress_operations(self) -> Sequence['outputs.GetLcmStatusV2InProgressOperationResult']:
        """
        Operation type and UUID of an ongoing operation in LCM.
        """
        return pulumi.get(self, "in_progress_operations")

    @_builtins.property
    @pulumi.getter(name="isCancelIntentSet")
    def is_cancel_intent_set(self) -> _builtins.bool:
        """
        Boolean that indicates if cancel intent for LCM update is set or not.
        """
        return pulumi.get(self, "is_cancel_intent_set")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetLcmStatusV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="uploadTaskUuid")
    def upload_task_uuid(self) -> _builtins.str:
        """
        Upload task UUID.
        """
        return pulumi.get(self, "upload_task_uuid")

    @_builtins.property
    @pulumi.getter(name="xClusterId")
    def x_cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "x_cluster_id")


class AwaitableGetLcmStatusV2Result(GetLcmStatusV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLcmStatusV2Result(
            ext_id=self.ext_id,
            framework_versions=self.framework_versions,
            id=self.id,
            in_progress_operations=self.in_progress_operations,
            is_cancel_intent_set=self.is_cancel_intent_set,
            links=self.links,
            tenant_id=self.tenant_id,
            upload_task_uuid=self.upload_task_uuid,
            x_cluster_id=self.x_cluster_id)


def get_lcm_status_v2(x_cluster_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLcmStatusV2Result:
    """
    Get the LCM framework status. Represents the Status of LCM. Status represents details about a pending or ongoing action in LCM.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    lcm_framework_status = nutanix.get_lcm_status_v2(x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b")
    ```


    :param _builtins.str x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
    """
    __args__ = dict()
    __args__['xClusterId'] = x_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getLcmStatusV2:getLcmStatusV2', __args__, opts=opts, typ=GetLcmStatusV2Result).value

    return AwaitableGetLcmStatusV2Result(
        ext_id=pulumi.get(__ret__, 'ext_id'),
        framework_versions=pulumi.get(__ret__, 'framework_versions'),
        id=pulumi.get(__ret__, 'id'),
        in_progress_operations=pulumi.get(__ret__, 'in_progress_operations'),
        is_cancel_intent_set=pulumi.get(__ret__, 'is_cancel_intent_set'),
        links=pulumi.get(__ret__, 'links'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        upload_task_uuid=pulumi.get(__ret__, 'upload_task_uuid'),
        x_cluster_id=pulumi.get(__ret__, 'x_cluster_id'))
def get_lcm_status_v2_output(x_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLcmStatusV2Result]:
    """
    Get the LCM framework status. Represents the Status of LCM. Status represents details about a pending or ongoing action in LCM.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    lcm_framework_status = nutanix.get_lcm_status_v2(x_cluster_id="0005a104-0b0b-4b0b-8005-0b0b0b0b0b0b")
    ```


    :param _builtins.str x_cluster_id: Cluster uuid on which the resource is present or operation is being performed.
    """
    __args__ = dict()
    __args__['xClusterId'] = x_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getLcmStatusV2:getLcmStatusV2', __args__, opts=opts, typ=GetLcmStatusV2Result)
    return __ret__.apply(lambda __response__: GetLcmStatusV2Result(
        ext_id=pulumi.get(__response__, 'ext_id'),
        framework_versions=pulumi.get(__response__, 'framework_versions'),
        id=pulumi.get(__response__, 'id'),
        in_progress_operations=pulumi.get(__response__, 'in_progress_operations'),
        is_cancel_intent_set=pulumi.get(__response__, 'is_cancel_intent_set'),
        links=pulumi.get(__response__, 'links'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        upload_task_uuid=pulumi.get(__response__, 'upload_task_uuid'),
        x_cluster_id=pulumi.get(__response__, 'x_cluster_id')))
