# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNdbClonesResult',
    'AwaitableGetNdbClonesResult',
    'get_ndb_clones',
    'get_ndb_clones_output',
]

@pulumi.output_type
class GetNdbClonesResult:
    """
    A collection of values returned by getNdbClones.
    """
    def __init__(__self__, clones=None, filters=None, id=None):
        if clones and not isinstance(clones, list):
            raise TypeError("Expected argument 'clones' to be a list")
        pulumi.set(__self__, "clones", clones)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def clones(self) -> Sequence['outputs.GetNdbClonesCloneResult']:
        """
        List of clones based on filters
        """
        return pulumi.get(self, "clones")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNdbClonesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetNdbClonesResult(GetNdbClonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbClonesResult(
            clones=self.clones,
            filters=self.filters,
            id=self.id)


def get_ndb_clones(filters: Optional[Sequence[Union['GetNdbClonesFilterArgs', 'GetNdbClonesFilterArgsDict']]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbClonesResult:
    """
    List all the clone present in Nutanix Database Service


    :param Sequence[Union['GetNdbClonesFilterArgs', 'GetNdbClonesFilterArgsDict']] filters: Fetches the clone info based on given params
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbClones:getNdbClones', __args__, opts=opts, typ=GetNdbClonesResult).value

    return AwaitableGetNdbClonesResult(
        clones=pulumi.get(__ret__, 'clones'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_ndb_clones_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNdbClonesFilterArgs', 'GetNdbClonesFilterArgsDict']]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbClonesResult]:
    """
    List all the clone present in Nutanix Database Service


    :param Sequence[Union['GetNdbClonesFilterArgs', 'GetNdbClonesFilterArgsDict']] filters: Fetches the clone info based on given params
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbClones:getNdbClones', __args__, opts=opts, typ=GetNdbClonesResult)
    return __ret__.apply(lambda __response__: GetNdbClonesResult(
        clones=pulumi.get(__response__, 'clones'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
