# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNdbClusterResult',
    'AwaitableGetNdbClusterResult',
    'get_ndb_cluster',
    'get_ndb_cluster_output',
]

@pulumi.output_type
class GetNdbClusterResult:
    """
    A collection of values returned by getNdbCluster.
    """
    def __init__(__self__, cloud_info=None, cloud_type=None, cluster_id=None, cluster_name=None, date_created=None, date_modified=None, description=None, entity_counts=None, fqdns=None, healthy=None, hypervisor_type=None, hypervisor_version=None, id=None, ip_addresses=None, management_server_info=None, name=None, nx_cluster_uuid=None, owner_id=None, password=None, properties=None, reference_count=None, resource_configs=None, status=None, unique_name=None, username=None, version=None):
        if cloud_info and not isinstance(cloud_info, str):
            raise TypeError("Expected argument 'cloud_info' to be a str")
        pulumi.set(__self__, "cloud_info", cloud_info)
        if cloud_type and not isinstance(cloud_type, str):
            raise TypeError("Expected argument 'cloud_type' to be a str")
        pulumi.set(__self__, "cloud_type", cloud_type)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_name and not isinstance(cluster_name, str):
            raise TypeError("Expected argument 'cluster_name' to be a str")
        pulumi.set(__self__, "cluster_name", cluster_name)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_modified and not isinstance(date_modified, str):
            raise TypeError("Expected argument 'date_modified' to be a str")
        pulumi.set(__self__, "date_modified", date_modified)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entity_counts and not isinstance(entity_counts, list):
            raise TypeError("Expected argument 'entity_counts' to be a list")
        pulumi.set(__self__, "entity_counts", entity_counts)
        if fqdns and not isinstance(fqdns, str):
            raise TypeError("Expected argument 'fqdns' to be a str")
        pulumi.set(__self__, "fqdns", fqdns)
        if healthy and not isinstance(healthy, bool):
            raise TypeError("Expected argument 'healthy' to be a bool")
        pulumi.set(__self__, "healthy", healthy)
        if hypervisor_type and not isinstance(hypervisor_type, str):
            raise TypeError("Expected argument 'hypervisor_type' to be a str")
        pulumi.set(__self__, "hypervisor_type", hypervisor_type)
        if hypervisor_version and not isinstance(hypervisor_version, str):
            raise TypeError("Expected argument 'hypervisor_version' to be a str")
        pulumi.set(__self__, "hypervisor_version", hypervisor_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_addresses and not isinstance(ip_addresses, list):
            raise TypeError("Expected argument 'ip_addresses' to be a list")
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        if management_server_info and not isinstance(management_server_info, str):
            raise TypeError("Expected argument 'management_server_info' to be a str")
        pulumi.set(__self__, "management_server_info", management_server_info)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nx_cluster_uuid and not isinstance(nx_cluster_uuid, str):
            raise TypeError("Expected argument 'nx_cluster_uuid' to be a str")
        pulumi.set(__self__, "nx_cluster_uuid", nx_cluster_uuid)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if reference_count and not isinstance(reference_count, int):
            raise TypeError("Expected argument 'reference_count' to be a int")
        pulumi.set(__self__, "reference_count", reference_count)
        if resource_configs and not isinstance(resource_configs, list):
            raise TypeError("Expected argument 'resource_configs' to be a list")
        pulumi.set(__self__, "resource_configs", resource_configs)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if unique_name and not isinstance(unique_name, str):
            raise TypeError("Expected argument 'unique_name' to be a str")
        pulumi.set(__self__, "unique_name", unique_name)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="cloudInfo")
    def cloud_info(self) -> _builtins.str:
        """
        - cloud info
        """
        return pulumi.get(self, "cloud_info")

    @_builtins.property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> _builtins.str:
        """
        - cloud type
        """
        return pulumi.get(self, "cloud_type")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        - creation date
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> _builtins.str:
        """
        - date modified
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityCounts")
    def entity_counts(self) -> Sequence['outputs.GetNdbClusterEntityCountResult']:
        """
        - no. of entities related
        """
        return pulumi.get(self, "entity_counts")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> _builtins.str:
        """
        - fqdn
        """
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter
    def healthy(self) -> _builtins.bool:
        """
        - if healthy status
        """
        return pulumi.get(self, "healthy")

    @_builtins.property
    @pulumi.getter(name="hypervisorType")
    def hypervisor_type(self) -> _builtins.str:
        """
        - hypervisor type
        """
        return pulumi.get(self, "hypervisor_type")

    @_builtins.property
    @pulumi.getter(name="hypervisorVersion")
    def hypervisor_version(self) -> _builtins.str:
        """
        - hypervisor version
        """
        return pulumi.get(self, "hypervisor_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        - id of cluster
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        - IP address
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="managementServerInfo")
    def management_server_info(self) -> _builtins.str:
        """
        - NA
        """
        return pulumi.get(self, "management_server_info")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - name of cluster
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nxClusterUuid")
    def nx_cluster_uuid(self) -> _builtins.str:
        """
        - nutanix cluster uuid
        """
        return pulumi.get(self, "nx_cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        - owner UUID
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        - password
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetNdbClusterPropertyResult']:
        """
        - list of properties
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="referenceCount")
    def reference_count(self) -> _builtins.int:
        """
        - NA
        """
        return pulumi.get(self, "reference_count")

    @_builtins.property
    @pulumi.getter(name="resourceConfigs")
    def resource_configs(self) -> Sequence['outputs.GetNdbClusterResourceConfigResult']:
        """
        - resource related consumption info
        """
        return pulumi.get(self, "resource_configs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        - current status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> _builtins.str:
        """
        - unique name of cluster
        """
        return pulumi.get(self, "unique_name")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        - username
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        - version
        """
        return pulumi.get(self, "version")


class AwaitableGetNdbClusterResult(GetNdbClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbClusterResult(
            cloud_info=self.cloud_info,
            cloud_type=self.cloud_type,
            cluster_id=self.cluster_id,
            cluster_name=self.cluster_name,
            date_created=self.date_created,
            date_modified=self.date_modified,
            description=self.description,
            entity_counts=self.entity_counts,
            fqdns=self.fqdns,
            healthy=self.healthy,
            hypervisor_type=self.hypervisor_type,
            hypervisor_version=self.hypervisor_version,
            id=self.id,
            ip_addresses=self.ip_addresses,
            management_server_info=self.management_server_info,
            name=self.name,
            nx_cluster_uuid=self.nx_cluster_uuid,
            owner_id=self.owner_id,
            password=self.password,
            properties=self.properties,
            reference_count=self.reference_count,
            resource_configs=self.resource_configs,
            status=self.status,
            unique_name=self.unique_name,
            username=self.username,
            version=self.version)


def get_ndb_cluster(cluster_id: Optional[_builtins.str] = None,
                    cluster_name: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbClusterResult:
    """
    Describes a cluster in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    c1 = nutanix.get_ndb_cluster(cluster_name="<era-cluster-name>")
    pulumi.export("cluster", c1)
    ```


    :param _builtins.str cluster_id: ID of cluster
    :param _builtins.str cluster_name: and `cluster_id` are mutually exclusive.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterName'] = cluster_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbCluster:getNdbCluster', __args__, opts=opts, typ=GetNdbClusterResult).value

    return AwaitableGetNdbClusterResult(
        cloud_info=pulumi.get(__ret__, 'cloud_info'),
        cloud_type=pulumi.get(__ret__, 'cloud_type'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        cluster_name=pulumi.get(__ret__, 'cluster_name'),
        date_created=pulumi.get(__ret__, 'date_created'),
        date_modified=pulumi.get(__ret__, 'date_modified'),
        description=pulumi.get(__ret__, 'description'),
        entity_counts=pulumi.get(__ret__, 'entity_counts'),
        fqdns=pulumi.get(__ret__, 'fqdns'),
        healthy=pulumi.get(__ret__, 'healthy'),
        hypervisor_type=pulumi.get(__ret__, 'hypervisor_type'),
        hypervisor_version=pulumi.get(__ret__, 'hypervisor_version'),
        id=pulumi.get(__ret__, 'id'),
        ip_addresses=pulumi.get(__ret__, 'ip_addresses'),
        management_server_info=pulumi.get(__ret__, 'management_server_info'),
        name=pulumi.get(__ret__, 'name'),
        nx_cluster_uuid=pulumi.get(__ret__, 'nx_cluster_uuid'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        password=pulumi.get(__ret__, 'password'),
        properties=pulumi.get(__ret__, 'properties'),
        reference_count=pulumi.get(__ret__, 'reference_count'),
        resource_configs=pulumi.get(__ret__, 'resource_configs'),
        status=pulumi.get(__ret__, 'status'),
        unique_name=pulumi.get(__ret__, 'unique_name'),
        username=pulumi.get(__ret__, 'username'),
        version=pulumi.get(__ret__, 'version'))
def get_ndb_cluster_output(cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           cluster_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbClusterResult]:
    """
    Describes a cluster in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    c1 = nutanix.get_ndb_cluster(cluster_name="<era-cluster-name>")
    pulumi.export("cluster", c1)
    ```


    :param _builtins.str cluster_id: ID of cluster
    :param _builtins.str cluster_name: and `cluster_id` are mutually exclusive.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['clusterName'] = cluster_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbCluster:getNdbCluster', __args__, opts=opts, typ=GetNdbClusterResult)
    return __ret__.apply(lambda __response__: GetNdbClusterResult(
        cloud_info=pulumi.get(__response__, 'cloud_info'),
        cloud_type=pulumi.get(__response__, 'cloud_type'),
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        cluster_name=pulumi.get(__response__, 'cluster_name'),
        date_created=pulumi.get(__response__, 'date_created'),
        date_modified=pulumi.get(__response__, 'date_modified'),
        description=pulumi.get(__response__, 'description'),
        entity_counts=pulumi.get(__response__, 'entity_counts'),
        fqdns=pulumi.get(__response__, 'fqdns'),
        healthy=pulumi.get(__response__, 'healthy'),
        hypervisor_type=pulumi.get(__response__, 'hypervisor_type'),
        hypervisor_version=pulumi.get(__response__, 'hypervisor_version'),
        id=pulumi.get(__response__, 'id'),
        ip_addresses=pulumi.get(__response__, 'ip_addresses'),
        management_server_info=pulumi.get(__response__, 'management_server_info'),
        name=pulumi.get(__response__, 'name'),
        nx_cluster_uuid=pulumi.get(__response__, 'nx_cluster_uuid'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        password=pulumi.get(__response__, 'password'),
        properties=pulumi.get(__response__, 'properties'),
        reference_count=pulumi.get(__response__, 'reference_count'),
        resource_configs=pulumi.get(__response__, 'resource_configs'),
        status=pulumi.get(__response__, 'status'),
        unique_name=pulumi.get(__response__, 'unique_name'),
        username=pulumi.get(__response__, 'username'),
        version=pulumi.get(__response__, 'version')))
