# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNdbClustersResult',
    'AwaitableGetNdbClustersResult',
    'get_ndb_clusters',
    'get_ndb_clusters_output',
]

@pulumi.output_type
class GetNdbClustersResult:
    """
    A collection of values returned by getNdbClusters.
    """
    def __init__(__self__, clusters=None, id=None):
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetNdbClustersClusterResult']:
        """
        list of clusters
        """
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetNdbClustersResult(GetNdbClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbClustersResult(
            clusters=self.clusters,
            id=self.id)


def get_ndb_clusters(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbClustersResult:
    """
    List all clusters in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    clusters = nutanix.get_ndb_clusters()
    pulumi.export("clustersOp", clusters)
    ```

    ## clusters

    The following attributes are exported for each cluster:

    * `id`: - id of cluster
    * `name`: - name of cluster
    * `unique_name`: - unique name of cluster
    * `ip_addresses`: - IP address
    * `fqdns`: - fqdn
    * `nx_cluster_uuid`: - nutanix cluster uuid
    * `description`: - description
    * `cloud_type`: - cloud type
    * `date_created`: - creation date
    * `date_modified`: - date modified
    * `version`: - version
    * `owner_id`: - owner UUID
    * `status`: - current status
    * `hypervisor_type`: - hypervisor type
    * `hypervisor_version`: - hypervisor version
    * `properties`: - list of properties
    * `reference_count`: - NA
    * `username`: - username
    * `password`: - password
    * `cloud_info`: - cloud info
    * `resource_config`: - resource related consumption info
    * `management_server_info`: - NA
    * `entity_counts`: - no. of entities related
    * `healthy`: - if healthy status

    See detailed information in [NDB Clusters](https://www.nutanix.dev/api_references/ndb/#/b00cac8329db1-get-a-list-of-all-clusters).
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbClusters:getNdbClusters', __args__, opts=opts, typ=GetNdbClustersResult).value

    return AwaitableGetNdbClustersResult(
        clusters=pulumi.get(__ret__, 'clusters'),
        id=pulumi.get(__ret__, 'id'))
def get_ndb_clusters_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbClustersResult]:
    """
    List all clusters in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    clusters = nutanix.get_ndb_clusters()
    pulumi.export("clustersOp", clusters)
    ```

    ## clusters

    The following attributes are exported for each cluster:

    * `id`: - id of cluster
    * `name`: - name of cluster
    * `unique_name`: - unique name of cluster
    * `ip_addresses`: - IP address
    * `fqdns`: - fqdn
    * `nx_cluster_uuid`: - nutanix cluster uuid
    * `description`: - description
    * `cloud_type`: - cloud type
    * `date_created`: - creation date
    * `date_modified`: - date modified
    * `version`: - version
    * `owner_id`: - owner UUID
    * `status`: - current status
    * `hypervisor_type`: - hypervisor type
    * `hypervisor_version`: - hypervisor version
    * `properties`: - list of properties
    * `reference_count`: - NA
    * `username`: - username
    * `password`: - password
    * `cloud_info`: - cloud info
    * `resource_config`: - resource related consumption info
    * `management_server_info`: - NA
    * `entity_counts`: - no. of entities related
    * `healthy`: - if healthy status

    See detailed information in [NDB Clusters](https://www.nutanix.dev/api_references/ndb/#/b00cac8329db1-get-a-list-of-all-clusters).
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbClusters:getNdbClusters', __args__, opts=opts, typ=GetNdbClustersResult)
    return __ret__.apply(lambda __response__: GetNdbClustersResult(
        clusters=pulumi.get(__response__, 'clusters'),
        id=pulumi.get(__response__, 'id')))
