# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNdbDatabasesResult',
    'AwaitableGetNdbDatabasesResult',
    'get_ndb_databases',
    'get_ndb_databases_output',
]

@pulumi.output_type
class GetNdbDatabasesResult:
    """
    A collection of values returned by getNdbDatabases.
    """
    def __init__(__self__, database_instances=None, database_type=None, id=None):
        if database_instances and not isinstance(database_instances, list):
            raise TypeError("Expected argument 'database_instances' to be a list")
        pulumi.set(__self__, "database_instances", database_instances)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="databaseInstances")
    def database_instances(self) -> Sequence['outputs.GetNdbDatabasesDatabaseInstanceResult']:
        """
        - list of database instances
        """
        return pulumi.get(self, "database_instances")

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "database_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetNdbDatabasesResult(GetNdbDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbDatabasesResult(
            database_instances=self.database_instances,
            database_type=self.database_type,
            id=self.id)


def get_ndb_databases(database_type: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbDatabasesResult:
    """
    List all database instances in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    dbs = nutanix.get_ndb_databases()
    pulumi.export("dbsOutput", dbs)
    ```

    ## database_instances

    The following attributes are exported for each database_instances:

    * `id`: - id of database instance
    * `name`: - name of database instance
    * `description`: - description
    * `date_created`: - creation date
    * `date_modified`: - date modified
    * `properties`: - properties
    * `tags`: - tags attached
    * `clustered`: - if clustered or not
    * `clone`: - if cloned
    * `database_name`: - database instance name
    * `type`: - database engine type
    * `status`: - status of database instance
    * `dbserver_logical_cluster_id`: - NA
    * `time_machine_id`: - time machine ID
    * `time_zone`: - timezone
    * `info`: - info regarding disks, vm, storage, etc.
    * `metric`: - metrics
    * `parent_database_id`: - parent database ID
    * `lcm_config`: - lcm configuration
    * `time_machine`: - time machine related config info
    * `database_nodes`: - nodes info
    * `dbserver_logical_cluster`: - NA
    * `linked_databases`: - list of databases created in instance with info

    See detailed information in [List Database Instances](https://www.nutanix.dev/api_references/ndb/#/1e508756bcdcc-get-all-the-databases).
    """
    __args__ = dict()
    __args__['databaseType'] = database_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbDatabases:getNdbDatabases', __args__, opts=opts, typ=GetNdbDatabasesResult).value

    return AwaitableGetNdbDatabasesResult(
        database_instances=pulumi.get(__ret__, 'database_instances'),
        database_type=pulumi.get(__ret__, 'database_type'),
        id=pulumi.get(__ret__, 'id'))
def get_ndb_databases_output(database_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbDatabasesResult]:
    """
    List all database instances in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    dbs = nutanix.get_ndb_databases()
    pulumi.export("dbsOutput", dbs)
    ```

    ## database_instances

    The following attributes are exported for each database_instances:

    * `id`: - id of database instance
    * `name`: - name of database instance
    * `description`: - description
    * `date_created`: - creation date
    * `date_modified`: - date modified
    * `properties`: - properties
    * `tags`: - tags attached
    * `clustered`: - if clustered or not
    * `clone`: - if cloned
    * `database_name`: - database instance name
    * `type`: - database engine type
    * `status`: - status of database instance
    * `dbserver_logical_cluster_id`: - NA
    * `time_machine_id`: - time machine ID
    * `time_zone`: - timezone
    * `info`: - info regarding disks, vm, storage, etc.
    * `metric`: - metrics
    * `parent_database_id`: - parent database ID
    * `lcm_config`: - lcm configuration
    * `time_machine`: - time machine related config info
    * `database_nodes`: - nodes info
    * `dbserver_logical_cluster`: - NA
    * `linked_databases`: - list of databases created in instance with info

    See detailed information in [List Database Instances](https://www.nutanix.dev/api_references/ndb/#/1e508756bcdcc-get-all-the-databases).
    """
    __args__ = dict()
    __args__['databaseType'] = database_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbDatabases:getNdbDatabases', __args__, opts=opts, typ=GetNdbDatabasesResult)
    return __ret__.apply(lambda __response__: GetNdbDatabasesResult(
        database_instances=pulumi.get(__response__, 'database_instances'),
        database_type=pulumi.get(__response__, 'database_type'),
        id=pulumi.get(__response__, 'id')))
