# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNdbDbserverResult',
    'AwaitableGetNdbDbserverResult',
    'get_ndb_dbserver',
    'get_ndb_dbserver_output',
]

@pulumi.output_type
class GetNdbDbserverResult:
    """
    A collection of values returned by getNdbDbserver.
    """
    def __init__(__self__, access_key_id=None, access_level=None, associated_time_machine_ids=None, client_id=None, clustered=None, database_type=None, date_created=None, date_modified=None, dbserver_cluster_id=None, dbserver_invalid_ea_state=None, description=None, era_drive_id=None, era_version=None, fqdns=None, id=None, ip=None, ip_addresses=None, is_server_driven=None, mac_addresses=None, name=None, nx_cluster_id=None, properties=None, protection_domain_id=None, query_count=None, status=None, tags=None, type=None, valid_diagnostic_bundle_state=None, vm_cluster_id=None, vm_cluster_name=None, vm_cluster_uuid=None, vm_infos=None, vm_timezone=None, windows_db_server=None, working_directory=None):
        if access_key_id and not isinstance(access_key_id, str):
            raise TypeError("Expected argument 'access_key_id' to be a str")
        pulumi.set(__self__, "access_key_id", access_key_id)
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if associated_time_machine_ids and not isinstance(associated_time_machine_ids, list):
            raise TypeError("Expected argument 'associated_time_machine_ids' to be a list")
        pulumi.set(__self__, "associated_time_machine_ids", associated_time_machine_ids)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if clustered and not isinstance(clustered, bool):
            raise TypeError("Expected argument 'clustered' to be a bool")
        pulumi.set(__self__, "clustered", clustered)
        if database_type and not isinstance(database_type, str):
            raise TypeError("Expected argument 'database_type' to be a str")
        pulumi.set(__self__, "database_type", database_type)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_modified and not isinstance(date_modified, str):
            raise TypeError("Expected argument 'date_modified' to be a str")
        pulumi.set(__self__, "date_modified", date_modified)
        if dbserver_cluster_id and not isinstance(dbserver_cluster_id, str):
            raise TypeError("Expected argument 'dbserver_cluster_id' to be a str")
        pulumi.set(__self__, "dbserver_cluster_id", dbserver_cluster_id)
        if dbserver_invalid_ea_state and not isinstance(dbserver_invalid_ea_state, bool):
            raise TypeError("Expected argument 'dbserver_invalid_ea_state' to be a bool")
        pulumi.set(__self__, "dbserver_invalid_ea_state", dbserver_invalid_ea_state)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if era_drive_id and not isinstance(era_drive_id, str):
            raise TypeError("Expected argument 'era_drive_id' to be a str")
        pulumi.set(__self__, "era_drive_id", era_drive_id)
        if era_version and not isinstance(era_version, str):
            raise TypeError("Expected argument 'era_version' to be a str")
        pulumi.set(__self__, "era_version", era_version)
        if fqdns and not isinstance(fqdns, str):
            raise TypeError("Expected argument 'fqdns' to be a str")
        pulumi.set(__self__, "fqdns", fqdns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if ip_addresses and not isinstance(ip_addresses, list):
            raise TypeError("Expected argument 'ip_addresses' to be a list")
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        if is_server_driven and not isinstance(is_server_driven, bool):
            raise TypeError("Expected argument 'is_server_driven' to be a bool")
        pulumi.set(__self__, "is_server_driven", is_server_driven)
        if mac_addresses and not isinstance(mac_addresses, list):
            raise TypeError("Expected argument 'mac_addresses' to be a list")
        pulumi.set(__self__, "mac_addresses", mac_addresses)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nx_cluster_id and not isinstance(nx_cluster_id, str):
            raise TypeError("Expected argument 'nx_cluster_id' to be a str")
        pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if protection_domain_id and not isinstance(protection_domain_id, str):
            raise TypeError("Expected argument 'protection_domain_id' to be a str")
        pulumi.set(__self__, "protection_domain_id", protection_domain_id)
        if query_count and not isinstance(query_count, int):
            raise TypeError("Expected argument 'query_count' to be a int")
        pulumi.set(__self__, "query_count", query_count)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if valid_diagnostic_bundle_state and not isinstance(valid_diagnostic_bundle_state, bool):
            raise TypeError("Expected argument 'valid_diagnostic_bundle_state' to be a bool")
        pulumi.set(__self__, "valid_diagnostic_bundle_state", valid_diagnostic_bundle_state)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)
        if vm_cluster_name and not isinstance(vm_cluster_name, str):
            raise TypeError("Expected argument 'vm_cluster_name' to be a str")
        pulumi.set(__self__, "vm_cluster_name", vm_cluster_name)
        if vm_cluster_uuid and not isinstance(vm_cluster_uuid, str):
            raise TypeError("Expected argument 'vm_cluster_uuid' to be a str")
        pulumi.set(__self__, "vm_cluster_uuid", vm_cluster_uuid)
        if vm_infos and not isinstance(vm_infos, list):
            raise TypeError("Expected argument 'vm_infos' to be a list")
        pulumi.set(__self__, "vm_infos", vm_infos)
        if vm_timezone and not isinstance(vm_timezone, str):
            raise TypeError("Expected argument 'vm_timezone' to be a str")
        pulumi.set(__self__, "vm_timezone", vm_timezone)
        if windows_db_server and not isinstance(windows_db_server, bool):
            raise TypeError("Expected argument 'windows_db_server' to be a bool")
        pulumi.set(__self__, "windows_db_server", windows_db_server)
        if working_directory and not isinstance(working_directory, str):
            raise TypeError("Expected argument 'working_directory' to be a str")
        pulumi.set(__self__, "working_directory", working_directory)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> _builtins.str:
        """
        access key id of dbserver vm
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> _builtins.str:
        """
        access level
        """
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="associatedTimeMachineIds")
    def associated_time_machine_ids(self) -> Sequence[_builtins.str]:
        """
        associated time machines ids
        """
        return pulumi.get(self, "associated_time_machine_ids")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        client id
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter
    def clustered(self) -> _builtins.bool:
        """
        clustered or not
        """
        return pulumi.get(self, "clustered")

    @_builtins.property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> _builtins.str:
        """
        database type
        """
        return pulumi.get(self, "database_type")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        date created of db server vm
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> _builtins.str:
        """
        date modified of db server vm
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter(name="dbserverClusterId")
    def dbserver_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "dbserver_cluster_id")

    @_builtins.property
    @pulumi.getter(name="dbserverInvalidEaState")
    def dbserver_invalid_ea_state(self) -> _builtins.bool:
        """
        dbserver invalid ea state
        """
        return pulumi.get(self, "dbserver_invalid_ea_state")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        description of db server vm
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eraDriveId")
    def era_drive_id(self) -> _builtins.str:
        """
        era drive id
        """
        return pulumi.get(self, "era_drive_id")

    @_builtins.property
    @pulumi.getter(name="eraVersion")
    def era_version(self) -> _builtins.str:
        """
        era version
        """
        return pulumi.get(self, "era_version")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> _builtins.str:
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[_builtins.str]:
        """
        IP addresses of the dbserver vm
        """
        return pulumi.get(self, "ip_addresses")

    @_builtins.property
    @pulumi.getter(name="isServerDriven")
    def is_server_driven(self) -> _builtins.bool:
        """
        is server down or not
        """
        return pulumi.get(self, "is_server_driven")

    @_builtins.property
    @pulumi.getter(name="macAddresses")
    def mac_addresses(self) -> Sequence[_builtins.str]:
        """
        Mac addresses of dbserver vm
        """
        return pulumi.get(self, "mac_addresses")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "nx_cluster_id")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetNdbDbserverPropertyResult']:
        """
        properties of db server vm
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="protectionDomainId")
    def protection_domain_id(self) -> _builtins.str:
        """
        protection domain id
        """
        return pulumi.get(self, "protection_domain_id")

    @_builtins.property
    @pulumi.getter(name="queryCount")
    def query_count(self) -> _builtins.int:
        """
        query count
        """
        return pulumi.get(self, "query_count")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of Dbserver . Active or not.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetNdbDbserverTagResult']:
        """
        tags for db server vm
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of entity. i.e. Dbserver
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="validDiagnosticBundleState")
    def valid_diagnostic_bundle_state(self) -> _builtins.bool:
        """
        valid diagnostic bundle state
        """
        return pulumi.get(self, "valid_diagnostic_bundle_state")

    @_builtins.property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="vmClusterName")
    def vm_cluster_name(self) -> _builtins.str:
        return pulumi.get(self, "vm_cluster_name")

    @_builtins.property
    @pulumi.getter(name="vmClusterUuid")
    def vm_cluster_uuid(self) -> _builtins.str:
        """
        clusetr uuid for dbserver vm
        """
        return pulumi.get(self, "vm_cluster_uuid")

    @_builtins.property
    @pulumi.getter(name="vmInfos")
    def vm_infos(self) -> Sequence['outputs.GetNdbDbserverVmInfoResult']:
        """
        info of dbserver vm
        """
        return pulumi.get(self, "vm_infos")

    @_builtins.property
    @pulumi.getter(name="vmTimezone")
    def vm_timezone(self) -> _builtins.str:
        """
        timezone of dbserver vm
        """
        return pulumi.get(self, "vm_timezone")

    @_builtins.property
    @pulumi.getter(name="windowsDbServer")
    def windows_db_server(self) -> _builtins.bool:
        """
        window db server
        """
        return pulumi.get(self, "windows_db_server")

    @_builtins.property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> _builtins.str:
        """
        working directory of db server vm
        """
        return pulumi.get(self, "working_directory")


class AwaitableGetNdbDbserverResult(GetNdbDbserverResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbDbserverResult(
            access_key_id=self.access_key_id,
            access_level=self.access_level,
            associated_time_machine_ids=self.associated_time_machine_ids,
            client_id=self.client_id,
            clustered=self.clustered,
            database_type=self.database_type,
            date_created=self.date_created,
            date_modified=self.date_modified,
            dbserver_cluster_id=self.dbserver_cluster_id,
            dbserver_invalid_ea_state=self.dbserver_invalid_ea_state,
            description=self.description,
            era_drive_id=self.era_drive_id,
            era_version=self.era_version,
            fqdns=self.fqdns,
            id=self.id,
            ip=self.ip,
            ip_addresses=self.ip_addresses,
            is_server_driven=self.is_server_driven,
            mac_addresses=self.mac_addresses,
            name=self.name,
            nx_cluster_id=self.nx_cluster_id,
            properties=self.properties,
            protection_domain_id=self.protection_domain_id,
            query_count=self.query_count,
            status=self.status,
            tags=self.tags,
            type=self.type,
            valid_diagnostic_bundle_state=self.valid_diagnostic_bundle_state,
            vm_cluster_id=self.vm_cluster_id,
            vm_cluster_name=self.vm_cluster_name,
            vm_cluster_uuid=self.vm_cluster_uuid,
            vm_infos=self.vm_infos,
            vm_timezone=self.vm_timezone,
            windows_db_server=self.windows_db_server,
            working_directory=self.working_directory)


def get_ndb_dbserver(dbserver_cluster_id: Optional[_builtins.str] = None,
                     id: Optional[_builtins.str] = None,
                     ip: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     nx_cluster_id: Optional[_builtins.str] = None,
                     tags: Optional[Sequence[Union['GetNdbDbserverTagArgs', 'GetNdbDbserverTagArgsDict']]] = None,
                     vm_cluster_id: Optional[_builtins.str] = None,
                     vm_cluster_name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbDbserverResult:
    """
    Describes Database Server VM in Nutanix Database Service


    :param _builtins.str id: id of database server vm
    :param _builtins.str ip: ip of database server vm
    :param _builtins.str name: name of database server vm
    :param Sequence[Union['GetNdbDbserverTagArgs', 'GetNdbDbserverTagArgsDict']] tags: tags for db server vm
    :param _builtins.str vm_cluster_id: vm cluster id of database server
    :param _builtins.str vm_cluster_name: vm cluster name of database server
    """
    __args__ = dict()
    __args__['dbserverClusterId'] = dbserver_cluster_id
    __args__['id'] = id
    __args__['ip'] = ip
    __args__['name'] = name
    __args__['nxClusterId'] = nx_cluster_id
    __args__['tags'] = tags
    __args__['vmClusterId'] = vm_cluster_id
    __args__['vmClusterName'] = vm_cluster_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbDbserver:getNdbDbserver', __args__, opts=opts, typ=GetNdbDbserverResult).value

    return AwaitableGetNdbDbserverResult(
        access_key_id=pulumi.get(__ret__, 'access_key_id'),
        access_level=pulumi.get(__ret__, 'access_level'),
        associated_time_machine_ids=pulumi.get(__ret__, 'associated_time_machine_ids'),
        client_id=pulumi.get(__ret__, 'client_id'),
        clustered=pulumi.get(__ret__, 'clustered'),
        database_type=pulumi.get(__ret__, 'database_type'),
        date_created=pulumi.get(__ret__, 'date_created'),
        date_modified=pulumi.get(__ret__, 'date_modified'),
        dbserver_cluster_id=pulumi.get(__ret__, 'dbserver_cluster_id'),
        dbserver_invalid_ea_state=pulumi.get(__ret__, 'dbserver_invalid_ea_state'),
        description=pulumi.get(__ret__, 'description'),
        era_drive_id=pulumi.get(__ret__, 'era_drive_id'),
        era_version=pulumi.get(__ret__, 'era_version'),
        fqdns=pulumi.get(__ret__, 'fqdns'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        ip_addresses=pulumi.get(__ret__, 'ip_addresses'),
        is_server_driven=pulumi.get(__ret__, 'is_server_driven'),
        mac_addresses=pulumi.get(__ret__, 'mac_addresses'),
        name=pulumi.get(__ret__, 'name'),
        nx_cluster_id=pulumi.get(__ret__, 'nx_cluster_id'),
        properties=pulumi.get(__ret__, 'properties'),
        protection_domain_id=pulumi.get(__ret__, 'protection_domain_id'),
        query_count=pulumi.get(__ret__, 'query_count'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        valid_diagnostic_bundle_state=pulumi.get(__ret__, 'valid_diagnostic_bundle_state'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'),
        vm_cluster_name=pulumi.get(__ret__, 'vm_cluster_name'),
        vm_cluster_uuid=pulumi.get(__ret__, 'vm_cluster_uuid'),
        vm_infos=pulumi.get(__ret__, 'vm_infos'),
        vm_timezone=pulumi.get(__ret__, 'vm_timezone'),
        windows_db_server=pulumi.get(__ret__, 'windows_db_server'),
        working_directory=pulumi.get(__ret__, 'working_directory'))
def get_ndb_dbserver_output(dbserver_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            ip: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            nx_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Sequence[Union['GetNdbDbserverTagArgs', 'GetNdbDbserverTagArgsDict']]]]] = None,
                            vm_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            vm_cluster_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbDbserverResult]:
    """
    Describes Database Server VM in Nutanix Database Service


    :param _builtins.str id: id of database server vm
    :param _builtins.str ip: ip of database server vm
    :param _builtins.str name: name of database server vm
    :param Sequence[Union['GetNdbDbserverTagArgs', 'GetNdbDbserverTagArgsDict']] tags: tags for db server vm
    :param _builtins.str vm_cluster_id: vm cluster id of database server
    :param _builtins.str vm_cluster_name: vm cluster name of database server
    """
    __args__ = dict()
    __args__['dbserverClusterId'] = dbserver_cluster_id
    __args__['id'] = id
    __args__['ip'] = ip
    __args__['name'] = name
    __args__['nxClusterId'] = nx_cluster_id
    __args__['tags'] = tags
    __args__['vmClusterId'] = vm_cluster_id
    __args__['vmClusterName'] = vm_cluster_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbDbserver:getNdbDbserver', __args__, opts=opts, typ=GetNdbDbserverResult)
    return __ret__.apply(lambda __response__: GetNdbDbserverResult(
        access_key_id=pulumi.get(__response__, 'access_key_id'),
        access_level=pulumi.get(__response__, 'access_level'),
        associated_time_machine_ids=pulumi.get(__response__, 'associated_time_machine_ids'),
        client_id=pulumi.get(__response__, 'client_id'),
        clustered=pulumi.get(__response__, 'clustered'),
        database_type=pulumi.get(__response__, 'database_type'),
        date_created=pulumi.get(__response__, 'date_created'),
        date_modified=pulumi.get(__response__, 'date_modified'),
        dbserver_cluster_id=pulumi.get(__response__, 'dbserver_cluster_id'),
        dbserver_invalid_ea_state=pulumi.get(__response__, 'dbserver_invalid_ea_state'),
        description=pulumi.get(__response__, 'description'),
        era_drive_id=pulumi.get(__response__, 'era_drive_id'),
        era_version=pulumi.get(__response__, 'era_version'),
        fqdns=pulumi.get(__response__, 'fqdns'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        ip_addresses=pulumi.get(__response__, 'ip_addresses'),
        is_server_driven=pulumi.get(__response__, 'is_server_driven'),
        mac_addresses=pulumi.get(__response__, 'mac_addresses'),
        name=pulumi.get(__response__, 'name'),
        nx_cluster_id=pulumi.get(__response__, 'nx_cluster_id'),
        properties=pulumi.get(__response__, 'properties'),
        protection_domain_id=pulumi.get(__response__, 'protection_domain_id'),
        query_count=pulumi.get(__response__, 'query_count'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        valid_diagnostic_bundle_state=pulumi.get(__response__, 'valid_diagnostic_bundle_state'),
        vm_cluster_id=pulumi.get(__response__, 'vm_cluster_id'),
        vm_cluster_name=pulumi.get(__response__, 'vm_cluster_name'),
        vm_cluster_uuid=pulumi.get(__response__, 'vm_cluster_uuid'),
        vm_infos=pulumi.get(__response__, 'vm_infos'),
        vm_timezone=pulumi.get(__response__, 'vm_timezone'),
        windows_db_server=pulumi.get(__response__, 'windows_db_server'),
        working_directory=pulumi.get(__response__, 'working_directory')))
