# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNdbNetworkAvailableIpsResult',
    'AwaitableGetNdbNetworkAvailableIpsResult',
    'get_ndb_network_available_ips',
    'get_ndb_network_available_ips_output',
]

@pulumi.output_type
class GetNdbNetworkAvailableIpsResult:
    """
    A collection of values returned by getNdbNetworkAvailableIps.
    """
    def __init__(__self__, available_ips=None, id=None, profile_id=None):
        if available_ips and not isinstance(available_ips, list):
            raise TypeError("Expected argument 'available_ips' to be a list")
        pulumi.set(__self__, "available_ips", available_ips)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)

    @_builtins.property
    @pulumi.getter(name="availableIps")
    def available_ips(self) -> Sequence['outputs.GetNdbNetworkAvailableIpsAvailableIpResult']:
        """
        List of network available ips
        """
        return pulumi.get(self, "available_ips")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> _builtins.str:
        """
        (Required) Network Profile id.
        """
        return pulumi.get(self, "profile_id")


class AwaitableGetNdbNetworkAvailableIpsResult(GetNdbNetworkAvailableIpsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbNetworkAvailableIpsResult(
            available_ips=self.available_ips,
            id=self.id,
            profile_id=self.profile_id)


def get_ndb_network_available_ips(profile_id: Optional[_builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbNetworkAvailableIpsResult:
    """
    List of available IPs in Network

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    network = nutanix.get_ndb_network_available_ips(profile_id="{{ network_profile_id }}")
    ```


    :param _builtins.str profile_id: (Required) Network Profile id.
    """
    __args__ = dict()
    __args__['profileId'] = profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbNetworkAvailableIps:getNdbNetworkAvailableIps', __args__, opts=opts, typ=GetNdbNetworkAvailableIpsResult).value

    return AwaitableGetNdbNetworkAvailableIpsResult(
        available_ips=pulumi.get(__ret__, 'available_ips'),
        id=pulumi.get(__ret__, 'id'),
        profile_id=pulumi.get(__ret__, 'profile_id'))
def get_ndb_network_available_ips_output(profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbNetworkAvailableIpsResult]:
    """
    List of available IPs in Network

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    network = nutanix.get_ndb_network_available_ips(profile_id="{{ network_profile_id }}")
    ```


    :param _builtins.str profile_id: (Required) Network Profile id.
    """
    __args__ = dict()
    __args__['profileId'] = profile_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbNetworkAvailableIps:getNdbNetworkAvailableIps', __args__, opts=opts, typ=GetNdbNetworkAvailableIpsResult)
    return __ret__.apply(lambda __response__: GetNdbNetworkAvailableIpsResult(
        available_ips=pulumi.get(__response__, 'available_ips'),
        id=pulumi.get(__response__, 'id'),
        profile_id=pulumi.get(__response__, 'profile_id')))
