# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNdbProfileResult',
    'AwaitableGetNdbProfileResult',
    'get_ndb_profile',
    'get_ndb_profile_output',
]

@pulumi.output_type
class GetNdbProfileResult:
    """
    A collection of values returned by getNdbProfile.
    """
    def __init__(__self__, assoc_databases=None, assoc_db_servers=None, cluster_availabilities=None, db_version=None, description=None, engine=None, engine_type=None, id=None, latest_version=None, latest_version_id=None, name=None, nx_cluster_id=None, owner=None, profile_id=None, profile_name=None, profile_type=None, status=None, system_profile=None, topology=None, type=None, versions=None):
        if assoc_databases and not isinstance(assoc_databases, list):
            raise TypeError("Expected argument 'assoc_databases' to be a list")
        pulumi.set(__self__, "assoc_databases", assoc_databases)
        if assoc_db_servers and not isinstance(assoc_db_servers, list):
            raise TypeError("Expected argument 'assoc_db_servers' to be a list")
        pulumi.set(__self__, "assoc_db_servers", assoc_db_servers)
        if cluster_availabilities and not isinstance(cluster_availabilities, list):
            raise TypeError("Expected argument 'cluster_availabilities' to be a list")
        pulumi.set(__self__, "cluster_availabilities", cluster_availabilities)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_type and not isinstance(engine_type, str):
            raise TypeError("Expected argument 'engine_type' to be a str")
        pulumi.set(__self__, "engine_type", engine_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if latest_version and not isinstance(latest_version, str):
            raise TypeError("Expected argument 'latest_version' to be a str")
        pulumi.set(__self__, "latest_version", latest_version)
        if latest_version_id and not isinstance(latest_version_id, str):
            raise TypeError("Expected argument 'latest_version_id' to be a str")
        pulumi.set(__self__, "latest_version_id", latest_version_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nx_cluster_id and not isinstance(nx_cluster_id, str):
            raise TypeError("Expected argument 'nx_cluster_id' to be a str")
        pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if profile_id and not isinstance(profile_id, str):
            raise TypeError("Expected argument 'profile_id' to be a str")
        pulumi.set(__self__, "profile_id", profile_id)
        if profile_name and not isinstance(profile_name, str):
            raise TypeError("Expected argument 'profile_name' to be a str")
        pulumi.set(__self__, "profile_name", profile_name)
        if profile_type and not isinstance(profile_type, str):
            raise TypeError("Expected argument 'profile_type' to be a str")
        pulumi.set(__self__, "profile_type", profile_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_profile and not isinstance(system_profile, bool):
            raise TypeError("Expected argument 'system_profile' to be a bool")
        pulumi.set(__self__, "system_profile", system_profile)
        if topology and not isinstance(topology, str):
            raise TypeError("Expected argument 'topology' to be a str")
        pulumi.set(__self__, "topology", topology)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="assocDatabases")
    def assoc_databases(self) -> Sequence[_builtins.str]:
        """
        - associated databases
        """
        return pulumi.get(self, "assoc_databases")

    @_builtins.property
    @pulumi.getter(name="assocDbServers")
    def assoc_db_servers(self) -> Sequence[_builtins.str]:
        """
        - associated DB servers
        """
        return pulumi.get(self, "assoc_db_servers")

    @_builtins.property
    @pulumi.getter(name="clusterAvailabilities")
    def cluster_availabilities(self) -> Sequence['outputs.GetNdbProfileClusterAvailabilityResult']:
        """
        - list of clusters availability
        """
        return pulumi.get(self, "cluster_availabilities")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> _builtins.str:
        """
        - database version
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - description of profile
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> _builtins.str:
        """
        - database engine type
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        - id of profile
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> _builtins.str:
        """
        - latest version for engine software
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter(name="latestVersionId")
    def latest_version_id(self) -> _builtins.str:
        """
        - ID of latest version for engine software
        """
        return pulumi.get(self, "latest_version_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - profile name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> _builtins.str:
        """
        - era cluster ID
        """
        return pulumi.get(self, "nx_cluster_id")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        - owner name
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "profile_name")

    @_builtins.property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "profile_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        - status of profile
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemProfile")
    def system_profile(self) -> _builtins.bool:
        """
        - if system profile or not
        """
        return pulumi.get(self, "system_profile")

    @_builtins.property
    @pulumi.getter
    def topology(self) -> _builtins.str:
        """
        - topology
        """
        return pulumi.get(self, "topology")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetNdbProfileVersionResult']:
        """
        - profile's different version config
        """
        return pulumi.get(self, "versions")


class AwaitableGetNdbProfileResult(GetNdbProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbProfileResult(
            assoc_databases=self.assoc_databases,
            assoc_db_servers=self.assoc_db_servers,
            cluster_availabilities=self.cluster_availabilities,
            db_version=self.db_version,
            description=self.description,
            engine=self.engine,
            engine_type=self.engine_type,
            id=self.id,
            latest_version=self.latest_version,
            latest_version_id=self.latest_version_id,
            name=self.name,
            nx_cluster_id=self.nx_cluster_id,
            owner=self.owner,
            profile_id=self.profile_id,
            profile_name=self.profile_name,
            profile_type=self.profile_type,
            status=self.status,
            system_profile=self.system_profile,
            topology=self.topology,
            type=self.type,
            versions=self.versions)


def get_ndb_profile(engine: Optional[_builtins.str] = None,
                    profile_id: Optional[_builtins.str] = None,
                    profile_name: Optional[_builtins.str] = None,
                    profile_type: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbProfileResult:
    """
    Describes a profile in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    profile1 = nutanix.get_ndb_profile(profile_type="Network",
        profile_name="TEST_NETWORK_PROFILE")
    pulumi.export("profile", profile1)
    ```


    :param _builtins.str engine: Database engine. For eg. postgres_database
    :param _builtins.str profile_id: Profile ID for query
    :param _builtins.str profile_name: Profile Name for query
    :param _builtins.str profile_type: Profile type. Types: Software, Compute, Network and Database_Parameter
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['profileId'] = profile_id
    __args__['profileName'] = profile_name
    __args__['profileType'] = profile_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbProfile:getNdbProfile', __args__, opts=opts, typ=GetNdbProfileResult).value

    return AwaitableGetNdbProfileResult(
        assoc_databases=pulumi.get(__ret__, 'assoc_databases'),
        assoc_db_servers=pulumi.get(__ret__, 'assoc_db_servers'),
        cluster_availabilities=pulumi.get(__ret__, 'cluster_availabilities'),
        db_version=pulumi.get(__ret__, 'db_version'),
        description=pulumi.get(__ret__, 'description'),
        engine=pulumi.get(__ret__, 'engine'),
        engine_type=pulumi.get(__ret__, 'engine_type'),
        id=pulumi.get(__ret__, 'id'),
        latest_version=pulumi.get(__ret__, 'latest_version'),
        latest_version_id=pulumi.get(__ret__, 'latest_version_id'),
        name=pulumi.get(__ret__, 'name'),
        nx_cluster_id=pulumi.get(__ret__, 'nx_cluster_id'),
        owner=pulumi.get(__ret__, 'owner'),
        profile_id=pulumi.get(__ret__, 'profile_id'),
        profile_name=pulumi.get(__ret__, 'profile_name'),
        profile_type=pulumi.get(__ret__, 'profile_type'),
        status=pulumi.get(__ret__, 'status'),
        system_profile=pulumi.get(__ret__, 'system_profile'),
        topology=pulumi.get(__ret__, 'topology'),
        type=pulumi.get(__ret__, 'type'),
        versions=pulumi.get(__ret__, 'versions'))
def get_ndb_profile_output(engine: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           profile_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           profile_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           profile_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbProfileResult]:
    """
    Describes a profile in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    profile1 = nutanix.get_ndb_profile(profile_type="Network",
        profile_name="TEST_NETWORK_PROFILE")
    pulumi.export("profile", profile1)
    ```


    :param _builtins.str engine: Database engine. For eg. postgres_database
    :param _builtins.str profile_id: Profile ID for query
    :param _builtins.str profile_name: Profile Name for query
    :param _builtins.str profile_type: Profile type. Types: Software, Compute, Network and Database_Parameter
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['profileId'] = profile_id
    __args__['profileName'] = profile_name
    __args__['profileType'] = profile_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbProfile:getNdbProfile', __args__, opts=opts, typ=GetNdbProfileResult)
    return __ret__.apply(lambda __response__: GetNdbProfileResult(
        assoc_databases=pulumi.get(__response__, 'assoc_databases'),
        assoc_db_servers=pulumi.get(__response__, 'assoc_db_servers'),
        cluster_availabilities=pulumi.get(__response__, 'cluster_availabilities'),
        db_version=pulumi.get(__response__, 'db_version'),
        description=pulumi.get(__response__, 'description'),
        engine=pulumi.get(__response__, 'engine'),
        engine_type=pulumi.get(__response__, 'engine_type'),
        id=pulumi.get(__response__, 'id'),
        latest_version=pulumi.get(__response__, 'latest_version'),
        latest_version_id=pulumi.get(__response__, 'latest_version_id'),
        name=pulumi.get(__response__, 'name'),
        nx_cluster_id=pulumi.get(__response__, 'nx_cluster_id'),
        owner=pulumi.get(__response__, 'owner'),
        profile_id=pulumi.get(__response__, 'profile_id'),
        profile_name=pulumi.get(__response__, 'profile_name'),
        profile_type=pulumi.get(__response__, 'profile_type'),
        status=pulumi.get(__response__, 'status'),
        system_profile=pulumi.get(__response__, 'system_profile'),
        topology=pulumi.get(__response__, 'topology'),
        type=pulumi.get(__response__, 'type'),
        versions=pulumi.get(__response__, 'versions')))
