# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNdbProfilesResult',
    'AwaitableGetNdbProfilesResult',
    'get_ndb_profiles',
    'get_ndb_profiles_output',
]

@pulumi.output_type
class GetNdbProfilesResult:
    """
    A collection of values returned by getNdbProfiles.
    """
    def __init__(__self__, engine=None, id=None, profile_type=None, profiles=None):
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if profile_type and not isinstance(profile_type, str):
            raise TypeError("Expected argument 'profile_type' to be a str")
        pulumi.set(__self__, "profile_type", profile_type)
        if profiles and not isinstance(profiles, list):
            raise TypeError("Expected argument 'profiles' to be a list")
        pulumi.set(__self__, "profiles", profiles)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="profileType")
    def profile_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "profile_type")

    @_builtins.property
    @pulumi.getter
    def profiles(self) -> Sequence['outputs.GetNdbProfilesProfileResult']:
        """
        List of profiles
        """
        return pulumi.get(self, "profiles")


class AwaitableGetNdbProfilesResult(GetNdbProfilesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbProfilesResult(
            engine=self.engine,
            id=self.id,
            profile_type=self.profile_type,
            profiles=self.profiles)


def get_ndb_profiles(engine: Optional[_builtins.str] = None,
                     profile_type: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbProfilesResult:
    """
    List profiles in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    profiles = nutanix.get_ndb_profiles()
    pulumi.export("profilesList", profiles)
    ```

    ## profiles

    The following attributes are exported for each profile:

    * `id`: - id of profile
    * `name`: - profile name
    * `description`: - description of profile
    * `status`: - status of profile
    * `owner`: - owner name
    * `engine_type`: - database engine type
    * `db_version`: - database version
    * `topology`: - topology
    * `system_profile`: - if system profile or not
    * `assoc_db_servers`: - associated DB servers
    * `assoc_databases`: - associated databases
    * `latest_version`: - latest version for engine software
    * `latest_version_id`: - ID of latest version for engine software
    * `versions`: - profile's different version config
    * `cluster_availability`: - list of clusters availability
    * `nx_cluster_id`: - era cluster ID

    See detailed information in [Nutanix Database Service Profiles](https://www.nutanix.dev/api_references/ndb/#/74ae456d63b24-get-all-profiles).


    :param _builtins.str engine: Database engine. For eg. postgres_database
    :param _builtins.str profile_type: profile type. Types: Software, Compute, Network and Database_Parameter
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['profileType'] = profile_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbProfiles:getNdbProfiles', __args__, opts=opts, typ=GetNdbProfilesResult).value

    return AwaitableGetNdbProfilesResult(
        engine=pulumi.get(__ret__, 'engine'),
        id=pulumi.get(__ret__, 'id'),
        profile_type=pulumi.get(__ret__, 'profile_type'),
        profiles=pulumi.get(__ret__, 'profiles'))
def get_ndb_profiles_output(engine: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            profile_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbProfilesResult]:
    """
    List profiles in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    profiles = nutanix.get_ndb_profiles()
    pulumi.export("profilesList", profiles)
    ```

    ## profiles

    The following attributes are exported for each profile:

    * `id`: - id of profile
    * `name`: - profile name
    * `description`: - description of profile
    * `status`: - status of profile
    * `owner`: - owner name
    * `engine_type`: - database engine type
    * `db_version`: - database version
    * `topology`: - topology
    * `system_profile`: - if system profile or not
    * `assoc_db_servers`: - associated DB servers
    * `assoc_databases`: - associated databases
    * `latest_version`: - latest version for engine software
    * `latest_version_id`: - ID of latest version for engine software
    * `versions`: - profile's different version config
    * `cluster_availability`: - list of clusters availability
    * `nx_cluster_id`: - era cluster ID

    See detailed information in [Nutanix Database Service Profiles](https://www.nutanix.dev/api_references/ndb/#/74ae456d63b24-get-all-profiles).


    :param _builtins.str engine: Database engine. For eg. postgres_database
    :param _builtins.str profile_type: profile type. Types: Software, Compute, Network and Database_Parameter
    """
    __args__ = dict()
    __args__['engine'] = engine
    __args__['profileType'] = profile_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbProfiles:getNdbProfiles', __args__, opts=opts, typ=GetNdbProfilesResult)
    return __ret__.apply(lambda __response__: GetNdbProfilesResult(
        engine=pulumi.get(__response__, 'engine'),
        id=pulumi.get(__response__, 'id'),
        profile_type=pulumi.get(__response__, 'profile_type'),
        profiles=pulumi.get(__response__, 'profiles')))
