# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNdbSlaResult',
    'AwaitableGetNdbSlaResult',
    'get_ndb_sla',
    'get_ndb_sla_output',
]

@pulumi.output_type
class GetNdbSlaResult:
    """
    A collection of values returned by getNdbSla.
    """
    def __init__(__self__, continuous_retention=None, current_active_frequency=None, daily_retention=None, date_created=None, date_modified=None, description=None, id=None, monthly_retention=None, name=None, owner_id=None, pitr_enabled=None, quartely_retention=None, reference_count=None, sla_id=None, sla_name=None, system_sla=None, unique_name=None, weekly_retention=None, yearly_retention=None):
        if continuous_retention and not isinstance(continuous_retention, int):
            raise TypeError("Expected argument 'continuous_retention' to be a int")
        pulumi.set(__self__, "continuous_retention", continuous_retention)
        if current_active_frequency and not isinstance(current_active_frequency, str):
            raise TypeError("Expected argument 'current_active_frequency' to be a str")
        pulumi.set(__self__, "current_active_frequency", current_active_frequency)
        if daily_retention and not isinstance(daily_retention, int):
            raise TypeError("Expected argument 'daily_retention' to be a int")
        pulumi.set(__self__, "daily_retention", daily_retention)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_modified and not isinstance(date_modified, str):
            raise TypeError("Expected argument 'date_modified' to be a str")
        pulumi.set(__self__, "date_modified", date_modified)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monthly_retention and not isinstance(monthly_retention, int):
            raise TypeError("Expected argument 'monthly_retention' to be a int")
        pulumi.set(__self__, "monthly_retention", monthly_retention)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if pitr_enabled and not isinstance(pitr_enabled, bool):
            raise TypeError("Expected argument 'pitr_enabled' to be a bool")
        pulumi.set(__self__, "pitr_enabled", pitr_enabled)
        if quartely_retention and not isinstance(quartely_retention, int):
            raise TypeError("Expected argument 'quartely_retention' to be a int")
        pulumi.set(__self__, "quartely_retention", quartely_retention)
        if reference_count and not isinstance(reference_count, int):
            raise TypeError("Expected argument 'reference_count' to be a int")
        pulumi.set(__self__, "reference_count", reference_count)
        if sla_id and not isinstance(sla_id, str):
            raise TypeError("Expected argument 'sla_id' to be a str")
        pulumi.set(__self__, "sla_id", sla_id)
        if sla_name and not isinstance(sla_name, str):
            raise TypeError("Expected argument 'sla_name' to be a str")
        pulumi.set(__self__, "sla_name", sla_name)
        if system_sla and not isinstance(system_sla, bool):
            raise TypeError("Expected argument 'system_sla' to be a bool")
        pulumi.set(__self__, "system_sla", system_sla)
        if unique_name and not isinstance(unique_name, str):
            raise TypeError("Expected argument 'unique_name' to be a str")
        pulumi.set(__self__, "unique_name", unique_name)
        if weekly_retention and not isinstance(weekly_retention, int):
            raise TypeError("Expected argument 'weekly_retention' to be a int")
        pulumi.set(__self__, "weekly_retention", weekly_retention)
        if yearly_retention and not isinstance(yearly_retention, int):
            raise TypeError("Expected argument 'yearly_retention' to be a int")
        pulumi.set(__self__, "yearly_retention", yearly_retention)

    @_builtins.property
    @pulumi.getter(name="continuousRetention")
    def continuous_retention(self) -> _builtins.int:
        """
        - continuous retention of logs limit
        """
        return pulumi.get(self, "continuous_retention")

    @_builtins.property
    @pulumi.getter(name="currentActiveFrequency")
    def current_active_frequency(self) -> _builtins.str:
        """
        - Current active frequency
        """
        return pulumi.get(self, "current_active_frequency")

    @_builtins.property
    @pulumi.getter(name="dailyRetention")
    def daily_retention(self) -> _builtins.int:
        """
        - Daily snapshots retention limit
        """
        return pulumi.get(self, "daily_retention")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        - creation date
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> _builtins.str:
        """
        - last modified
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - description of sla
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        - id of sla
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="monthlyRetention")
    def monthly_retention(self) -> _builtins.int:
        """
        - Monthly snapshots retention limit
        """
        return pulumi.get(self, "monthly_retention")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - sla name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        - owner ID
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter(name="pitrEnabled")
    def pitr_enabled(self) -> _builtins.bool:
        """
        - If point in time recovery enabled
        """
        return pulumi.get(self, "pitr_enabled")

    @_builtins.property
    @pulumi.getter(name="quartelyRetention")
    def quartely_retention(self) -> _builtins.int:
        """
        - Daily snapshots retention limit
        """
        return pulumi.get(self, "quartely_retention")

    @_builtins.property
    @pulumi.getter(name="referenceCount")
    def reference_count(self) -> _builtins.int:
        """
        - Reference count
        """
        return pulumi.get(self, "reference_count")

    @_builtins.property
    @pulumi.getter(name="slaId")
    def sla_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sla_id")

    @_builtins.property
    @pulumi.getter(name="slaName")
    def sla_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sla_name")

    @_builtins.property
    @pulumi.getter(name="systemSla")
    def system_sla(self) -> _builtins.bool:
        """
        - if system sla
        """
        return pulumi.get(self, "system_sla")

    @_builtins.property
    @pulumi.getter(name="uniqueName")
    def unique_name(self) -> _builtins.str:
        """
        - unique name
        """
        return pulumi.get(self, "unique_name")

    @_builtins.property
    @pulumi.getter(name="weeklyRetention")
    def weekly_retention(self) -> _builtins.int:
        """
        - weeky snapshots retention limit
        """
        return pulumi.get(self, "weekly_retention")

    @_builtins.property
    @pulumi.getter(name="yearlyRetention")
    def yearly_retention(self) -> _builtins.int:
        """
        - Yearly snapshots retention limit
        """
        return pulumi.get(self, "yearly_retention")


class AwaitableGetNdbSlaResult(GetNdbSlaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbSlaResult(
            continuous_retention=self.continuous_retention,
            current_active_frequency=self.current_active_frequency,
            daily_retention=self.daily_retention,
            date_created=self.date_created,
            date_modified=self.date_modified,
            description=self.description,
            id=self.id,
            monthly_retention=self.monthly_retention,
            name=self.name,
            owner_id=self.owner_id,
            pitr_enabled=self.pitr_enabled,
            quartely_retention=self.quartely_retention,
            reference_count=self.reference_count,
            sla_id=self.sla_id,
            sla_name=self.sla_name,
            system_sla=self.system_sla,
            unique_name=self.unique_name,
            weekly_retention=self.weekly_retention,
            yearly_retention=self.yearly_retention)


def get_ndb_sla(sla_id: Optional[_builtins.str] = None,
                sla_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbSlaResult:
    """
    Describes a SLA in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    sla1 = nutanix.get_ndb_sla(sla_name="test-sla")
    pulumi.export("sla", sla1)
    ```


    :param _builtins.str sla_id: and `sla_name` are mutually exclusive.
    :param _builtins.str sla_name: SLA Name for query
    """
    __args__ = dict()
    __args__['slaId'] = sla_id
    __args__['slaName'] = sla_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbSla:getNdbSla', __args__, opts=opts, typ=GetNdbSlaResult).value

    return AwaitableGetNdbSlaResult(
        continuous_retention=pulumi.get(__ret__, 'continuous_retention'),
        current_active_frequency=pulumi.get(__ret__, 'current_active_frequency'),
        daily_retention=pulumi.get(__ret__, 'daily_retention'),
        date_created=pulumi.get(__ret__, 'date_created'),
        date_modified=pulumi.get(__ret__, 'date_modified'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        monthly_retention=pulumi.get(__ret__, 'monthly_retention'),
        name=pulumi.get(__ret__, 'name'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        pitr_enabled=pulumi.get(__ret__, 'pitr_enabled'),
        quartely_retention=pulumi.get(__ret__, 'quartely_retention'),
        reference_count=pulumi.get(__ret__, 'reference_count'),
        sla_id=pulumi.get(__ret__, 'sla_id'),
        sla_name=pulumi.get(__ret__, 'sla_name'),
        system_sla=pulumi.get(__ret__, 'system_sla'),
        unique_name=pulumi.get(__ret__, 'unique_name'),
        weekly_retention=pulumi.get(__ret__, 'weekly_retention'),
        yearly_retention=pulumi.get(__ret__, 'yearly_retention'))
def get_ndb_sla_output(sla_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       sla_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbSlaResult]:
    """
    Describes a SLA in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    sla1 = nutanix.get_ndb_sla(sla_name="test-sla")
    pulumi.export("sla", sla1)
    ```


    :param _builtins.str sla_id: and `sla_name` are mutually exclusive.
    :param _builtins.str sla_name: SLA Name for query
    """
    __args__ = dict()
    __args__['slaId'] = sla_id
    __args__['slaName'] = sla_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbSla:getNdbSla', __args__, opts=opts, typ=GetNdbSlaResult)
    return __ret__.apply(lambda __response__: GetNdbSlaResult(
        continuous_retention=pulumi.get(__response__, 'continuous_retention'),
        current_active_frequency=pulumi.get(__response__, 'current_active_frequency'),
        daily_retention=pulumi.get(__response__, 'daily_retention'),
        date_created=pulumi.get(__response__, 'date_created'),
        date_modified=pulumi.get(__response__, 'date_modified'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        monthly_retention=pulumi.get(__response__, 'monthly_retention'),
        name=pulumi.get(__response__, 'name'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        pitr_enabled=pulumi.get(__response__, 'pitr_enabled'),
        quartely_retention=pulumi.get(__response__, 'quartely_retention'),
        reference_count=pulumi.get(__response__, 'reference_count'),
        sla_id=pulumi.get(__response__, 'sla_id'),
        sla_name=pulumi.get(__response__, 'sla_name'),
        system_sla=pulumi.get(__response__, 'system_sla'),
        unique_name=pulumi.get(__response__, 'unique_name'),
        weekly_retention=pulumi.get(__response__, 'weekly_retention'),
        yearly_retention=pulumi.get(__response__, 'yearly_retention')))
