# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNdbSnapshotResult',
    'AwaitableGetNdbSnapshotResult',
    'get_ndb_snapshot',
    'get_ndb_snapshot_output',
]

@pulumi.output_type
class GetNdbSnapshotResult:
    """
    A collection of values returned by getNdbSnapshot.
    """
    def __init__(__self__, app_info_version=None, applicable_types=None, database_node_id=None, database_snapshot=None, date_created=None, date_modified=None, dbserver_id=None, dbserver_ip=None, dbserver_name=None, dbserver_storage_metadata_version=None, description=None, filters=None, from_timestamp=None, id=None, lcm_configs=None, name=None, nx_cluster_id=None, parent_snapshot=None, parent_snapshot_id=None, processed=None, properties=None, protection_domain_id=None, replicated_snapshots=None, santized=None, santized_from_snapshot_id=None, santized_snapshots=None, snapshot_family=None, snapshot_id=None, snapshot_size=None, snapshot_timestamp=None, snapshot_timestamp_date=None, snapshot_uuid=None, software_database_snapshot=None, software_snapshot=None, software_snapshot_id=None, status=None, tags=None, time_machine_id=None, timezone=None, to_timestamp=None, type=None):
        if app_info_version and not isinstance(app_info_version, str):
            raise TypeError("Expected argument 'app_info_version' to be a str")
        pulumi.set(__self__, "app_info_version", app_info_version)
        if applicable_types and not isinstance(applicable_types, list):
            raise TypeError("Expected argument 'applicable_types' to be a list")
        pulumi.set(__self__, "applicable_types", applicable_types)
        if database_node_id and not isinstance(database_node_id, str):
            raise TypeError("Expected argument 'database_node_id' to be a str")
        pulumi.set(__self__, "database_node_id", database_node_id)
        if database_snapshot and not isinstance(database_snapshot, bool):
            raise TypeError("Expected argument 'database_snapshot' to be a bool")
        pulumi.set(__self__, "database_snapshot", database_snapshot)
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_modified and not isinstance(date_modified, str):
            raise TypeError("Expected argument 'date_modified' to be a str")
        pulumi.set(__self__, "date_modified", date_modified)
        if dbserver_id and not isinstance(dbserver_id, str):
            raise TypeError("Expected argument 'dbserver_id' to be a str")
        pulumi.set(__self__, "dbserver_id", dbserver_id)
        if dbserver_ip and not isinstance(dbserver_ip, str):
            raise TypeError("Expected argument 'dbserver_ip' to be a str")
        pulumi.set(__self__, "dbserver_ip", dbserver_ip)
        if dbserver_name and not isinstance(dbserver_name, str):
            raise TypeError("Expected argument 'dbserver_name' to be a str")
        pulumi.set(__self__, "dbserver_name", dbserver_name)
        if dbserver_storage_metadata_version and not isinstance(dbserver_storage_metadata_version, int):
            raise TypeError("Expected argument 'dbserver_storage_metadata_version' to be a int")
        pulumi.set(__self__, "dbserver_storage_metadata_version", dbserver_storage_metadata_version)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if from_timestamp and not isinstance(from_timestamp, str):
            raise TypeError("Expected argument 'from_timestamp' to be a str")
        pulumi.set(__self__, "from_timestamp", from_timestamp)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lcm_configs and not isinstance(lcm_configs, list):
            raise TypeError("Expected argument 'lcm_configs' to be a list")
        pulumi.set(__self__, "lcm_configs", lcm_configs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nx_cluster_id and not isinstance(nx_cluster_id, str):
            raise TypeError("Expected argument 'nx_cluster_id' to be a str")
        pulumi.set(__self__, "nx_cluster_id", nx_cluster_id)
        if parent_snapshot and not isinstance(parent_snapshot, bool):
            raise TypeError("Expected argument 'parent_snapshot' to be a bool")
        pulumi.set(__self__, "parent_snapshot", parent_snapshot)
        if parent_snapshot_id and not isinstance(parent_snapshot_id, str):
            raise TypeError("Expected argument 'parent_snapshot_id' to be a str")
        pulumi.set(__self__, "parent_snapshot_id", parent_snapshot_id)
        if processed and not isinstance(processed, bool):
            raise TypeError("Expected argument 'processed' to be a bool")
        pulumi.set(__self__, "processed", processed)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if protection_domain_id and not isinstance(protection_domain_id, str):
            raise TypeError("Expected argument 'protection_domain_id' to be a str")
        pulumi.set(__self__, "protection_domain_id", protection_domain_id)
        if replicated_snapshots and not isinstance(replicated_snapshots, list):
            raise TypeError("Expected argument 'replicated_snapshots' to be a list")
        pulumi.set(__self__, "replicated_snapshots", replicated_snapshots)
        if santized and not isinstance(santized, bool):
            raise TypeError("Expected argument 'santized' to be a bool")
        pulumi.set(__self__, "santized", santized)
        if santized_from_snapshot_id and not isinstance(santized_from_snapshot_id, str):
            raise TypeError("Expected argument 'santized_from_snapshot_id' to be a str")
        pulumi.set(__self__, "santized_from_snapshot_id", santized_from_snapshot_id)
        if santized_snapshots and not isinstance(santized_snapshots, str):
            raise TypeError("Expected argument 'santized_snapshots' to be a str")
        pulumi.set(__self__, "santized_snapshots", santized_snapshots)
        if snapshot_family and not isinstance(snapshot_family, str):
            raise TypeError("Expected argument 'snapshot_family' to be a str")
        pulumi.set(__self__, "snapshot_family", snapshot_family)
        if snapshot_id and not isinstance(snapshot_id, str):
            raise TypeError("Expected argument 'snapshot_id' to be a str")
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if snapshot_size and not isinstance(snapshot_size, float):
            raise TypeError("Expected argument 'snapshot_size' to be a float")
        pulumi.set(__self__, "snapshot_size", snapshot_size)
        if snapshot_timestamp and not isinstance(snapshot_timestamp, str):
            raise TypeError("Expected argument 'snapshot_timestamp' to be a str")
        pulumi.set(__self__, "snapshot_timestamp", snapshot_timestamp)
        if snapshot_timestamp_date and not isinstance(snapshot_timestamp_date, int):
            raise TypeError("Expected argument 'snapshot_timestamp_date' to be a int")
        pulumi.set(__self__, "snapshot_timestamp_date", snapshot_timestamp_date)
        if snapshot_uuid and not isinstance(snapshot_uuid, str):
            raise TypeError("Expected argument 'snapshot_uuid' to be a str")
        pulumi.set(__self__, "snapshot_uuid", snapshot_uuid)
        if software_database_snapshot and not isinstance(software_database_snapshot, bool):
            raise TypeError("Expected argument 'software_database_snapshot' to be a bool")
        pulumi.set(__self__, "software_database_snapshot", software_database_snapshot)
        if software_snapshot and not isinstance(software_snapshot, str):
            raise TypeError("Expected argument 'software_snapshot' to be a str")
        pulumi.set(__self__, "software_snapshot", software_snapshot)
        if software_snapshot_id and not isinstance(software_snapshot_id, str):
            raise TypeError("Expected argument 'software_snapshot_id' to be a str")
        pulumi.set(__self__, "software_snapshot_id", software_snapshot_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if time_machine_id and not isinstance(time_machine_id, str):
            raise TypeError("Expected argument 'time_machine_id' to be a str")
        pulumi.set(__self__, "time_machine_id", time_machine_id)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)
        if to_timestamp and not isinstance(to_timestamp, str):
            raise TypeError("Expected argument 'to_timestamp' to be a str")
        pulumi.set(__self__, "to_timestamp", to_timestamp)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="appInfoVersion")
    def app_info_version(self) -> _builtins.str:
        """
        App info version
        """
        return pulumi.get(self, "app_info_version")

    @_builtins.property
    @pulumi.getter(name="applicableTypes")
    def applicable_types(self) -> Sequence[_builtins.str]:
        """
        Applicable types
        """
        return pulumi.get(self, "applicable_types")

    @_builtins.property
    @pulumi.getter(name="databaseNodeId")
    def database_node_id(self) -> _builtins.str:
        """
        database node id
        """
        return pulumi.get(self, "database_node_id")

    @_builtins.property
    @pulumi.getter(name="databaseSnapshot")
    def database_snapshot(self) -> _builtins.bool:
        """
        database snapshot
        """
        return pulumi.get(self, "database_snapshot")

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        created date
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> _builtins.str:
        """
        modified date
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter(name="dbserverId")
    def dbserver_id(self) -> _builtins.str:
        """
        dbserver id
        """
        return pulumi.get(self, "dbserver_id")

    @_builtins.property
    @pulumi.getter(name="dbserverIp")
    def dbserver_ip(self) -> _builtins.str:
        """
        dbserver ip
        """
        return pulumi.get(self, "dbserver_ip")

    @_builtins.property
    @pulumi.getter(name="dbserverName")
    def dbserver_name(self) -> _builtins.str:
        """
        dbserver name
        """
        return pulumi.get(self, "dbserver_name")

    @_builtins.property
    @pulumi.getter(name="dbserverStorageMetadataVersion")
    def dbserver_storage_metadata_version(self) -> _builtins.int:
        """
        dbserver storage metadata version
        """
        return pulumi.get(self, "dbserver_storage_metadata_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        description of snapshot
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetNdbSnapshotFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fromTimestamp")
    def from_timestamp(self) -> _builtins.str:
        """
        from timestamp
        """
        return pulumi.get(self, "from_timestamp")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        name of snapshot
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lcmConfigs")
    def lcm_configs(self) -> Sequence['outputs.GetNdbSnapshotLcmConfigResult']:
        """
        LCM config
        """
        return pulumi.get(self, "lcm_configs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nxClusterId")
    def nx_cluster_id(self) -> _builtins.str:
        """
        nx cluster id
        """
        return pulumi.get(self, "nx_cluster_id")

    @_builtins.property
    @pulumi.getter(name="parentSnapshot")
    def parent_snapshot(self) -> _builtins.bool:
        """
        parent snapshot
        """
        return pulumi.get(self, "parent_snapshot")

    @_builtins.property
    @pulumi.getter(name="parentSnapshotId")
    def parent_snapshot_id(self) -> _builtins.str:
        """
        parent snapshot id
        """
        return pulumi.get(self, "parent_snapshot_id")

    @_builtins.property
    @pulumi.getter
    def processed(self) -> _builtins.bool:
        """
        processed
        """
        return pulumi.get(self, "processed")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetNdbSnapshotPropertyResult']:
        """
        properties
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="protectionDomainId")
    def protection_domain_id(self) -> _builtins.str:
        """
        protection domain
        """
        return pulumi.get(self, "protection_domain_id")

    @_builtins.property
    @pulumi.getter(name="replicatedSnapshots")
    def replicated_snapshots(self) -> Sequence[_builtins.str]:
        """
        replicated snapshots
        """
        return pulumi.get(self, "replicated_snapshots")

    @_builtins.property
    @pulumi.getter
    def santized(self) -> _builtins.bool:
        return pulumi.get(self, "santized")

    @_builtins.property
    @pulumi.getter(name="santizedFromSnapshotId")
    def santized_from_snapshot_id(self) -> _builtins.str:
        return pulumi.get(self, "santized_from_snapshot_id")

    @_builtins.property
    @pulumi.getter(name="santizedSnapshots")
    def santized_snapshots(self) -> _builtins.str:
        return pulumi.get(self, "santized_snapshots")

    @_builtins.property
    @pulumi.getter(name="snapshotFamily")
    def snapshot_family(self) -> _builtins.str:
        """
        snapshot family
        """
        return pulumi.get(self, "snapshot_family")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> _builtins.str:
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter(name="snapshotSize")
    def snapshot_size(self) -> _builtins.float:
        """
        snapshot size
        """
        return pulumi.get(self, "snapshot_size")

    @_builtins.property
    @pulumi.getter(name="snapshotTimestamp")
    def snapshot_timestamp(self) -> _builtins.str:
        """
        snapshot timeStamp
        """
        return pulumi.get(self, "snapshot_timestamp")

    @_builtins.property
    @pulumi.getter(name="snapshotTimestampDate")
    def snapshot_timestamp_date(self) -> _builtins.int:
        """
        snapshot timestamp date
        """
        return pulumi.get(self, "snapshot_timestamp_date")

    @_builtins.property
    @pulumi.getter(name="snapshotUuid")
    def snapshot_uuid(self) -> _builtins.str:
        """
        snapshot uuid
        """
        return pulumi.get(self, "snapshot_uuid")

    @_builtins.property
    @pulumi.getter(name="softwareDatabaseSnapshot")
    def software_database_snapshot(self) -> _builtins.bool:
        """
        software database snapshot
        """
        return pulumi.get(self, "software_database_snapshot")

    @_builtins.property
    @pulumi.getter(name="softwareSnapshot")
    def software_snapshot(self) -> _builtins.str:
        """
        software snapshot
        """
        return pulumi.get(self, "software_snapshot")

    @_builtins.property
    @pulumi.getter(name="softwareSnapshotId")
    def software_snapshot_id(self) -> _builtins.str:
        """
        software snapshot id
        """
        return pulumi.get(self, "software_snapshot_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetNdbSnapshotTagResult']:
        """
        tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeMachineId")
    def time_machine_id(self) -> _builtins.str:
        return pulumi.get(self, "time_machine_id")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        timezone
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="toTimestamp")
    def to_timestamp(self) -> _builtins.str:
        """
        to timestamp
        """
        return pulumi.get(self, "to_timestamp")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type
        """
        return pulumi.get(self, "type")


class AwaitableGetNdbSnapshotResult(GetNdbSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbSnapshotResult(
            app_info_version=self.app_info_version,
            applicable_types=self.applicable_types,
            database_node_id=self.database_node_id,
            database_snapshot=self.database_snapshot,
            date_created=self.date_created,
            date_modified=self.date_modified,
            dbserver_id=self.dbserver_id,
            dbserver_ip=self.dbserver_ip,
            dbserver_name=self.dbserver_name,
            dbserver_storage_metadata_version=self.dbserver_storage_metadata_version,
            description=self.description,
            filters=self.filters,
            from_timestamp=self.from_timestamp,
            id=self.id,
            lcm_configs=self.lcm_configs,
            name=self.name,
            nx_cluster_id=self.nx_cluster_id,
            parent_snapshot=self.parent_snapshot,
            parent_snapshot_id=self.parent_snapshot_id,
            processed=self.processed,
            properties=self.properties,
            protection_domain_id=self.protection_domain_id,
            replicated_snapshots=self.replicated_snapshots,
            santized=self.santized,
            santized_from_snapshot_id=self.santized_from_snapshot_id,
            santized_snapshots=self.santized_snapshots,
            snapshot_family=self.snapshot_family,
            snapshot_id=self.snapshot_id,
            snapshot_size=self.snapshot_size,
            snapshot_timestamp=self.snapshot_timestamp,
            snapshot_timestamp_date=self.snapshot_timestamp_date,
            snapshot_uuid=self.snapshot_uuid,
            software_database_snapshot=self.software_database_snapshot,
            software_snapshot=self.software_snapshot,
            software_snapshot_id=self.software_snapshot_id,
            status=self.status,
            tags=self.tags,
            time_machine_id=self.time_machine_id,
            timezone=self.timezone,
            to_timestamp=self.to_timestamp,
            type=self.type)


def get_ndb_snapshot(filters: Optional[Sequence[Union['GetNdbSnapshotFilterArgs', 'GetNdbSnapshotFilterArgsDict']]] = None,
                     snapshot_id: Optional[_builtins.str] = None,
                     tags: Optional[Sequence[Union['GetNdbSnapshotTagArgs', 'GetNdbSnapshotTagArgsDict']]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbSnapshotResult:
    """
    Describes the snapshot present in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    snaps = nutanix.get_ndb_snapshot(snapshot_id="{{ snapshot_id }}",
        filters=[{
            "load_replicated_child_snapshots": "true",
        }])
    ```


    :param Sequence[Union['GetNdbSnapshotFilterArgs', 'GetNdbSnapshotFilterArgsDict']] filters: Filters will fetch the snapshot details as per input
    :param _builtins.str snapshot_id: Snapshot ID to be given
    :param Sequence[Union['GetNdbSnapshotTagArgs', 'GetNdbSnapshotTagArgsDict']] tags: tags
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['snapshotId'] = snapshot_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbSnapshot:getNdbSnapshot', __args__, opts=opts, typ=GetNdbSnapshotResult).value

    return AwaitableGetNdbSnapshotResult(
        app_info_version=pulumi.get(__ret__, 'app_info_version'),
        applicable_types=pulumi.get(__ret__, 'applicable_types'),
        database_node_id=pulumi.get(__ret__, 'database_node_id'),
        database_snapshot=pulumi.get(__ret__, 'database_snapshot'),
        date_created=pulumi.get(__ret__, 'date_created'),
        date_modified=pulumi.get(__ret__, 'date_modified'),
        dbserver_id=pulumi.get(__ret__, 'dbserver_id'),
        dbserver_ip=pulumi.get(__ret__, 'dbserver_ip'),
        dbserver_name=pulumi.get(__ret__, 'dbserver_name'),
        dbserver_storage_metadata_version=pulumi.get(__ret__, 'dbserver_storage_metadata_version'),
        description=pulumi.get(__ret__, 'description'),
        filters=pulumi.get(__ret__, 'filters'),
        from_timestamp=pulumi.get(__ret__, 'from_timestamp'),
        id=pulumi.get(__ret__, 'id'),
        lcm_configs=pulumi.get(__ret__, 'lcm_configs'),
        name=pulumi.get(__ret__, 'name'),
        nx_cluster_id=pulumi.get(__ret__, 'nx_cluster_id'),
        parent_snapshot=pulumi.get(__ret__, 'parent_snapshot'),
        parent_snapshot_id=pulumi.get(__ret__, 'parent_snapshot_id'),
        processed=pulumi.get(__ret__, 'processed'),
        properties=pulumi.get(__ret__, 'properties'),
        protection_domain_id=pulumi.get(__ret__, 'protection_domain_id'),
        replicated_snapshots=pulumi.get(__ret__, 'replicated_snapshots'),
        santized=pulumi.get(__ret__, 'santized'),
        santized_from_snapshot_id=pulumi.get(__ret__, 'santized_from_snapshot_id'),
        santized_snapshots=pulumi.get(__ret__, 'santized_snapshots'),
        snapshot_family=pulumi.get(__ret__, 'snapshot_family'),
        snapshot_id=pulumi.get(__ret__, 'snapshot_id'),
        snapshot_size=pulumi.get(__ret__, 'snapshot_size'),
        snapshot_timestamp=pulumi.get(__ret__, 'snapshot_timestamp'),
        snapshot_timestamp_date=pulumi.get(__ret__, 'snapshot_timestamp_date'),
        snapshot_uuid=pulumi.get(__ret__, 'snapshot_uuid'),
        software_database_snapshot=pulumi.get(__ret__, 'software_database_snapshot'),
        software_snapshot=pulumi.get(__ret__, 'software_snapshot'),
        software_snapshot_id=pulumi.get(__ret__, 'software_snapshot_id'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        time_machine_id=pulumi.get(__ret__, 'time_machine_id'),
        timezone=pulumi.get(__ret__, 'timezone'),
        to_timestamp=pulumi.get(__ret__, 'to_timestamp'),
        type=pulumi.get(__ret__, 'type'))
def get_ndb_snapshot_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetNdbSnapshotFilterArgs', 'GetNdbSnapshotFilterArgsDict']]]]] = None,
                            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                            tags: Optional[pulumi.Input[Optional[Sequence[Union['GetNdbSnapshotTagArgs', 'GetNdbSnapshotTagArgsDict']]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbSnapshotResult]:
    """
    Describes the snapshot present in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    snaps = nutanix.get_ndb_snapshot(snapshot_id="{{ snapshot_id }}",
        filters=[{
            "load_replicated_child_snapshots": "true",
        }])
    ```


    :param Sequence[Union['GetNdbSnapshotFilterArgs', 'GetNdbSnapshotFilterArgsDict']] filters: Filters will fetch the snapshot details as per input
    :param _builtins.str snapshot_id: Snapshot ID to be given
    :param Sequence[Union['GetNdbSnapshotTagArgs', 'GetNdbSnapshotTagArgsDict']] tags: tags
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['snapshotId'] = snapshot_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbSnapshot:getNdbSnapshot', __args__, opts=opts, typ=GetNdbSnapshotResult)
    return __ret__.apply(lambda __response__: GetNdbSnapshotResult(
        app_info_version=pulumi.get(__response__, 'app_info_version'),
        applicable_types=pulumi.get(__response__, 'applicable_types'),
        database_node_id=pulumi.get(__response__, 'database_node_id'),
        database_snapshot=pulumi.get(__response__, 'database_snapshot'),
        date_created=pulumi.get(__response__, 'date_created'),
        date_modified=pulumi.get(__response__, 'date_modified'),
        dbserver_id=pulumi.get(__response__, 'dbserver_id'),
        dbserver_ip=pulumi.get(__response__, 'dbserver_ip'),
        dbserver_name=pulumi.get(__response__, 'dbserver_name'),
        dbserver_storage_metadata_version=pulumi.get(__response__, 'dbserver_storage_metadata_version'),
        description=pulumi.get(__response__, 'description'),
        filters=pulumi.get(__response__, 'filters'),
        from_timestamp=pulumi.get(__response__, 'from_timestamp'),
        id=pulumi.get(__response__, 'id'),
        lcm_configs=pulumi.get(__response__, 'lcm_configs'),
        name=pulumi.get(__response__, 'name'),
        nx_cluster_id=pulumi.get(__response__, 'nx_cluster_id'),
        parent_snapshot=pulumi.get(__response__, 'parent_snapshot'),
        parent_snapshot_id=pulumi.get(__response__, 'parent_snapshot_id'),
        processed=pulumi.get(__response__, 'processed'),
        properties=pulumi.get(__response__, 'properties'),
        protection_domain_id=pulumi.get(__response__, 'protection_domain_id'),
        replicated_snapshots=pulumi.get(__response__, 'replicated_snapshots'),
        santized=pulumi.get(__response__, 'santized'),
        santized_from_snapshot_id=pulumi.get(__response__, 'santized_from_snapshot_id'),
        santized_snapshots=pulumi.get(__response__, 'santized_snapshots'),
        snapshot_family=pulumi.get(__response__, 'snapshot_family'),
        snapshot_id=pulumi.get(__response__, 'snapshot_id'),
        snapshot_size=pulumi.get(__response__, 'snapshot_size'),
        snapshot_timestamp=pulumi.get(__response__, 'snapshot_timestamp'),
        snapshot_timestamp_date=pulumi.get(__response__, 'snapshot_timestamp_date'),
        snapshot_uuid=pulumi.get(__response__, 'snapshot_uuid'),
        software_database_snapshot=pulumi.get(__response__, 'software_database_snapshot'),
        software_snapshot=pulumi.get(__response__, 'software_snapshot'),
        software_snapshot_id=pulumi.get(__response__, 'software_snapshot_id'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        time_machine_id=pulumi.get(__response__, 'time_machine_id'),
        timezone=pulumi.get(__response__, 'timezone'),
        to_timestamp=pulumi.get(__response__, 'to_timestamp'),
        type=pulumi.get(__response__, 'type')))
