# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNdbTagResult',
    'AwaitableGetNdbTagResult',
    'get_ndb_tag',
    'get_ndb_tag_output',
]

@pulumi.output_type
class GetNdbTagResult:
    """
    A collection of values returned by getNdbTag.
    """
    def __init__(__self__, date_created=None, date_modified=None, description=None, entity_type=None, id=None, name=None, owner=None, required=None, status=None, values=None):
        if date_created and not isinstance(date_created, str):
            raise TypeError("Expected argument 'date_created' to be a str")
        pulumi.set(__self__, "date_created", date_created)
        if date_modified and not isinstance(date_modified, str):
            raise TypeError("Expected argument 'date_modified' to be a str")
        pulumi.set(__self__, "date_modified", date_modified)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner and not isinstance(owner, str):
            raise TypeError("Expected argument 'owner' to be a str")
        pulumi.set(__self__, "owner", owner)
        if required and not isinstance(required, bool):
            raise TypeError("Expected argument 'required' to be a bool")
        pulumi.set(__self__, "required", required)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if values and not isinstance(values, int):
            raise TypeError("Expected argument 'values' to be a int")
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="dateCreated")
    def date_created(self) -> _builtins.str:
        """
        date created of the tag
        """
        return pulumi.get(self, "date_created")

    @_builtins.property
    @pulumi.getter(name="dateModified")
    def date_modified(self) -> _builtins.str:
        """
        modified date of tha tag
        """
        return pulumi.get(self, "date_modified")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        description for the tag
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        entity for the tag to be associated with.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        name for the tag
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        """
        owner id of the tag
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def required(self) -> _builtins.bool:
        """
        tag value for entities.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the tag
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def values(self) -> _builtins.int:
        """
        value for the tag
        """
        return pulumi.get(self, "values")


class AwaitableGetNdbTagResult(GetNdbTagResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbTagResult(
            date_created=self.date_created,
            date_modified=self.date_modified,
            description=self.description,
            entity_type=self.entity_type,
            id=self.id,
            name=self.name,
            owner=self.owner,
            required=self.required,
            status=self.status,
            values=self.values)


def get_ndb_tag(id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbTagResult:
    """
    Describes a tag in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    tag = nutanix.get_ndb_tag(id="{{ tag id }}")
    ```


    :param _builtins.str id: tag id. Conflicts with  name.
    :param _builtins.str name: tag name. Conflicts with id.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbTag:getNdbTag', __args__, opts=opts, typ=GetNdbTagResult).value

    return AwaitableGetNdbTagResult(
        date_created=pulumi.get(__ret__, 'date_created'),
        date_modified=pulumi.get(__ret__, 'date_modified'),
        description=pulumi.get(__ret__, 'description'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        owner=pulumi.get(__ret__, 'owner'),
        required=pulumi.get(__ret__, 'required'),
        status=pulumi.get(__ret__, 'status'),
        values=pulumi.get(__ret__, 'values'))
def get_ndb_tag_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbTagResult]:
    """
    Describes a tag in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    tag = nutanix.get_ndb_tag(id="{{ tag id }}")
    ```


    :param _builtins.str id: tag id. Conflicts with  name.
    :param _builtins.str name: tag name. Conflicts with id.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbTag:getNdbTag', __args__, opts=opts, typ=GetNdbTagResult)
    return __ret__.apply(lambda __response__: GetNdbTagResult(
        date_created=pulumi.get(__response__, 'date_created'),
        date_modified=pulumi.get(__response__, 'date_modified'),
        description=pulumi.get(__response__, 'description'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        owner=pulumi.get(__response__, 'owner'),
        required=pulumi.get(__response__, 'required'),
        status=pulumi.get(__response__, 'status'),
        values=pulumi.get(__response__, 'values')))
