# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNdbTagsResult',
    'AwaitableGetNdbTagsResult',
    'get_ndb_tags',
    'get_ndb_tags_output',
]

@pulumi.output_type
class GetNdbTagsResult:
    """
    A collection of values returned by getNdbTags.
    """
    def __init__(__self__, entity_type=None, id=None, tags=None):
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[_builtins.str]:
        """
        entity for the tag to be associated with.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetNdbTagsTagResult']:
        """
        List of tags present in NDB.
        """
        return pulumi.get(self, "tags")


class AwaitableGetNdbTagsResult(GetNdbTagsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNdbTagsResult(
            entity_type=self.entity_type,
            id=self.id,
            tags=self.tags)


def get_ndb_tags(entity_type: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNdbTagsResult:
    """
    List of tags in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    tags = nutanix.get_ndb_tags()
    ```


    :param _builtins.str entity_type: entity for the tag to be associated with.
    """
    __args__ = dict()
    __args__['entityType'] = entity_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNdbTags:getNdbTags', __args__, opts=opts, typ=GetNdbTagsResult).value

    return AwaitableGetNdbTagsResult(
        entity_type=pulumi.get(__ret__, 'entity_type'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ndb_tags_output(entity_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNdbTagsResult]:
    """
    List of tags in Nutanix Database Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    tags = nutanix.get_ndb_tags()
    ```


    :param _builtins.str entity_type: entity for the tag to be associated with.
    """
    __args__ = dict()
    __args__['entityType'] = entity_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNdbTags:getNdbTags', __args__, opts=opts, typ=GetNdbTagsResult)
    return __ret__.apply(lambda __response__: GetNdbTagsResult(
        entity_type=pulumi.get(__response__, 'entity_type'),
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags')))
