# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetNetworkSecurityRuleResult',
    'AwaitableGetNetworkSecurityRuleResult',
    'get_network_security_rule',
    'get_network_security_rule_output',
]

@pulumi.output_type
class GetNetworkSecurityRuleResult:
    """
    A collection of values returned by getNetworkSecurityRule.
    """
    def __init__(__self__, ad_rule_action=None, ad_rule_inbound_allow_lists=None, ad_rule_outbound_allow_lists=None, ad_rule_target_group_default_internal_policy=None, ad_rule_target_group_filter_kind_lists=None, ad_rule_target_group_filter_params=None, ad_rule_target_group_filter_type=None, ad_rule_target_group_peer_specification_type=None, allow_ipv6_traffic=None, api_version=None, app_rule_action=None, app_rule_inbound_allow_lists=None, app_rule_outbound_allow_lists=None, app_rule_target_group_default_internal_policy=None, app_rule_target_group_filter_kind_lists=None, app_rule_target_group_filter_params=None, app_rule_target_group_filter_type=None, app_rule_target_group_peer_specification_type=None, categories=None, description=None, id=None, is_policy_hitlog_enabled=None, isolation_rule_action=None, isolation_rule_first_entity_filter_kind_lists=None, isolation_rule_first_entity_filter_params=None, isolation_rule_first_entity_filter_type=None, isolation_rule_second_entity_filter_kind_lists=None, isolation_rule_second_entity_filter_params=None, isolation_rule_second_entity_filter_type=None, metadata=None, name=None, network_security_rule_id=None, owner_reference=None, project_reference=None, quarantine_rule_action=None, quarantine_rule_inbound_allow_lists=None, quarantine_rule_outbound_allow_lists=None, quarantine_rule_target_group_default_internal_policy=None, quarantine_rule_target_group_filter_kind_lists=None, quarantine_rule_target_group_filter_params=None, quarantine_rule_target_group_filter_type=None, quarantine_rule_target_group_peer_specification_type=None):
        if ad_rule_action and not isinstance(ad_rule_action, str):
            raise TypeError("Expected argument 'ad_rule_action' to be a str")
        pulumi.set(__self__, "ad_rule_action", ad_rule_action)
        if ad_rule_inbound_allow_lists and not isinstance(ad_rule_inbound_allow_lists, list):
            raise TypeError("Expected argument 'ad_rule_inbound_allow_lists' to be a list")
        pulumi.set(__self__, "ad_rule_inbound_allow_lists", ad_rule_inbound_allow_lists)
        if ad_rule_outbound_allow_lists and not isinstance(ad_rule_outbound_allow_lists, list):
            raise TypeError("Expected argument 'ad_rule_outbound_allow_lists' to be a list")
        pulumi.set(__self__, "ad_rule_outbound_allow_lists", ad_rule_outbound_allow_lists)
        if ad_rule_target_group_default_internal_policy and not isinstance(ad_rule_target_group_default_internal_policy, str):
            raise TypeError("Expected argument 'ad_rule_target_group_default_internal_policy' to be a str")
        pulumi.set(__self__, "ad_rule_target_group_default_internal_policy", ad_rule_target_group_default_internal_policy)
        if ad_rule_target_group_filter_kind_lists and not isinstance(ad_rule_target_group_filter_kind_lists, list):
            raise TypeError("Expected argument 'ad_rule_target_group_filter_kind_lists' to be a list")
        pulumi.set(__self__, "ad_rule_target_group_filter_kind_lists", ad_rule_target_group_filter_kind_lists)
        if ad_rule_target_group_filter_params and not isinstance(ad_rule_target_group_filter_params, list):
            raise TypeError("Expected argument 'ad_rule_target_group_filter_params' to be a list")
        pulumi.set(__self__, "ad_rule_target_group_filter_params", ad_rule_target_group_filter_params)
        if ad_rule_target_group_filter_type and not isinstance(ad_rule_target_group_filter_type, str):
            raise TypeError("Expected argument 'ad_rule_target_group_filter_type' to be a str")
        pulumi.set(__self__, "ad_rule_target_group_filter_type", ad_rule_target_group_filter_type)
        if ad_rule_target_group_peer_specification_type and not isinstance(ad_rule_target_group_peer_specification_type, str):
            raise TypeError("Expected argument 'ad_rule_target_group_peer_specification_type' to be a str")
        pulumi.set(__self__, "ad_rule_target_group_peer_specification_type", ad_rule_target_group_peer_specification_type)
        if allow_ipv6_traffic and not isinstance(allow_ipv6_traffic, bool):
            raise TypeError("Expected argument 'allow_ipv6_traffic' to be a bool")
        pulumi.set(__self__, "allow_ipv6_traffic", allow_ipv6_traffic)
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if app_rule_action and not isinstance(app_rule_action, str):
            raise TypeError("Expected argument 'app_rule_action' to be a str")
        pulumi.set(__self__, "app_rule_action", app_rule_action)
        if app_rule_inbound_allow_lists and not isinstance(app_rule_inbound_allow_lists, list):
            raise TypeError("Expected argument 'app_rule_inbound_allow_lists' to be a list")
        pulumi.set(__self__, "app_rule_inbound_allow_lists", app_rule_inbound_allow_lists)
        if app_rule_outbound_allow_lists and not isinstance(app_rule_outbound_allow_lists, list):
            raise TypeError("Expected argument 'app_rule_outbound_allow_lists' to be a list")
        pulumi.set(__self__, "app_rule_outbound_allow_lists", app_rule_outbound_allow_lists)
        if app_rule_target_group_default_internal_policy and not isinstance(app_rule_target_group_default_internal_policy, str):
            raise TypeError("Expected argument 'app_rule_target_group_default_internal_policy' to be a str")
        pulumi.set(__self__, "app_rule_target_group_default_internal_policy", app_rule_target_group_default_internal_policy)
        if app_rule_target_group_filter_kind_lists and not isinstance(app_rule_target_group_filter_kind_lists, list):
            raise TypeError("Expected argument 'app_rule_target_group_filter_kind_lists' to be a list")
        pulumi.set(__self__, "app_rule_target_group_filter_kind_lists", app_rule_target_group_filter_kind_lists)
        if app_rule_target_group_filter_params and not isinstance(app_rule_target_group_filter_params, list):
            raise TypeError("Expected argument 'app_rule_target_group_filter_params' to be a list")
        pulumi.set(__self__, "app_rule_target_group_filter_params", app_rule_target_group_filter_params)
        if app_rule_target_group_filter_type and not isinstance(app_rule_target_group_filter_type, str):
            raise TypeError("Expected argument 'app_rule_target_group_filter_type' to be a str")
        pulumi.set(__self__, "app_rule_target_group_filter_type", app_rule_target_group_filter_type)
        if app_rule_target_group_peer_specification_type and not isinstance(app_rule_target_group_peer_specification_type, str):
            raise TypeError("Expected argument 'app_rule_target_group_peer_specification_type' to be a str")
        pulumi.set(__self__, "app_rule_target_group_peer_specification_type", app_rule_target_group_peer_specification_type)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_policy_hitlog_enabled and not isinstance(is_policy_hitlog_enabled, bool):
            raise TypeError("Expected argument 'is_policy_hitlog_enabled' to be a bool")
        pulumi.set(__self__, "is_policy_hitlog_enabled", is_policy_hitlog_enabled)
        if isolation_rule_action and not isinstance(isolation_rule_action, str):
            raise TypeError("Expected argument 'isolation_rule_action' to be a str")
        pulumi.set(__self__, "isolation_rule_action", isolation_rule_action)
        if isolation_rule_first_entity_filter_kind_lists and not isinstance(isolation_rule_first_entity_filter_kind_lists, list):
            raise TypeError("Expected argument 'isolation_rule_first_entity_filter_kind_lists' to be a list")
        pulumi.set(__self__, "isolation_rule_first_entity_filter_kind_lists", isolation_rule_first_entity_filter_kind_lists)
        if isolation_rule_first_entity_filter_params and not isinstance(isolation_rule_first_entity_filter_params, list):
            raise TypeError("Expected argument 'isolation_rule_first_entity_filter_params' to be a list")
        pulumi.set(__self__, "isolation_rule_first_entity_filter_params", isolation_rule_first_entity_filter_params)
        if isolation_rule_first_entity_filter_type and not isinstance(isolation_rule_first_entity_filter_type, str):
            raise TypeError("Expected argument 'isolation_rule_first_entity_filter_type' to be a str")
        pulumi.set(__self__, "isolation_rule_first_entity_filter_type", isolation_rule_first_entity_filter_type)
        if isolation_rule_second_entity_filter_kind_lists and not isinstance(isolation_rule_second_entity_filter_kind_lists, list):
            raise TypeError("Expected argument 'isolation_rule_second_entity_filter_kind_lists' to be a list")
        pulumi.set(__self__, "isolation_rule_second_entity_filter_kind_lists", isolation_rule_second_entity_filter_kind_lists)
        if isolation_rule_second_entity_filter_params and not isinstance(isolation_rule_second_entity_filter_params, list):
            raise TypeError("Expected argument 'isolation_rule_second_entity_filter_params' to be a list")
        pulumi.set(__self__, "isolation_rule_second_entity_filter_params", isolation_rule_second_entity_filter_params)
        if isolation_rule_second_entity_filter_type and not isinstance(isolation_rule_second_entity_filter_type, str):
            raise TypeError("Expected argument 'isolation_rule_second_entity_filter_type' to be a str")
        pulumi.set(__self__, "isolation_rule_second_entity_filter_type", isolation_rule_second_entity_filter_type)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_security_rule_id and not isinstance(network_security_rule_id, str):
            raise TypeError("Expected argument 'network_security_rule_id' to be a str")
        pulumi.set(__self__, "network_security_rule_id", network_security_rule_id)
        if owner_reference and not isinstance(owner_reference, dict):
            raise TypeError("Expected argument 'owner_reference' to be a dict")
        pulumi.set(__self__, "owner_reference", owner_reference)
        if project_reference and not isinstance(project_reference, dict):
            raise TypeError("Expected argument 'project_reference' to be a dict")
        pulumi.set(__self__, "project_reference", project_reference)
        if quarantine_rule_action and not isinstance(quarantine_rule_action, str):
            raise TypeError("Expected argument 'quarantine_rule_action' to be a str")
        pulumi.set(__self__, "quarantine_rule_action", quarantine_rule_action)
        if quarantine_rule_inbound_allow_lists and not isinstance(quarantine_rule_inbound_allow_lists, list):
            raise TypeError("Expected argument 'quarantine_rule_inbound_allow_lists' to be a list")
        pulumi.set(__self__, "quarantine_rule_inbound_allow_lists", quarantine_rule_inbound_allow_lists)
        if quarantine_rule_outbound_allow_lists and not isinstance(quarantine_rule_outbound_allow_lists, list):
            raise TypeError("Expected argument 'quarantine_rule_outbound_allow_lists' to be a list")
        pulumi.set(__self__, "quarantine_rule_outbound_allow_lists", quarantine_rule_outbound_allow_lists)
        if quarantine_rule_target_group_default_internal_policy and not isinstance(quarantine_rule_target_group_default_internal_policy, str):
            raise TypeError("Expected argument 'quarantine_rule_target_group_default_internal_policy' to be a str")
        pulumi.set(__self__, "quarantine_rule_target_group_default_internal_policy", quarantine_rule_target_group_default_internal_policy)
        if quarantine_rule_target_group_filter_kind_lists and not isinstance(quarantine_rule_target_group_filter_kind_lists, list):
            raise TypeError("Expected argument 'quarantine_rule_target_group_filter_kind_lists' to be a list")
        pulumi.set(__self__, "quarantine_rule_target_group_filter_kind_lists", quarantine_rule_target_group_filter_kind_lists)
        if quarantine_rule_target_group_filter_params and not isinstance(quarantine_rule_target_group_filter_params, list):
            raise TypeError("Expected argument 'quarantine_rule_target_group_filter_params' to be a list")
        pulumi.set(__self__, "quarantine_rule_target_group_filter_params", quarantine_rule_target_group_filter_params)
        if quarantine_rule_target_group_filter_type and not isinstance(quarantine_rule_target_group_filter_type, str):
            raise TypeError("Expected argument 'quarantine_rule_target_group_filter_type' to be a str")
        pulumi.set(__self__, "quarantine_rule_target_group_filter_type", quarantine_rule_target_group_filter_type)
        if quarantine_rule_target_group_peer_specification_type and not isinstance(quarantine_rule_target_group_peer_specification_type, str):
            raise TypeError("Expected argument 'quarantine_rule_target_group_peer_specification_type' to be a str")
        pulumi.set(__self__, "quarantine_rule_target_group_peer_specification_type", quarantine_rule_target_group_peer_specification_type)

    @_builtins.property
    @pulumi.getter(name="adRuleAction")
    def ad_rule_action(self) -> _builtins.str:
        """
        - These rules govern what flows are allowed. Target group is a required attribute. Empty inbound_allow_list will not anything into target group. Empty outbound_allow_list will allow everything from target group.
        """
        return pulumi.get(self, "ad_rule_action")

    @_builtins.property
    @pulumi.getter(name="adRuleInboundAllowLists")
    def ad_rule_inbound_allow_lists(self) -> Sequence['outputs.GetNetworkSecurityRuleAdRuleInboundAllowListResult']:
        """
        The set of categories that matching VMs need to have.
        """
        return pulumi.get(self, "ad_rule_inbound_allow_lists")

    @_builtins.property
    @pulumi.getter(name="adRuleOutboundAllowLists")
    def ad_rule_outbound_allow_lists(self) -> Sequence['outputs.GetNetworkSecurityRuleAdRuleOutboundAllowListResult']:
        return pulumi.get(self, "ad_rule_outbound_allow_lists")

    @_builtins.property
    @pulumi.getter(name="adRuleTargetGroupDefaultInternalPolicy")
    def ad_rule_target_group_default_internal_policy(self) -> _builtins.str:
        """
        - Default policy for communication within target group.
        """
        return pulumi.get(self, "ad_rule_target_group_default_internal_policy")

    @_builtins.property
    @pulumi.getter(name="adRuleTargetGroupFilterKindLists")
    def ad_rule_target_group_filter_kind_lists(self) -> Sequence[_builtins.str]:
        """
        - List of kinds associated with this filter.
        """
        return pulumi.get(self, "ad_rule_target_group_filter_kind_lists")

    @_builtins.property
    @pulumi.getter(name="adRuleTargetGroupFilterParams")
    def ad_rule_target_group_filter_params(self) -> Sequence['outputs.GetNetworkSecurityRuleAdRuleTargetGroupFilterParamResult']:
        """
        - A list of category key and list of values.
        """
        return pulumi.get(self, "ad_rule_target_group_filter_params")

    @_builtins.property
    @pulumi.getter(name="adRuleTargetGroupFilterType")
    def ad_rule_target_group_filter_type(self) -> _builtins.str:
        """
        - The type of the filter being used.
        """
        return pulumi.get(self, "ad_rule_target_group_filter_type")

    @_builtins.property
    @pulumi.getter(name="adRuleTargetGroupPeerSpecificationType")
    def ad_rule_target_group_peer_specification_type(self) -> _builtins.str:
        """
        - Way to identify the object for which rule is applied.
        """
        return pulumi.get(self, "ad_rule_target_group_peer_specification_type")

    @_builtins.property
    @pulumi.getter(name="allowIpv6Traffic")
    def allow_ipv6_traffic(self) -> _builtins.bool:
        return pulumi.get(self, "allow_ipv6_traffic")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="appRuleAction")
    def app_rule_action(self) -> _builtins.str:
        """
        - These rules govern what flows are allowed. Target group is a required attribute. Empty inbound_allow_list will not anything into target group. Empty outbound_allow_list will allow everything from target group.
        """
        return pulumi.get(self, "app_rule_action")

    @_builtins.property
    @pulumi.getter(name="appRuleInboundAllowLists")
    def app_rule_inbound_allow_lists(self) -> Sequence['outputs.GetNetworkSecurityRuleAppRuleInboundAllowListResult']:
        return pulumi.get(self, "app_rule_inbound_allow_lists")

    @_builtins.property
    @pulumi.getter(name="appRuleOutboundAllowLists")
    def app_rule_outbound_allow_lists(self) -> Sequence['outputs.GetNetworkSecurityRuleAppRuleOutboundAllowListResult']:
        return pulumi.get(self, "app_rule_outbound_allow_lists")

    @_builtins.property
    @pulumi.getter(name="appRuleTargetGroupDefaultInternalPolicy")
    def app_rule_target_group_default_internal_policy(self) -> _builtins.str:
        """
        - Default policy for communication within target group.
        """
        return pulumi.get(self, "app_rule_target_group_default_internal_policy")

    @_builtins.property
    @pulumi.getter(name="appRuleTargetGroupFilterKindLists")
    def app_rule_target_group_filter_kind_lists(self) -> Sequence[_builtins.str]:
        """
        - List of kinds associated with this filter.
        """
        return pulumi.get(self, "app_rule_target_group_filter_kind_lists")

    @_builtins.property
    @pulumi.getter(name="appRuleTargetGroupFilterParams")
    def app_rule_target_group_filter_params(self) -> Sequence['outputs.GetNetworkSecurityRuleAppRuleTargetGroupFilterParamResult']:
        """
        - A list of category key and list of values.
        """
        return pulumi.get(self, "app_rule_target_group_filter_params")

    @_builtins.property
    @pulumi.getter(name="appRuleTargetGroupFilterType")
    def app_rule_target_group_filter_type(self) -> _builtins.str:
        """
        - The type of the filter being used.
        """
        return pulumi.get(self, "app_rule_target_group_filter_type")

    @_builtins.property
    @pulumi.getter(name="appRuleTargetGroupPeerSpecificationType")
    def app_rule_target_group_peer_specification_type(self) -> _builtins.str:
        """
        - Way to identify the object for which rule is applied.
        """
        return pulumi.get(self, "app_rule_target_group_peer_specification_type")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetNetworkSecurityRuleCategoryResult']:
        """
        Categories for the network_security_rule.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description for network_security_rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isPolicyHitlogEnabled")
    def is_policy_hitlog_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "is_policy_hitlog_enabled")

    @_builtins.property
    @pulumi.getter(name="isolationRuleAction")
    def isolation_rule_action(self) -> _builtins.str:
        """
        - These rules are used for environmental isolation.
        """
        return pulumi.get(self, "isolation_rule_action")

    @_builtins.property
    @pulumi.getter(name="isolationRuleFirstEntityFilterKindLists")
    def isolation_rule_first_entity_filter_kind_lists(self) -> Sequence[_builtins.str]:
        """
        - List of kinds associated with this filter.
        """
        return pulumi.get(self, "isolation_rule_first_entity_filter_kind_lists")

    @_builtins.property
    @pulumi.getter(name="isolationRuleFirstEntityFilterParams")
    def isolation_rule_first_entity_filter_params(self) -> Sequence['outputs.GetNetworkSecurityRuleIsolationRuleFirstEntityFilterParamResult']:
        """
        - A list of category key and list of values.
        """
        return pulumi.get(self, "isolation_rule_first_entity_filter_params")

    @_builtins.property
    @pulumi.getter(name="isolationRuleFirstEntityFilterType")
    def isolation_rule_first_entity_filter_type(self) -> _builtins.str:
        """
        - The type of the filter being used.
        """
        return pulumi.get(self, "isolation_rule_first_entity_filter_type")

    @_builtins.property
    @pulumi.getter(name="isolationRuleSecondEntityFilterKindLists")
    def isolation_rule_second_entity_filter_kind_lists(self) -> Sequence[_builtins.str]:
        """
        - List of kinds associated with this filter.
        """
        return pulumi.get(self, "isolation_rule_second_entity_filter_kind_lists")

    @_builtins.property
    @pulumi.getter(name="isolationRuleSecondEntityFilterParams")
    def isolation_rule_second_entity_filter_params(self) -> Sequence['outputs.GetNetworkSecurityRuleIsolationRuleSecondEntityFilterParamResult']:
        """
        - A list of category key and list of values.
        """
        return pulumi.get(self, "isolation_rule_second_entity_filter_params")

    @_builtins.property
    @pulumi.getter(name="isolationRuleSecondEntityFilterType")
    def isolation_rule_second_entity_filter_type(self) -> _builtins.str:
        """
        - The type of the filter being used.
        """
        return pulumi.get(self, "isolation_rule_second_entity_filter_type")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - the name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSecurityRuleId")
    def network_security_rule_id(self) -> _builtins.str:
        """
        (Required) The ID for the rule you want to retrieve.
        """
        return pulumi.get(self, "network_security_rule_id")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Mapping[str, _builtins.str]:
        """
        The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Mapping[str, _builtins.str]:
        """
        The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="quarantineRuleAction")
    def quarantine_rule_action(self) -> _builtins.str:
        """
        These rules are used for quarantining suspected VMs. Target group is a required attribute. Empty inbound_allow_list will not allow anything into target group. Empty outbound_allow_list will allow everything from target group.
        """
        return pulumi.get(self, "quarantine_rule_action")

    @_builtins.property
    @pulumi.getter(name="quarantineRuleInboundAllowLists")
    def quarantine_rule_inbound_allow_lists(self) -> Sequence['outputs.GetNetworkSecurityRuleQuarantineRuleInboundAllowListResult']:
        return pulumi.get(self, "quarantine_rule_inbound_allow_lists")

    @_builtins.property
    @pulumi.getter(name="quarantineRuleOutboundAllowLists")
    def quarantine_rule_outbound_allow_lists(self) -> Sequence['outputs.GetNetworkSecurityRuleQuarantineRuleOutboundAllowListResult']:
        return pulumi.get(self, "quarantine_rule_outbound_allow_lists")

    @_builtins.property
    @pulumi.getter(name="quarantineRuleTargetGroupDefaultInternalPolicy")
    def quarantine_rule_target_group_default_internal_policy(self) -> _builtins.str:
        """
        - Default policy for communication within target group.
        """
        return pulumi.get(self, "quarantine_rule_target_group_default_internal_policy")

    @_builtins.property
    @pulumi.getter(name="quarantineRuleTargetGroupFilterKindLists")
    def quarantine_rule_target_group_filter_kind_lists(self) -> Sequence[_builtins.str]:
        """
        - List of kinds associated with this filter.
        """
        return pulumi.get(self, "quarantine_rule_target_group_filter_kind_lists")

    @_builtins.property
    @pulumi.getter(name="quarantineRuleTargetGroupFilterParams")
    def quarantine_rule_target_group_filter_params(self) -> Sequence['outputs.GetNetworkSecurityRuleQuarantineRuleTargetGroupFilterParamResult']:
        """
        - A list of category key and list of values.
        """
        return pulumi.get(self, "quarantine_rule_target_group_filter_params")

    @_builtins.property
    @pulumi.getter(name="quarantineRuleTargetGroupFilterType")
    def quarantine_rule_target_group_filter_type(self) -> _builtins.str:
        """
        - The type of the filter being used.
        """
        return pulumi.get(self, "quarantine_rule_target_group_filter_type")

    @_builtins.property
    @pulumi.getter(name="quarantineRuleTargetGroupPeerSpecificationType")
    def quarantine_rule_target_group_peer_specification_type(self) -> _builtins.str:
        """
        - Way to identify the object for which rule is applied.
        """
        return pulumi.get(self, "quarantine_rule_target_group_peer_specification_type")


class AwaitableGetNetworkSecurityRuleResult(GetNetworkSecurityRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkSecurityRuleResult(
            ad_rule_action=self.ad_rule_action,
            ad_rule_inbound_allow_lists=self.ad_rule_inbound_allow_lists,
            ad_rule_outbound_allow_lists=self.ad_rule_outbound_allow_lists,
            ad_rule_target_group_default_internal_policy=self.ad_rule_target_group_default_internal_policy,
            ad_rule_target_group_filter_kind_lists=self.ad_rule_target_group_filter_kind_lists,
            ad_rule_target_group_filter_params=self.ad_rule_target_group_filter_params,
            ad_rule_target_group_filter_type=self.ad_rule_target_group_filter_type,
            ad_rule_target_group_peer_specification_type=self.ad_rule_target_group_peer_specification_type,
            allow_ipv6_traffic=self.allow_ipv6_traffic,
            api_version=self.api_version,
            app_rule_action=self.app_rule_action,
            app_rule_inbound_allow_lists=self.app_rule_inbound_allow_lists,
            app_rule_outbound_allow_lists=self.app_rule_outbound_allow_lists,
            app_rule_target_group_default_internal_policy=self.app_rule_target_group_default_internal_policy,
            app_rule_target_group_filter_kind_lists=self.app_rule_target_group_filter_kind_lists,
            app_rule_target_group_filter_params=self.app_rule_target_group_filter_params,
            app_rule_target_group_filter_type=self.app_rule_target_group_filter_type,
            app_rule_target_group_peer_specification_type=self.app_rule_target_group_peer_specification_type,
            categories=self.categories,
            description=self.description,
            id=self.id,
            is_policy_hitlog_enabled=self.is_policy_hitlog_enabled,
            isolation_rule_action=self.isolation_rule_action,
            isolation_rule_first_entity_filter_kind_lists=self.isolation_rule_first_entity_filter_kind_lists,
            isolation_rule_first_entity_filter_params=self.isolation_rule_first_entity_filter_params,
            isolation_rule_first_entity_filter_type=self.isolation_rule_first_entity_filter_type,
            isolation_rule_second_entity_filter_kind_lists=self.isolation_rule_second_entity_filter_kind_lists,
            isolation_rule_second_entity_filter_params=self.isolation_rule_second_entity_filter_params,
            isolation_rule_second_entity_filter_type=self.isolation_rule_second_entity_filter_type,
            metadata=self.metadata,
            name=self.name,
            network_security_rule_id=self.network_security_rule_id,
            owner_reference=self.owner_reference,
            project_reference=self.project_reference,
            quarantine_rule_action=self.quarantine_rule_action,
            quarantine_rule_inbound_allow_lists=self.quarantine_rule_inbound_allow_lists,
            quarantine_rule_outbound_allow_lists=self.quarantine_rule_outbound_allow_lists,
            quarantine_rule_target_group_default_internal_policy=self.quarantine_rule_target_group_default_internal_policy,
            quarantine_rule_target_group_filter_kind_lists=self.quarantine_rule_target_group_filter_kind_lists,
            quarantine_rule_target_group_filter_params=self.quarantine_rule_target_group_filter_params,
            quarantine_rule_target_group_filter_type=self.quarantine_rule_target_group_filter_type,
            quarantine_rule_target_group_peer_specification_type=self.quarantine_rule_target_group_peer_specification_type)


def get_network_security_rule(categories: Optional[Sequence[Union['GetNetworkSecurityRuleCategoryArgs', 'GetNetworkSecurityRuleCategoryArgsDict']]] = None,
                              network_security_rule_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkSecurityRuleResult:
    """
    Describes a Network security rule

    > NOTE: The use of network_security_rule is only applicable in AHV clusters and requires Microsegmentation to be enabled. This feature is a function of the Flow product and requires a Flow license. For more information on Flow and Microsegmentation please visit https://www.nutanix.com/products/flow

    ## Example Usage

    ### Isolate Development VMs From Production VMs And Get Its Information)

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    isolation = nutanix.NetworkSecurityRule("isolation",
        name="example-isolation-rule",
        description="Isolation Rule Example",
        isolation_rule_action="APPLY",
        isolation_rule_first_entity_filter_kind_lists=["vm"],
        isolation_rule_first_entity_filter_type="CATEGORIES_MATCH_ALL",
        isolation_rule_first_entity_filter_params=[{
            "name": "Environment",
            "values": ["Dev"],
        }],
        isolation_rule_second_entity_filter_kind_lists=["vm"],
        isolation_rule_second_entity_filter_type="CATEGORIES_MATCH_ALL",
        isolation_rule_second_entity_filter_params=[{
            "name": "Environment",
            "values": ["Production"],
        }])
    test = nutanix.get_network_security_rule_output(network_security_rule_id=isolation.id)
    ```


    :param Sequence[Union['GetNetworkSecurityRuleCategoryArgs', 'GetNetworkSecurityRuleCategoryArgsDict']] categories: Categories for the network_security_rule.
    :param _builtins.str network_security_rule_id: Represents network security rule UUID
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['networkSecurityRuleId'] = network_security_rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNetworkSecurityRule:getNetworkSecurityRule', __args__, opts=opts, typ=GetNetworkSecurityRuleResult).value

    return AwaitableGetNetworkSecurityRuleResult(
        ad_rule_action=pulumi.get(__ret__, 'ad_rule_action'),
        ad_rule_inbound_allow_lists=pulumi.get(__ret__, 'ad_rule_inbound_allow_lists'),
        ad_rule_outbound_allow_lists=pulumi.get(__ret__, 'ad_rule_outbound_allow_lists'),
        ad_rule_target_group_default_internal_policy=pulumi.get(__ret__, 'ad_rule_target_group_default_internal_policy'),
        ad_rule_target_group_filter_kind_lists=pulumi.get(__ret__, 'ad_rule_target_group_filter_kind_lists'),
        ad_rule_target_group_filter_params=pulumi.get(__ret__, 'ad_rule_target_group_filter_params'),
        ad_rule_target_group_filter_type=pulumi.get(__ret__, 'ad_rule_target_group_filter_type'),
        ad_rule_target_group_peer_specification_type=pulumi.get(__ret__, 'ad_rule_target_group_peer_specification_type'),
        allow_ipv6_traffic=pulumi.get(__ret__, 'allow_ipv6_traffic'),
        api_version=pulumi.get(__ret__, 'api_version'),
        app_rule_action=pulumi.get(__ret__, 'app_rule_action'),
        app_rule_inbound_allow_lists=pulumi.get(__ret__, 'app_rule_inbound_allow_lists'),
        app_rule_outbound_allow_lists=pulumi.get(__ret__, 'app_rule_outbound_allow_lists'),
        app_rule_target_group_default_internal_policy=pulumi.get(__ret__, 'app_rule_target_group_default_internal_policy'),
        app_rule_target_group_filter_kind_lists=pulumi.get(__ret__, 'app_rule_target_group_filter_kind_lists'),
        app_rule_target_group_filter_params=pulumi.get(__ret__, 'app_rule_target_group_filter_params'),
        app_rule_target_group_filter_type=pulumi.get(__ret__, 'app_rule_target_group_filter_type'),
        app_rule_target_group_peer_specification_type=pulumi.get(__ret__, 'app_rule_target_group_peer_specification_type'),
        categories=pulumi.get(__ret__, 'categories'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_policy_hitlog_enabled=pulumi.get(__ret__, 'is_policy_hitlog_enabled'),
        isolation_rule_action=pulumi.get(__ret__, 'isolation_rule_action'),
        isolation_rule_first_entity_filter_kind_lists=pulumi.get(__ret__, 'isolation_rule_first_entity_filter_kind_lists'),
        isolation_rule_first_entity_filter_params=pulumi.get(__ret__, 'isolation_rule_first_entity_filter_params'),
        isolation_rule_first_entity_filter_type=pulumi.get(__ret__, 'isolation_rule_first_entity_filter_type'),
        isolation_rule_second_entity_filter_kind_lists=pulumi.get(__ret__, 'isolation_rule_second_entity_filter_kind_lists'),
        isolation_rule_second_entity_filter_params=pulumi.get(__ret__, 'isolation_rule_second_entity_filter_params'),
        isolation_rule_second_entity_filter_type=pulumi.get(__ret__, 'isolation_rule_second_entity_filter_type'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        network_security_rule_id=pulumi.get(__ret__, 'network_security_rule_id'),
        owner_reference=pulumi.get(__ret__, 'owner_reference'),
        project_reference=pulumi.get(__ret__, 'project_reference'),
        quarantine_rule_action=pulumi.get(__ret__, 'quarantine_rule_action'),
        quarantine_rule_inbound_allow_lists=pulumi.get(__ret__, 'quarantine_rule_inbound_allow_lists'),
        quarantine_rule_outbound_allow_lists=pulumi.get(__ret__, 'quarantine_rule_outbound_allow_lists'),
        quarantine_rule_target_group_default_internal_policy=pulumi.get(__ret__, 'quarantine_rule_target_group_default_internal_policy'),
        quarantine_rule_target_group_filter_kind_lists=pulumi.get(__ret__, 'quarantine_rule_target_group_filter_kind_lists'),
        quarantine_rule_target_group_filter_params=pulumi.get(__ret__, 'quarantine_rule_target_group_filter_params'),
        quarantine_rule_target_group_filter_type=pulumi.get(__ret__, 'quarantine_rule_target_group_filter_type'),
        quarantine_rule_target_group_peer_specification_type=pulumi.get(__ret__, 'quarantine_rule_target_group_peer_specification_type'))
def get_network_security_rule_output(categories: Optional[pulumi.Input[Optional[Sequence[Union['GetNetworkSecurityRuleCategoryArgs', 'GetNetworkSecurityRuleCategoryArgsDict']]]]] = None,
                                     network_security_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkSecurityRuleResult]:
    """
    Describes a Network security rule

    > NOTE: The use of network_security_rule is only applicable in AHV clusters and requires Microsegmentation to be enabled. This feature is a function of the Flow product and requires a Flow license. For more information on Flow and Microsegmentation please visit https://www.nutanix.com/products/flow

    ## Example Usage

    ### Isolate Development VMs From Production VMs And Get Its Information)

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    isolation = nutanix.NetworkSecurityRule("isolation",
        name="example-isolation-rule",
        description="Isolation Rule Example",
        isolation_rule_action="APPLY",
        isolation_rule_first_entity_filter_kind_lists=["vm"],
        isolation_rule_first_entity_filter_type="CATEGORIES_MATCH_ALL",
        isolation_rule_first_entity_filter_params=[{
            "name": "Environment",
            "values": ["Dev"],
        }],
        isolation_rule_second_entity_filter_kind_lists=["vm"],
        isolation_rule_second_entity_filter_type="CATEGORIES_MATCH_ALL",
        isolation_rule_second_entity_filter_params=[{
            "name": "Environment",
            "values": ["Production"],
        }])
    test = nutanix.get_network_security_rule_output(network_security_rule_id=isolation.id)
    ```


    :param Sequence[Union['GetNetworkSecurityRuleCategoryArgs', 'GetNetworkSecurityRuleCategoryArgsDict']] categories: Categories for the network_security_rule.
    :param _builtins.str network_security_rule_id: Represents network security rule UUID
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['networkSecurityRuleId'] = network_security_rule_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNetworkSecurityRule:getNetworkSecurityRule', __args__, opts=opts, typ=GetNetworkSecurityRuleResult)
    return __ret__.apply(lambda __response__: GetNetworkSecurityRuleResult(
        ad_rule_action=pulumi.get(__response__, 'ad_rule_action'),
        ad_rule_inbound_allow_lists=pulumi.get(__response__, 'ad_rule_inbound_allow_lists'),
        ad_rule_outbound_allow_lists=pulumi.get(__response__, 'ad_rule_outbound_allow_lists'),
        ad_rule_target_group_default_internal_policy=pulumi.get(__response__, 'ad_rule_target_group_default_internal_policy'),
        ad_rule_target_group_filter_kind_lists=pulumi.get(__response__, 'ad_rule_target_group_filter_kind_lists'),
        ad_rule_target_group_filter_params=pulumi.get(__response__, 'ad_rule_target_group_filter_params'),
        ad_rule_target_group_filter_type=pulumi.get(__response__, 'ad_rule_target_group_filter_type'),
        ad_rule_target_group_peer_specification_type=pulumi.get(__response__, 'ad_rule_target_group_peer_specification_type'),
        allow_ipv6_traffic=pulumi.get(__response__, 'allow_ipv6_traffic'),
        api_version=pulumi.get(__response__, 'api_version'),
        app_rule_action=pulumi.get(__response__, 'app_rule_action'),
        app_rule_inbound_allow_lists=pulumi.get(__response__, 'app_rule_inbound_allow_lists'),
        app_rule_outbound_allow_lists=pulumi.get(__response__, 'app_rule_outbound_allow_lists'),
        app_rule_target_group_default_internal_policy=pulumi.get(__response__, 'app_rule_target_group_default_internal_policy'),
        app_rule_target_group_filter_kind_lists=pulumi.get(__response__, 'app_rule_target_group_filter_kind_lists'),
        app_rule_target_group_filter_params=pulumi.get(__response__, 'app_rule_target_group_filter_params'),
        app_rule_target_group_filter_type=pulumi.get(__response__, 'app_rule_target_group_filter_type'),
        app_rule_target_group_peer_specification_type=pulumi.get(__response__, 'app_rule_target_group_peer_specification_type'),
        categories=pulumi.get(__response__, 'categories'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        is_policy_hitlog_enabled=pulumi.get(__response__, 'is_policy_hitlog_enabled'),
        isolation_rule_action=pulumi.get(__response__, 'isolation_rule_action'),
        isolation_rule_first_entity_filter_kind_lists=pulumi.get(__response__, 'isolation_rule_first_entity_filter_kind_lists'),
        isolation_rule_first_entity_filter_params=pulumi.get(__response__, 'isolation_rule_first_entity_filter_params'),
        isolation_rule_first_entity_filter_type=pulumi.get(__response__, 'isolation_rule_first_entity_filter_type'),
        isolation_rule_second_entity_filter_kind_lists=pulumi.get(__response__, 'isolation_rule_second_entity_filter_kind_lists'),
        isolation_rule_second_entity_filter_params=pulumi.get(__response__, 'isolation_rule_second_entity_filter_params'),
        isolation_rule_second_entity_filter_type=pulumi.get(__response__, 'isolation_rule_second_entity_filter_type'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        network_security_rule_id=pulumi.get(__response__, 'network_security_rule_id'),
        owner_reference=pulumi.get(__response__, 'owner_reference'),
        project_reference=pulumi.get(__response__, 'project_reference'),
        quarantine_rule_action=pulumi.get(__response__, 'quarantine_rule_action'),
        quarantine_rule_inbound_allow_lists=pulumi.get(__response__, 'quarantine_rule_inbound_allow_lists'),
        quarantine_rule_outbound_allow_lists=pulumi.get(__response__, 'quarantine_rule_outbound_allow_lists'),
        quarantine_rule_target_group_default_internal_policy=pulumi.get(__response__, 'quarantine_rule_target_group_default_internal_policy'),
        quarantine_rule_target_group_filter_kind_lists=pulumi.get(__response__, 'quarantine_rule_target_group_filter_kind_lists'),
        quarantine_rule_target_group_filter_params=pulumi.get(__response__, 'quarantine_rule_target_group_filter_params'),
        quarantine_rule_target_group_filter_type=pulumi.get(__response__, 'quarantine_rule_target_group_filter_type'),
        quarantine_rule_target_group_peer_specification_type=pulumi.get(__response__, 'quarantine_rule_target_group_peer_specification_type')))
