# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNgtConfigurationV2Result',
    'AwaitableGetNgtConfigurationV2Result',
    'get_ngt_configuration_v2',
    'get_ngt_configuration_v2_output',
]

@pulumi.output_type
class GetNgtConfigurationV2Result:
    """
    A collection of values returned by getNgtConfigurationV2.
    """
    def __init__(__self__, available_version=None, capablities=None, ext_id=None, guest_os_version=None, id=None, is_enabled=None, is_installed=None, is_iso_inserted=None, is_reachable=None, is_vm_mobility_drivers_installed=None, is_vss_snapshot_capable=None, version=None):
        if available_version and not isinstance(available_version, str):
            raise TypeError("Expected argument 'available_version' to be a str")
        pulumi.set(__self__, "available_version", available_version)
        if capablities and not isinstance(capablities, list):
            raise TypeError("Expected argument 'capablities' to be a list")
        pulumi.set(__self__, "capablities", capablities)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if guest_os_version and not isinstance(guest_os_version, str):
            raise TypeError("Expected argument 'guest_os_version' to be a str")
        pulumi.set(__self__, "guest_os_version", guest_os_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_installed and not isinstance(is_installed, bool):
            raise TypeError("Expected argument 'is_installed' to be a bool")
        pulumi.set(__self__, "is_installed", is_installed)
        if is_iso_inserted and not isinstance(is_iso_inserted, bool):
            raise TypeError("Expected argument 'is_iso_inserted' to be a bool")
        pulumi.set(__self__, "is_iso_inserted", is_iso_inserted)
        if is_reachable and not isinstance(is_reachable, bool):
            raise TypeError("Expected argument 'is_reachable' to be a bool")
        pulumi.set(__self__, "is_reachable", is_reachable)
        if is_vm_mobility_drivers_installed and not isinstance(is_vm_mobility_drivers_installed, bool):
            raise TypeError("Expected argument 'is_vm_mobility_drivers_installed' to be a bool")
        pulumi.set(__self__, "is_vm_mobility_drivers_installed", is_vm_mobility_drivers_installed)
        if is_vss_snapshot_capable and not isinstance(is_vss_snapshot_capable, bool):
            raise TypeError("Expected argument 'is_vss_snapshot_capable' to be a bool")
        pulumi.set(__self__, "is_vss_snapshot_capable", is_vss_snapshot_capable)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="availableVersion")
    def available_version(self) -> _builtins.str:
        """
        Version of Nutanix Guest Tools available on the cluster.
        """
        return pulumi.get(self, "available_version")

    @_builtins.property
    @pulumi.getter
    def capablities(self) -> Sequence[_builtins.str]:
        """
        The list of the application names that are enabled on the guest VM. [`SELF_SERVICE_RESTORE`, `VSS_SNAPSHOT`]
        """
        return pulumi.get(self, "capablities")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        uuid of the Virtual Machine.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="guestOsVersion")
    def guest_os_version(self) -> _builtins.str:
        """
        Version of the operating system on the VM.
        """
        return pulumi.get(self, "guest_os_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Indicates whether Nutanix Guest Tools is enabled or not.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="isInstalled")
    def is_installed(self) -> _builtins.bool:
        """
        Indicates whether Nutanix Guest Tools is installed on the VM or not.
        """
        return pulumi.get(self, "is_installed")

    @_builtins.property
    @pulumi.getter(name="isIsoInserted")
    def is_iso_inserted(self) -> _builtins.bool:
        """
        Indicates whether Nutanix Guest Tools ISO is inserted or not.
        """
        return pulumi.get(self, "is_iso_inserted")

    @_builtins.property
    @pulumi.getter(name="isReachable")
    def is_reachable(self) -> _builtins.bool:
        """
        Indicates whether the communication from VM to CVM is active or not.
        """
        return pulumi.get(self, "is_reachable")

    @_builtins.property
    @pulumi.getter(name="isVmMobilityDriversInstalled")
    def is_vm_mobility_drivers_installed(self) -> _builtins.bool:
        """
        Indicates whether the VM mobility drivers are installed on the VM or not.
        """
        return pulumi.get(self, "is_vm_mobility_drivers_installed")

    @_builtins.property
    @pulumi.getter(name="isVssSnapshotCapable")
    def is_vss_snapshot_capable(self) -> _builtins.bool:
        """
        Indicates whether the VM is configured to take VSS snapshots through NGT or not.
        """
        return pulumi.get(self, "is_vss_snapshot_capable")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Version of Nutanix Guest Tools installed on the VM.
        """
        return pulumi.get(self, "version")


class AwaitableGetNgtConfigurationV2Result(GetNgtConfigurationV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNgtConfigurationV2Result(
            available_version=self.available_version,
            capablities=self.capablities,
            ext_id=self.ext_id,
            guest_os_version=self.guest_os_version,
            id=self.id,
            is_enabled=self.is_enabled,
            is_installed=self.is_installed,
            is_iso_inserted=self.is_iso_inserted,
            is_reachable=self.is_reachable,
            is_vm_mobility_drivers_installed=self.is_vm_mobility_drivers_installed,
            is_vss_snapshot_capable=self.is_vss_snapshot_capable,
            version=self.version)


def get_ngt_configuration_v2(ext_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNgtConfigurationV2Result:
    """
    Provides Nutanix datasource to Retrieves the Nutanix Guest Tools configuration for a Virtual Machine.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_ngt_configuration_v2(ext_id="f29535e2-6bd8-4782-b879-409f17217b31")
    ```


    :param _builtins.str ext_id: uuid of the Virtual Machine.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getNgtConfigurationV2:getNgtConfigurationV2', __args__, opts=opts, typ=GetNgtConfigurationV2Result).value

    return AwaitableGetNgtConfigurationV2Result(
        available_version=pulumi.get(__ret__, 'available_version'),
        capablities=pulumi.get(__ret__, 'capablities'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        guest_os_version=pulumi.get(__ret__, 'guest_os_version'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        is_installed=pulumi.get(__ret__, 'is_installed'),
        is_iso_inserted=pulumi.get(__ret__, 'is_iso_inserted'),
        is_reachable=pulumi.get(__ret__, 'is_reachable'),
        is_vm_mobility_drivers_installed=pulumi.get(__ret__, 'is_vm_mobility_drivers_installed'),
        is_vss_snapshot_capable=pulumi.get(__ret__, 'is_vss_snapshot_capable'),
        version=pulumi.get(__ret__, 'version'))
def get_ngt_configuration_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNgtConfigurationV2Result]:
    """
    Provides Nutanix datasource to Retrieves the Nutanix Guest Tools configuration for a Virtual Machine.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_ngt_configuration_v2(ext_id="f29535e2-6bd8-4782-b879-409f17217b31")
    ```


    :param _builtins.str ext_id: uuid of the Virtual Machine.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getNgtConfigurationV2:getNgtConfigurationV2', __args__, opts=opts, typ=GetNgtConfigurationV2Result)
    return __ret__.apply(lambda __response__: GetNgtConfigurationV2Result(
        available_version=pulumi.get(__response__, 'available_version'),
        capablities=pulumi.get(__response__, 'capablities'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        guest_os_version=pulumi.get(__response__, 'guest_os_version'),
        id=pulumi.get(__response__, 'id'),
        is_enabled=pulumi.get(__response__, 'is_enabled'),
        is_installed=pulumi.get(__response__, 'is_installed'),
        is_iso_inserted=pulumi.get(__response__, 'is_iso_inserted'),
        is_reachable=pulumi.get(__response__, 'is_reachable'),
        is_vm_mobility_drivers_installed=pulumi.get(__response__, 'is_vm_mobility_drivers_installed'),
        is_vss_snapshot_capable=pulumi.get(__response__, 'is_vss_snapshot_capable'),
        version=pulumi.get(__response__, 'version')))
