# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetObjectStoreV2Result',
    'AwaitableGetObjectStoreV2Result',
    'get_object_store_v2',
    'get_object_store_v2_output',
]

@pulumi.output_type
class GetObjectStoreV2Result:
    """
    A collection of values returned by getObjectStoreV2.
    """
    def __init__(__self__, certificate_ext_ids=None, cluster_ext_id=None, creation_time=None, deployment_version=None, description=None, domain=None, ext_id=None, id=None, last_update_time=None, links=None, metadatas=None, name=None, num_worker_nodes=None, public_network_ips=None, public_network_reference=None, region=None, state=None, storage_network_dns_ips=None, storage_network_reference=None, storage_network_vips=None, tenant_id=None, total_capacity_gib=None):
        if certificate_ext_ids and not isinstance(certificate_ext_ids, list):
            raise TypeError("Expected argument 'certificate_ext_ids' to be a list")
        pulumi.set(__self__, "certificate_ext_ids", certificate_ext_ids)
        if cluster_ext_id and not isinstance(cluster_ext_id, str):
            raise TypeError("Expected argument 'cluster_ext_id' to be a str")
        pulumi.set(__self__, "cluster_ext_id", cluster_ext_id)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if deployment_version and not isinstance(deployment_version, str):
            raise TypeError("Expected argument 'deployment_version' to be a str")
        pulumi.set(__self__, "deployment_version", deployment_version)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_update_time and not isinstance(last_update_time, str):
            raise TypeError("Expected argument 'last_update_time' to be a str")
        pulumi.set(__self__, "last_update_time", last_update_time)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if num_worker_nodes and not isinstance(num_worker_nodes, int):
            raise TypeError("Expected argument 'num_worker_nodes' to be a int")
        pulumi.set(__self__, "num_worker_nodes", num_worker_nodes)
        if public_network_ips and not isinstance(public_network_ips, list):
            raise TypeError("Expected argument 'public_network_ips' to be a list")
        pulumi.set(__self__, "public_network_ips", public_network_ips)
        if public_network_reference and not isinstance(public_network_reference, str):
            raise TypeError("Expected argument 'public_network_reference' to be a str")
        pulumi.set(__self__, "public_network_reference", public_network_reference)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_network_dns_ips and not isinstance(storage_network_dns_ips, list):
            raise TypeError("Expected argument 'storage_network_dns_ips' to be a list")
        pulumi.set(__self__, "storage_network_dns_ips", storage_network_dns_ips)
        if storage_network_reference and not isinstance(storage_network_reference, str):
            raise TypeError("Expected argument 'storage_network_reference' to be a str")
        pulumi.set(__self__, "storage_network_reference", storage_network_reference)
        if storage_network_vips and not isinstance(storage_network_vips, list):
            raise TypeError("Expected argument 'storage_network_vips' to be a list")
        pulumi.set(__self__, "storage_network_vips", storage_network_vips)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if total_capacity_gib and not isinstance(total_capacity_gib, int):
            raise TypeError("Expected argument 'total_capacity_gib' to be a int")
        pulumi.set(__self__, "total_capacity_gib", total_capacity_gib)

    @_builtins.property
    @pulumi.getter(name="certificateExtIds")
    def certificate_ext_ids(self) -> Sequence[_builtins.str]:
        """
        - A list of the UUIDs of the certificates of an Object store.
        """
        return pulumi.get(self, "certificate_ext_ids")

    @_builtins.property
    @pulumi.getter(name="clusterExtId")
    def cluster_ext_id(self) -> _builtins.str:
        """
        - UUID of the AHV or ESXi cluster.
        """
        return pulumi.get(self, "cluster_ext_id")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        - The time when the Object store was created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="deploymentVersion")
    def deployment_version(self) -> _builtins.str:
        """
        - The deployment version of the Object store.
        """
        return pulumi.get(self, "deployment_version")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - A brief description of the Object store.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        - The DNS domain/subdomain the Object store belongs to. All the Object stores under one Prism Central must have the same domain name. The domain name must consist of at least 2 parts separated by a '.'. Each part can contain upper and lower case letters, digits, hyphens, or underscores. Each part can be up to 63 characters long. The domain must begin and end with an alphanumeric character. For example - 'objects-0.pc_nutanix.com'.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> _builtins.str:
        """
        - The time when the Object store was last updated.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetObjectStoreV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetObjectStoreV2MetadataResult']:
        """
        - Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - The name of the Object store.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numWorkerNodes")
    def num_worker_nodes(self) -> _builtins.int:
        """
        - The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
        """
        return pulumi.get(self, "num_worker_nodes")

    @_builtins.property
    @pulumi.getter(name="publicNetworkIps")
    def public_network_ips(self) -> Sequence['outputs.GetObjectStoreV2PublicNetworkIpResult']:
        """
        - A list of static IP addresses used as public IPs to access the Object store.
        """
        return pulumi.get(self, "public_network_ips")

    @_builtins.property
    @pulumi.getter(name="publicNetworkReference")
    def public_network_reference(self) -> _builtins.str:
        """
        - Public network reference of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        """
        return pulumi.get(self, "public_network_reference")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        - The region in which the Object store is deployed.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        - Enum for the state of the Object store.
        | Enum                                   | Description                                                     |
        |----------------------------------------|-----------------------------------------------------------------|
        | `DEPLOYING_OBJECT_STORE`             | The Object store is being deployed.                             |
        | `OBJECT_STORE_DEPLOYMENT_FAILED`     | The Object store deployment has failed.                         |
        | `DELETING_OBJECT_STORE`              | A deployed Object store is being deleted.                       |
        | `OBJECT_STORE_OPERATION_FAILED`      | There was an error while performing an operation on the Object store. |
        | `UNDEPLOYED_OBJECT_STORE`            | The Object store is not deployed.                               |
        | `OBJECT_STORE_OPERATION_PENDING`     | There is an ongoing operation on the Object store.              |
        | `OBJECT_STORE_AVAILABLE`            | There are no ongoing operations on the deployed Object store.   |
        | `OBJECT_STORE_CERT_CREATION_FAILED`  | Creating the Object store certificate has failed.               |
        | `CREATING_OBJECT_STORE_CERT`         | A certificate is being created for the Object store.            |
        | `OBJECT_STORE_DELETION_FAILED`       | There was an error deleting the Object store.                   |
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="storageNetworkDnsIps")
    def storage_network_dns_ips(self) -> Sequence['outputs.GetObjectStoreV2StorageNetworkDnsIpResult']:
        """
        - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        """
        return pulumi.get(self, "storage_network_dns_ips")

    @_builtins.property
    @pulumi.getter(name="storageNetworkReference")
    def storage_network_reference(self) -> _builtins.str:
        """
        - Reference to the Storage Network of the Object store. This is the subnet UUID for an AHV cluster or the IPAM name for an ESXi cluster.
        """
        return pulumi.get(self, "storage_network_reference")

    @_builtins.property
    @pulumi.getter(name="storageNetworkVips")
    def storage_network_vips(self) -> Sequence['outputs.GetObjectStoreV2StorageNetworkVipResult']:
        """
        - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
        """
        return pulumi.get(self, "storage_network_vips")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="totalCapacityGib")
    def total_capacity_gib(self) -> _builtins.int:
        """
        - Size of the Object store in GiB.
        """
        return pulumi.get(self, "total_capacity_gib")


class AwaitableGetObjectStoreV2Result(GetObjectStoreV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetObjectStoreV2Result(
            certificate_ext_ids=self.certificate_ext_ids,
            cluster_ext_id=self.cluster_ext_id,
            creation_time=self.creation_time,
            deployment_version=self.deployment_version,
            description=self.description,
            domain=self.domain,
            ext_id=self.ext_id,
            id=self.id,
            last_update_time=self.last_update_time,
            links=self.links,
            metadatas=self.metadatas,
            name=self.name,
            num_worker_nodes=self.num_worker_nodes,
            public_network_ips=self.public_network_ips,
            public_network_reference=self.public_network_reference,
            region=self.region,
            state=self.state,
            storage_network_dns_ips=self.storage_network_dns_ips,
            storage_network_reference=self.storage_network_reference,
            storage_network_vips=self.storage_network_vips,
            tenant_id=self.tenant_id,
            total_capacity_gib=self.total_capacity_gib)


def get_object_store_v2(ext_id: Optional[_builtins.str] = None,
                        num_worker_nodes: Optional[_builtins.int] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetObjectStoreV2Result:
    """
    Get an Object store for the provided UUID

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_object_store_v2(ext_id="95eb5f66-f547-4aea-9af8-b580e2060693")
    ```


    :param _builtins.str ext_id: -(Required) The UUID of the Object store.
    :param _builtins.int num_worker_nodes: - The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['numWorkerNodes'] = num_worker_nodes
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getObjectStoreV2:getObjectStoreV2', __args__, opts=opts, typ=GetObjectStoreV2Result).value

    return AwaitableGetObjectStoreV2Result(
        certificate_ext_ids=pulumi.get(__ret__, 'certificate_ext_ids'),
        cluster_ext_id=pulumi.get(__ret__, 'cluster_ext_id'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        deployment_version=pulumi.get(__ret__, 'deployment_version'),
        description=pulumi.get(__ret__, 'description'),
        domain=pulumi.get(__ret__, 'domain'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        last_update_time=pulumi.get(__ret__, 'last_update_time'),
        links=pulumi.get(__ret__, 'links'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        num_worker_nodes=pulumi.get(__ret__, 'num_worker_nodes'),
        public_network_ips=pulumi.get(__ret__, 'public_network_ips'),
        public_network_reference=pulumi.get(__ret__, 'public_network_reference'),
        region=pulumi.get(__ret__, 'region'),
        state=pulumi.get(__ret__, 'state'),
        storage_network_dns_ips=pulumi.get(__ret__, 'storage_network_dns_ips'),
        storage_network_reference=pulumi.get(__ret__, 'storage_network_reference'),
        storage_network_vips=pulumi.get(__ret__, 'storage_network_vips'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        total_capacity_gib=pulumi.get(__ret__, 'total_capacity_gib'))
def get_object_store_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                               num_worker_nodes: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetObjectStoreV2Result]:
    """
    Get an Object store for the provided UUID

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_object_store_v2(ext_id="95eb5f66-f547-4aea-9af8-b580e2060693")
    ```


    :param _builtins.str ext_id: -(Required) The UUID of the Object store.
    :param _builtins.int num_worker_nodes: - The number of worker nodes (VMs) to be created for the Object store. Each worker node requires 10 vCPUs and 32 GiB of memory.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['numWorkerNodes'] = num_worker_nodes
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getObjectStoreV2:getObjectStoreV2', __args__, opts=opts, typ=GetObjectStoreV2Result)
    return __ret__.apply(lambda __response__: GetObjectStoreV2Result(
        certificate_ext_ids=pulumi.get(__response__, 'certificate_ext_ids'),
        cluster_ext_id=pulumi.get(__response__, 'cluster_ext_id'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        deployment_version=pulumi.get(__response__, 'deployment_version'),
        description=pulumi.get(__response__, 'description'),
        domain=pulumi.get(__response__, 'domain'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        last_update_time=pulumi.get(__response__, 'last_update_time'),
        links=pulumi.get(__response__, 'links'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        name=pulumi.get(__response__, 'name'),
        num_worker_nodes=pulumi.get(__response__, 'num_worker_nodes'),
        public_network_ips=pulumi.get(__response__, 'public_network_ips'),
        public_network_reference=pulumi.get(__response__, 'public_network_reference'),
        region=pulumi.get(__response__, 'region'),
        state=pulumi.get(__response__, 'state'),
        storage_network_dns_ips=pulumi.get(__response__, 'storage_network_dns_ips'),
        storage_network_reference=pulumi.get(__response__, 'storage_network_reference'),
        storage_network_vips=pulumi.get(__response__, 'storage_network_vips'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        total_capacity_gib=pulumi.get(__response__, 'total_capacity_gib')))
