# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetOperationV2Result',
    'AwaitableGetOperationV2Result',
    'get_operation_v2',
    'get_operation_v2_output',
]

@pulumi.output_type
class GetOperationV2Result:
    """
    A collection of values returned by getOperationV2.
    """
    def __init__(__self__, associated_endpoint_lists=None, client_name=None, created_time=None, description=None, display_name=None, entity_type=None, ext_id=None, id=None, last_updated_time=None, operation_type=None, related_operation_lists=None):
        if associated_endpoint_lists and not isinstance(associated_endpoint_lists, list):
            raise TypeError("Expected argument 'associated_endpoint_lists' to be a list")
        pulumi.set(__self__, "associated_endpoint_lists", associated_endpoint_lists)
        if client_name and not isinstance(client_name, str):
            raise TypeError("Expected argument 'client_name' to be a str")
        pulumi.set(__self__, "client_name", client_name)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if operation_type and not isinstance(operation_type, str):
            raise TypeError("Expected argument 'operation_type' to be a str")
        pulumi.set(__self__, "operation_type", operation_type)
        if related_operation_lists and not isinstance(related_operation_lists, list):
            raise TypeError("Expected argument 'related_operation_lists' to be a list")
        pulumi.set(__self__, "related_operation_lists", related_operation_lists)

    @_builtins.property
    @pulumi.getter(name="associatedEndpointLists")
    def associated_endpoint_lists(self) -> Sequence['outputs.GetOperationV2AssociatedEndpointListResult']:
        """
        List of associated endpoint objects for the Operation.
        """
        return pulumi.get(self, "associated_endpoint_lists")

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> _builtins.str:
        """
        Client that created the entity.
        """
        return pulumi.get(self, "client_name")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        Permission creation time
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Permission description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Permission name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        Type of entity associated with this Operation.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> _builtins.str:
        """
        Permission last updated time.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> _builtins.str:
        """
        The Operation type. Currently we support INTERNAL, EXTERNAL and SYSTEM_DEFINED_ONLY.
        """
        return pulumi.get(self, "operation_type")

    @_builtins.property
    @pulumi.getter(name="relatedOperationLists")
    def related_operation_lists(self) -> Sequence[_builtins.str]:
        """
        List of related Operations. These are the Operations which might need to be given access to, along with the current Operation, for certain workflows to succeed.
        """
        return pulumi.get(self, "related_operation_lists")


class AwaitableGetOperationV2Result(GetOperationV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOperationV2Result(
            associated_endpoint_lists=self.associated_endpoint_lists,
            client_name=self.client_name,
            created_time=self.created_time,
            description=self.description,
            display_name=self.display_name,
            entity_type=self.entity_type,
            ext_id=self.ext_id,
            id=self.id,
            last_updated_time=self.last_updated_time,
            operation_type=self.operation_type,
            related_operation_lists=self.related_operation_lists)


def get_operation_v2(ext_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOperationV2Result:
    """
    Fetches an operation based on the external identifier.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    operation = nutanix.get_operation_v2(ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
    ```


    :param _builtins.str ext_id: ExtId of the Operation.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getOperationV2:getOperationV2', __args__, opts=opts, typ=GetOperationV2Result).value

    return AwaitableGetOperationV2Result(
        associated_endpoint_lists=pulumi.get(__ret__, 'associated_endpoint_lists'),
        client_name=pulumi.get(__ret__, 'client_name'),
        created_time=pulumi.get(__ret__, 'created_time'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        operation_type=pulumi.get(__ret__, 'operation_type'),
        related_operation_lists=pulumi.get(__ret__, 'related_operation_lists'))
def get_operation_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOperationV2Result]:
    """
    Fetches an operation based on the external identifier.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    operation = nutanix.get_operation_v2(ext_id="8a938cc5-282b-48c4-81be-de22de145d07")
    ```


    :param _builtins.str ext_id: ExtId of the Operation.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getOperationV2:getOperationV2', __args__, opts=opts, typ=GetOperationV2Result)
    return __ret__.apply(lambda __response__: GetOperationV2Result(
        associated_endpoint_lists=pulumi.get(__response__, 'associated_endpoint_lists'),
        client_name=pulumi.get(__response__, 'client_name'),
        created_time=pulumi.get(__response__, 'created_time'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        operation_type=pulumi.get(__response__, 'operation_type'),
        related_operation_lists=pulumi.get(__response__, 'related_operation_lists')))
