# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPbrResult',
    'AwaitableGetPbrResult',
    'get_pbr',
    'get_pbr_output',
]

@pulumi.output_type
class GetPbrResult:
    """
    A collection of values returned by getPbr.
    """
    def __init__(__self__, api_version=None, id=None, metadata=None, pbr_uuid=None, specs=None, statuses=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if pbr_uuid and not isinstance(pbr_uuid, str):
            raise TypeError("Expected argument 'pbr_uuid' to be a str")
        pulumi.set(__self__, "pbr_uuid", pbr_uuid)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        - The routing policies kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="pbrUuid")
    def pbr_uuid(self) -> _builtins.str:
        return pulumi.get(self, "pbr_uuid")

    @_builtins.property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetPbrSpecResult']:
        """
        PBR input spec
        """
        return pulumi.get(self, "specs")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Sequence['outputs.GetPbrStatusResult']:
        """
        PBR output status
        """
        return pulumi.get(self, "statuses")


class AwaitableGetPbrResult(GetPbrResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbrResult(
            api_version=self.api_version,
            id=self.id,
            metadata=self.metadata,
            pbr_uuid=self.pbr_uuid,
            specs=self.specs,
            statuses=self.statuses)


def get_pbr(pbr_uuid: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbrResult:
    """
    Provides a datasource to retrieve PBR with pbr_uuid .


    :param _builtins.str pbr_uuid: pbr UUID
    """
    __args__ = dict()
    __args__['pbrUuid'] = pbr_uuid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPbr:getPbr', __args__, opts=opts, typ=GetPbrResult).value

    return AwaitableGetPbrResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        pbr_uuid=pulumi.get(__ret__, 'pbr_uuid'),
        specs=pulumi.get(__ret__, 'specs'),
        statuses=pulumi.get(__ret__, 'statuses'))
def get_pbr_output(pbr_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPbrResult]:
    """
    Provides a datasource to retrieve PBR with pbr_uuid .


    :param _builtins.str pbr_uuid: pbr UUID
    """
    __args__ = dict()
    __args__['pbrUuid'] = pbr_uuid
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPbr:getPbr', __args__, opts=opts, typ=GetPbrResult)
    return __ret__.apply(lambda __response__: GetPbrResult(
        api_version=pulumi.get(__response__, 'api_version'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        pbr_uuid=pulumi.get(__response__, 'pbr_uuid'),
        specs=pulumi.get(__response__, 'specs'),
        statuses=pulumi.get(__response__, 'statuses')))
