# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPbrV2Result',
    'AwaitableGetPbrV2Result',
    'get_pbr_v2',
    'get_pbr_v2_output',
]

@pulumi.output_type
class GetPbrV2Result:
    """
    A collection of values returned by getPbrV2.
    """
    def __init__(__self__, description=None, ext_id=None, id=None, links=None, metadatas=None, name=None, policies=None, priority=None, tenant_id=None, vpc_ext_id=None, vpcs=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if vpc_ext_id and not isinstance(vpc_ext_id, str):
            raise TypeError("Expected argument 'vpc_ext_id' to be a str")
        pulumi.set(__self__, "vpc_ext_id", vpc_ext_id)
        if vpcs and not isinstance(vpcs, list):
            raise TypeError("Expected argument 'vpcs' to be a list")
        pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of the routing policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetPbrV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetPbrV2MetadataResult']:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the routing policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetPbrV2PolicyResult']:
        """
        Routing Policies
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Priority of the routing policy.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vpcExtId")
    def vpc_ext_id(self) -> _builtins.str:
        """
        ExtId of the VPC extId to which the routing policy belongs.
        """
        return pulumi.get(self, "vpc_ext_id")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Sequence['outputs.GetPbrV2VpcResult']:
        """
        VPC name for projections
        """
        return pulumi.get(self, "vpcs")


class AwaitableGetPbrV2Result(GetPbrV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbrV2Result(
            description=self.description,
            ext_id=self.ext_id,
            id=self.id,
            links=self.links,
            metadatas=self.metadatas,
            name=self.name,
            policies=self.policies,
            priority=self.priority,
            tenant_id=self.tenant_id,
            vpc_ext_id=self.vpc_ext_id,
            vpcs=self.vpcs)


def get_pbr_v2(ext_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbrV2Result:
    """
    Get a single Routing Policy corresponding to the extId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_pbr = nutanix.get_pbr_v2(ext_id="96a22c81-ed58-4bed-96bc-46b488626612")
    ```


    :param _builtins.str ext_id: pbr UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPbrV2:getPbrV2', __args__, opts=opts, typ=GetPbrV2Result).value

    return AwaitableGetPbrV2Result(
        description=pulumi.get(__ret__, 'description'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        policies=pulumi.get(__ret__, 'policies'),
        priority=pulumi.get(__ret__, 'priority'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        vpc_ext_id=pulumi.get(__ret__, 'vpc_ext_id'),
        vpcs=pulumi.get(__ret__, 'vpcs'))
def get_pbr_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPbrV2Result]:
    """
    Get a single Routing Policy corresponding to the extId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_pbr = nutanix.get_pbr_v2(ext_id="96a22c81-ed58-4bed-96bc-46b488626612")
    ```


    :param _builtins.str ext_id: pbr UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPbrV2:getPbrV2', __args__, opts=opts, typ=GetPbrV2Result)
    return __ret__.apply(lambda __response__: GetPbrV2Result(
        description=pulumi.get(__response__, 'description'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        name=pulumi.get(__response__, 'name'),
        policies=pulumi.get(__response__, 'policies'),
        priority=pulumi.get(__response__, 'priority'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        vpc_ext_id=pulumi.get(__response__, 'vpc_ext_id'),
        vpcs=pulumi.get(__response__, 'vpcs')))
