# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPbrsResult',
    'AwaitableGetPbrsResult',
    'get_pbrs',
    'get_pbrs_output',
]

@pulumi.output_type
class GetPbrsResult:
    """
    A collection of values returned by getPbrs.
    """
    def __init__(__self__, api_version=None, entities=None, id=None, metadatas=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if entities and not isinstance(entities, list):
            raise TypeError("Expected argument 'entities' to be a list")
        pulumi.set(__self__, "entities", entities)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        version of the API
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def entities(self) -> Sequence['outputs.GetPbrsEntityResult']:
        """
        List of PBRs.
        """
        return pulumi.get(self, "entities")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetPbrsMetadataResult']:
        """
        - The routing policies kind metadata.
        """
        return pulumi.get(self, "metadatas")


class AwaitableGetPbrsResult(GetPbrsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbrsResult(
            api_version=self.api_version,
            entities=self.entities,
            id=self.id,
            metadatas=self.metadatas)


def get_pbrs(metadatas: Optional[Sequence[Union['GetPbrsMetadataArgs', 'GetPbrsMetadataArgsDict']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbrsResult:
    """
    Provides a datasource to retrieve all the pbrs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test = nutanix.get_pbrs()
    ```


    :param Sequence[Union['GetPbrsMetadataArgs', 'GetPbrsMetadataArgsDict']] metadatas: - The routing policies kind metadata.
    """
    __args__ = dict()
    __args__['metadatas'] = metadatas
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPbrs:getPbrs', __args__, opts=opts, typ=GetPbrsResult).value

    return AwaitableGetPbrsResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        entities=pulumi.get(__ret__, 'entities'),
        id=pulumi.get(__ret__, 'id'),
        metadatas=pulumi.get(__ret__, 'metadatas'))
def get_pbrs_output(metadatas: Optional[pulumi.Input[Optional[Sequence[Union['GetPbrsMetadataArgs', 'GetPbrsMetadataArgsDict']]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPbrsResult]:
    """
    Provides a datasource to retrieve all the pbrs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test = nutanix.get_pbrs()
    ```


    :param Sequence[Union['GetPbrsMetadataArgs', 'GetPbrsMetadataArgsDict']] metadatas: - The routing policies kind metadata.
    """
    __args__ = dict()
    __args__['metadatas'] = metadatas
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPbrs:getPbrs', __args__, opts=opts, typ=GetPbrsResult)
    return __ret__.apply(lambda __response__: GetPbrsResult(
        api_version=pulumi.get(__response__, 'api_version'),
        entities=pulumi.get(__response__, 'entities'),
        id=pulumi.get(__response__, 'id'),
        metadatas=pulumi.get(__response__, 'metadatas')))
