# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPcBackupTargetV2Result',
    'AwaitableGetPcBackupTargetV2Result',
    'get_pc_backup_target_v2',
    'get_pc_backup_target_v2_output',
]

@pulumi.output_type
class GetPcBackupTargetV2Result:
    """
    A collection of values returned by getPcBackupTargetV2.
    """
    def __init__(__self__, backup_pause_reason=None, domain_manager_ext_id=None, ext_id=None, id=None, is_backup_paused=None, last_sync_time=None, links=None, locations=None, tenant_id=None):
        if backup_pause_reason and not isinstance(backup_pause_reason, str):
            raise TypeError("Expected argument 'backup_pause_reason' to be a str")
        pulumi.set(__self__, "backup_pause_reason", backup_pause_reason)
        if domain_manager_ext_id and not isinstance(domain_manager_ext_id, str):
            raise TypeError("Expected argument 'domain_manager_ext_id' to be a str")
        pulumi.set(__self__, "domain_manager_ext_id", domain_manager_ext_id)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_backup_paused and not isinstance(is_backup_paused, bool):
            raise TypeError("Expected argument 'is_backup_paused' to be a bool")
        pulumi.set(__self__, "is_backup_paused", is_backup_paused)
        if last_sync_time and not isinstance(last_sync_time, str):
            raise TypeError("Expected argument 'last_sync_time' to be a str")
        pulumi.set(__self__, "last_sync_time", last_sync_time)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="backupPauseReason")
    def backup_pause_reason(self) -> _builtins.str:
        """
        - Specifies a reason why the backup might have paused. This will be empty if the isBackupPaused field is false.
        """
        return pulumi.get(self, "backup_pause_reason")

    @_builtins.property
    @pulumi.getter(name="domainManagerExtId")
    def domain_manager_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "domain_manager_ext_id")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - Cluster UUID of a remote cluster.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isBackupPaused")
    def is_backup_paused(self) -> _builtins.bool:
        """
        - Whether the backup is paused on the given cluster or not.
        """
        return pulumi.get(self, "is_backup_paused")

    @_builtins.property
    @pulumi.getter(name="lastSyncTime")
    def last_sync_time(self) -> _builtins.str:
        """
        - Represents the time when the domain manager was last synchronized or copied its configuration data to the backup target. This field is updated every 30 minutes.
        """
        return pulumi.get(self, "last_sync_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetPcBackupTargetV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GetPcBackupTargetV2LocationResult']:
        """
        - Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetPcBackupTargetV2Result(GetPcBackupTargetV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPcBackupTargetV2Result(
            backup_pause_reason=self.backup_pause_reason,
            domain_manager_ext_id=self.domain_manager_ext_id,
            ext_id=self.ext_id,
            id=self.id,
            is_backup_paused=self.is_backup_paused,
            last_sync_time=self.last_sync_time,
            links=self.links,
            locations=self.locations,
            tenant_id=self.tenant_id)


def get_pc_backup_target_v2(domain_manager_ext_id: Optional[_builtins.str] = None,
                            ext_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPcBackupTargetV2Result:
    """
    Retrieves the backup targets (cluster or object store) from a domain manager and returns the backup configuration and lastSyncTimestamp parameter to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_pc_backup_target_v2(domain_manager_ext_id="75dde184-3a0e-4f59-a185-03ca1efead17",
        ext_id="00062d3d-5d07-0da6-0000-000000028f57")
    ```


    :param _builtins.str domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
    :param _builtins.str ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
    """
    __args__ = dict()
    __args__['domainManagerExtId'] = domain_manager_ext_id
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPcBackupTargetV2:getPcBackupTargetV2', __args__, opts=opts, typ=GetPcBackupTargetV2Result).value

    return AwaitableGetPcBackupTargetV2Result(
        backup_pause_reason=pulumi.get(__ret__, 'backup_pause_reason'),
        domain_manager_ext_id=pulumi.get(__ret__, 'domain_manager_ext_id'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        is_backup_paused=pulumi.get(__ret__, 'is_backup_paused'),
        last_sync_time=pulumi.get(__ret__, 'last_sync_time'),
        links=pulumi.get(__ret__, 'links'),
        locations=pulumi.get(__ret__, 'locations'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_pc_backup_target_v2_output(domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPcBackupTargetV2Result]:
    """
    Retrieves the backup targets (cluster or object store) from a domain manager and returns the backup configuration and lastSyncTimestamp parameter to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_pc_backup_target_v2(domain_manager_ext_id="75dde184-3a0e-4f59-a185-03ca1efead17",
        ext_id="00062d3d-5d07-0da6-0000-000000028f57")
    ```


    :param _builtins.str domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
    :param _builtins.str ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
    """
    __args__ = dict()
    __args__['domainManagerExtId'] = domain_manager_ext_id
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPcBackupTargetV2:getPcBackupTargetV2', __args__, opts=opts, typ=GetPcBackupTargetV2Result)
    return __ret__.apply(lambda __response__: GetPcBackupTargetV2Result(
        backup_pause_reason=pulumi.get(__response__, 'backup_pause_reason'),
        domain_manager_ext_id=pulumi.get(__response__, 'domain_manager_ext_id'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        is_backup_paused=pulumi.get(__response__, 'is_backup_paused'),
        last_sync_time=pulumi.get(__response__, 'last_sync_time'),
        links=pulumi.get(__response__, 'links'),
        locations=pulumi.get(__response__, 'locations'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
