# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPcBackupTargetsV2Result',
    'AwaitableGetPcBackupTargetsV2Result',
    'get_pc_backup_targets_v2',
    'get_pc_backup_targets_v2_output',
]

@pulumi.output_type
class GetPcBackupTargetsV2Result:
    """
    A collection of values returned by getPcBackupTargetsV2.
    """
    def __init__(__self__, backup_targets=None, domain_manager_ext_id=None, id=None):
        if backup_targets and not isinstance(backup_targets, list):
            raise TypeError("Expected argument 'backup_targets' to be a list")
        pulumi.set(__self__, "backup_targets", backup_targets)
        if domain_manager_ext_id and not isinstance(domain_manager_ext_id, str):
            raise TypeError("Expected argument 'domain_manager_ext_id' to be a str")
        pulumi.set(__self__, "domain_manager_ext_id", domain_manager_ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="backupTargets")
    def backup_targets(self) -> Sequence['outputs.GetPcBackupTargetsV2BackupTargetResult']:
        """
        - A list of backup target entities.
        """
        return pulumi.get(self, "backup_targets")

    @_builtins.property
    @pulumi.getter(name="domainManagerExtId")
    def domain_manager_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "domain_manager_ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetPcBackupTargetsV2Result(GetPcBackupTargetsV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPcBackupTargetsV2Result(
            backup_targets=self.backup_targets,
            domain_manager_ext_id=self.domain_manager_ext_id,
            id=self.id)


def get_pc_backup_targets_v2(domain_manager_ext_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPcBackupTargetsV2Result:
    """
    Lists backup targets (cluster or object store) configured for a given domain manager.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_pc_backup_targets_v2(domain_manager_ext_id="75dde184-3a0e-4f59-a185-03ca1efead17")
    ```

    ## Backup Targets

    The `backup_targets` argument supports the following:

    - `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    - `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    - `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    - `location`: - Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
    - `last_sync_time`: - Represents the time when the domain manager was last synchronized or copied its configuration data to the backup target. This field is updated every 30 minutes.
    - `is_backup_paused`: - Whether the backup is paused on the given cluster or not.
    - `backup_pause_reason`: - Specifies a reason why the backup might have paused. This will be empty if the isBackupPaused field is false.

    ### Location

    The location argument exports the following:

    - `cluster_location`: - A boolean value indicating whether to enable lockdown mode for a cluster.
    - `object_store_location`: - Currently representing the build information to be used for the cluster creation.

    #### Cluster Location

    The `cluster_location` argument exports the following:

    - `config`: - Cluster reference of the remote cluster to be connected.

    ##### Config

    The `config` argument exports the following:

    - `ext_id`: - Cluster UUID of a remote cluster.
    - `name`: - Name of the cluster.

    #### Object Store Location

    The `object_store_location` argument exports the following:

    - `provider_config`: -(Required) The base model of S3 object store endpoint where domain manager is backed up.
    - `backup_policy`: -(Optional) Backup policy for the object store provided.

    ##### Provider Config

    The `provider_config` argument exports the following:

    - `bucket_name`: - The bucket name of the object store endpoint where backup data of domain manager is to be stored.
    - `region`: - The region name of the object store endpoint where backup data of domain manager is stored. Default is `us-east-1`.
    - `credentials`: - Secret credentials model for the object store containing access key ID and secret access key.

    ###### Credentials

    The `credentials` argument exports the following:

    - `access_key_id`: - Access key ID for the object store provided for backup target.
    - `secret_access_key`: - Secret access key for the object store provided for backup target.

    ##### Backup Policy

    The `backup_policy` argument exports the following:

    - `rpo_in_minutes`: - RPO interval in minutes at which the backup will be taken. The Value should be in the range of 60 to 1440.

    See detailed information in [Nutanix List Backup Targets ](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/listBackupTargets).


    :param _builtins.str domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
    """
    __args__ = dict()
    __args__['domainManagerExtId'] = domain_manager_ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPcBackupTargetsV2:getPcBackupTargetsV2', __args__, opts=opts, typ=GetPcBackupTargetsV2Result).value

    return AwaitableGetPcBackupTargetsV2Result(
        backup_targets=pulumi.get(__ret__, 'backup_targets'),
        domain_manager_ext_id=pulumi.get(__ret__, 'domain_manager_ext_id'),
        id=pulumi.get(__ret__, 'id'))
def get_pc_backup_targets_v2_output(domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPcBackupTargetsV2Result]:
    """
    Lists backup targets (cluster or object store) configured for a given domain manager.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_pc_backup_targets_v2(domain_manager_ext_id="75dde184-3a0e-4f59-a185-03ca1efead17")
    ```

    ## Backup Targets

    The `backup_targets` argument supports the following:

    - `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    - `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    - `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    - `location`: - Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
    - `last_sync_time`: - Represents the time when the domain manager was last synchronized or copied its configuration data to the backup target. This field is updated every 30 minutes.
    - `is_backup_paused`: - Whether the backup is paused on the given cluster or not.
    - `backup_pause_reason`: - Specifies a reason why the backup might have paused. This will be empty if the isBackupPaused field is false.

    ### Location

    The location argument exports the following:

    - `cluster_location`: - A boolean value indicating whether to enable lockdown mode for a cluster.
    - `object_store_location`: - Currently representing the build information to be used for the cluster creation.

    #### Cluster Location

    The `cluster_location` argument exports the following:

    - `config`: - Cluster reference of the remote cluster to be connected.

    ##### Config

    The `config` argument exports the following:

    - `ext_id`: - Cluster UUID of a remote cluster.
    - `name`: - Name of the cluster.

    #### Object Store Location

    The `object_store_location` argument exports the following:

    - `provider_config`: -(Required) The base model of S3 object store endpoint where domain manager is backed up.
    - `backup_policy`: -(Optional) Backup policy for the object store provided.

    ##### Provider Config

    The `provider_config` argument exports the following:

    - `bucket_name`: - The bucket name of the object store endpoint where backup data of domain manager is to be stored.
    - `region`: - The region name of the object store endpoint where backup data of domain manager is stored. Default is `us-east-1`.
    - `credentials`: - Secret credentials model for the object store containing access key ID and secret access key.

    ###### Credentials

    The `credentials` argument exports the following:

    - `access_key_id`: - Access key ID for the object store provided for backup target.
    - `secret_access_key`: - Secret access key for the object store provided for backup target.

    ##### Backup Policy

    The `backup_policy` argument exports the following:

    - `rpo_in_minutes`: - RPO interval in minutes at which the backup will be taken. The Value should be in the range of 60 to 1440.

    See detailed information in [Nutanix List Backup Targets ](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/listBackupTargets).


    :param _builtins.str domain_manager_ext_id: -(Required) A unique identifier for the domain manager.
    """
    __args__ = dict()
    __args__['domainManagerExtId'] = domain_manager_ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPcBackupTargetsV2:getPcBackupTargetsV2', __args__, opts=opts, typ=GetPcBackupTargetsV2Result)
    return __ret__.apply(lambda __response__: GetPcBackupTargetsV2Result(
        backup_targets=pulumi.get(__response__, 'backup_targets'),
        domain_manager_ext_id=pulumi.get(__response__, 'domain_manager_ext_id'),
        id=pulumi.get(__response__, 'id')))
