# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPcRestorePointV2Result',
    'AwaitableGetPcRestorePointV2Result',
    'get_pc_restore_point_v2',
    'get_pc_restore_point_v2_output',
]

@pulumi.output_type
class GetPcRestorePointV2Result:
    """
    A collection of values returned by getPcRestorePointV2.
    """
    def __init__(__self__, creation_time=None, domain_managers=None, ext_id=None, id=None, links=None, restorable_domain_manager_ext_id=None, restore_source_ext_id=None, tenant_id=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if domain_managers and not isinstance(domain_managers, list):
            raise TypeError("Expected argument 'domain_managers' to be a list")
        pulumi.set(__self__, "domain_managers", domain_managers)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if restorable_domain_manager_ext_id and not isinstance(restorable_domain_manager_ext_id, str):
            raise TypeError("Expected argument 'restorable_domain_manager_ext_id' to be a str")
        pulumi.set(__self__, "restorable_domain_manager_ext_id", restorable_domain_manager_ext_id)
        if restore_source_ext_id and not isinstance(restore_source_ext_id, str):
            raise TypeError("Expected argument 'restore_source_ext_id' to be a str")
        pulumi.set(__self__, "restore_source_ext_id", restore_source_ext_id)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        The UTC date and time in ISO-8601 format when the Restore point was created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="domainManagers")
    def domain_managers(self) -> Sequence['outputs.GetPcRestorePointV2DomainManagerResult']:
        """
        Domain manager (Prism Central) details.
        """
        return pulumi.get(self, "domain_managers")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetPcRestorePointV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="restorableDomainManagerExtId")
    def restorable_domain_manager_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "restorable_domain_manager_ext_id")

    @_builtins.property
    @pulumi.getter(name="restoreSourceExtId")
    def restore_source_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "restore_source_ext_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetPcRestorePointV2Result(GetPcRestorePointV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPcRestorePointV2Result(
            creation_time=self.creation_time,
            domain_managers=self.domain_managers,
            ext_id=self.ext_id,
            id=self.id,
            links=self.links,
            restorable_domain_manager_ext_id=self.restorable_domain_manager_ext_id,
            restore_source_ext_id=self.restore_source_ext_id,
            tenant_id=self.tenant_id)


def get_pc_restore_point_v2(ext_id: Optional[_builtins.str] = None,
                            restorable_domain_manager_ext_id: Optional[_builtins.str] = None,
                            restore_source_ext_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPcRestorePointV2Result:
    """
    Retrieves detailed information about a specific recovery point and provides essential domain manager information stored in the backup, which is required for the restoration process.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # this is PE based module, so use PE provider alias
    get_restore_point = nutanix.get_pc_restore_point_v2(restorable_domain_manager_ext_id=test_nutanix_restorable_pcs_v2["restorablePcs"][0]["extId"],
        restore_source_ext_id=cluster_location["id"],
        ext_id=test["restorePoints"][0]["extId"])
    ```


    :param _builtins.str ext_id: Restore point ID for the backup created in cluster/object store.
    :param _builtins.str restorable_domain_manager_ext_id: A unique identifier for the domain manager.
    :param _builtins.str restore_source_ext_id: A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['restorableDomainManagerExtId'] = restorable_domain_manager_ext_id
    __args__['restoreSourceExtId'] = restore_source_ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPcRestorePointV2:getPcRestorePointV2', __args__, opts=opts, typ=GetPcRestorePointV2Result).value

    return AwaitableGetPcRestorePointV2Result(
        creation_time=pulumi.get(__ret__, 'creation_time'),
        domain_managers=pulumi.get(__ret__, 'domain_managers'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        restorable_domain_manager_ext_id=pulumi.get(__ret__, 'restorable_domain_manager_ext_id'),
        restore_source_ext_id=pulumi.get(__ret__, 'restore_source_ext_id'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_pc_restore_point_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   restorable_domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   restore_source_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPcRestorePointV2Result]:
    """
    Retrieves detailed information about a specific recovery point and provides essential domain manager information stored in the backup, which is required for the restoration process.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # this is PE based module, so use PE provider alias
    get_restore_point = nutanix.get_pc_restore_point_v2(restorable_domain_manager_ext_id=test_nutanix_restorable_pcs_v2["restorablePcs"][0]["extId"],
        restore_source_ext_id=cluster_location["id"],
        ext_id=test["restorePoints"][0]["extId"])
    ```


    :param _builtins.str ext_id: Restore point ID for the backup created in cluster/object store.
    :param _builtins.str restorable_domain_manager_ext_id: A unique identifier for the domain manager.
    :param _builtins.str restore_source_ext_id: A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['restorableDomainManagerExtId'] = restorable_domain_manager_ext_id
    __args__['restoreSourceExtId'] = restore_source_ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPcRestorePointV2:getPcRestorePointV2', __args__, opts=opts, typ=GetPcRestorePointV2Result)
    return __ret__.apply(lambda __response__: GetPcRestorePointV2Result(
        creation_time=pulumi.get(__response__, 'creation_time'),
        domain_managers=pulumi.get(__response__, 'domain_managers'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        restorable_domain_manager_ext_id=pulumi.get(__response__, 'restorable_domain_manager_ext_id'),
        restore_source_ext_id=pulumi.get(__response__, 'restore_source_ext_id'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
