# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPcRestorePointsV2Result',
    'AwaitableGetPcRestorePointsV2Result',
    'get_pc_restore_points_v2',
    'get_pc_restore_points_v2_output',
]

@pulumi.output_type
class GetPcRestorePointsV2Result:
    """
    A collection of values returned by getPcRestorePointsV2.
    """
    def __init__(__self__, filter=None, id=None, limit=None, order_by=None, page=None, restorable_domain_manager_ext_id=None, restore_points=None, restore_source_ext_id=None, select=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if restorable_domain_manager_ext_id and not isinstance(restorable_domain_manager_ext_id, str):
            raise TypeError("Expected argument 'restorable_domain_manager_ext_id' to be a str")
        pulumi.set(__self__, "restorable_domain_manager_ext_id", restorable_domain_manager_ext_id)
        if restore_points and not isinstance(restore_points, list):
            raise TypeError("Expected argument 'restore_points' to be a list")
        pulumi.set(__self__, "restore_points", restore_points)
        if restore_source_ext_id and not isinstance(restore_source_ext_id, str):
            raise TypeError("Expected argument 'restore_source_ext_id' to be a str")
        pulumi.set(__self__, "restore_source_ext_id", restore_source_ext_id)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter(name="restorableDomainManagerExtId")
    def restorable_domain_manager_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "restorable_domain_manager_ext_id")

    @_builtins.property
    @pulumi.getter(name="restorePoints")
    def restore_points(self) -> Sequence['outputs.GetPcRestorePointsV2RestorePointResult']:
        """
        A list of restore points.
        """
        return pulumi.get(self, "restore_points")

    @_builtins.property
    @pulumi.getter(name="restoreSourceExtId")
    def restore_source_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "restore_source_ext_id")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")


class AwaitableGetPcRestorePointsV2Result(GetPcRestorePointsV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPcRestorePointsV2Result(
            filter=self.filter,
            id=self.id,
            limit=self.limit,
            order_by=self.order_by,
            page=self.page,
            restorable_domain_manager_ext_id=self.restorable_domain_manager_ext_id,
            restore_points=self.restore_points,
            restore_source_ext_id=self.restore_source_ext_id,
            select=self.select)


def get_pc_restore_points_v2(filter: Optional[_builtins.str] = None,
                             limit: Optional[_builtins.int] = None,
                             order_by: Optional[_builtins.str] = None,
                             page: Optional[_builtins.int] = None,
                             restorable_domain_manager_ext_id: Optional[_builtins.str] = None,
                             restore_source_ext_id: Optional[_builtins.str] = None,
                             select: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPcRestorePointsV2Result:
    """
    The list restore points API allows you to retrieve a list of available restore points, which are snapshots of the domain manager taken at different times. These restore points can be used to revert the domain manager to a previous state. The list response includes the creation time and identifier ID for the configuration data.

    - For cluster-based backups, only the most recent restore point is available, as backups are continuous.
    - For object store-based backups, multiple restore points may be available, depending on the configured Recovery Point Objective (RPO) and the retention period set on the s3 bucket.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # This pe based module, so use pe provider alias
    restore_points = nutanix.get_pc_restore_points_v2(restorable_domain_manager_ext_id="1cf35cfe-a341-4f27-8e31-2f51b79302c4",
        restore_source_ext_id="ec77405b-16c5-4c8d-ade1-bede241afae0")
    # list all the restorable pcs with select properties
    restore_points_select = nutanix.get_pc_restore_points_v2(restorable_domain_manager_ext_id="1cf35cfe-a341-4f27-8e31-2f51b79302c4",
        restore_source_ext_id="ec77405b-16c5-4c8d-ade1-bede241afae0",
        select="creationTime,domainManager,extId")
    ```

    ## Restore Points

    The restore_points attribute supports the following:

    - `ext_id`: A globally unique identifier of an instance that is suitable for external consumption.
    - `tenant_id`: A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    - `links`: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    - `creation_time`: The UTC date and time in ISO-8601 format when the Restore point was created.
    - `domain_manager`: Domain manager (Prism Central) details.

    ### Links

    The links attribute supports the following:

    - `href`: - The URL at which the entity described by the link can be accessed.
    - `rel`: - A name that identifies the relationship of the link to the object that is returned by the URL. The unique value of "self" identifies the URL for the object.

    ### Domain Manager

    The domain_manager attribute supports the following:

    - `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    - `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    - `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    - `config`: - Domain manager (Prism Central) cluster configuration details.
    - `is_registered_with_hosting_cluster`: - Boolean value indicating if the domain manager (Prism Central) is registered with the hosting cluster, that is, Prism Element.
    - `network`: - Domain manager (Prism Central) network configuration details.
    - `hosting_cluster_ext_id`: - The external identifier of the cluster hosting the domain manager (Prism Central) instance.
    - `should_enable_high_availability`: - This configuration enables Prism Central to be deployed in scale-out mode.
    - `node_ext_ids`: - Domain manager (Prism Central) nodes external identifier.

    ### Config

    The config argument supports the following :

    - `should_enable_lockdown_mode`: - A boolean value indicating whether to enable lockdown mode for a cluster.
    - `build_info`: -Currently representing the build information to be used for the cluster creation.
    - `name`: - Name of the domain manager (Prism Central).
    - `size`: - Domain manager (Prism Central) size is an enumeration of starter, small, large, or extra large starter values. possible values are:
      - `SMALL` : Domain manager (Prism Central) of size small.
      - `LARGE` : Domain manager (Prism Central) of size large.
      - `EXTRALARGE` : Domain manager (Prism Central) of size extra large.
      - `STARTER` : Domain manager (Prism Central) of size starter.
    - `bootstrap_config`: - Bootstrap configuration details for the domain manager (Prism Central).
    - `resource_config`: - This configuration is used to provide the resource-related details like container external identifiers, number of VCPUs, memory size, data disk size of the domain manager (Prism Central). In the case of a multi-node setup, the sum of resources like number of VCPUs, memory size and data disk size are provided.

    #### Build Info

    The `build_info` argument supports the following:

    - `version`: - Software version.

    #### Bootstrap Config

    The `bootstrap_config` argument supports the following:

    - `environment_info`: - Environment information for the domain manager (Prism Central) cluster.

    ##### Environment Info

    The `environment_info` argument supports the following:

    - `type`: - Enums denoting the environment type of the PC, that is, on-prem PC or cloud PC.
      Following are the supported entity types:
      - `ONPREM` : On-prem environment.
      - `NTNX_CLOUD` : Nutanix cloud environment.
    - `provider_type`: - Enums denoting the provider type of the PC, that is, AHV or ESXi.
      Following are the supported provider types:
      - `VSPHERE` : Vsphere cloud provider.
      - `AZURE` : Azure cloud provider.
      - `NTNX` : Nutanix cloud provider.
      - `GCP` : GCP cloud provider.
      - `AWS` : AWS cloud provider.
    - `provisioning_type`: - Enums denoting the instance type of the cloud PC. It indicates whether the PC is created on bare-metal or on a cloud-provisioned VM. Hence, it supports two possible values:
      - `NTNX` : Nutanix instance.
      - `NATIVE` : Native instance.

    #### Resource Config

    The `resource_config` argument supports the following:

    - `num_vcpus`: - This property is used for readOnly purposes to display Prism Central number of VCPUs allocation.
    - `memory_size_bytes`: - This property is used for readOnly purposes to display Prism Central RAM allocation at the cluster level.
    - `data_disk_size_bytes`: - This property is used for readOnly purposes to display Prism Central data disk size allocation at a cluster level.
    - `container_ext_ids`: - The external identifier of the container that will be used to create the domain manager (Prism Central) cluster.

    ### Network

    the `network` argument supports the following:

    - `external_address`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    - `name_servers`: - List of name servers on a cluster. This is part of payload for both cluster create & update operations. For create operation, only ipv4 address / fqdn values are supported currently.
    - `ntp_servers`: - List of NTP servers on a cluster. This is part of payload for both cluster create & update operations. For create operation, only ipv4 address / fqdn values are supported currently.
    - `fqdn`: - Cluster fully qualified domain name. This is part of payload for cluster update operation only.
    - `external_networks`: - This configuration is used to manage Prism Central.

    #### External Address

    The `external_address` argument supports the following:

    - `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    - `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### Name Servers, NTP Servers

    The `name_servers` and `ntp_servers` arguments support the following:

    - `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    - `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    - `fqdn`: - A fully qualified domain name that specifies its exact location in the tree hierarchy of the Domain Name System.

    #### External Networks

    The `external_networks` argument supports the following:

    - `default_gateway`: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
    - `subnet_mask`: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
    - `ip_ranges`: - Range of IPs used for Prism Central network setup.
    - `network_ext_id`: - The network external identifier to which Domain Manager (Prism Central) is to be deployed or is already configured.

    #### Default Gateway, Subnet Mask

    The `default_gateway`and `subnet_mask` arguments support the following:

    - `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    - `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    - `fqdn`: - A fully qualified domain name that specifies its exact location in the tree hierarchy of the Domain Name System.

    #### IP Ranges

    The `ip_ranges` argument supports the following:

    - `begin`: - The beginning IP address of the range.
    - `end`: - The ending IP address of the range.

    #### begin, end

    The `begin` and `end` arguments support the following:

    - `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    - `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### IpV4, IpV6

    The `ipv4` and `ipv6` arguments support the following:

    - `value`: - The IPv4/IPv6 address of the host.
    - `prefix_length`: - The prefix length of the network to which this host IPv4/IPv6 address belongs.

    #### FQDN

    The `fqdn` argument supports the following:

    - `value`: - The fully qualified domain name of the host.

    See detailed information in [Nutanix List Restore Points V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/listRestorePoints).


    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources.
           - The filter can be applied to the following fields:
           - `creationTime`
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default
           - The orderby can be applied to the following fields:
           - `creationTime`
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str restorable_domain_manager_ext_id: A unique identifier for the domain manager.
    :param _builtins.str restore_source_ext_id: A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions
           - The select can be applied to the following fields:
           - `creationTime`
           - `domainManager`
           - `extId`
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['restorableDomainManagerExtId'] = restorable_domain_manager_ext_id
    __args__['restoreSourceExtId'] = restore_source_ext_id
    __args__['select'] = select
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPcRestorePointsV2:getPcRestorePointsV2', __args__, opts=opts, typ=GetPcRestorePointsV2Result).value

    return AwaitableGetPcRestorePointsV2Result(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        restorable_domain_manager_ext_id=pulumi.get(__ret__, 'restorable_domain_manager_ext_id'),
        restore_points=pulumi.get(__ret__, 'restore_points'),
        restore_source_ext_id=pulumi.get(__ret__, 'restore_source_ext_id'),
        select=pulumi.get(__ret__, 'select'))
def get_pc_restore_points_v2_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                    order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                    restorable_domain_manager_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    restore_source_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPcRestorePointsV2Result]:
    """
    The list restore points API allows you to retrieve a list of available restore points, which are snapshots of the domain manager taken at different times. These restore points can be used to revert the domain manager to a previous state. The list response includes the creation time and identifier ID for the configuration data.

    - For cluster-based backups, only the most recent restore point is available, as backups are continuous.
    - For object store-based backups, multiple restore points may be available, depending on the configured Recovery Point Objective (RPO) and the retention period set on the s3 bucket.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # This pe based module, so use pe provider alias
    restore_points = nutanix.get_pc_restore_points_v2(restorable_domain_manager_ext_id="1cf35cfe-a341-4f27-8e31-2f51b79302c4",
        restore_source_ext_id="ec77405b-16c5-4c8d-ade1-bede241afae0")
    # list all the restorable pcs with select properties
    restore_points_select = nutanix.get_pc_restore_points_v2(restorable_domain_manager_ext_id="1cf35cfe-a341-4f27-8e31-2f51b79302c4",
        restore_source_ext_id="ec77405b-16c5-4c8d-ade1-bede241afae0",
        select="creationTime,domainManager,extId")
    ```

    ## Restore Points

    The restore_points attribute supports the following:

    - `ext_id`: A globally unique identifier of an instance that is suitable for external consumption.
    - `tenant_id`: A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    - `links`: A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    - `creation_time`: The UTC date and time in ISO-8601 format when the Restore point was created.
    - `domain_manager`: Domain manager (Prism Central) details.

    ### Links

    The links attribute supports the following:

    - `href`: - The URL at which the entity described by the link can be accessed.
    - `rel`: - A name that identifies the relationship of the link to the object that is returned by the URL. The unique value of "self" identifies the URL for the object.

    ### Domain Manager

    The domain_manager attribute supports the following:

    - `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    - `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    - `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    - `config`: - Domain manager (Prism Central) cluster configuration details.
    - `is_registered_with_hosting_cluster`: - Boolean value indicating if the domain manager (Prism Central) is registered with the hosting cluster, that is, Prism Element.
    - `network`: - Domain manager (Prism Central) network configuration details.
    - `hosting_cluster_ext_id`: - The external identifier of the cluster hosting the domain manager (Prism Central) instance.
    - `should_enable_high_availability`: - This configuration enables Prism Central to be deployed in scale-out mode.
    - `node_ext_ids`: - Domain manager (Prism Central) nodes external identifier.

    ### Config

    The config argument supports the following :

    - `should_enable_lockdown_mode`: - A boolean value indicating whether to enable lockdown mode for a cluster.
    - `build_info`: -Currently representing the build information to be used for the cluster creation.
    - `name`: - Name of the domain manager (Prism Central).
    - `size`: - Domain manager (Prism Central) size is an enumeration of starter, small, large, or extra large starter values. possible values are:
      - `SMALL` : Domain manager (Prism Central) of size small.
      - `LARGE` : Domain manager (Prism Central) of size large.
      - `EXTRALARGE` : Domain manager (Prism Central) of size extra large.
      - `STARTER` : Domain manager (Prism Central) of size starter.
    - `bootstrap_config`: - Bootstrap configuration details for the domain manager (Prism Central).
    - `resource_config`: - This configuration is used to provide the resource-related details like container external identifiers, number of VCPUs, memory size, data disk size of the domain manager (Prism Central). In the case of a multi-node setup, the sum of resources like number of VCPUs, memory size and data disk size are provided.

    #### Build Info

    The `build_info` argument supports the following:

    - `version`: - Software version.

    #### Bootstrap Config

    The `bootstrap_config` argument supports the following:

    - `environment_info`: - Environment information for the domain manager (Prism Central) cluster.

    ##### Environment Info

    The `environment_info` argument supports the following:

    - `type`: - Enums denoting the environment type of the PC, that is, on-prem PC or cloud PC.
      Following are the supported entity types:
      - `ONPREM` : On-prem environment.
      - `NTNX_CLOUD` : Nutanix cloud environment.
    - `provider_type`: - Enums denoting the provider type of the PC, that is, AHV or ESXi.
      Following are the supported provider types:
      - `VSPHERE` : Vsphere cloud provider.
      - `AZURE` : Azure cloud provider.
      - `NTNX` : Nutanix cloud provider.
      - `GCP` : GCP cloud provider.
      - `AWS` : AWS cloud provider.
    - `provisioning_type`: - Enums denoting the instance type of the cloud PC. It indicates whether the PC is created on bare-metal or on a cloud-provisioned VM. Hence, it supports two possible values:
      - `NTNX` : Nutanix instance.
      - `NATIVE` : Native instance.

    #### Resource Config

    The `resource_config` argument supports the following:

    - `num_vcpus`: - This property is used for readOnly purposes to display Prism Central number of VCPUs allocation.
    - `memory_size_bytes`: - This property is used for readOnly purposes to display Prism Central RAM allocation at the cluster level.
    - `data_disk_size_bytes`: - This property is used for readOnly purposes to display Prism Central data disk size allocation at a cluster level.
    - `container_ext_ids`: - The external identifier of the container that will be used to create the domain manager (Prism Central) cluster.

    ### Network

    the `network` argument supports the following:

    - `external_address`: - An unique address that identifies a device on the internet or a local network in IPv4 or IPv6 format.
    - `name_servers`: - List of name servers on a cluster. This is part of payload for both cluster create & update operations. For create operation, only ipv4 address / fqdn values are supported currently.
    - `ntp_servers`: - List of NTP servers on a cluster. This is part of payload for both cluster create & update operations. For create operation, only ipv4 address / fqdn values are supported currently.
    - `fqdn`: - Cluster fully qualified domain name. This is part of payload for cluster update operation only.
    - `external_networks`: - This configuration is used to manage Prism Central.

    #### External Address

    The `external_address` argument supports the following:

    - `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    - `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### Name Servers, NTP Servers

    The `name_servers` and `ntp_servers` arguments support the following:

    - `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    - `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    - `fqdn`: - A fully qualified domain name that specifies its exact location in the tree hierarchy of the Domain Name System.

    #### External Networks

    The `external_networks` argument supports the following:

    - `default_gateway`: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
    - `subnet_mask`: - An unique address that identifies a device on the internet or a local network in IPv4/IPv6 format or a Fully Qualified Domain Name.
    - `ip_ranges`: - Range of IPs used for Prism Central network setup.
    - `network_ext_id`: - The network external identifier to which Domain Manager (Prism Central) is to be deployed or is already configured.

    #### Default Gateway, Subnet Mask

    The `default_gateway`and `subnet_mask` arguments support the following:

    - `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    - `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.
    - `fqdn`: - A fully qualified domain name that specifies its exact location in the tree hierarchy of the Domain Name System.

    #### IP Ranges

    The `ip_ranges` argument supports the following:

    - `begin`: - The beginning IP address of the range.
    - `end`: - The ending IP address of the range.

    #### begin, end

    The `begin` and `end` arguments support the following:

    - `ipv4`: - An unique address that identifies a device on the internet or a local network in IPv4 format.
    - `ipv6`: - An unique address that identifies a device on the internet or a local network in IPv6 format.

    #### IpV4, IpV6

    The `ipv4` and `ipv6` arguments support the following:

    - `value`: - The IPv4/IPv6 address of the host.
    - `prefix_length`: - The prefix length of the network to which this host IPv4/IPv6 address belongs.

    #### FQDN

    The `fqdn` argument supports the following:

    - `value`: - The fully qualified domain name of the host.

    See detailed information in [Nutanix List Restore Points V4](https://developers.nutanix.com/api-reference?namespace=prism&version=v4.0#tag/DomainManager/operation/listRestorePoints).


    :param _builtins.str filter: A URL query parameter that allows clients to filter a collection of resources.
           - The filter can be applied to the following fields:
           - `creationTime`
    :param _builtins.int limit: A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default
           - The orderby can be applied to the following fields:
           - `creationTime`
    :param _builtins.int page: A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str restorable_domain_manager_ext_id: A unique identifier for the domain manager.
    :param _builtins.str restore_source_ext_id: A unique identifier obtained from the restore source API that corresponds to the details provided for the restore source.
    :param _builtins.str select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions
           - The select can be applied to the following fields:
           - `creationTime`
           - `domainManager`
           - `extId`
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['restorableDomainManagerExtId'] = restorable_domain_manager_ext_id
    __args__['restoreSourceExtId'] = restore_source_ext_id
    __args__['select'] = select
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPcRestorePointsV2:getPcRestorePointsV2', __args__, opts=opts, typ=GetPcRestorePointsV2Result)
    return __ret__.apply(lambda __response__: GetPcRestorePointsV2Result(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        restorable_domain_manager_ext_id=pulumi.get(__response__, 'restorable_domain_manager_ext_id'),
        restore_points=pulumi.get(__response__, 'restore_points'),
        restore_source_ext_id=pulumi.get(__response__, 'restore_source_ext_id'),
        select=pulumi.get(__response__, 'select')))
