# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPcRestoreSourceV2Result',
    'AwaitableGetPcRestoreSourceV2Result',
    'get_pc_restore_source_v2',
    'get_pc_restore_source_v2_output',
]

@pulumi.output_type
class GetPcRestoreSourceV2Result:
    """
    A collection of values returned by getPcRestoreSourceV2.
    """
    def __init__(__self__, ext_id=None, id=None, links=None, locations=None, tenant_id=None):
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - Cluster UUID of a remote cluster.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetPcRestoreSourceV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GetPcRestoreSourceV2LocationResult']:
        """
        - Location of the backup target. For example, a cluster or an object store endpoint, such as AWS s3.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetPcRestoreSourceV2Result(GetPcRestoreSourceV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPcRestoreSourceV2Result(
            ext_id=self.ext_id,
            id=self.id,
            links=self.links,
            locations=self.locations,
            tenant_id=self.tenant_id)


def get_pc_restore_source_v2(ext_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPcRestoreSourceV2Result:
    """
    Retrieves the restore source from the PE cache store and returns the restore source configuration and external identifier to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # get the restore source
    restore_source = nutanix.get_pc_restore_source_v2(ext_id="323860ca-bd10-411e-9fe0-1430b62eaf45")
    ```


    :param _builtins.str ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPcRestoreSourceV2:getPcRestoreSourceV2', __args__, opts=opts, typ=GetPcRestoreSourceV2Result).value

    return AwaitableGetPcRestoreSourceV2Result(
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        locations=pulumi.get(__ret__, 'locations'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_pc_restore_source_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPcRestoreSourceV2Result]:
    """
    Retrieves the restore source from the PE cache store and returns the restore source configuration and external identifier to the user.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # get the restore source
    restore_source = nutanix.get_pc_restore_source_v2(ext_id="323860ca-bd10-411e-9fe0-1430b62eaf45")
    ```


    :param _builtins.str ext_id: -(Required) A globally unique identifier of an instance that is suitable for external consumption.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPcRestoreSourceV2:getPcRestoreSourceV2', __args__, opts=opts, typ=GetPcRestoreSourceV2Result)
    return __ret__.apply(lambda __response__: GetPcRestoreSourceV2Result(
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        locations=pulumi.get(__response__, 'locations'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
