# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPcV2Result',
    'AwaitableGetPcV2Result',
    'get_pc_v2',
    'get_pc_v2_output',
]

@pulumi.output_type
class GetPcV2Result:
    """
    A collection of values returned by getPcV2.
    """
    def __init__(__self__, configs=None, ext_id=None, hosting_cluster_ext_id=None, id=None, is_registered_with_hosting_cluster=None, links=None, networks=None, node_ext_ids=None, should_enable_high_availability=None, tenant_id=None):
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if hosting_cluster_ext_id and not isinstance(hosting_cluster_ext_id, str):
            raise TypeError("Expected argument 'hosting_cluster_ext_id' to be a str")
        pulumi.set(__self__, "hosting_cluster_ext_id", hosting_cluster_ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_registered_with_hosting_cluster and not isinstance(is_registered_with_hosting_cluster, bool):
            raise TypeError("Expected argument 'is_registered_with_hosting_cluster' to be a bool")
        pulumi.set(__self__, "is_registered_with_hosting_cluster", is_registered_with_hosting_cluster)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if node_ext_ids and not isinstance(node_ext_ids, list):
            raise TypeError("Expected argument 'node_ext_ids' to be a list")
        pulumi.set(__self__, "node_ext_ids", node_ext_ids)
        if should_enable_high_availability and not isinstance(should_enable_high_availability, bool):
            raise TypeError("Expected argument 'should_enable_high_availability' to be a bool")
        pulumi.set(__self__, "should_enable_high_availability", should_enable_high_availability)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetPcV2ConfigResult']:
        """
        - Domain manager (Prism Central) cluster configuration details.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="hostingClusterExtId")
    def hosting_cluster_ext_id(self) -> _builtins.str:
        """
        - The external identifier of the cluster hosting the domain manager (Prism Central) instance.
        """
        return pulumi.get(self, "hosting_cluster_ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isRegisteredWithHostingCluster")
    def is_registered_with_hosting_cluster(self) -> _builtins.bool:
        """
        - Boolean value indicating if the domain manager (Prism Central) is registered with the hosting cluster, that is, Prism Element.
        """
        return pulumi.get(self, "is_registered_with_hosting_cluster")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetPcV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetPcV2NetworkResult']:
        """
        - Domain manager (Prism Central) network configuration details.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="nodeExtIds")
    def node_ext_ids(self) -> Sequence[_builtins.str]:
        """
        - Domain manager (Prism Central) nodes external identifier.
        """
        return pulumi.get(self, "node_ext_ids")

    @_builtins.property
    @pulumi.getter(name="shouldEnableHighAvailability")
    def should_enable_high_availability(self) -> Optional[_builtins.bool]:
        """
        - This configuration enables Prism Central to be deployed in scale-out mode.
        """
        return pulumi.get(self, "should_enable_high_availability")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetPcV2Result(GetPcV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPcV2Result(
            configs=self.configs,
            ext_id=self.ext_id,
            hosting_cluster_ext_id=self.hosting_cluster_ext_id,
            id=self.id,
            is_registered_with_hosting_cluster=self.is_registered_with_hosting_cluster,
            links=self.links,
            networks=self.networks,
            node_ext_ids=self.node_ext_ids,
            should_enable_high_availability=self.should_enable_high_availability,
            tenant_id=self.tenant_id)


def get_pc_v2(ext_id: Optional[_builtins.str] = None,
              should_enable_high_availability: Optional[_builtins.bool] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPcV2Result:
    """
    Fetches the attributes associated with the domain manager (Prism Central) resource based on the provided external identifier. It includes attributes like config, network, node and other information such as size, environment and resource specifications.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Fetch a single PC (Domain Manager) by its external ID
    example_2 = nutanix.get_pc_v2(ext_id="75dde184-3a0e-4f59-a185-03ca1efead17")
    ```


    :param _builtins.str ext_id: -(Required) The external identifier of the domain manager (Prism Central) entity.
    :param _builtins.bool should_enable_high_availability: - This configuration enables Prism Central to be deployed in scale-out mode.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['shouldEnableHighAvailability'] = should_enable_high_availability
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPcV2:getPcV2', __args__, opts=opts, typ=GetPcV2Result).value

    return AwaitableGetPcV2Result(
        configs=pulumi.get(__ret__, 'configs'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        hosting_cluster_ext_id=pulumi.get(__ret__, 'hosting_cluster_ext_id'),
        id=pulumi.get(__ret__, 'id'),
        is_registered_with_hosting_cluster=pulumi.get(__ret__, 'is_registered_with_hosting_cluster'),
        links=pulumi.get(__ret__, 'links'),
        networks=pulumi.get(__ret__, 'networks'),
        node_ext_ids=pulumi.get(__ret__, 'node_ext_ids'),
        should_enable_high_availability=pulumi.get(__ret__, 'should_enable_high_availability'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_pc_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                     should_enable_high_availability: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPcV2Result]:
    """
    Fetches the attributes associated with the domain manager (Prism Central) resource based on the provided external identifier. It includes attributes like config, network, node and other information such as size, environment and resource specifications.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # Fetch a single PC (Domain Manager) by its external ID
    example_2 = nutanix.get_pc_v2(ext_id="75dde184-3a0e-4f59-a185-03ca1efead17")
    ```


    :param _builtins.str ext_id: -(Required) The external identifier of the domain manager (Prism Central) entity.
    :param _builtins.bool should_enable_high_availability: - This configuration enables Prism Central to be deployed in scale-out mode.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['shouldEnableHighAvailability'] = should_enable_high_availability
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPcV2:getPcV2', __args__, opts=opts, typ=GetPcV2Result)
    return __ret__.apply(lambda __response__: GetPcV2Result(
        configs=pulumi.get(__response__, 'configs'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        hosting_cluster_ext_id=pulumi.get(__response__, 'hosting_cluster_ext_id'),
        id=pulumi.get(__response__, 'id'),
        is_registered_with_hosting_cluster=pulumi.get(__response__, 'is_registered_with_hosting_cluster'),
        links=pulumi.get(__response__, 'links'),
        networks=pulumi.get(__response__, 'networks'),
        node_ext_ids=pulumi.get(__response__, 'node_ext_ids'),
        should_enable_high_availability=pulumi.get(__response__, 'should_enable_high_availability'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
