# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPermissionResult',
    'AwaitableGetPermissionResult',
    'get_permission',
    'get_permission_output',
]

@pulumi.output_type
class GetPermissionResult:
    """
    A collection of values returned by getPermission.
    """
    def __init__(__self__, api_version=None, categories=None, description=None, fields=None, id=None, kind=None, metadata=None, name=None, operation=None, owner_reference=None, permission_id=None, permission_name=None, project_reference=None, state=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operation and not isinstance(operation, str):
            raise TypeError("Expected argument 'operation' to be a str")
        pulumi.set(__self__, "operation", operation)
        if owner_reference and not isinstance(owner_reference, dict):
            raise TypeError("Expected argument 'owner_reference' to be a dict")
        pulumi.set(__self__, "owner_reference", owner_reference)
        if permission_id and not isinstance(permission_id, str):
            raise TypeError("Expected argument 'permission_id' to be a str")
        pulumi.set(__self__, "permission_id", permission_id)
        if permission_name and not isinstance(permission_name, str):
            raise TypeError("Expected argument 'permission_name' to be a str")
        pulumi.set(__self__, "permission_name", permission_name)
        if project_reference and not isinstance(project_reference, dict):
            raise TypeError("Expected argument 'project_reference' to be a dict")
        pulumi.set(__self__, "project_reference", project_reference)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetPermissionCategoryResult']:
        """
        The categories for this resource.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description for the permission.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.GetPermissionFieldResult']:
        """
        . The fields that can/cannot be accessed during the specified operation. field_name_list will be a list of fields. e.g. if field_mode = disallowed, field_name_list = [“xyz”] then the list of allowed fields is ALL fields minus xyz. Seee Field for more info.
        """
        return pulumi.get(self, "fields")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        (Required) The kind name (Default value: `project`).
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        The permission kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        the name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        The operation that is being performed on a given kind.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Mapping[str, _builtins.str]:
        """
        The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="permissionId")
    def permission_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "permission_id")

    @_builtins.property
    @pulumi.getter(name="permissionName")
    def permission_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "permission_name")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Mapping[str, _builtins.str]:
        """
        The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the permission.
        """
        return pulumi.get(self, "state")


class AwaitableGetPermissionResult(GetPermissionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPermissionResult(
            api_version=self.api_version,
            categories=self.categories,
            description=self.description,
            fields=self.fields,
            id=self.id,
            kind=self.kind,
            metadata=self.metadata,
            name=self.name,
            operation=self.operation,
            owner_reference=self.owner_reference,
            permission_id=self.permission_id,
            permission_name=self.permission_name,
            project_reference=self.project_reference,
            state=self.state)


def get_permission(categories: Optional[Sequence[Union['GetPermissionCategoryArgs', 'GetPermissionCategoryArgsDict']]] = None,
                   permission_id: Optional[_builtins.str] = None,
                   permission_name: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPermissionResult:
    """
    Describe a Nutanix Permission and its values (if it has them).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    #Get permission by UUID
    byuuid = nutanix.get_permission(permission_id="26b81a55-2bca-48c6-9fab-4f82c6bb4284")
    #Get permission by name
    byname = nutanix.get_permission(permission_name="Access_Console_Virtual_Machine")
    ```


    :param Sequence[Union['GetPermissionCategoryArgs', 'GetPermissionCategoryArgsDict']] categories: The categories for this resource.
    :param _builtins.str permission_id: The `id` of the permission.
    :param _builtins.str permission_name: The `name` of the permission.
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['permissionId'] = permission_id
    __args__['permissionName'] = permission_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getPermission:getPermission', __args__, opts=opts, typ=GetPermissionResult).value

    return AwaitableGetPermissionResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        categories=pulumi.get(__ret__, 'categories'),
        description=pulumi.get(__ret__, 'description'),
        fields=pulumi.get(__ret__, 'fields'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        operation=pulumi.get(__ret__, 'operation'),
        owner_reference=pulumi.get(__ret__, 'owner_reference'),
        permission_id=pulumi.get(__ret__, 'permission_id'),
        permission_name=pulumi.get(__ret__, 'permission_name'),
        project_reference=pulumi.get(__ret__, 'project_reference'),
        state=pulumi.get(__ret__, 'state'))
def get_permission_output(categories: Optional[pulumi.Input[Optional[Sequence[Union['GetPermissionCategoryArgs', 'GetPermissionCategoryArgsDict']]]]] = None,
                          permission_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          permission_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPermissionResult]:
    """
    Describe a Nutanix Permission and its values (if it has them).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    #Get permission by UUID
    byuuid = nutanix.get_permission(permission_id="26b81a55-2bca-48c6-9fab-4f82c6bb4284")
    #Get permission by name
    byname = nutanix.get_permission(permission_name="Access_Console_Virtual_Machine")
    ```


    :param Sequence[Union['GetPermissionCategoryArgs', 'GetPermissionCategoryArgsDict']] categories: The categories for this resource.
    :param _builtins.str permission_id: The `id` of the permission.
    :param _builtins.str permission_name: The `name` of the permission.
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['permissionId'] = permission_id
    __args__['permissionName'] = permission_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getPermission:getPermission', __args__, opts=opts, typ=GetPermissionResult)
    return __ret__.apply(lambda __response__: GetPermissionResult(
        api_version=pulumi.get(__response__, 'api_version'),
        categories=pulumi.get(__response__, 'categories'),
        description=pulumi.get(__response__, 'description'),
        fields=pulumi.get(__response__, 'fields'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        operation=pulumi.get(__response__, 'operation'),
        owner_reference=pulumi.get(__response__, 'owner_reference'),
        permission_id=pulumi.get(__response__, 'permission_id'),
        permission_name=pulumi.get(__response__, 'permission_name'),
        project_reference=pulumi.get(__response__, 'project_reference'),
        state=pulumi.get(__response__, 'state')))
