# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, account_reference_lists=None, acps=None, api_version=None, categories=None, cluster_reference_lists=None, default_environment_references=None, default_subnet_reference=None, description=None, environment_reference_lists=None, external_network_lists=None, external_user_group_reference_lists=None, id=None, is_default=None, metadata=None, name=None, owner_reference=None, project_id=None, project_name=None, project_reference=None, resource_domains=None, state=None, subnet_reference_lists=None, tunnel_reference_lists=None, user_reference_lists=None, vpc_reference_lists=None):
        if account_reference_lists and not isinstance(account_reference_lists, list):
            raise TypeError("Expected argument 'account_reference_lists' to be a list")
        pulumi.set(__self__, "account_reference_lists", account_reference_lists)
        if acps and not isinstance(acps, list):
            raise TypeError("Expected argument 'acps' to be a list")
        pulumi.set(__self__, "acps", acps)
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if cluster_reference_lists and not isinstance(cluster_reference_lists, list):
            raise TypeError("Expected argument 'cluster_reference_lists' to be a list")
        pulumi.set(__self__, "cluster_reference_lists", cluster_reference_lists)
        if default_environment_references and not isinstance(default_environment_references, list):
            raise TypeError("Expected argument 'default_environment_references' to be a list")
        pulumi.set(__self__, "default_environment_references", default_environment_references)
        if default_subnet_reference and not isinstance(default_subnet_reference, dict):
            raise TypeError("Expected argument 'default_subnet_reference' to be a dict")
        pulumi.set(__self__, "default_subnet_reference", default_subnet_reference)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment_reference_lists and not isinstance(environment_reference_lists, list):
            raise TypeError("Expected argument 'environment_reference_lists' to be a list")
        pulumi.set(__self__, "environment_reference_lists", environment_reference_lists)
        if external_network_lists and not isinstance(external_network_lists, list):
            raise TypeError("Expected argument 'external_network_lists' to be a list")
        pulumi.set(__self__, "external_network_lists", external_network_lists)
        if external_user_group_reference_lists and not isinstance(external_user_group_reference_lists, list):
            raise TypeError("Expected argument 'external_user_group_reference_lists' to be a list")
        pulumi.set(__self__, "external_user_group_reference_lists", external_user_group_reference_lists)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_reference and not isinstance(owner_reference, dict):
            raise TypeError("Expected argument 'owner_reference' to be a dict")
        pulumi.set(__self__, "owner_reference", owner_reference)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if project_reference and not isinstance(project_reference, dict):
            raise TypeError("Expected argument 'project_reference' to be a dict")
        pulumi.set(__self__, "project_reference", project_reference)
        if resource_domains and not isinstance(resource_domains, list):
            raise TypeError("Expected argument 'resource_domains' to be a list")
        pulumi.set(__self__, "resource_domains", resource_domains)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_reference_lists and not isinstance(subnet_reference_lists, list):
            raise TypeError("Expected argument 'subnet_reference_lists' to be a list")
        pulumi.set(__self__, "subnet_reference_lists", subnet_reference_lists)
        if tunnel_reference_lists and not isinstance(tunnel_reference_lists, list):
            raise TypeError("Expected argument 'tunnel_reference_lists' to be a list")
        pulumi.set(__self__, "tunnel_reference_lists", tunnel_reference_lists)
        if user_reference_lists and not isinstance(user_reference_lists, list):
            raise TypeError("Expected argument 'user_reference_lists' to be a list")
        pulumi.set(__self__, "user_reference_lists", user_reference_lists)
        if vpc_reference_lists and not isinstance(vpc_reference_lists, list):
            raise TypeError("Expected argument 'vpc_reference_lists' to be a list")
        pulumi.set(__self__, "vpc_reference_lists", vpc_reference_lists)

    @_builtins.property
    @pulumi.getter(name="accountReferenceLists")
    def account_reference_lists(self) -> Sequence['outputs.GetProjectAccountReferenceListResult']:
        """
        List of accounts associated with the project.
        * `account_reference_list.#.kind` - The kind name. Default value is `account`
        * `account_reference_list.#.uuid` - The UUID of an account.
        * `account_reference_list.#.name` - The name of an account.
        """
        return pulumi.get(self, "account_reference_lists")

    @_builtins.property
    @pulumi.getter
    def acps(self) -> Sequence['outputs.GetProjectAcpResult']:
        return pulumi.get(self, "acps")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetProjectCategoryResult']:
        """
        - (Optional) The category values represented as a dictionary of key > list of values.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="clusterReferenceLists")
    def cluster_reference_lists(self) -> Sequence['outputs.GetProjectClusterReferenceListResult']:
        """
        (Optional/Computed) List of clusters associated with the project..
        * `cluster_reference_list.#.kind` - (Optional) The kind name. Default value is `cluster`
        * `cluster_reference_list.#.uuid` - (Required) The UUID of a cluster
        * `cluster_reference_list.#.name` - (Optional/Computed) The name of a cluster.
        """
        return pulumi.get(self, "cluster_reference_lists")

    @_builtins.property
    @pulumi.getter(name="defaultEnvironmentReferences")
    def default_environment_references(self) -> Sequence['outputs.GetProjectDefaultEnvironmentReferenceResult']:
        """
        (Optional/Computed) Reference to a environment.
        """
        return pulumi.get(self, "default_environment_references")

    @_builtins.property
    @pulumi.getter(name="defaultSubnetReference")
    def default_subnet_reference(self) -> Mapping[str, _builtins.str]:
        """
        Reference to a subnet.
        """
        return pulumi.get(self, "default_subnet_reference")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of ACP
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="environmentReferenceLists")
    def environment_reference_lists(self) -> Sequence['outputs.GetProjectEnvironmentReferenceListResult']:
        """
        List of environments associated with the project.
        * `environment_reference_list.#.kind` - The kind name. Default value is `environment`
        * `environment_reference_list.#.uuid` - The UUID of an environment.
        * `environment_reference_list.#.name` - The name of an environment.
        """
        return pulumi.get(self, "environment_reference_lists")

    @_builtins.property
    @pulumi.getter(name="externalNetworkLists")
    def external_network_lists(self) -> Sequence['outputs.GetProjectExternalNetworkListResult']:
        """
        List of external networks associated with the project.
        * `external_network_list.#.uuid` - The UUID of a network.
        * `external_network_list.#.name` - The name of a network.
        """
        return pulumi.get(self, "external_network_lists")

    @_builtins.property
    @pulumi.getter(name="externalUserGroupReferenceLists")
    def external_user_group_reference_lists(self) -> Sequence['outputs.GetProjectExternalUserGroupReferenceListResult']:
        """
        List of directory service user groups. These groups are not managed by Nutanix.
        * `external_user_group_reference_list.#.kind` - The kind name. Default value is `user_group`
        * `external_user_group_reference_list.#.uuid` - The UUID of a user_group
        * `external_user_group_reference_list.#.name` - The name of a user_group
        """
        return pulumi.get(self, "external_user_group_reference_lists")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        the name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="resourceDomains")
    def resource_domains(self) -> Sequence['outputs.GetProjectResourceDomainResult']:
        """
        The status for a resource domain (limits and values)
        """
        return pulumi.get(self, "resource_domains")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetReferenceLists")
    def subnet_reference_lists(self) -> Sequence['outputs.GetProjectSubnetReferenceListResult']:
        """
        List of subnets for the project.
        * `subnet_reference_list.#.kind` - The kind name. Default value is `subnet`
        * `subnet_reference_list.#.uuid` - The UUID of a subnet
        * `subnet_reference_list.#.name` - The name of a subnet.
        """
        return pulumi.get(self, "subnet_reference_lists")

    @_builtins.property
    @pulumi.getter(name="tunnelReferenceLists")
    def tunnel_reference_lists(self) -> Sequence['outputs.GetProjectTunnelReferenceListResult']:
        """
        (Optional/Computed) List of tunnels associated with the project.
        * `tunnel_reference_list.#.kind` - (Optional) The kind name. Default value is `tunnel`
        * `tunnel_reference_list.#.uuid` - (Required) The UUID of a tunnel
        * `tunnel_reference_list.#.name` - (Optional/Computed) The name of a tunnel.
        """
        return pulumi.get(self, "tunnel_reference_lists")

    @_builtins.property
    @pulumi.getter(name="userReferenceLists")
    def user_reference_lists(self) -> Sequence['outputs.GetProjectUserReferenceListResult']:
        """
        List of Reference of users.
        """
        return pulumi.get(self, "user_reference_lists")

    @_builtins.property
    @pulumi.getter(name="vpcReferenceLists")
    def vpc_reference_lists(self) -> Sequence['outputs.GetProjectVpcReferenceListResult']:
        """
        (Optional/Computed) List of VPCs associated with the project..
        * `vpc_reference_list.#.kind` - (Optional) The kind name. Default value is `vpc`
        * `vpc_reference_list.#.uuid` - (Required) The UUID of a vpc
        * `vpc_reference_list.#.name` - (Optional/Computed) The name of a vpc.
        """
        return pulumi.get(self, "vpc_reference_lists")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            account_reference_lists=self.account_reference_lists,
            acps=self.acps,
            api_version=self.api_version,
            categories=self.categories,
            cluster_reference_lists=self.cluster_reference_lists,
            default_environment_references=self.default_environment_references,
            default_subnet_reference=self.default_subnet_reference,
            description=self.description,
            environment_reference_lists=self.environment_reference_lists,
            external_network_lists=self.external_network_lists,
            external_user_group_reference_lists=self.external_user_group_reference_lists,
            id=self.id,
            is_default=self.is_default,
            metadata=self.metadata,
            name=self.name,
            owner_reference=self.owner_reference,
            project_id=self.project_id,
            project_name=self.project_name,
            project_reference=self.project_reference,
            resource_domains=self.resource_domains,
            state=self.state,
            subnet_reference_lists=self.subnet_reference_lists,
            tunnel_reference_lists=self.tunnel_reference_lists,
            user_reference_lists=self.user_reference_lists,
            vpc_reference_lists=self.vpc_reference_lists)


def get_project(categories: Optional[Sequence[Union['GetProjectCategoryArgs', 'GetProjectCategoryArgsDict']]] = None,
                external_user_group_reference_lists: Optional[Sequence[Union['GetProjectExternalUserGroupReferenceListArgs', 'GetProjectExternalUserGroupReferenceListArgsDict']]] = None,
                project_id: Optional[_builtins.str] = None,
                project_name: Optional[_builtins.str] = None,
                subnet_reference_lists: Optional[Sequence[Union['GetProjectSubnetReferenceListArgs', 'GetProjectSubnetReferenceListArgsDict']]] = None,
                user_reference_lists: Optional[Sequence[Union['GetProjectUserReferenceListArgs', 'GetProjectUserReferenceListArgsDict']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Describe a Nutanix Project and its values (if it has them).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    subnet = nutanix.Subnet("subnet",
        cluster_uuid="<YOUR_CLUSTER_ID>",
        name="sunet_test_name",
        description="Description of my unit test VLAN",
        vlan_id=31,
        subnet_type="VLAN",
        subnet_ip="10.250.140.0",
        default_gateway_ip="10.250.140.1",
        prefix_length=24,
        dhcp_options={
            "boot_file_name": "bootfile",
            "domain_name": "nutanix",
            "tftp_server_name": "10.250.140.200",
        },
        dhcp_domain_name_server_lists=[
            "8.8.8.8",
            "4.2.2.2",
        ],
        dhcp_domain_search_lists=[
            "terraform.nutanix.com",
            "terraform.unit.test.com",
        ])
    project_test = nutanix.Project("project_test",
        name="my-project",
        description="This is my project",
        categories=[{
            "name": "Environment",
            "value": "Staging",
        }],
        resource_domain={
            "resources": [{
                "limit": 4,
                "resource_type": "STORAGE",
            }],
        },
        default_subnet_reference={
            "uuid": subnet.metadata["uuid"],
        },
        api_version="3.1")
    test = nutanix.get_project_output(project_id=project_test.id)
    ```


    :param Sequence[Union['GetProjectCategoryArgs', 'GetProjectCategoryArgsDict']] categories: - (Optional) The category values represented as a dictionary of key > list of values.
    :param Sequence[Union['GetProjectExternalUserGroupReferenceListArgs', 'GetProjectExternalUserGroupReferenceListArgsDict']] external_user_group_reference_lists: List of directory service user groups. These groups are not managed by Nutanix.
           * `external_user_group_reference_list.#.kind` - The kind name. Default value is `user_group`
           * `external_user_group_reference_list.#.uuid` - The UUID of a user_group
           * `external_user_group_reference_list.#.name` - The name of a user_group
    :param _builtins.str project_id: - (Required) The `id` of the project.
    :param Sequence[Union['GetProjectSubnetReferenceListArgs', 'GetProjectSubnetReferenceListArgsDict']] subnet_reference_lists: List of subnets for the project.
           * `subnet_reference_list.#.kind` - The kind name. Default value is `subnet`
           * `subnet_reference_list.#.uuid` - The UUID of a subnet
           * `subnet_reference_list.#.name` - The name of a subnet.
    :param Sequence[Union['GetProjectUserReferenceListArgs', 'GetProjectUserReferenceListArgsDict']] user_reference_lists: List of Reference of users.
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['externalUserGroupReferenceLists'] = external_user_group_reference_lists
    __args__['projectId'] = project_id
    __args__['projectName'] = project_name
    __args__['subnetReferenceLists'] = subnet_reference_lists
    __args__['userReferenceLists'] = user_reference_lists
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        account_reference_lists=pulumi.get(__ret__, 'account_reference_lists'),
        acps=pulumi.get(__ret__, 'acps'),
        api_version=pulumi.get(__ret__, 'api_version'),
        categories=pulumi.get(__ret__, 'categories'),
        cluster_reference_lists=pulumi.get(__ret__, 'cluster_reference_lists'),
        default_environment_references=pulumi.get(__ret__, 'default_environment_references'),
        default_subnet_reference=pulumi.get(__ret__, 'default_subnet_reference'),
        description=pulumi.get(__ret__, 'description'),
        environment_reference_lists=pulumi.get(__ret__, 'environment_reference_lists'),
        external_network_lists=pulumi.get(__ret__, 'external_network_lists'),
        external_user_group_reference_lists=pulumi.get(__ret__, 'external_user_group_reference_lists'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        owner_reference=pulumi.get(__ret__, 'owner_reference'),
        project_id=pulumi.get(__ret__, 'project_id'),
        project_name=pulumi.get(__ret__, 'project_name'),
        project_reference=pulumi.get(__ret__, 'project_reference'),
        resource_domains=pulumi.get(__ret__, 'resource_domains'),
        state=pulumi.get(__ret__, 'state'),
        subnet_reference_lists=pulumi.get(__ret__, 'subnet_reference_lists'),
        tunnel_reference_lists=pulumi.get(__ret__, 'tunnel_reference_lists'),
        user_reference_lists=pulumi.get(__ret__, 'user_reference_lists'),
        vpc_reference_lists=pulumi.get(__ret__, 'vpc_reference_lists'))
def get_project_output(categories: Optional[pulumi.Input[Optional[Sequence[Union['GetProjectCategoryArgs', 'GetProjectCategoryArgsDict']]]]] = None,
                       external_user_group_reference_lists: Optional[pulumi.Input[Optional[Sequence[Union['GetProjectExternalUserGroupReferenceListArgs', 'GetProjectExternalUserGroupReferenceListArgsDict']]]]] = None,
                       project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       project_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       subnet_reference_lists: Optional[pulumi.Input[Optional[Sequence[Union['GetProjectSubnetReferenceListArgs', 'GetProjectSubnetReferenceListArgsDict']]]]] = None,
                       user_reference_lists: Optional[pulumi.Input[Optional[Sequence[Union['GetProjectUserReferenceListArgs', 'GetProjectUserReferenceListArgsDict']]]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Describe a Nutanix Project and its values (if it has them).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    subnet = nutanix.Subnet("subnet",
        cluster_uuid="<YOUR_CLUSTER_ID>",
        name="sunet_test_name",
        description="Description of my unit test VLAN",
        vlan_id=31,
        subnet_type="VLAN",
        subnet_ip="10.250.140.0",
        default_gateway_ip="10.250.140.1",
        prefix_length=24,
        dhcp_options={
            "boot_file_name": "bootfile",
            "domain_name": "nutanix",
            "tftp_server_name": "10.250.140.200",
        },
        dhcp_domain_name_server_lists=[
            "8.8.8.8",
            "4.2.2.2",
        ],
        dhcp_domain_search_lists=[
            "terraform.nutanix.com",
            "terraform.unit.test.com",
        ])
    project_test = nutanix.Project("project_test",
        name="my-project",
        description="This is my project",
        categories=[{
            "name": "Environment",
            "value": "Staging",
        }],
        resource_domain={
            "resources": [{
                "limit": 4,
                "resource_type": "STORAGE",
            }],
        },
        default_subnet_reference={
            "uuid": subnet.metadata["uuid"],
        },
        api_version="3.1")
    test = nutanix.get_project_output(project_id=project_test.id)
    ```


    :param Sequence[Union['GetProjectCategoryArgs', 'GetProjectCategoryArgsDict']] categories: - (Optional) The category values represented as a dictionary of key > list of values.
    :param Sequence[Union['GetProjectExternalUserGroupReferenceListArgs', 'GetProjectExternalUserGroupReferenceListArgsDict']] external_user_group_reference_lists: List of directory service user groups. These groups are not managed by Nutanix.
           * `external_user_group_reference_list.#.kind` - The kind name. Default value is `user_group`
           * `external_user_group_reference_list.#.uuid` - The UUID of a user_group
           * `external_user_group_reference_list.#.name` - The name of a user_group
    :param _builtins.str project_id: - (Required) The `id` of the project.
    :param Sequence[Union['GetProjectSubnetReferenceListArgs', 'GetProjectSubnetReferenceListArgsDict']] subnet_reference_lists: List of subnets for the project.
           * `subnet_reference_list.#.kind` - The kind name. Default value is `subnet`
           * `subnet_reference_list.#.uuid` - The UUID of a subnet
           * `subnet_reference_list.#.name` - The name of a subnet.
    :param Sequence[Union['GetProjectUserReferenceListArgs', 'GetProjectUserReferenceListArgsDict']] user_reference_lists: List of Reference of users.
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['externalUserGroupReferenceLists'] = external_user_group_reference_lists
    __args__['projectId'] = project_id
    __args__['projectName'] = project_name
    __args__['subnetReferenceLists'] = subnet_reference_lists
    __args__['userReferenceLists'] = user_reference_lists
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        account_reference_lists=pulumi.get(__response__, 'account_reference_lists'),
        acps=pulumi.get(__response__, 'acps'),
        api_version=pulumi.get(__response__, 'api_version'),
        categories=pulumi.get(__response__, 'categories'),
        cluster_reference_lists=pulumi.get(__response__, 'cluster_reference_lists'),
        default_environment_references=pulumi.get(__response__, 'default_environment_references'),
        default_subnet_reference=pulumi.get(__response__, 'default_subnet_reference'),
        description=pulumi.get(__response__, 'description'),
        environment_reference_lists=pulumi.get(__response__, 'environment_reference_lists'),
        external_network_lists=pulumi.get(__response__, 'external_network_lists'),
        external_user_group_reference_lists=pulumi.get(__response__, 'external_user_group_reference_lists'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        owner_reference=pulumi.get(__response__, 'owner_reference'),
        project_id=pulumi.get(__response__, 'project_id'),
        project_name=pulumi.get(__response__, 'project_name'),
        project_reference=pulumi.get(__response__, 'project_reference'),
        resource_domains=pulumi.get(__response__, 'resource_domains'),
        state=pulumi.get(__response__, 'state'),
        subnet_reference_lists=pulumi.get(__response__, 'subnet_reference_lists'),
        tunnel_reference_lists=pulumi.get(__response__, 'tunnel_reference_lists'),
        user_reference_lists=pulumi.get(__response__, 'user_reference_lists'),
        vpc_reference_lists=pulumi.get(__response__, 'vpc_reference_lists')))
