# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProtectedResourceV2Result',
    'AwaitableGetProtectedResourceV2Result',
    'get_protected_resource_v2',
    'get_protected_resource_v2_output',
]

@pulumi.output_type
class GetProtectedResourceV2Result:
    """
    A collection of values returned by getProtectedResourceV2.
    """
    def __init__(__self__, category_fq_names=None, consistency_group_ext_id=None, entity_ext_id=None, entity_type=None, ext_id=None, id=None, links=None, replication_states=None, site_protection_infos=None, source_site_references=None, tenant_id=None):
        if category_fq_names and not isinstance(category_fq_names, list):
            raise TypeError("Expected argument 'category_fq_names' to be a list")
        pulumi.set(__self__, "category_fq_names", category_fq_names)
        if consistency_group_ext_id and not isinstance(consistency_group_ext_id, str):
            raise TypeError("Expected argument 'consistency_group_ext_id' to be a str")
        pulumi.set(__self__, "consistency_group_ext_id", consistency_group_ext_id)
        if entity_ext_id and not isinstance(entity_ext_id, str):
            raise TypeError("Expected argument 'entity_ext_id' to be a str")
        pulumi.set(__self__, "entity_ext_id", entity_ext_id)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if replication_states and not isinstance(replication_states, list):
            raise TypeError("Expected argument 'replication_states' to be a list")
        pulumi.set(__self__, "replication_states", replication_states)
        if site_protection_infos and not isinstance(site_protection_infos, list):
            raise TypeError("Expected argument 'site_protection_infos' to be a list")
        pulumi.set(__self__, "site_protection_infos", site_protection_infos)
        if source_site_references and not isinstance(source_site_references, list):
            raise TypeError("Expected argument 'source_site_references' to be a list")
        pulumi.set(__self__, "source_site_references", source_site_references)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="categoryFqNames")
    def category_fq_names(self) -> Sequence[_builtins.str]:
        """
        Category key-value pairs associated with the protected resource at the time of protection. The category key and value are separated by '/'. For example, a category with key 'dept' and value 'hr' will be represented as 'dept/hr'.
        """
        return pulumi.get(self, "category_fq_names")

    @_builtins.property
    @pulumi.getter(name="consistencyGroupExtId")
    def consistency_group_ext_id(self) -> _builtins.str:
        """
        External identifier of the Consistency group which the protected resource is part of.
        """
        return pulumi.get(self, "consistency_group_ext_id")

    @_builtins.property
    @pulumi.getter(name="entityExtId")
    def entity_ext_id(self) -> _builtins.str:
        """
        The external identifier of the VM or the volume group associated with the protected resource.
        """
        return pulumi.get(self, "entity_ext_id")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        Protected resource entity type. Possible values are: VM, VOLUME_GROUP.
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetProtectedResourceV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="replicationStates")
    def replication_states(self) -> Sequence['outputs.GetProtectedResourceV2ReplicationStateResult']:
        """
        Replication related information about the protected resource.
        """
        return pulumi.get(self, "replication_states")

    @_builtins.property
    @pulumi.getter(name="siteProtectionInfos")
    def site_protection_infos(self) -> Sequence['outputs.GetProtectedResourceV2SiteProtectionInfoResult']:
        """
        The data protection details for the protected resource that are relevant to any of the sites in the local Prism Central, like the time ranges available for recovery.
        """
        return pulumi.get(self, "site_protection_infos")

    @_builtins.property
    @pulumi.getter(name="sourceSiteReferences")
    def source_site_references(self) -> Sequence['outputs.GetProtectedResourceV2SourceSiteReferenceResult']:
        """
        Details about the data protection site in the Prism Central.
        """
        return pulumi.get(self, "source_site_references")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetProtectedResourceV2Result(GetProtectedResourceV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectedResourceV2Result(
            category_fq_names=self.category_fq_names,
            consistency_group_ext_id=self.consistency_group_ext_id,
            entity_ext_id=self.entity_ext_id,
            entity_type=self.entity_type,
            ext_id=self.ext_id,
            id=self.id,
            links=self.links,
            replication_states=self.replication_states,
            site_protection_infos=self.site_protection_infos,
            source_site_references=self.source_site_references,
            tenant_id=self.tenant_id)


def get_protected_resource_v2(ext_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectedResourceV2Result:
    """
    Get the details of the specified protected resource such as the restorable time ranges available on the local Prism Central and the state of replication to the targets specified in the applied protection policies. This applies only if the entity is protected in a minutely or synchronous schedule. Other protection schedules are not served by this endpoint yet, and are considered not protected.

    ## Example 1: Get Protected Virtual Machine

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    protected_vm = nutanix.get_protected_resource_v2(ext_id="d22529bb-f02d-4710-894b-d1de772d7832")
    ```

    ## Example 2: Get Protected Volume Group

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    protected_vg = nutanix.get_protected_resource_v2(ext_id="246c651a-1b16-4983-b5ff-204840f85e07")
    ```


    :param _builtins.str ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getProtectedResourceV2:getProtectedResourceV2', __args__, opts=opts, typ=GetProtectedResourceV2Result).value

    return AwaitableGetProtectedResourceV2Result(
        category_fq_names=pulumi.get(__ret__, 'category_fq_names'),
        consistency_group_ext_id=pulumi.get(__ret__, 'consistency_group_ext_id'),
        entity_ext_id=pulumi.get(__ret__, 'entity_ext_id'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        replication_states=pulumi.get(__ret__, 'replication_states'),
        site_protection_infos=pulumi.get(__ret__, 'site_protection_infos'),
        source_site_references=pulumi.get(__ret__, 'source_site_references'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_protected_resource_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProtectedResourceV2Result]:
    """
    Get the details of the specified protected resource such as the restorable time ranges available on the local Prism Central and the state of replication to the targets specified in the applied protection policies. This applies only if the entity is protected in a minutely or synchronous schedule. Other protection schedules are not served by this endpoint yet, and are considered not protected.

    ## Example 1: Get Protected Virtual Machine

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    protected_vm = nutanix.get_protected_resource_v2(ext_id="d22529bb-f02d-4710-894b-d1de772d7832")
    ```

    ## Example 2: Get Protected Volume Group

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    protected_vg = nutanix.get_protected_resource_v2(ext_id="246c651a-1b16-4983-b5ff-204840f85e07")
    ```


    :param _builtins.str ext_id: -(Required) The external identifier of a protected VM or volume group that can be used to retrieve the protected resource.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getProtectedResourceV2:getProtectedResourceV2', __args__, opts=opts, typ=GetProtectedResourceV2Result)
    return __ret__.apply(lambda __response__: GetProtectedResourceV2Result(
        category_fq_names=pulumi.get(__response__, 'category_fq_names'),
        consistency_group_ext_id=pulumi.get(__response__, 'consistency_group_ext_id'),
        entity_ext_id=pulumi.get(__response__, 'entity_ext_id'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        replication_states=pulumi.get(__response__, 'replication_states'),
        site_protection_infos=pulumi.get(__response__, 'site_protection_infos'),
        source_site_references=pulumi.get(__response__, 'source_site_references'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
