# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProtectionPoliciesV2Result',
    'AwaitableGetProtectionPoliciesV2Result',
    'get_protection_policies_v2',
    'get_protection_policies_v2_output',
]

@pulumi.output_type
class GetProtectionPoliciesV2Result:
    """
    A collection of values returned by getProtectionPoliciesV2.
    """
    def __init__(__self__, filter=None, id=None, limit=None, order_by=None, page=None, protection_policies=None, select=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if page and not isinstance(page, int):
            raise TypeError("Expected argument 'page' to be a int")
        pulumi.set(__self__, "page", page)
        if protection_policies and not isinstance(protection_policies, list):
            raise TypeError("Expected argument 'protection_policies' to be a list")
        pulumi.set(__self__, "protection_policies", protection_policies)
        if select and not isinstance(select, str):
            raise TypeError("Expected argument 'select' to be a str")
        pulumi.set(__self__, "select", select)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter
    def page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "page")

    @_builtins.property
    @pulumi.getter(name="protectionPolicies")
    def protection_policies(self) -> Sequence['outputs.GetProtectionPoliciesV2ProtectionPolicyResult']:
        """
        - List of protection policies.
        """
        return pulumi.get(self, "protection_policies")

    @_builtins.property
    @pulumi.getter
    def select(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "select")


class AwaitableGetProtectionPoliciesV2Result(GetProtectionPoliciesV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectionPoliciesV2Result(
            filter=self.filter,
            id=self.id,
            limit=self.limit,
            order_by=self.order_by,
            page=self.page,
            protection_policies=self.protection_policies,
            select=self.select)


def get_protection_policies_v2(filter: Optional[_builtins.str] = None,
                               limit: Optional[_builtins.int] = None,
                               order_by: Optional[_builtins.str] = None,
                               page: Optional[_builtins.int] = None,
                               select: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectionPoliciesV2Result:
    """
    List the protection policies defined on the system. This operation supports filtering, sorting, selection and pagination.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # with filter
    pps_filter = nutanix.get_protection_policies_v2(filter="name eq 'example_protection_policy'")
    # with limit
    pp_limit = nutanix.get_protection_policies_v2(limit=4)
    # with filter and limit
    example = nutanix.get_protection_policies_v2(filter="startswith(name, 'C')",
        limit=10)
    ```

    ## Protection Policies

    The `protection_policies` is a list of protection policies. Each protection policy supports the following attributes:

    * `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    * `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    * `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    * `name`: - Name of the protection policy.
    * `description`: - Description of the protection policy.
    * `replication_locations`: - Hypervisor details.
    * `replication_configurations`: - Cluster reference for an entity.
    * `category_ids`: - Host entity with its attributes.
    * `is_approval_policy_needed`: - Disks attached to host.
    * `owner_ext_id`: - Node degraded status.

    ### Links
    The links attribute supports the following:

    * `href`: - The URL at which the entity described by the link can be accessed.
    * `rel`: - A name that identifies the relationship of the link to the object that is returned by the URL. The unique value of "self" identifies the URL for the object.

    ### Replication Locations
    The replication_locations attribute supports the following:

    * `label`: - This is a unique user defined label of the replication location. It is used to identify the location in the replication configurations.
    * `domain_manager_ext_id`: - External identifier of the domain manager.
    * `replication_sub_location`: - Specifies the replication sub-locations where recovery points can be created or replicated.
    * `is_primary`: - One of the locations must be specified as the primary location. All the other locations must be connected to the primary location.

    #### Replication Sub Location
    The replication_sub_location attribute supports the following:
    > One of `cluster_ext_ids` :
    * `cluster_ext_ids` :  - External identifier of the clusters.

    ##### Cluster Ext Ids
    The cluster_ext_ids attribute supports the following:

    * `cluster_ext_id`: - List of Prism Element cluster external identifiers whose associated VMs and volume groups are protected. Only the primary location can have multiple clusters configured, while the other locations can specify only one cluster. Clusters must be specified for replication within the same Prism Central and cannot be specified for an MST type location. All clusters are considered if the cluster external identifier list is empty.

    ### Replication Configurations
    The replication_configurations attribute supports the following:

    * `source_location_label`: - Label of the source location from the replication locations list, where the entity is running. The location of type MST can not be specified as the replication source.
    * `remote_location_label`: - Label of the source location from the replication locations list, where the entity will be replicated.
    * `schedule`: - Schedule for protection. The schedule specifies the recovery point objective and the retention policy for the participating locations.

    #### Schedule
    The schedule attribute supports the following:

    * `recovery_point_type`: - Type of recovery point.
       * `CRASH_CONSISTENT`: Crash-consistent Recovery points capture all the VM and application level details.
       * `APP_CONSISTENT`: Application-consistent Recovery points can capture all the data stored in the memory and also the in-progress transaction details.
    * `recovery_point_objective_time_seconds`: - The Recovery point objective of the schedule in seconds and specified in multiple of 60 seconds. Only following RPO values can be provided for rollup retention type:
      - Minute(s): 1, 2, 3, 4, 5, 6, 10, 12, 15
      - Hour(s): 1, 2, 3, 4, 6, 8, 12
      - Day(s): 1
      - Week(s): 1, 2
    * `retention`: - Specifies the retention policy for the recovery point schedule.
    * `start_time`: - Represents the protection start time for the new entities added to the policy after the policy is created in h:m format. The values must be between 00h:00m and 23h:59m and in UTC timezone. It specifies the time when the first snapshot is taken and replicated for any entity added to the policy. If this is not specified, the snapshot is taken immediately and replicated for any new entity added to the policy.
    * `sync_replication_auto_suspend_timeout_seconds`: - Auto suspend timeout if there is a connection failure between locations for synchronous replication. If this value is not set, then the policy will not be suspended.

    #### Retention
    > One of `linear_retention` or `auto_rollup_retention` :

    * `linear_retention`: - Linear retention policy.
    * `auto_rollup_retention`: - Auto rollup retention policy.

    ##### Linear Retention
    The linear_retention attribute supports the following:

    * `local`: - Specifies the number of recovery points to retain on the local location.
    * `remote`: - Specifies the number of recovery points to retain on the remote location.

    ##### Auto Rollup Retention
    The auto_rollup_retention attribute supports the following:

    * `local`: - Specifies the auto rollup retention details.
    * `remote`: - Specifies the auto rollup retention details.

    ###### Local, Remote
    The local, remote attribute in the auto_rollup_retention supports the following:

    * `snapshot_interval_type`: - Snapshot interval period.
       * `YEARLY`: Specifies the number of latest yearly recovery points to retain.
       * `WEEKLY`: Specifies the number of latest weekly recovery points to retain.
       * `DAILY`: Specifies the number of latest daily recovery points to retain.
       * `MONTHLY`: Specifies the number of latest monthly recovery points to retain.
       * `HOURLY`: Specifies the number of latest hourly recovery points to retain.
    * `frequency`: - Multiplier to 'snapshotIntervalType'. For example, if 'snapshotIntervalType' is 'YEARLY' and 'multiple' is 5, then 5 years worth of rollup snapshots will be retained.

    See detailed information in [Nutanix List Protection Policies V4](https://developers.nutanix.com/api-reference?namespace=datapolicies&version=v4.0#tag/ProtectionPolicies/operation/listProtectionPolicies).


    :param _builtins.str filter: -(Optional) A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions. For example, filter '$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
           - extId
           - name
           - ownerExtId
           - replicationLocations/domainManagerExtId
    :param _builtins.int limit: -(Optional) A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: -(Optional) A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:
           - name
    :param _builtins.int page: -(Optional) A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: -(Optional) A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e., *), then all properties on the matching resource will be returned.
           - extId
           - name
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getProtectionPoliciesV2:getProtectionPoliciesV2', __args__, opts=opts, typ=GetProtectionPoliciesV2Result).value

    return AwaitableGetProtectionPoliciesV2Result(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        order_by=pulumi.get(__ret__, 'order_by'),
        page=pulumi.get(__ret__, 'page'),
        protection_policies=pulumi.get(__ret__, 'protection_policies'),
        select=pulumi.get(__ret__, 'select'))
def get_protection_policies_v2_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                      order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                                      select: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProtectionPoliciesV2Result]:
    """
    List the protection policies defined on the system. This operation supports filtering, sorting, selection and pagination.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    # with filter
    pps_filter = nutanix.get_protection_policies_v2(filter="name eq 'example_protection_policy'")
    # with limit
    pp_limit = nutanix.get_protection_policies_v2(limit=4)
    # with filter and limit
    example = nutanix.get_protection_policies_v2(filter="startswith(name, 'C')",
        limit=10)
    ```

    ## Protection Policies

    The `protection_policies` is a list of protection policies. Each protection policy supports the following attributes:

    * `tenant_id`: - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
    * `ext_id`: - A globally unique identifier of an instance that is suitable for external consumption.
    * `links`: - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
    * `name`: - Name of the protection policy.
    * `description`: - Description of the protection policy.
    * `replication_locations`: - Hypervisor details.
    * `replication_configurations`: - Cluster reference for an entity.
    * `category_ids`: - Host entity with its attributes.
    * `is_approval_policy_needed`: - Disks attached to host.
    * `owner_ext_id`: - Node degraded status.

    ### Links
    The links attribute supports the following:

    * `href`: - The URL at which the entity described by the link can be accessed.
    * `rel`: - A name that identifies the relationship of the link to the object that is returned by the URL. The unique value of "self" identifies the URL for the object.

    ### Replication Locations
    The replication_locations attribute supports the following:

    * `label`: - This is a unique user defined label of the replication location. It is used to identify the location in the replication configurations.
    * `domain_manager_ext_id`: - External identifier of the domain manager.
    * `replication_sub_location`: - Specifies the replication sub-locations where recovery points can be created or replicated.
    * `is_primary`: - One of the locations must be specified as the primary location. All the other locations must be connected to the primary location.

    #### Replication Sub Location
    The replication_sub_location attribute supports the following:
    > One of `cluster_ext_ids` :
    * `cluster_ext_ids` :  - External identifier of the clusters.

    ##### Cluster Ext Ids
    The cluster_ext_ids attribute supports the following:

    * `cluster_ext_id`: - List of Prism Element cluster external identifiers whose associated VMs and volume groups are protected. Only the primary location can have multiple clusters configured, while the other locations can specify only one cluster. Clusters must be specified for replication within the same Prism Central and cannot be specified for an MST type location. All clusters are considered if the cluster external identifier list is empty.

    ### Replication Configurations
    The replication_configurations attribute supports the following:

    * `source_location_label`: - Label of the source location from the replication locations list, where the entity is running. The location of type MST can not be specified as the replication source.
    * `remote_location_label`: - Label of the source location from the replication locations list, where the entity will be replicated.
    * `schedule`: - Schedule for protection. The schedule specifies the recovery point objective and the retention policy for the participating locations.

    #### Schedule
    The schedule attribute supports the following:

    * `recovery_point_type`: - Type of recovery point.
       * `CRASH_CONSISTENT`: Crash-consistent Recovery points capture all the VM and application level details.
       * `APP_CONSISTENT`: Application-consistent Recovery points can capture all the data stored in the memory and also the in-progress transaction details.
    * `recovery_point_objective_time_seconds`: - The Recovery point objective of the schedule in seconds and specified in multiple of 60 seconds. Only following RPO values can be provided for rollup retention type:
      - Minute(s): 1, 2, 3, 4, 5, 6, 10, 12, 15
      - Hour(s): 1, 2, 3, 4, 6, 8, 12
      - Day(s): 1
      - Week(s): 1, 2
    * `retention`: - Specifies the retention policy for the recovery point schedule.
    * `start_time`: - Represents the protection start time for the new entities added to the policy after the policy is created in h:m format. The values must be between 00h:00m and 23h:59m and in UTC timezone. It specifies the time when the first snapshot is taken and replicated for any entity added to the policy. If this is not specified, the snapshot is taken immediately and replicated for any new entity added to the policy.
    * `sync_replication_auto_suspend_timeout_seconds`: - Auto suspend timeout if there is a connection failure between locations for synchronous replication. If this value is not set, then the policy will not be suspended.

    #### Retention
    > One of `linear_retention` or `auto_rollup_retention` :

    * `linear_retention`: - Linear retention policy.
    * `auto_rollup_retention`: - Auto rollup retention policy.

    ##### Linear Retention
    The linear_retention attribute supports the following:

    * `local`: - Specifies the number of recovery points to retain on the local location.
    * `remote`: - Specifies the number of recovery points to retain on the remote location.

    ##### Auto Rollup Retention
    The auto_rollup_retention attribute supports the following:

    * `local`: - Specifies the auto rollup retention details.
    * `remote`: - Specifies the auto rollup retention details.

    ###### Local, Remote
    The local, remote attribute in the auto_rollup_retention supports the following:

    * `snapshot_interval_type`: - Snapshot interval period.
       * `YEARLY`: Specifies the number of latest yearly recovery points to retain.
       * `WEEKLY`: Specifies the number of latest weekly recovery points to retain.
       * `DAILY`: Specifies the number of latest daily recovery points to retain.
       * `MONTHLY`: Specifies the number of latest monthly recovery points to retain.
       * `HOURLY`: Specifies the number of latest hourly recovery points to retain.
    * `frequency`: - Multiplier to 'snapshotIntervalType'. For example, if 'snapshotIntervalType' is 'YEARLY' and 'multiple' is 5, then 5 years worth of rollup snapshots will be retained.

    See detailed information in [Nutanix List Protection Policies V4](https://developers.nutanix.com/api-reference?namespace=datapolicies&version=v4.0#tag/ProtectionPolicies/operation/listProtectionPolicies).


    :param _builtins.str filter: -(Optional) A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions. For example, filter '$filter=name eq 'karbon-ntnx-1.0' would filter the result on cluster name 'karbon-ntnx1.0', filter '$filter=startswith(name, 'C')' would filter on cluster name starting with 'C'. The filter can be applied to the following fields:
           - extId
           - name
           - ownerExtId
           - replicationLocations/domainManagerExtId
    :param _builtins.int limit: -(Optional) A URL query parameter that specifies the total number of records returned in the result set. Must be a positive integer between 1 and 100. Any number out of this range will lead to a validation error. If the limit is not provided, a default value of 50 records will be returned in the result set.
    :param _builtins.str order_by: -(Optional) A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified, the resources will be sorted in ascending order by default. For example, '$orderby=templateName desc' would get all templates sorted by templateName in descending order. The orderby can be applied to the following fields:
           - name
    :param _builtins.int page: -(Optional) A URL query parameter that specifies the page number of the result set. It must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range might lead to no results.
    :param _builtins.str select: -(Optional) A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e., *), then all properties on the matching resource will be returned.
           - extId
           - name
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['limit'] = limit
    __args__['orderBy'] = order_by
    __args__['page'] = page
    __args__['select'] = select
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getProtectionPoliciesV2:getProtectionPoliciesV2', __args__, opts=opts, typ=GetProtectionPoliciesV2Result)
    return __ret__.apply(lambda __response__: GetProtectionPoliciesV2Result(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        order_by=pulumi.get(__response__, 'order_by'),
        page=pulumi.get(__response__, 'page'),
        protection_policies=pulumi.get(__response__, 'protection_policies'),
        select=pulumi.get(__response__, 'select')))
