# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProtectionPolicyV2Result',
    'AwaitableGetProtectionPolicyV2Result',
    'get_protection_policy_v2',
    'get_protection_policy_v2_output',
]

@pulumi.output_type
class GetProtectionPolicyV2Result:
    """
    A collection of values returned by getProtectionPolicyV2.
    """
    def __init__(__self__, category_ids=None, description=None, ext_id=None, id=None, is_approval_policy_needed=None, links=None, name=None, owner_ext_id=None, replication_configurations=None, replication_locations=None, tenant_id=None):
        if category_ids and not isinstance(category_ids, list):
            raise TypeError("Expected argument 'category_ids' to be a list")
        pulumi.set(__self__, "category_ids", category_ids)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_approval_policy_needed and not isinstance(is_approval_policy_needed, bool):
            raise TypeError("Expected argument 'is_approval_policy_needed' to be a bool")
        pulumi.set(__self__, "is_approval_policy_needed", is_approval_policy_needed)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_ext_id and not isinstance(owner_ext_id, str):
            raise TypeError("Expected argument 'owner_ext_id' to be a str")
        pulumi.set(__self__, "owner_ext_id", owner_ext_id)
        if replication_configurations and not isinstance(replication_configurations, list):
            raise TypeError("Expected argument 'replication_configurations' to be a list")
        pulumi.set(__self__, "replication_configurations", replication_configurations)
        if replication_locations and not isinstance(replication_locations, list):
            raise TypeError("Expected argument 'replication_locations' to be a list")
        pulumi.set(__self__, "replication_locations", replication_locations)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="categoryIds")
    def category_ids(self) -> Sequence[_builtins.str]:
        """
        - Host entity with its attributes.
        """
        return pulumi.get(self, "category_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - Description of the protection policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isApprovalPolicyNeeded")
    def is_approval_policy_needed(self) -> _builtins.bool:
        """
        - Disks attached to host.
        """
        return pulumi.get(self, "is_approval_policy_needed")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetProtectionPolicyV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - Name of the protection policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> _builtins.str:
        """
        - Node degraded status.
        """
        return pulumi.get(self, "owner_ext_id")

    @_builtins.property
    @pulumi.getter(name="replicationConfigurations")
    def replication_configurations(self) -> Sequence['outputs.GetProtectionPolicyV2ReplicationConfigurationResult']:
        """
        - Cluster reference for an entity.
        """
        return pulumi.get(self, "replication_configurations")

    @_builtins.property
    @pulumi.getter(name="replicationLocations")
    def replication_locations(self) -> Sequence['outputs.GetProtectionPolicyV2ReplicationLocationResult']:
        """
        - Hypervisor details.
        """
        return pulumi.get(self, "replication_locations")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetProtectionPolicyV2Result(GetProtectionPolicyV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectionPolicyV2Result(
            category_ids=self.category_ids,
            description=self.description,
            ext_id=self.ext_id,
            id=self.id,
            is_approval_policy_needed=self.is_approval_policy_needed,
            links=self.links,
            name=self.name,
            owner_ext_id=self.owner_ext_id,
            replication_configurations=self.replication_configurations,
            replication_locations=self.replication_locations,
            tenant_id=self.tenant_id)


def get_protection_policy_v2(ext_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectionPolicyV2Result:
    """
    Describes the Fetches the protection policy identified by an external identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_protection_policy_v2(ext_id="00000000-0000-0000-0000-000000000000")
    ```


    :param _builtins.str ext_id: -(Required) The external identifier of the protection policy.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getProtectionPolicyV2:getProtectionPolicyV2', __args__, opts=opts, typ=GetProtectionPolicyV2Result).value

    return AwaitableGetProtectionPolicyV2Result(
        category_ids=pulumi.get(__ret__, 'category_ids'),
        description=pulumi.get(__ret__, 'description'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        is_approval_policy_needed=pulumi.get(__ret__, 'is_approval_policy_needed'),
        links=pulumi.get(__ret__, 'links'),
        name=pulumi.get(__ret__, 'name'),
        owner_ext_id=pulumi.get(__ret__, 'owner_ext_id'),
        replication_configurations=pulumi.get(__ret__, 'replication_configurations'),
        replication_locations=pulumi.get(__ret__, 'replication_locations'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_protection_policy_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProtectionPolicyV2Result]:
    """
    Describes the Fetches the protection policy identified by an external identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    example = nutanix.get_protection_policy_v2(ext_id="00000000-0000-0000-0000-000000000000")
    ```


    :param _builtins.str ext_id: -(Required) The external identifier of the protection policy.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getProtectionPolicyV2:getProtectionPolicyV2', __args__, opts=opts, typ=GetProtectionPolicyV2Result)
    return __ret__.apply(lambda __response__: GetProtectionPolicyV2Result(
        category_ids=pulumi.get(__response__, 'category_ids'),
        description=pulumi.get(__response__, 'description'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        is_approval_policy_needed=pulumi.get(__response__, 'is_approval_policy_needed'),
        links=pulumi.get(__response__, 'links'),
        name=pulumi.get(__response__, 'name'),
        owner_ext_id=pulumi.get(__response__, 'owner_ext_id'),
        replication_configurations=pulumi.get(__response__, 'replication_configurations'),
        replication_locations=pulumi.get(__response__, 'replication_locations'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
