# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRecoveryPointV2Result',
    'AwaitableGetRecoveryPointV2Result',
    'get_recovery_point_v2',
    'get_recovery_point_v2_output',
]

@pulumi.output_type
class GetRecoveryPointV2Result:
    """
    A collection of values returned by getRecoveryPointV2.
    """
    def __init__(__self__, creation_time=None, expiration_time=None, ext_id=None, id=None, links=None, location_agnostic_id=None, location_references=None, name=None, owner_ext_id=None, recovery_point_type=None, status=None, tenant_id=None, vm_recovery_points=None, volume_group_recovery_points=None):
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if expiration_time and not isinstance(expiration_time, str):
            raise TypeError("Expected argument 'expiration_time' to be a str")
        pulumi.set(__self__, "expiration_time", expiration_time)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if location_agnostic_id and not isinstance(location_agnostic_id, str):
            raise TypeError("Expected argument 'location_agnostic_id' to be a str")
        pulumi.set(__self__, "location_agnostic_id", location_agnostic_id)
        if location_references and not isinstance(location_references, list):
            raise TypeError("Expected argument 'location_references' to be a list")
        pulumi.set(__self__, "location_references", location_references)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_ext_id and not isinstance(owner_ext_id, str):
            raise TypeError("Expected argument 'owner_ext_id' to be a str")
        pulumi.set(__self__, "owner_ext_id", owner_ext_id)
        if recovery_point_type and not isinstance(recovery_point_type, str):
            raise TypeError("Expected argument 'recovery_point_type' to be a str")
        pulumi.set(__self__, "recovery_point_type", recovery_point_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if vm_recovery_points and not isinstance(vm_recovery_points, list):
            raise TypeError("Expected argument 'vm_recovery_points' to be a list")
        pulumi.set(__self__, "vm_recovery_points", vm_recovery_points)
        if volume_group_recovery_points and not isinstance(volume_group_recovery_points, list):
            raise TypeError("Expected argument 'volume_group_recovery_points' to be a list")
        pulumi.set(__self__, "volume_group_recovery_points", volume_group_recovery_points)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        The UTC date and time in ISO-8601 format when the Recovery point is created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        """
        The UTC date and time in ISO-8601 format when the current Recovery point expires and will be garbage collected.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        recovery point UUID
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetRecoveryPointV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="locationAgnosticId")
    def location_agnostic_id(self) -> _builtins.str:
        """
        Location agnostic identifier of the recovery point. This identifier is used to identify the same instances of a recovery point across different sites.
        """
        return pulumi.get(self, "location_agnostic_id")

    @_builtins.property
    @pulumi.getter(name="locationReferences")
    def location_references(self) -> Sequence['outputs.GetRecoveryPointV2LocationReferenceResult']:
        """
        List of location references where the VM or volume group recovery point are a part of the specified recovery point.
        """
        return pulumi.get(self, "location_references")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Recovery point.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerExtId")
    def owner_ext_id(self) -> _builtins.str:
        """
        A read only field inserted into recovery point at the time of recovery point creation, indicating the external identifier of the user who created this recovery point.
        """
        return pulumi.get(self, "owner_ext_id")

    @_builtins.property
    @pulumi.getter(name="recoveryPointType")
    def recovery_point_type(self) -> _builtins.str:
        """
        Type of the Recovery point.
        """
        return pulumi.get(self, "recovery_point_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Recovery point, which indicates whether this Recovery point is fit to be consumed.
        * supported values:
        * `COMPLETE`: -  The Recovery point is in a complete state and ready to be consumed.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vmRecoveryPoints")
    def vm_recovery_points(self) -> Sequence['outputs.GetRecoveryPointV2VmRecoveryPointResult']:
        """
        List of VM recovery point that are a part of the specified top-level recovery point. Note that a recovery point can contain a maximum number of 30 entities. These entities can be a combination of VM(s) and volume group(s).
        """
        return pulumi.get(self, "vm_recovery_points")

    @_builtins.property
    @pulumi.getter(name="volumeGroupRecoveryPoints")
    def volume_group_recovery_points(self) -> Sequence['outputs.GetRecoveryPointV2VolumeGroupRecoveryPointResult']:
        """
        List of volume group recovery point that are a part of the specified top-level recovery point. Note that a recovery point can contain a maximum number of 30 entities. These entities can be a combination of VM(s) and volume group(s).
        """
        return pulumi.get(self, "volume_group_recovery_points")


class AwaitableGetRecoveryPointV2Result(GetRecoveryPointV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecoveryPointV2Result(
            creation_time=self.creation_time,
            expiration_time=self.expiration_time,
            ext_id=self.ext_id,
            id=self.id,
            links=self.links,
            location_agnostic_id=self.location_agnostic_id,
            location_references=self.location_references,
            name=self.name,
            owner_ext_id=self.owner_ext_id,
            recovery_point_type=self.recovery_point_type,
            status=self.status,
            tenant_id=self.tenant_id,
            vm_recovery_points=self.vm_recovery_points,
            volume_group_recovery_points=self.volume_group_recovery_points)


def get_recovery_point_v2(ext_id: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecoveryPointV2Result:
    """
    Get a single recovery point  corresponding to the extId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_recovery_point = nutanix.get_recovery_point_v2(ext_id="1cefd0f5-6d38-4c9b-a07c-bdd2db004224")
    ```


    :param _builtins.str ext_id: recovery point UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getRecoveryPointV2:getRecoveryPointV2', __args__, opts=opts, typ=GetRecoveryPointV2Result).value

    return AwaitableGetRecoveryPointV2Result(
        creation_time=pulumi.get(__ret__, 'creation_time'),
        expiration_time=pulumi.get(__ret__, 'expiration_time'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        location_agnostic_id=pulumi.get(__ret__, 'location_agnostic_id'),
        location_references=pulumi.get(__ret__, 'location_references'),
        name=pulumi.get(__ret__, 'name'),
        owner_ext_id=pulumi.get(__ret__, 'owner_ext_id'),
        recovery_point_type=pulumi.get(__ret__, 'recovery_point_type'),
        status=pulumi.get(__ret__, 'status'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        vm_recovery_points=pulumi.get(__ret__, 'vm_recovery_points'),
        volume_group_recovery_points=pulumi.get(__ret__, 'volume_group_recovery_points'))
def get_recovery_point_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRecoveryPointV2Result]:
    """
    Get a single recovery point  corresponding to the extId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_recovery_point = nutanix.get_recovery_point_v2(ext_id="1cefd0f5-6d38-4c9b-a07c-bdd2db004224")
    ```


    :param _builtins.str ext_id: recovery point UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getRecoveryPointV2:getRecoveryPointV2', __args__, opts=opts, typ=GetRecoveryPointV2Result)
    return __ret__.apply(lambda __response__: GetRecoveryPointV2Result(
        creation_time=pulumi.get(__response__, 'creation_time'),
        expiration_time=pulumi.get(__response__, 'expiration_time'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        location_agnostic_id=pulumi.get(__response__, 'location_agnostic_id'),
        location_references=pulumi.get(__response__, 'location_references'),
        name=pulumi.get(__response__, 'name'),
        owner_ext_id=pulumi.get(__response__, 'owner_ext_id'),
        recovery_point_type=pulumi.get(__response__, 'recovery_point_type'),
        status=pulumi.get(__response__, 'status'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        vm_recovery_points=pulumi.get(__response__, 'vm_recovery_points'),
        volume_group_recovery_points=pulumi.get(__response__, 'volume_group_recovery_points')))
