# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRoleResult',
    'AwaitableGetRoleResult',
    'get_role',
    'get_role_output',
]

@pulumi.output_type
class GetRoleResult:
    """
    A collection of values returned by getRole.
    """
    def __init__(__self__, api_version=None, categories=None, description=None, id=None, metadata=None, name=None, owner_reference=None, permission_reference_lists=None, project_reference=None, role_id=None, role_name=None, state=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_reference and not isinstance(owner_reference, dict):
            raise TypeError("Expected argument 'owner_reference' to be a dict")
        pulumi.set(__self__, "owner_reference", owner_reference)
        if permission_reference_lists and not isinstance(permission_reference_lists, list):
            raise TypeError("Expected argument 'permission_reference_lists' to be a list")
        pulumi.set(__self__, "permission_reference_lists", permission_reference_lists)
        if project_reference and not isinstance(project_reference, dict):
            raise TypeError("Expected argument 'project_reference' to be a dict")
        pulumi.set(__self__, "project_reference", project_reference)
        if role_id and not isinstance(role_id, str):
            raise TypeError("Expected argument 'role_id' to be a str")
        pulumi.set(__self__, "role_id", role_id)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        The version of the API.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.GetRoleCategoryResult']:
        """
        - Categories for the Role.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - The description of the Role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        - The role kind metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        - the name(Optional).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerReference")
    def owner_reference(self) -> Mapping[str, _builtins.str]:
        """
        - The reference to a user.
        """
        return pulumi.get(self, "owner_reference")

    @_builtins.property
    @pulumi.getter(name="permissionReferenceLists")
    def permission_reference_lists(self) -> Sequence['outputs.GetRolePermissionReferenceListResult']:
        """
        - (Required) List of permission references.
        """
        return pulumi.get(self, "permission_reference_lists")

    @_builtins.property
    @pulumi.getter(name="projectReference")
    def project_reference(self) -> Mapping[str, _builtins.str]:
        """
        - The reference to a project.
        """
        return pulumi.get(self, "project_reference")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "role_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        - The state of the role.
        """
        return pulumi.get(self, "state")


class AwaitableGetRoleResult(GetRoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleResult(
            api_version=self.api_version,
            categories=self.categories,
            description=self.description,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            owner_reference=self.owner_reference,
            permission_reference_lists=self.permission_reference_lists,
            project_reference=self.project_reference,
            role_id=self.role_id,
            role_name=self.role_name,
            state=self.state)


def get_role(categories: Optional[Sequence[Union['GetRoleCategoryArgs', 'GetRoleCategoryArgsDict']]] = None,
             role_id: Optional[_builtins.str] = None,
             role_name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleResult:
    """
    Describes a Role.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test_role = nutanix.Role("test",
        name="NAME",
        description="DESCRIPTION",
        permission_reference_lists=[{
            "kind": "permission",
            "uuid": "ID OF PERMISSION",
        }])
    test = nutanix.get_role_output(role_id=test_role.id)
    ```


    :param Sequence[Union['GetRoleCategoryArgs', 'GetRoleCategoryArgsDict']] categories: - Categories for the Role.
    :param _builtins.str role_id: - (Optional) The UUID of a Role.
    :param _builtins.str role_name: - (Optional) The name of a Role.
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['roleId'] = role_id
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getRole:getRole', __args__, opts=opts, typ=GetRoleResult).value

    return AwaitableGetRoleResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        categories=pulumi.get(__ret__, 'categories'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        owner_reference=pulumi.get(__ret__, 'owner_reference'),
        permission_reference_lists=pulumi.get(__ret__, 'permission_reference_lists'),
        project_reference=pulumi.get(__ret__, 'project_reference'),
        role_id=pulumi.get(__ret__, 'role_id'),
        role_name=pulumi.get(__ret__, 'role_name'),
        state=pulumi.get(__ret__, 'state'))
def get_role_output(categories: Optional[pulumi.Input[Optional[Sequence[Union['GetRoleCategoryArgs', 'GetRoleCategoryArgsDict']]]]] = None,
                    role_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    role_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoleResult]:
    """
    Describes a Role.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test_role = nutanix.Role("test",
        name="NAME",
        description="DESCRIPTION",
        permission_reference_lists=[{
            "kind": "permission",
            "uuid": "ID OF PERMISSION",
        }])
    test = nutanix.get_role_output(role_id=test_role.id)
    ```


    :param Sequence[Union['GetRoleCategoryArgs', 'GetRoleCategoryArgsDict']] categories: - Categories for the Role.
    :param _builtins.str role_id: - (Optional) The UUID of a Role.
    :param _builtins.str role_name: - (Optional) The name of a Role.
    """
    __args__ = dict()
    __args__['categories'] = categories
    __args__['roleId'] = role_id
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getRole:getRole', __args__, opts=opts, typ=GetRoleResult)
    return __ret__.apply(lambda __response__: GetRoleResult(
        api_version=pulumi.get(__response__, 'api_version'),
        categories=pulumi.get(__response__, 'categories'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        owner_reference=pulumi.get(__response__, 'owner_reference'),
        permission_reference_lists=pulumi.get(__response__, 'permission_reference_lists'),
        project_reference=pulumi.get(__response__, 'project_reference'),
        role_id=pulumi.get(__response__, 'role_id'),
        role_name=pulumi.get(__response__, 'role_name'),
        state=pulumi.get(__response__, 'state')))
