# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRoleV2Result',
    'AwaitableGetRoleV2Result',
    'get_role_v2',
    'get_role_v2_output',
]

@pulumi.output_type
class GetRoleV2Result:
    """
    A collection of values returned by getRoleV2.
    """
    def __init__(__self__, accessible_clients=None, accessible_entity_types=None, assigned_users_count=None, assigned_users_groups_count=None, client_name=None, created_by=None, created_time=None, description=None, display_name=None, ext_id=None, id=None, is_system_defined=None, last_updated_time=None, links=None, operations=None, tenant_id=None):
        if accessible_clients and not isinstance(accessible_clients, list):
            raise TypeError("Expected argument 'accessible_clients' to be a list")
        pulumi.set(__self__, "accessible_clients", accessible_clients)
        if accessible_entity_types and not isinstance(accessible_entity_types, list):
            raise TypeError("Expected argument 'accessible_entity_types' to be a list")
        pulumi.set(__self__, "accessible_entity_types", accessible_entity_types)
        if assigned_users_count and not isinstance(assigned_users_count, int):
            raise TypeError("Expected argument 'assigned_users_count' to be a int")
        pulumi.set(__self__, "assigned_users_count", assigned_users_count)
        if assigned_users_groups_count and not isinstance(assigned_users_groups_count, int):
            raise TypeError("Expected argument 'assigned_users_groups_count' to be a int")
        pulumi.set(__self__, "assigned_users_groups_count", assigned_users_groups_count)
        if client_name and not isinstance(client_name, str):
            raise TypeError("Expected argument 'client_name' to be a str")
        pulumi.set(__self__, "client_name", client_name)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_system_defined and not isinstance(is_system_defined, bool):
            raise TypeError("Expected argument 'is_system_defined' to be a bool")
        pulumi.set(__self__, "is_system_defined", is_system_defined)
        if last_updated_time and not isinstance(last_updated_time, str):
            raise TypeError("Expected argument 'last_updated_time' to be a str")
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if operations and not isinstance(operations, list):
            raise TypeError("Expected argument 'operations' to be a list")
        pulumi.set(__self__, "operations", operations)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="accessibleClients")
    def accessible_clients(self) -> Sequence[_builtins.str]:
        """
        - List of Accessible Clients for the Role.
        """
        return pulumi.get(self, "accessible_clients")

    @_builtins.property
    @pulumi.getter(name="accessibleEntityTypes")
    def accessible_entity_types(self) -> Sequence[_builtins.str]:
        """
        - List of Accessible Entity Types for the Role.
        """
        return pulumi.get(self, "accessible_entity_types")

    @_builtins.property
    @pulumi.getter(name="assignedUsersCount")
    def assigned_users_count(self) -> _builtins.int:
        """
        - Number of Users assigned to given Role.
        """
        return pulumi.get(self, "assigned_users_count")

    @_builtins.property
    @pulumi.getter(name="assignedUsersGroupsCount")
    def assigned_users_groups_count(self) -> _builtins.int:
        """
        - Number of User Groups assigned to given Role.
        """
        return pulumi.get(self, "assigned_users_groups_count")

    @_builtins.property
    @pulumi.getter(name="clientName")
    def client_name(self) -> _builtins.str:
        """
        - Client that created the entity.
        """
        return pulumi.get(self, "client_name")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        - User or Service Name that created the Role.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        - The creation time of the Role.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        - Description of the Role.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        - The display name for the Role.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        - A globally unique identifier of an instance that is suitable for external consumption.
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> _builtins.bool:
        """
        - Flag identifying if the Role is system defined or not.
        """
        return pulumi.get(self, "is_system_defined")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> _builtins.str:
        """
        - The time when the Role was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetRoleV2LinkResult']:
        """
        - A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def operations(self) -> Sequence[_builtins.str]:
        """
        - List of operations for the role.
        """
        return pulumi.get(self, "operations")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        - A globally unique identifier that represents the tenant that owns this entity. The system automatically assigns it, and it and is immutable from an API consumer perspective (some use cases may cause this Id to change - For instance, a use case may require the transfer of ownership of the entity, but these cases are handled automatically on the server).
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetRoleV2Result(GetRoleV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleV2Result(
            accessible_clients=self.accessible_clients,
            accessible_entity_types=self.accessible_entity_types,
            assigned_users_count=self.assigned_users_count,
            assigned_users_groups_count=self.assigned_users_groups_count,
            client_name=self.client_name,
            created_by=self.created_by,
            created_time=self.created_time,
            description=self.description,
            display_name=self.display_name,
            ext_id=self.ext_id,
            id=self.id,
            is_system_defined=self.is_system_defined,
            last_updated_time=self.last_updated_time,
            links=self.links,
            operations=self.operations,
            tenant_id=self.tenant_id)


def get_role_v2(ext_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleV2Result:
    """
    Fetches a role based on the provided external identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    role = nutanix.get_role_v2(ext_id="a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b")
    ```


    :param _builtins.str ext_id: - (Required) ExtId for the Role.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getRoleV2:getRoleV2', __args__, opts=opts, typ=GetRoleV2Result).value

    return AwaitableGetRoleV2Result(
        accessible_clients=pulumi.get(__ret__, 'accessible_clients'),
        accessible_entity_types=pulumi.get(__ret__, 'accessible_entity_types'),
        assigned_users_count=pulumi.get(__ret__, 'assigned_users_count'),
        assigned_users_groups_count=pulumi.get(__ret__, 'assigned_users_groups_count'),
        client_name=pulumi.get(__ret__, 'client_name'),
        created_by=pulumi.get(__ret__, 'created_by'),
        created_time=pulumi.get(__ret__, 'created_time'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        id=pulumi.get(__ret__, 'id'),
        is_system_defined=pulumi.get(__ret__, 'is_system_defined'),
        last_updated_time=pulumi.get(__ret__, 'last_updated_time'),
        links=pulumi.get(__ret__, 'links'),
        operations=pulumi.get(__ret__, 'operations'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_role_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoleV2Result]:
    """
    Fetches a role based on the provided external identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    role = nutanix.get_role_v2(ext_id="a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b")
    ```


    :param _builtins.str ext_id: - (Required) ExtId for the Role.
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getRoleV2:getRoleV2', __args__, opts=opts, typ=GetRoleV2Result)
    return __ret__.apply(lambda __response__: GetRoleV2Result(
        accessible_clients=pulumi.get(__response__, 'accessible_clients'),
        accessible_entity_types=pulumi.get(__response__, 'accessible_entity_types'),
        assigned_users_count=pulumi.get(__response__, 'assigned_users_count'),
        assigned_users_groups_count=pulumi.get(__response__, 'assigned_users_groups_count'),
        client_name=pulumi.get(__response__, 'client_name'),
        created_by=pulumi.get(__response__, 'created_by'),
        created_time=pulumi.get(__response__, 'created_time'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        id=pulumi.get(__response__, 'id'),
        is_system_defined=pulumi.get(__response__, 'is_system_defined'),
        last_updated_time=pulumi.get(__response__, 'last_updated_time'),
        links=pulumi.get(__response__, 'links'),
        operations=pulumi.get(__response__, 'operations'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
