# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRouteTableV2Result',
    'AwaitableGetRouteTableV2Result',
    'get_route_table_v2',
    'get_route_table_v2_output',
]

@pulumi.output_type
class GetRouteTableV2Result:
    """
    A collection of values returned by getRouteTableV2.
    """
    def __init__(__self__, ext_id=None, external_routing_domain_reference=None, id=None, links=None, metadatas=None, tenant_id=None, vpc_reference=None):
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if external_routing_domain_reference and not isinstance(external_routing_domain_reference, str):
            raise TypeError("Expected argument 'external_routing_domain_reference' to be a str")
        pulumi.set(__self__, "external_routing_domain_reference", external_routing_domain_reference)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if vpc_reference and not isinstance(vpc_reference, str):
            raise TypeError("Expected argument 'vpc_reference' to be a str")
        pulumi.set(__self__, "vpc_reference", vpc_reference)

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        Route UUID
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> _builtins.str:
        """
        External routing domain associated with this route table.
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetRouteTableV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetRouteTableV2MetadataResult']:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> _builtins.str:
        """
        VPC reference.
        """
        return pulumi.get(self, "vpc_reference")


class AwaitableGetRouteTableV2Result(GetRouteTableV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteTableV2Result(
            ext_id=self.ext_id,
            external_routing_domain_reference=self.external_routing_domain_reference,
            id=self.id,
            links=self.links,
            metadatas=self.metadatas,
            tenant_id=self.tenant_id,
            vpc_reference=self.vpc_reference)


def get_route_table_v2(ext_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteTableV2Result:
    """
    Provides Nutanix datasource Get the route table for the specified extId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_route_table = nutanix.get_route_table_v2(ext_id="ad7692ff-50f8-4a47-b3c9-fd5a3462d455")
    ```


    :param _builtins.str ext_id: Route UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getRouteTableV2:getRouteTableV2', __args__, opts=opts, typ=GetRouteTableV2Result).value

    return AwaitableGetRouteTableV2Result(
        ext_id=pulumi.get(__ret__, 'ext_id'),
        external_routing_domain_reference=pulumi.get(__ret__, 'external_routing_domain_reference'),
        id=pulumi.get(__ret__, 'id'),
        links=pulumi.get(__ret__, 'links'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        vpc_reference=pulumi.get(__ret__, 'vpc_reference'))
def get_route_table_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteTableV2Result]:
    """
    Provides Nutanix datasource Get the route table for the specified extId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    get_route_table = nutanix.get_route_table_v2(ext_id="ad7692ff-50f8-4a47-b3c9-fd5a3462d455")
    ```


    :param _builtins.str ext_id: Route UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getRouteTableV2:getRouteTableV2', __args__, opts=opts, typ=GetRouteTableV2Result)
    return __ret__.apply(lambda __response__: GetRouteTableV2Result(
        ext_id=pulumi.get(__response__, 'ext_id'),
        external_routing_domain_reference=pulumi.get(__response__, 'external_routing_domain_reference'),
        id=pulumi.get(__response__, 'id'),
        links=pulumi.get(__response__, 'links'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        vpc_reference=pulumi.get(__response__, 'vpc_reference')))
