# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRouteV2Result',
    'AwaitableGetRouteV2Result',
    'get_route_v2',
    'get_route_v2_output',
]

@pulumi.output_type
class GetRouteV2Result:
    """
    A collection of values returned by getRouteV2.
    """
    def __init__(__self__, description=None, destinations=None, ext_id=None, external_routing_domain_reference=None, id=None, is_active=None, links=None, metadatas=None, name=None, next_hops=None, priority=None, route_table_ext_id=None, route_table_reference=None, route_type=None, tenant_id=None, vpc_reference=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destinations and not isinstance(destinations, list):
            raise TypeError("Expected argument 'destinations' to be a list")
        pulumi.set(__self__, "destinations", destinations)
        if ext_id and not isinstance(ext_id, str):
            raise TypeError("Expected argument 'ext_id' to be a str")
        pulumi.set(__self__, "ext_id", ext_id)
        if external_routing_domain_reference and not isinstance(external_routing_domain_reference, str):
            raise TypeError("Expected argument 'external_routing_domain_reference' to be a str")
        pulumi.set(__self__, "external_routing_domain_reference", external_routing_domain_reference)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active and not isinstance(is_active, bool):
            raise TypeError("Expected argument 'is_active' to be a bool")
        pulumi.set(__self__, "is_active", is_active)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if next_hops and not isinstance(next_hops, list):
            raise TypeError("Expected argument 'next_hops' to be a list")
        pulumi.set(__self__, "next_hops", next_hops)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if route_table_ext_id and not isinstance(route_table_ext_id, str):
            raise TypeError("Expected argument 'route_table_ext_id' to be a str")
        pulumi.set(__self__, "route_table_ext_id", route_table_ext_id)
        if route_table_reference and not isinstance(route_table_reference, str):
            raise TypeError("Expected argument 'route_table_reference' to be a str")
        pulumi.set(__self__, "route_table_reference", route_table_reference)
        if route_type and not isinstance(route_type, str):
            raise TypeError("Expected argument 'route_type' to be a str")
        pulumi.set(__self__, "route_type", route_type)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if vpc_reference and not isinstance(vpc_reference, str):
            raise TypeError("Expected argument 'vpc_reference' to be a str")
        pulumi.set(__self__, "vpc_reference", vpc_reference)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        BGP session description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.GetRouteV2DestinationResult']:
        """
        Destination IP Subnet Configuration.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter(name="extId")
    def ext_id(self) -> _builtins.str:
        """
        Route UUID
        """
        return pulumi.get(self, "ext_id")

    @_builtins.property
    @pulumi.getter(name="externalRoutingDomainReference")
    def external_routing_domain_reference(self) -> _builtins.str:
        """
        External routing domain associated with this route table.
        """
        return pulumi.get(self, "external_routing_domain_reference")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isActive")
    def is_active(self) -> _builtins.bool:
        """
        Indicates whether the route is active in the forwarding plane.
        """
        return pulumi.get(self, "is_active")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetRouteV2LinkResult']:
        """
        A HATEOAS style link for the response. Each link contains a user-friendly name identifying the link and an address for retrieving the particular resource.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetRouteV2MetadataResult']:
        """
        Metadata associated with this resource.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Route name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nextHops")
    def next_hops(self) -> Sequence['outputs.GetRouteV2NextHopResult']:
        """
        Route nexthop.
        """
        return pulumi.get(self, "next_hops")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        Route priority. A higher value implies greater preference is assigned to the route.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="routeTableExtId")
    def route_table_ext_id(self) -> _builtins.str:
        return pulumi.get(self, "route_table_ext_id")

    @_builtins.property
    @pulumi.getter(name="routeTableReference")
    def route_table_reference(self) -> _builtins.str:
        """
        Route table reference.
        """
        return pulumi.get(self, "route_table_reference")

    @_builtins.property
    @pulumi.getter(name="routeType")
    def route_type(self) -> _builtins.str:
        """
        Route type. Acceptable values are "STATIC", "LOCAL", "DYNAMIC"
        """
        return pulumi.get(self, "route_type")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        A globally unique identifier that represents the tenant that owns this entity
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vpcReference")
    def vpc_reference(self) -> _builtins.str:
        """
        VPC reference.
        """
        return pulumi.get(self, "vpc_reference")


class AwaitableGetRouteV2Result(GetRouteV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteV2Result(
            description=self.description,
            destinations=self.destinations,
            ext_id=self.ext_id,
            external_routing_domain_reference=self.external_routing_domain_reference,
            id=self.id,
            is_active=self.is_active,
            links=self.links,
            metadatas=self.metadatas,
            name=self.name,
            next_hops=self.next_hops,
            priority=self.priority,
            route_table_ext_id=self.route_table_ext_id,
            route_table_reference=self.route_table_reference,
            route_type=self.route_type,
            tenant_id=self.tenant_id,
            vpc_reference=self.vpc_reference)


def get_route_v2(ext_id: Optional[_builtins.str] = None,
                 route_table_ext_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteV2Result:
    """
    Provides Nutanix datasource Get Route for the specified {extId}.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    route_by_id = nutanix.get_route_v2(route_table_ext_id="a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
        ext_id="7f66e20f-67f4-473f-96bb-c4fcfd487f16")
    ```


    :param _builtins.str ext_id: Route UUID.
    :param _builtins.str route_table_ext_id: Route table UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['routeTableExtId'] = route_table_ext_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getRouteV2:getRouteV2', __args__, opts=opts, typ=GetRouteV2Result).value

    return AwaitableGetRouteV2Result(
        description=pulumi.get(__ret__, 'description'),
        destinations=pulumi.get(__ret__, 'destinations'),
        ext_id=pulumi.get(__ret__, 'ext_id'),
        external_routing_domain_reference=pulumi.get(__ret__, 'external_routing_domain_reference'),
        id=pulumi.get(__ret__, 'id'),
        is_active=pulumi.get(__ret__, 'is_active'),
        links=pulumi.get(__ret__, 'links'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        name=pulumi.get(__ret__, 'name'),
        next_hops=pulumi.get(__ret__, 'next_hops'),
        priority=pulumi.get(__ret__, 'priority'),
        route_table_ext_id=pulumi.get(__ret__, 'route_table_ext_id'),
        route_table_reference=pulumi.get(__ret__, 'route_table_reference'),
        route_type=pulumi.get(__ret__, 'route_type'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        vpc_reference=pulumi.get(__ret__, 'vpc_reference'))
def get_route_v2_output(ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                        route_table_ext_id: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteV2Result]:
    """
    Provides Nutanix datasource Get Route for the specified {extId}.

    ## Example

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    route_by_id = nutanix.get_route_v2(route_table_ext_id="a8fe48c4-f0d3-49c7-a017-efc30dd8fb2b",
        ext_id="7f66e20f-67f4-473f-96bb-c4fcfd487f16")
    ```


    :param _builtins.str ext_id: Route UUID.
    :param _builtins.str route_table_ext_id: Route table UUID
    """
    __args__ = dict()
    __args__['extId'] = ext_id
    __args__['routeTableExtId'] = route_table_ext_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getRouteV2:getRouteV2', __args__, opts=opts, typ=GetRouteV2Result)
    return __ret__.apply(lambda __response__: GetRouteV2Result(
        description=pulumi.get(__response__, 'description'),
        destinations=pulumi.get(__response__, 'destinations'),
        ext_id=pulumi.get(__response__, 'ext_id'),
        external_routing_domain_reference=pulumi.get(__response__, 'external_routing_domain_reference'),
        id=pulumi.get(__response__, 'id'),
        is_active=pulumi.get(__response__, 'is_active'),
        links=pulumi.get(__response__, 'links'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        name=pulumi.get(__response__, 'name'),
        next_hops=pulumi.get(__response__, 'next_hops'),
        priority=pulumi.get(__response__, 'priority'),
        route_table_ext_id=pulumi.get(__response__, 'route_table_ext_id'),
        route_table_reference=pulumi.get(__response__, 'route_table_reference'),
        route_type=pulumi.get(__response__, 'route_type'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        vpc_reference=pulumi.get(__response__, 'vpc_reference')))
