# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSelfServiceAppResult',
    'AwaitableGetSelfServiceAppResult',
    'get_self_service_app',
    'get_self_service_app_output',
]

@pulumi.output_type
class GetSelfServiceAppResult:
    """
    A collection of values returned by getSelfServiceApp.
    """
    def __init__(__self__, actions=None, api_version=None, app_description=None, app_name=None, app_summaries=None, app_uuid=None, id=None, spec=None, state=None, status=None, vms=None):
        if actions and not isinstance(actions, list):
            raise TypeError("Expected argument 'actions' to be a list")
        pulumi.set(__self__, "actions", actions)
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if app_description and not isinstance(app_description, str):
            raise TypeError("Expected argument 'app_description' to be a str")
        pulumi.set(__self__, "app_description", app_description)
        if app_name and not isinstance(app_name, str):
            raise TypeError("Expected argument 'app_name' to be a str")
        pulumi.set(__self__, "app_name", app_name)
        if app_summaries and not isinstance(app_summaries, list):
            raise TypeError("Expected argument 'app_summaries' to be a list")
        pulumi.set(__self__, "app_summaries", app_summaries)
        if app_uuid and not isinstance(app_uuid, str):
            raise TypeError("Expected argument 'app_uuid' to be a str")
        pulumi.set(__self__, "app_uuid", app_uuid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if spec and not isinstance(spec, str):
            raise TypeError("Expected argument 'spec' to be a str")
        pulumi.set(__self__, "spec", spec)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vms and not isinstance(vms, list):
            raise TypeError("Expected argument 'vms' to be a list")
        pulumi.set(__self__, "vms", vms)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetSelfServiceAppActionResult']:
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> _builtins.str:
        """
        - The API version used for the application.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="appDescription")
    def app_description(self) -> _builtins.str:
        """
        - The description of the Self Service Application.
        """
        return pulumi.get(self, "app_description")

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> _builtins.str:
        """
        - The name of the Self Service Application.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appSummaries")
    def app_summaries(self) -> Sequence['outputs.GetSelfServiceAppAppSummaryResult']:
        return pulumi.get(self, "app_summaries")

    @_builtins.property
    @pulumi.getter(name="appUuid")
    def app_uuid(self) -> _builtins.str:
        return pulumi.get(self, "app_uuid")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> _builtins.str:
        """
        - The specification of the Self Service Application.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        - The state of the application (e.g., Running, Provisioning, etc.).
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        - The current status of the application.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def vms(self) -> Sequence['outputs.GetSelfServiceAppVmResult']:
        return pulumi.get(self, "vms")


class AwaitableGetSelfServiceAppResult(GetSelfServiceAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSelfServiceAppResult(
            actions=self.actions,
            api_version=self.api_version,
            app_description=self.app_description,
            app_name=self.app_name,
            app_summaries=self.app_summaries,
            app_uuid=self.app_uuid,
            id=self.id,
            spec=self.spec,
            state=self.state,
            status=self.status,
            vms=self.vms)


def get_self_service_app(app_uuid: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSelfServiceAppResult:
    """
    Describes an Application (app) in NCM Self Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test_self_service_app_provision = nutanix.SelfServiceAppProvision("test",
        bp_name="NAME OF BLUEPRINT IN SERVER",
        app_name="NAME OF APP YOU WANT TO SET",
        app_description="DESCRIPTION OF APP")
    test = nutanix.get_self_service_app_output(app_uuid=test_self_service_app_provision.id)
    ```


    :param _builtins.str app_uuid: - (Required) The UUID of an app you want to get data from.
    """
    __args__ = dict()
    __args__['appUuid'] = app_uuid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('nutanix:index/getSelfServiceApp:getSelfServiceApp', __args__, opts=opts, typ=GetSelfServiceAppResult).value

    return AwaitableGetSelfServiceAppResult(
        actions=pulumi.get(__ret__, 'actions'),
        api_version=pulumi.get(__ret__, 'api_version'),
        app_description=pulumi.get(__ret__, 'app_description'),
        app_name=pulumi.get(__ret__, 'app_name'),
        app_summaries=pulumi.get(__ret__, 'app_summaries'),
        app_uuid=pulumi.get(__ret__, 'app_uuid'),
        id=pulumi.get(__ret__, 'id'),
        spec=pulumi.get(__ret__, 'spec'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        vms=pulumi.get(__ret__, 'vms'))
def get_self_service_app_output(app_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSelfServiceAppResult]:
    """
    Describes an Application (app) in NCM Self Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_nutanix as nutanix

    test_self_service_app_provision = nutanix.SelfServiceAppProvision("test",
        bp_name="NAME OF BLUEPRINT IN SERVER",
        app_name="NAME OF APP YOU WANT TO SET",
        app_description="DESCRIPTION OF APP")
    test = nutanix.get_self_service_app_output(app_uuid=test_self_service_app_provision.id)
    ```


    :param _builtins.str app_uuid: - (Required) The UUID of an app you want to get data from.
    """
    __args__ = dict()
    __args__['appUuid'] = app_uuid
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('nutanix:index/getSelfServiceApp:getSelfServiceApp', __args__, opts=opts, typ=GetSelfServiceAppResult)
    return __ret__.apply(lambda __response__: GetSelfServiceAppResult(
        actions=pulumi.get(__response__, 'actions'),
        api_version=pulumi.get(__response__, 'api_version'),
        app_description=pulumi.get(__response__, 'app_description'),
        app_name=pulumi.get(__response__, 'app_name'),
        app_summaries=pulumi.get(__response__, 'app_summaries'),
        app_uuid=pulumi.get(__response__, 'app_uuid'),
        id=pulumi.get(__response__, 'id'),
        spec=pulumi.get(__response__, 'spec'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        vms=pulumi.get(__response__, 'vms')))
